/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.webpage;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.webpage.Configuration;
import org.apache.jetspeed.services.webpage.WebPageHelper;
import org.apache.jetspeed.services.webpage.WebPageManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class WebPageServlet
extends HttpServlet {
    public static final String WPS_KILLSESSION = "kill";
    public static final String WPS_KILLPARAM = "9";
    static Logger log = Logger.getLogger(WebPageServlet.class);
    private static boolean firstInit = true;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!WebPageManager.isInit()) {
            this.displayInfoPage(response);
            log.error((Object)WebPageManager.getErrorString());
            return;
        }
        boolean error = false;
        try {
            if (this.dispatch(request, response, true)) {
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            this.displayErrorPage(response, e.getMessage());
            error = true;
        }
        if (!error) {
            this.displayInfoPage(response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!WebPageManager.isInit()) {
            this.displayInfoPage(response);
            log.error((Object)WebPageManager.getErrorString());
            return;
        }
        boolean error = false;
        try {
            if (this.dispatch(request, response, false)) {
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            this.displayErrorPage(response, e.getMessage());
            error = true;
        }
        if (!error) {
            this.displayInfoPage(response);
        }
    }

    private boolean dispatch(HttpServletRequest request, HttpServletResponse response, boolean isGet) throws ServletException, IOException {
        Configuration config = Configuration.getInstance();
        String nesid = request.getParameter(config.getSID());
        String pxurl = request.getParameter(config.getURL());
        if (nesid == null && null == pxurl) {
            return false;
        }
        if (isGet) {
            WebPageManager.get(this, request, response);
        } else {
            WebPageManager.post(this, request, response);
        }
        return true;
    }

    private void displayInfoPage(HttpServletResponse response) {
        try {
            String line;
            PrintWriter pw = response.getWriter();
            String infoFile = Configuration.getInstance().getProperty("content.info");
            String indexFile = this.getServletContext().getRealPath(infoFile);
            BufferedReader br = new BufferedReader(new FileReader(indexFile));
            while ((line = br.readLine()) != null) {
                pw.println(line);
            }
            if (WebPageManager.isInit()) {
                pw.println("<br><font color='green'>:: Status :: Online ::</font><br>");
            } else {
                pw.println("<br><font color='red'>:: Status :: Offline ::</font><br>");
                pw.println(":: Reason :: " + WebPageManager.getErrorString());
            }
            br.close();
        }
        catch (Exception ex) {
            log.error((Object)"Failed to read servlet info page");
            this.displayInfo(response);
        }
    }

    private void displayErrorPage(HttpServletResponse response, String msg) {
        try {
            String line;
            PrintWriter pw = response.getWriter();
            String fileName = Configuration.getInstance().getProperty("content.error");
            String template = this.getServletContext().getRealPath(fileName);
            BufferedReader br = new BufferedReader(new FileReader(template));
            while ((line = br.readLine()) != null) {
                int index = line.indexOf("$msg");
                if (index > -1) {
                    StringBuffer buffer = new StringBuffer(line);
                    WebPageHelper.replaceAll(buffer, "$msg", msg);
                    pw.println(buffer.toString());
                    continue;
                }
                pw.println(line);
            }
            br.close();
        }
        catch (Exception ex) {
            log.error((Object)"Failed to read servlet info page");
            this.displayError(response, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        PropertyConfigurator.configure((String)"WebPageManagerLog4j.properties");
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            if (!firstInit) {
                return;
            }
            firstInit = false;
            try {
                WebPageManager.init(config);
            }
            catch (IOException ex) {
                throw new ServletException(ex.toString());
            }
        }
    }

    public final void destroy() {
        WebPageManager.destroy();
    }

    private void displayInfo(HttpServletResponse response) {
        try {
            PrintWriter pw = response.getWriter();
            pw.println("<HTML><HEAD><title>Jetspeed Web Page Servlet</title></HEAD><BODY><H1>Jetspeed Web Page Servlet</H1>");
            if (WebPageManager.isInit()) {
                pw.println("<br><font color='green'>:: Status :: Online ::</font><br>");
            } else {
                pw.println("<br><font color='red'>:: Status :: Offline ::</font><br>");
                pw.println(":: Reason :: " + WebPageManager.getErrorString());
            }
            pw.println("<br><br>Warning. The Jetspeed HTTP Web Page Servlet was not correctly installed.<br>");
            pw.println("<br>Please contact Al Gore for support (he invented the internet).<br>");
            pw.println("</BODY></HTML>");
        }
        catch (IOException ex) {
            log.error((Object)"Failed to get a PrintWriter on response.");
        }
    }

    private void displayError(HttpServletResponse response, String msg) {
        try {
            PrintWriter pw = response.getWriter();
            pw.println("<HTML><HEAD><title>Web Page Servlet General Exception</title></HEAD><BODY><H1>Web Page Servlet General Exception</H1>");
            if (WebPageManager.isInit()) {
                pw.println("<br><font color='green'>:: Status :: Online ::</font><br>");
            } else {
                pw.println("<br><font color='red'>:: Status :: Offline ::</font><br>");
                pw.println(":: Reason :: " + msg);
            }
            pw.println("<br><br>Warning. The Jetspeed Web Page Servlet was not correctly installed.<br>");
            pw.println("<br>Please contact Al Gore for support (he invented the internet).<br>");
            pw.println("</BODY></HTML>");
        }
        catch (IOException ex) {
            log.error((Object)"Failed to get a PrintWriter on response.");
        }
    }
}

