/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.turbine.util.RunData;

public class PortletSessionState {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PortletSessionState.class.getName());
    public static final String CONFIG_CHANGED = "config_changed";

    public static Object getAttribute(RunData rundata, String attrName) {
        return rundata.getUser().getTemp(attrName);
    }

    public static Object getAttribute(RunData rundata, String attrName, Object defValue) {
        Object o = rundata.getUser().getTemp(attrName, defValue);
        if (o instanceof String && !(defValue instanceof String)) {
            return defValue;
        }
        return o;
    }

    public static void setAttribute(RunData rundata, String attrName, Object attrValue) {
        rundata.getUser().setTemp(attrName, attrValue);
    }

    public static void clearAttribute(RunData rundata, String attrName) {
        rundata.getUser().removeTemp(attrName);
    }

    public static Object getAttribute(Portlet portlet, RunData rundata, String attrName) {
        return rundata.getUser().getTemp(PortletSessionState.generateKey(portlet, attrName));
    }

    public static Object getAttributeWithFallback(Portlet portlet, RunData rundata, String attrName) {
        Object result = null;
        if (PortletSessionState.isMyRequest(rundata, portlet) && (result = rundata.getParameters().getString(attrName)) != null) {
            if (result.toString().trim().equalsIgnoreCase("")) {
                PortletSessionState.clearAttribute(portlet, rundata, attrName);
                result = null;
            } else {
                PortletSessionState.setAttribute(portlet, rundata, attrName, result);
            }
        }
        if (result == null) {
            result = PortletSessionState.getAttribute(portlet, rundata, attrName);
        }
        if (result == null) {
            result = portlet.getAttribute(attrName, null, rundata);
        }
        if (result == null) {
            result = portlet.getPortletConfig().getInitParameter(attrName);
        }
        return result;
    }

    public static boolean isMyRequest(RunData rundata, Portlet portlet) {
        String requestPeid = rundata.getParameters().getString("js_peid");
        if (requestPeid == null || requestPeid.equalsIgnoreCase("")) {
            return true;
        }
        if (portlet == null || portlet.getID() == null) {
            return true;
        }
        String peId = null;
        PortletInstance instance = PersistenceManager.getInstance(portlet, rundata);
        if (instance != null) {
            peId = instance.getPortlet().getID();
        }
        return peId != null && peId.equals(requestPeid);
    }

    public static void setAttribute(Portlet portlet, RunData rundata, String attrName, Object attrValue) {
        rundata.getUser().setTemp(PortletSessionState.generateKey(portlet, attrName), attrValue);
    }

    public static void clearAttribute(Portlet portlet, RunData rundata, String attrName) {
        rundata.getUser().removeTemp(PortletSessionState.generateKey(portlet, attrName));
    }

    protected static String generateKey(Portlet portlet, String name) {
        if (portlet != null) {
            return portlet.getID() + "." + name;
        }
        logger.error("PortletSessionState: Passed null Velocity Portlet for name: " + name);
        return name;
    }

    public static Object getAttribute(VelocityPortlet portlet, RunData rundata, String attrName) {
        return PortletSessionState.getAttribute((Portlet)portlet, rundata, attrName);
    }

    public static void setAttribute(VelocityPortlet portlet, RunData rundata, String attrName, Object attrValue) {
        PortletSessionState.setAttribute((Portlet)portlet, rundata, attrName, attrValue);
    }

    public static void clearAttribute(VelocityPortlet portlet, RunData rundata, String attrName) {
        PortletSessionState.clearAttribute((Portlet)portlet, rundata, attrName);
    }

    public static void setPortletConfigChanged(Portlet portlet, RunData rundata) {
        PortletSessionState.setAttribute(portlet, rundata, CONFIG_CHANGED, (Object)"true");
    }

    public static boolean getPortletConfigChanged(Portlet portlet, RunData rundata) {
        String state = (String)PortletSessionState.getAttribute(portlet, rundata, CONFIG_CHANGED);
        if (state != null) {
            PortletSessionState.clearAttribute(portlet, rundata, CONFIG_CHANGED);
        }
        return state != null;
    }
}

