/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.Reference;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.idgenerator.JetspeedIdGenerator;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.turbine.util.RunData;

public class PortletUtils {
    public static void regenerateIds(Portlets topPortlets) throws Exception {
        Portlets[] portlets = topPortlets.getPortletsArray();
        for (int i = 0; i < portlets.length; ++i) {
            portlets[i].setId(JetspeedIdGenerator.getNextPeid());
            Entry[] entries = portlets[i].getEntriesArray();
            for (int j = 0; j < entries.length; ++j) {
                entries[j].setId(JetspeedIdGenerator.getNextPeid());
            }
            Reference[] refs = portlets[i].getReferenceArray();
            for (int k = 0; k < refs.length; ++k) {
                refs[k].setId(JetspeedIdGenerator.getNextPeid());
            }
            PortletUtils.regenerateIds(portlets[i]);
        }
    }

    public static boolean canAccessProfile(RunData rundata, Profile profile) {
        boolean result = true;
        if (profile != null && profile.getRootSet() != null) {
            PortalResource portalResource = new PortalResource(profile.getRootSet());
            String owner = null;
            if (profile.getUserName() != null) {
                owner = profile.getUserName();
            }
            portalResource.setOwner(owner);
            result = JetspeedSecurity.checkPermission((JetspeedUser)rundata.getUser(), portalResource, "customize");
        }
        return result;
    }
}

