/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import org.apache.jetspeed.util.StringUtils;

public class URIEncoder {
    public static final String[] INVALID_CHARACTERS = new String[]{"\\", "/", ":", "*", "\"", "<", ">", "|", "+", "?"};
    public static final String[] CODED_CHARACTERS = new String[]{"#92;", "#47;", "#58;", "#42;", "#34;", "#60;", "#62;", "#124;", "#43;", "#63;"};

    public static String encode(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI may not be null. ");
        }
        StringBuffer buffer = new StringBuffer(uri);
        StringUtils.replaceAll(buffer, "_", "__");
        StringUtils.replaceAll(buffer, "://", "_");
        StringUtils.replaceAll(buffer, "/", "_");
        StringUtils.replaceAll(buffer, ":", "___");
        URIEncoder.encodeQueryData(buffer);
        return buffer.toString();
    }

    public static String decode(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI may not be null. ");
        }
        String newURI = "";
        int start = uri.indexOf("_");
        String protocol = null;
        if (uri.charAt(start + 1) == '_') {
            start = -1;
        }
        if (start > -1) {
            protocol = uri.substring(0, start);
        }
        newURI = uri.substring(start + 1, uri.length());
        StringBuffer buffer = new StringBuffer(newURI);
        StringUtils.replaceAll(buffer, "___", ":");
        StringUtils.replaceAll(buffer, "_", "/");
        StringUtils.replaceAll(buffer, "_", "/");
        StringUtils.replaceAll(buffer, "//", "_");
        if (protocol != null) {
            buffer.replace(0, 0, "://");
            buffer.replace(0, 0, protocol);
        }
        URIEncoder.decodeQueryData(buffer);
        return buffer.toString();
    }

    private static StringBuffer encodeQueryData(StringBuffer data) {
        for (int i = 0; i < INVALID_CHARACTERS.length; ++i) {
            String source = INVALID_CHARACTERS[i];
            String coded = CODED_CHARACTERS[i];
            data = StringUtils.replaceAll(data, source, coded);
        }
        return data;
    }

    private static StringBuffer decodeQueryData(StringBuffer data) {
        for (int i = 0; i < INVALID_CHARACTERS.length; ++i) {
            String source = INVALID_CHARACTERS[i];
            String coded = CODED_CHARACTERS[i];
            data = StringUtils.replaceAll(data, coded, source);
        }
        return data;
    }
}

