/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import javax.servlet.http.HttpSession;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletControl;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.JetspeedException;
import org.apache.jetspeed.util.URIEncoder;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.template.TemplateLink;

public class URILookup {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(URILookup.class.getName());
    public static final int TYPE_HOME = 0;
    public static final int TYPE_INFO = 1;
    public static final int TYPE_EDIT_ACCOUNT = 3;
    public static final int TYPE_CUSTOMIZE = 4;
    public static final int TYPE_LOGIN = 5;
    public static final int TYPE_BACK = 6;
    public static final int TYPE_ENROLLMENT = 7;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_RESTORE = 1;
    public static final int SUBTYPE_MAXIMIZE = 2;
    public static final int SUBTYPE_MARK = 3;
    public static final int SUBTYPE_LOGOUT = 4;
    public static final int SUBTYPE_ACCEPT_LOGIN = 5;
    public static final int SUBTYPE_SAVE = 6;
    private static final String SCREEN_INFO = "Info";
    private static final String SCREEN_HOME = JetspeedResources.getString("template.homepage");
    private static final String SCREEN_CUSTOMIZE = JetspeedResources.getString("customizer.screen");
    private static final String SCREEN_LOGIN = JetspeedResources.getString("template.login");
    private static final String SCREEN_NEWACCOUNT = "NewAccount";
    private static final String SCREEN_EDIT_ACCOUNT = "EditAccount";
    private static final String ACTION_CUSTOMIZER = JetspeedResources.getString("customizer.action");
    private static final String ACTION_MARKPAGE = "MarkRefPage";
    private static final String ACTION_LOGOUT = JetspeedResources.getString("action.logout");
    private static final String ACTION_ACCEPT_LOGIN = JetspeedResources.getString("action.login");
    private static final String ACTION_CUSTOMIZER_SAVE = "SavePageConfig";
    private static final String ACTION_PREPARE_SCREEN_EDIT_ACCOUNT = "PrepareScreenEditAccount";

    public static String getURI(int aType, int aSubType, RunData rundata) throws JetspeedException {
        return URILookup.getURI(aType, aSubType, null, (String)null, rundata);
    }

    public static String getURI(int aType, int aSubType, Portlet aPortlet, RunData rundata) throws JetspeedException {
        return URILookup.getURI(aType, aSubType, null, aPortlet, rundata);
    }

    public static String getURI(int aType, int aSubType, String aPortletName, RunData rundata) throws JetspeedException {
        return URILookup.getURI(aType, aSubType, null, aPortletName, rundata);
    }

    public static String getURI(int aType, int aSubType, String userData, Portlet aPortlet, RunData rundata) throws JetspeedException {
        if (aPortlet != null) {
            aPortlet = URILookup.getRealPortlet(aPortlet);
            return URILookup.getURI(aType, aSubType, userData, aPortlet.getName(), rundata);
        }
        return URILookup.getURI(aType, aSubType, userData, (String)null, rundata);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getURI(int aType, int aSubType, String userData, String aPortletName, RunData rundata) throws JetspeedException {
        String propertiesParameterValue;
        String newURI = null;
        String propertiesParameter = "URILookup.";
        TemplateLink uri = new TemplateLink(rundata);
        if (aType == 0) {
            propertiesParameter = propertiesParameter + "home.";
            if (aSubType == 1) {
                propertiesParameter = propertiesParameter + "restore.";
                newURI = URILookup.getMarkedPage(rundata);
            } else if (aSubType == 2) {
                propertiesParameter = propertiesParameter + "maximize.";
                if (aPortletName == null) {
                    throw new JetspeedException("A portlet is required to return an URI.");
                }
                uri.setAction(ACTION_MARKPAGE);
                uri.addPathInfo("portlet", aPortletName);
            } else if (aSubType == 4) {
                propertiesParameter = propertiesParameter + "logout.";
                uri.setAction(ACTION_LOGOUT);
            } else if (aSubType == 5) {
                propertiesParameter = propertiesParameter + "acceptlogin.";
                uri.setAction(ACTION_ACCEPT_LOGIN);
            } else if (aSubType != 0) {
                throw new JetspeedException("Incorrect Type / Subtype combination.");
            }
        } else if (aType == 1) {
            propertiesParameter = propertiesParameter + "info.";
            if (aPortletName == null) {
                throw new JetspeedException("A portlet is required to return an URI.");
            }
            uri.setPage(SCREEN_INFO);
            uri.addPathInfo("portlet", aPortletName);
            if (aSubType == 3) {
                propertiesParameter = propertiesParameter + "mark.";
                uri.setAction(ACTION_MARKPAGE);
            } else if (aSubType != 0) {
                throw new JetspeedException("Incorrect Type / Subtype combination.");
            }
        } else if (aType == 3) {
            propertiesParameter = propertiesParameter + "editaccount.";
            uri.setPage(SCREEN_EDIT_ACCOUNT);
            if (aSubType == 0) {
                uri.setAction(ACTION_PREPARE_SCREEN_EDIT_ACCOUNT);
            } else {
                if (aSubType != 3) throw new JetspeedException("Incorrect Type / Subtype combination.");
                propertiesParameter = propertiesParameter + "mark.";
                if (aPortletName == null) {
                    throw new JetspeedException("A portlet is required to return an URI.");
                }
                uri.setAction(ACTION_MARKPAGE);
                uri.addPathInfo("portlet", aPortletName);
            }
        } else if (aType == 4) {
            propertiesParameter = propertiesParameter + "customize.";
            uri.setPage(SCREEN_CUSTOMIZE);
            if (aPortletName != null) {
                uri.addPathInfo("portlet", aPortletName);
            }
            if (aSubType == 0) {
                if (ACTION_CUSTOMIZER != null) {
                    uri.setAction(ACTION_CUSTOMIZER);
                }
            } else {
                if (aSubType != 6) throw new JetspeedException("Incorrect Type / Subtype combination.");
                propertiesParameter = propertiesParameter + "save.";
                uri.setAction(ACTION_CUSTOMIZER_SAVE);
            }
        } else if (aType == 5) {
            propertiesParameter = propertiesParameter + "login.";
            if (aSubType != 0) throw new JetspeedException("Incorrect Type / Subtype combination.");
            uri.setPage(SCREEN_LOGIN);
        } else if (aType == 6) {
            propertiesParameter = propertiesParameter + "back.";
            if (aSubType != 0) throw new JetspeedException("Incorrect Type / Subtype combination.");
            newURI = URILookup.getMarkedPage(rundata);
        } else {
            if (aType != 7) throw new JetspeedException("Incorrect Type / Subtype combination.");
            propertiesParameter = propertiesParameter + "enrollment.";
            uri.setPage(SCREEN_NEWACCOUNT);
        }
        if (newURI == null) {
            newURI = uri.toString();
        }
        if ((propertiesParameterValue = JetspeedResources.getString(propertiesParameter = propertiesParameter + "uri", null)) != null) {
            if (logger.isInfoEnabled()) {
                logger.info("URILookup: replaced uri " + newURI + " with " + propertiesParameterValue);
            }
            newURI = propertiesParameterValue;
        }
        if (userData != null) {
            newURI = URILookup.addURIParameter(newURI, userData);
        }
        if (newURI.indexOf(";jsessionid") != -1) {
            newURI = newURI.substring(0, newURI.indexOf(";jsessionid"));
        }
        if (!(newURI = rundata.getResponse().encodeURL(newURI)).startsWith("/")) return newURI;
        return newURI.substring(1);
    }

    public static int getURIType(RunData rundata) {
        return URILookup.getURIType(null, rundata);
    }

    public static int getURIType(Portlet aPortlet, RunData rundata) {
        if (aPortlet != null && (aPortlet = URILookup.getRealPortlet(aPortlet)).getName().equals(((JetspeedRunData)rundata).getPortlet()) && rundata.getScreen() != null && rundata.getScreen().equals(SCREEN_INFO)) {
            return 1;
        }
        if (rundata.getScreen() != null) {
            if (rundata.getScreen().equals(SCREEN_CUSTOMIZE)) {
                return 4;
            }
            if (rundata.getScreen().equals(SCREEN_NEWACCOUNT)) {
                return 7;
            }
            if (rundata.getScreen().equals(SCREEN_EDIT_ACCOUNT)) {
                return 3;
            }
            if (rundata.getScreen().equals(SCREEN_LOGIN)) {
                return 5;
            }
        }
        return 0;
    }

    public static int getURISubType(Portlet aPortlet, RunData rundata) throws JetspeedException {
        String value;
        if (rundata.getAction() != null) {
            if (rundata.getAction().equals(ACTION_ACCEPT_LOGIN)) {
                return 5;
            }
            if (rundata.getAction().equals(ACTION_LOGOUT)) {
                return 4;
            }
        }
        if ((value = rundata.getRequest().getParameter("type")) != null && value.equalsIgnoreCase("save")) {
            return 6;
        }
        if (aPortlet == null) {
            throw new JetspeedException("A portlet is required.");
        }
        if ((aPortlet = URILookup.getRealPortlet(aPortlet)).getName().equals(((JetspeedRunData)rundata).getPortlet()) && (rundata.getScreen() == null || SCREEN_HOME.equals(rundata.getScreen()))) {
            return 2;
        }
        return 0;
    }

    public static String getURIUserData(RunData rundata) {
        return rundata.getParameters().getString("info");
    }

    public static String getWebAppBaseDirURI(RunData rundata) {
        String ctxtPath = JetspeedResources.getString("content.root.url", "");
        String port = "";
        if ("http".equals(rundata.getServerScheme()) && rundata.getServerPort() != 80) {
            port = port + ":" + rundata.getServerPort();
        }
        if ("https".equals(rundata.getServerScheme()) && rundata.getServerPort() != 443) {
            port = port + ":" + rundata.getServerPort();
        }
        try {
            ctxtPath = rundata.getRequest().getContextPath() + ctxtPath;
        }
        catch (Exception e) {
            logger.error("Servlet container probably not 2.2", e);
        }
        return rundata.getServerScheme() + "://" + rundata.getServerName() + port + ctxtPath;
    }

    public static void markCurrentPage(RunData rundata) {
        HttpSession session = rundata.getSession();
        if (session != null) {
            String uri = URILookup.replaceTurbineURIParameter(rundata.getRequest().getRequestURI(), "action", null);
            session.setAttribute("URILookup_MarkedPage", (Object)uri);
        }
    }

    public static void markPage(String aURI, RunData rundata) {
        HttpSession session = rundata.getSession();
        if (session != null) {
            aURI = URILookup.replaceTurbineURIParameter(aURI, "action", null);
            session.setAttribute("URILookup_MarkedPage", (Object)aURI);
        }
    }

    public static String getMarkedPage(RunData rundata) {
        return URILookup.getMarkedPage(rundata, true);
    }

    public static String getMarkedPage(RunData rundata, boolean relative) {
        HttpSession session = rundata.getSession();
        if (session != null) {
            int idx;
            String markedPage = (String)session.getAttribute("URILookup_MarkedPage");
            if (markedPage != null && relative && (idx = markedPage.indexOf("://")) != -1 && (idx = markedPage.indexOf("/", idx + 3)) != -1 && (idx = markedPage.indexOf("/", idx + 1)) != -1) {
                markedPage = markedPage.substring(idx);
            }
            return markedPage;
        }
        return null;
    }

    public static final PortletEntry getEntry(ParameterParser params) throws Exception {
        String name = params.getString("portlet");
        return (PortletEntry)Registry.getEntry(Registry.PORTLET, name);
    }

    private static Portlet getRealPortlet(Portlet portlet) {
        while (portlet instanceof PortletControl) {
            portlet = ((PortletControl)portlet).getPortlet();
        }
        return portlet;
    }

    private static String replaceTurbineURIParameter(String uri, String parameter, String value) {
        int idx = uri.indexOf("/" + parameter + "/");
        if (idx != -1) {
            int idx2 = uri.indexOf("/", idx + parameter.length() + 2);
            if (idx2 == -1) {
                idx2 = uri.length();
            }
            uri = uri.substring(0, idx) + uri.substring(idx2);
        }
        if (value != null) {
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + parameter + "/" + value;
        }
        return uri;
    }

    private static String resetURIParameter(String uri) {
        if (uri.indexOf("?") != -1) {
            uri = uri.substring(0, uri.indexOf("?"));
        }
        return uri;
    }

    private static String addURIParameter(String uri, String parameter, String value) {
        int idx;
        parameter = URIEncoder.encode(parameter);
        value = URIEncoder.encode(value);
        if (uri.indexOf("?") != -1 && (idx = uri.indexOf(parameter + "=", uri.indexOf("?"))) != -1) {
            int idx2 = uri.indexOf("&", idx);
            if (idx2 == -1) {
                idx2 = uri.length();
            }
            uri = uri.substring(0, idx) + uri.substring(idx2);
        }
        return URILookup.addURIParameter(uri, parameter + "=" + value);
    }

    private static String addURIParameter(String uri, String data) {
        uri = uri.indexOf("?") != -1 ? uri + "&" : uri + "?";
        uri = uri + data;
        return uri;
    }
}

