/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.rewriter;

import java.io.Reader;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.jetspeed.util.rewriter.HTMLRewriter;
import org.apache.jetspeed.util.rewriter.SwingParserAdaptor;
import org.apache.turbine.util.Log;

public class ClipperRewriter
extends HTMLRewriter {
    private String startElement;
    private String stopElement;
    private boolean foundStart = false;
    private boolean foundStop = false;
    private boolean nested = false;
    private int nestedNumber = 0;
    private int startElementNumber;
    private int foundElementNumber = 0;
    private String NOT_FOUND = "<br>Element not found, returning null<br>";
    private String INVALID_START = "<br>Error: received null start element<br>";
    private String INVALID_NUMBER = "<br>Error: received tagNumber negative or null<br>";

    public String rewrite(Reader input, String baseURL) throws MalformedURLException {
        this.baseURL = baseURL;
        String rewrittenHTML = "";
        this.foundStart = false;
        this.foundStop = false;
        this.nestedNumber = 0;
        this.foundElementNumber = 0;
        if (this.startElement == null) {
            return this.INVALID_START;
        }
        if (this.startElementNumber <= 0) {
            return this.INVALID_NUMBER;
        }
        this.nested = this.controlCoupled(this.startElement, this.stopElement);
        SwingParserAdaptor parser = new SwingParserAdaptor(this);
        rewrittenHTML = parser.run(input);
        if (Log.getLogger().isDebugEnabled()) {
            Log.debug((String)("Clipper rewriter: start element:" + this.startElement));
            Log.debug((String)("Clipper rewriter: stop element:" + this.stopElement));
            Log.debug((String)("Clipper rewriter: foundStart:" + this.foundStart));
            Log.debug((String)("Clipper rewriter: foundStop:" + this.foundStop));
            Log.debug((String)("Clipper rewriter: nested:" + this.nested));
            Log.debug((String)("Clipper rewriter: foundElementNumber:" + this.foundElementNumber));
            Log.debug((String)("Clipper rewriter: rewrittenHTML:" + rewrittenHTML));
        }
        if (!this.foundStart || !this.foundStop && this.stopElement != null) {
            return this.NOT_FOUND;
        }
        return rewrittenHTML;
    }

    public boolean proxyAllTags() {
        return true;
    }

    public boolean enterSimpleTagEvent(HTML.Tag tag, MutableAttributeSet attrs) {
        String attributes = this.attrsToString(attrs);
        String tagString = tag.toString();
        return this.checkTag(tagString, attributes, "simple");
    }

    public boolean enterStartTagEvent(HTML.Tag tag, MutableAttributeSet attrs) {
        String attributes = this.attrsToString(attrs);
        String tagString = tag.toString();
        return this.checkTag(tagString, attributes, "start");
    }

    public boolean enterEndTagEvent(HTML.Tag tag) {
        String tagString = tag.toString();
        return this.checkTag(tagString, null, "end");
    }

    public boolean enterText(char[] values, int param) {
        return this.foundStart && !this.foundStop && this.stopElement != null;
    }

    public void setStartElement(String startElement) {
        this.startElement = startElement;
    }

    public void setStopElement(String stopElement) {
        this.stopElement = stopElement;
    }

    public void setStartElementNumber(int startElementNumber) {
        this.startElementNumber = startElementNumber;
    }

    private boolean controlCoupled(String start, String stop) {
        StringTokenizer startTok = new StringTokenizer(start);
        boolean foundCoupled = false;
        if (stop == null) {
            return false;
        }
        while (startTok.hasMoreTokens()) {
            String token = startTok.nextToken();
            if (!token.equals(stop)) continue;
            return true;
        }
        return false;
    }

    private String attrsToString(MutableAttributeSet attrs) {
        String element = "";
        if (attrs != null) {
            Enumeration<?> en = attrs.getAttributeNames();
            while (en.hasMoreElements()) {
                Object attr = en.nextElement();
                element = element + " " + attr.toString() + "=" + attrs.getAttribute(attr).toString();
            }
            return element;
        }
        return null;
    }

    private boolean checkTag(String tag, String attrs, String position) {
        if (!this.foundStart) {
            if (this.compareTag(tag, attrs, this.startElement) && (!position.equals("end") || this.stopElement == null)) {
                ++this.foundElementNumber;
                if (this.foundElementNumber == this.startElementNumber) {
                    this.foundStart = true;
                    if (this.nested) {
                        ++this.nestedNumber;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        if (!this.foundStop && this.stopElement != null) {
            if (this.compareTag(tag, attrs, this.stopElement)) {
                if (this.nested) {
                    if (position.equals("start")) {
                        ++this.nestedNumber;
                    } else if (position.equals("end")) {
                        --this.nestedNumber;
                    }
                }
                if (this.nestedNumber == 0 && !position.equals("start")) {
                    this.foundStop = true;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean compareTag(String tag, String attrs, String base) {
        StringTokenizer baseTok = new StringTokenizer(base);
        boolean foundTag = false;
        while (baseTok.hasMoreTokens()) {
            String token = baseTok.nextToken();
            if (token.equals(tag)) {
                foundTag = true;
                continue;
            }
            if (attrs == null) {
                return false;
            }
            if (attrs.indexOf(token) != -1) continue;
            return false;
        }
        if (!foundTag) {
            return false;
        }
        if (Log.getLogger().isDebugEnabled()) {
            Log.debug((String)("Clipper rewriter: match between tag " + tag + ", attrs " + attrs + ", and searched: " + base));
        }
        return true;
    }
}

