/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.rewriter;

import java.io.Reader;
import java.net.MalformedURLException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.jetspeed.util.rewriter.HTMLRewriter;
import org.apache.jetspeed.util.rewriter.SwingParserAdaptor;

public class SampleRewriter
extends HTMLRewriter {
    private boolean debug = false;
    private String basePortalURL;
    private String fullPortalURL;
    private String sampleURL;
    private String sessionID = "NONE";
    private String formID = "NONE";
    private boolean sampleEndFlag = false;

    public String getSessionID() {
        return this.sessionID;
    }

    public String getFormID() {
        return this.formID;
    }

    public boolean getSampleEndFlag() {
        return this.sampleEndFlag;
    }

    public SampleRewriter(String basePortalURL, String fullPortalURL, String sampleURL) {
        this.basePortalURL = basePortalURL;
        this.fullPortalURL = fullPortalURL;
        this.sampleURL = sampleURL;
    }

    public String rewrite(Reader input, String baseURL) throws MalformedURLException {
        String rewrittenHTML = "";
        this.basePortalURL = baseURL;
        SwingParserAdaptor parser = new SwingParserAdaptor(this);
        rewrittenHTML = parser.run(input);
        return rewrittenHTML;
    }

    public String generateNewUrl(String targetURL, HTML.Tag tag, HTML.Attribute attribute) {
        if (this.debug) {
            System.out.println("[rewriter] Tag: " + tag.toString() + "  Attribute: " + attribute.toString() + "  targetURL: " + targetURL + "  target = " + this.fullPortalURL + "]");
        }
        if (tag == HTML.Tag.FORM && attribute == HTML.Attribute.ACTION) {
            int equalsLocation;
            int sessionLocation = targetURL.indexOf("?sessionId");
            if (sessionLocation > -1 && (equalsLocation = targetURL.indexOf("=", sessionLocation)) > -1) {
                int ampLocation = targetURL.indexOf("&", equalsLocation);
                this.sessionID = ampLocation > -1 ? targetURL.substring(equalsLocation + 1, ampLocation) : targetURL.substring(equalsLocation + 1);
            }
            if (this.sampleEndFlag) {
                return this.basePortalURL;
            }
            return this.fullPortalURL;
        }
        return targetURL;
    }

    public boolean proxyAllTags() {
        return true;
    }

    public String exitStartTagEvent(HTML.Tag tag, MutableAttributeSet attrs) {
        if (tag == HTML.Tag.FORM) {
            String inputTag = "<input type='hidden' name='sessionId' value='" + this.sessionID + "'/>";
            return inputTag;
        }
        return null;
    }

    public boolean enterSimpleTagEvent(HTML.Tag tag, MutableAttributeSet attrs) {
        String s;
        Object o;
        if (tag == HTML.Tag.META && (o = attrs.getAttribute(HTML.Attribute.NAME)) != null && (s = o.toString()).equalsIgnoreCase("SampleEnd")) {
            this.sampleEndFlag = true;
        }
        return true;
    }

    public void convertTagEvent(HTML.Tag tag, MutableAttributeSet attrs) {
        String s;
        Object o;
        if (tag == HTML.Tag.FORM) {
            attrs.addAttribute("NAME", "SampleForm");
        }
        if (tag == HTML.Tag.INPUT && (o = attrs.getAttribute(HTML.Attribute.NAME)) != null && (s = o.toString()).equalsIgnoreCase("FormID") && (o = attrs.getAttribute(HTML.Attribute.VALUE)) != null) {
            this.formID = o.toString();
        }
    }
}

