/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail;

import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALMailContext;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailReceiver;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.ALMailSender;
import com.aimluck.eip.mail.ALMailSenderContext;
import com.aimluck.eip.mail.ALSmtpMailContext;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public abstract class ALMailHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALMailHandler.class.getName());

    public int receive(ALMailReceiverContext rcontext, String orgId) throws Exception {
        int result = -1;
        try {
            ALMailReceiver receiver = this.getALMailReceiver(rcontext);
            result = receiver.receive(orgId);
        }
        catch (Exception e) {
            result = -1;
            logger.error((Object)"ALMailHandler.receive", (Throwable)e);
        }
        return result;
    }

    protected abstract ALMailReceiver getALMailReceiver(ALMailReceiverContext var1);

    public int send(ALMailSenderContext scontext, ALMailContext mcontext) throws Exception {
        int result = 0;
        try {
            ALMailSender sender = this.getALMailSender(scontext);
            result = sender.send(mcontext);
        }
        catch (Exception e) {
            logger.error((Object)"ALMailHandler.send", (Throwable)e);
            result = 1;
        }
        return result;
    }

    public int sendAdmin(ALMailSenderContext scontext, ALMailContext mcontext) throws Exception {
        int result = 0;
        try {
            ALMailSender sender = this.getALAdminMailSender(scontext);
            result = sender.send(mcontext);
        }
        catch (Exception e) {
            logger.error((Object)"ALMailHandler.sendAdmin", (Throwable)e);
            result = 1;
        }
        return result;
    }

    protected abstract ALMailSender getALMailSender(ALMailSenderContext var1);

    protected abstract ALMailSender getALAdminMailSender(ALMailSenderContext var1);

    public abstract ALFolder getALFolder(int var1, String var2, int var3, int var4);

    private SelectQuery<EipTMail> getUnReadMailQuery(ALMailReceiverContext rcontext, List<Integer> foler_ids) {
        try {
            SelectQuery query = Database.query(EipTMail.class);
            if (rcontext != null) {
                if (Integer.valueOf(rcontext.getAccountId()) != null || Integer.valueOf(rcontext.getUserId()) != null) {
                    Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)rcontext.getUserId());
                    Expression exp2 = ExpressionFactory.matchExp((String)"accountId", (Object)rcontext.getAccountId());
                    Expression exp3 = ExpressionFactory.matchExp((String)"type", (Object)"R");
                    Expression exp4 = ExpressionFactory.matchExp((String)"readFlg", (Object)"F");
                    query.setQualifier(exp1.andExp(exp2).andExp(exp3).andExp(exp4));
                    if (foler_ids != null && foler_ids.size() > 0) {
                        Expression exp5 = ExpressionFactory.inExp((String)"folderId", foler_ids);
                        query.andQualifier(exp5);
                    }
                    return query;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"ALMailHandler.getUnReadMailQuery", (Throwable)e);
            return null;
        }
    }

    public int getUnReadMailSum(ALMailReceiverContext rcontext) {
        try {
            SelectQuery<EipTMail> query = this.getUnReadMailQuery(rcontext, null);
            if (query != null) {
                query.select("MAIL_ID");
                return query.getCount();
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Map<Integer, Integer> getUnReadMailSumMap(ALMailReceiverContext rcontext) {
        HashMap<Integer, Integer> mailSumMap = new HashMap<Integer, Integer>();
        try {
            EipMMailAccount account = ALMailUtils.getMailAccount(rcontext.getUserId(), rcontext.getAccountId());
            List<EipTMailFolder> folders = ALMailUtils.getEipTMailFolderAll(account);
            ArrayList<Integer> folder_ids = new ArrayList<Integer>();
            for (EipTMailFolder folder : folders) {
                int folder_id = folder.getFolderId();
                folder_ids.add(folder_id);
                mailSumMap.put(folder_id, 0);
            }
            Iterator iterator = folder_ids.iterator();
            while (iterator.hasNext()) {
                int _foler_id = (Integer)iterator.next();
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(_foler_id);
                SelectQuery<EipTMail> countquery = this.getUnReadMailQuery(rcontext, list);
                int count = countquery == null ? 0 : countquery.orderAscending("folderId").getCount();
                mailSumMap.put(_foler_id, count);
            }
        }
        catch (Exception e) {
            logger.error((Object)"ALMailHandler.getUnReadMailSumMap", (Throwable)e);
        }
        return mailSumMap;
    }

    public int getNewMailSum(ALMailReceiverContext rcontext) throws Exception {
        int result = -1;
        try {
            ALMailReceiver receiver = this.getALMailReceiver(rcontext);
            result = receiver != null ? receiver.getNewMailSum() : -1;
        }
        catch (Exception e) {
            logger.error((Object)"ALMailHandler.getNewMailSum", (Throwable)e);
            result = -1;
        }
        return result;
    }

    public abstract boolean removeAccount(String var1, int var2, int var3);

    public List<String> sendAdminMail(ALAdminMailContext adminMailContext) throws Exception {
        ArrayList<String> msgList = new ArrayList<String>();
        int destType = adminMailContext.getDestType();
        List<ALAdminMailMessage> messageList = adminMailContext.getMessageList();
        String org_id = adminMailContext.getOrgId();
        if (destType < 0 || destType > 3) {
            return msgList;
        }
        if (messageList == null || messageList.size() == 0) {
            return msgList;
        }
        EipMMailAccount account = ALMailUtils.getEipMMailAccountForAdmin();
        int successSendToPc = 0;
        int successSendToCell = 0;
        if (account == null) {
            if (destType == 1) {
                successSendToPc = 6;
            } else if (destType == 2) {
                successSendToCell = 6;
            } else {
                successSendToPc = 6;
                successSendToCell = 6;
            }
        } else {
            ALSmtpMailContext mailcontext;
            String[] tos;
            String emailAddr;
            ALMailHandler mailhandler = ALMailFactoryService.getInstance().getMailHandler();
            ALMailSenderContext scontext = ALMailUtils.getALSmtpMailSenderContext(org_id, account);
            if (destType == 1 || destType == 3) {
                for (ALAdminMailMessage message : messageList) {
                    if (!ALEipUtils.isEnabledUser((int)message.getUserId()) || (emailAddr = message.getPcMailAddr()) == null || emailAddr.equals("")) continue;
                    tos = new String[]{emailAddr};
                    mailcontext = ALMailUtils.getALSmtpMailContext(tos, null, null, account.getMailAddress(), ALStringUtil.unsanitizing((String)account.getMailUserName()), ALStringUtil.unsanitizing((String)message.getPcSubject()), ALStringUtil.unsanitizing((String)message.getPcBody()), null, null);
                    successSendToPc = mailhandler.sendAdmin(scontext, mailcontext);
                }
            }
            if (destType == 2 || destType == 3) {
                for (ALAdminMailMessage message : messageList) {
                    if (!ALEipUtils.isEnabledUser((int)message.getUserId()) || (emailAddr = message.getCellMailAddr()) == null || emailAddr.equals("")) continue;
                    tos = new String[]{emailAddr};
                    mailcontext = ALMailUtils.getALSmtpMailContext(tos, null, null, account.getMailAddress(), ALStringUtil.unsanitizing((String)account.getMailUserName()), ALStringUtil.unsanitizing((String)message.getCellularSubject()), ALStringUtil.unsanitizing((String)message.getCellularBody()), null, null);
                    successSendToCell = mailhandler.sendAdmin(scontext, mailcontext);
                }
            }
        }
        if (successSendToPc != 0) {
            if (successSendToPc == 2) {
                msgList.add("\u30e1\u30fc\u30eb\u30b5\u30a4\u30ba\u304c\u9001\u4fe1\u53ef\u80fd\u30b5\u30a4\u30ba\u3088\u308a\u3082\u5927\u304d\u3044\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 3) {
                msgList.add("\u30ed\u30c3\u30af\u304c\u304b\u304b\u3063\u3066\u3044\u3066\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 4) {
                msgList.add("Pop before SMTP\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 5) {
                msgList.add("SMTP\u8a8d\u8a3c\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 6) {
                msgList.add("\u7ba1\u7406\u8005\u306e\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else {
                msgList.add("\u9001\u4fe1\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3067\u304d\u306a\u304b\u3063\u305f\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            }
        }
        if (successSendToCell != 0) {
            if (successSendToCell == 2) {
                msgList.add("\u30e1\u30fc\u30eb\u30b5\u30a4\u30ba\u304c\u9001\u4fe1\u53ef\u80fd\u30b5\u30a4\u30ba\u3088\u308a\u3082\u5927\u304d\u3044\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 3) {
                msgList.add("\u30ed\u30c3\u30af\u304c\u304b\u304b\u3063\u3066\u3044\u3066\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 4) {
                msgList.add("Pop before SMTP\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 5) {
                msgList.add("SMTP\u8a8d\u8a3c\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 6) {
                msgList.add("\u7ba1\u7406\u8005\u306e\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else {
                msgList.add("\u9001\u4fe1\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3067\u304d\u306a\u304b\u3063\u305f\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            }
        }
        return msgList;
    }

    public abstract long getFolderSize(String var1, int var2, int var3);
}

