/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail.util;

import com.sk_jp.mail.AttachmentsExtractor;
import com.sk_jp.mail.MailUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALAttachmentsExtractor
extends AttachmentsExtractor {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALAttachmentsExtractor.class.getName());
    private final int mode;
    private final List<Part> attachmentParts = new ArrayList<Part>();

    public ALAttachmentsExtractor() {
        this(0);
    }

    public ALAttachmentsExtractor(int mode) {
        this.mode = mode;
    }

    public boolean processPart(Part part, ContentType context) throws MessagingException, IOException {
        if (part.isMimeType("message/*")) {
            if ((this.mode & 1) != 0) {
                return true;
            }
            this.attachmentParts.add(part);
            return true;
        }
        if (part.isMimeType("text/html")) {
            this.attachmentParts.add(part);
            return true;
        }
        if (MailUtility.getFileName((Part)part) == null) {
            return true;
        }
        if ((this.mode & 2) != 0 && "inline".equalsIgnoreCase(part.getDisposition())) {
            return true;
        }
        this.attachmentParts.add(part);
        return true;
    }

    public String getFileName(int index) throws MessagingException {
        Part part = this.attachmentParts.get(index);
        try {
            String name = null;
            if (part.getFileName() != null) {
                name = MimeUtility.decodeText((String)part.getFileName());
            }
            if (name == null) {
                name = part.isMimeType("message/*") ? "message" + index + ".eml" : (part.isMimeType("text/html") ? "message" + index + ".html" : "file" + index + ".tmp");
            }
            return name;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"ALAttachmentsExtractor.getFileName", (Throwable)e);
            return null;
        }
    }

    public int getCount() {
        return this.attachmentParts.size();
    }

    public String getContentType(int index) throws MessagingException {
        return MailUtility.unfold((String)this.attachmentParts.get(index).getContentType());
    }

    public int getSize(int index) throws MessagingException {
        return this.attachmentParts.get(index).getSize();
    }

    public InputStream getInputStream(int index) throws MessagingException, IOException {
        return this.attachmentParts.get(index).getInputStream();
    }
}

