/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail.util;

import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipMMailNotifyConf;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFilter;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailMessage;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.ALMailSenderContext;
import com.aimluck.eip.mail.ALPop3MailReceiverContext;
import com.aimluck.eip.mail.ALSmtpMailContext;
import com.aimluck.eip.mail.ALSmtpMailSenderContext;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.UnicodeCorrecter;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALServletUtils;
import com.sk_jp.mail.JISDataSource;
import com.sk_jp.mail.MailUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.Key;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.upload.TurbineUpload;
import org.apache.turbine.util.RunData;

public class ALMailUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALMailUtils.class.getName());
    public static final String CR = System.getProperty("line.separator");
    public static final int ACCOUNT_TYPE_NON = 0;
    public static final int ACCOUNT_TYPE_DEFAULT = 1;
    public static final int ACCOUNT_TYPE_INIT = 2;
    public static final int KEY_MSGTYPE_DAYMAIL = 1;
    public static final int KEY_MSGTYPE_NOTE = 21;
    public static final int KEY_MSGTYPE_BLOG = 22;
    public static final int KEY_MSGTYPE_WORKFLOW = 23;
    public static final int KEY_MSGTYPE_SCHEDULE = 24;
    public static final int KEY_MSGTYPE_TODO = 25;
    public static final int KEY_MSGTYPE_REPORT = 26;
    public static final int KEY_MSGTYPE_MSGBOARD = 27;
    public static final int VALUE_MSGTYPE_DEST_NONE = 0;
    public static final int VALUE_MSGTYPE_DEST_PC = 1;
    public static final int VALUE_MSGTYPE_DEST_CELLULAR = 2;
    public static final int VALUE_MSGTYPE_DEST_PC_CELLULAR = 3;
    public static final int COMPARE_TYPE_ASC = 1;
    public static final int COMPARE_TYPE_DESC = 2;
    public static final int COMPARE_NAME_SUBJECT = 1;
    public static final int COMPARE_NAME_PERSON = 2;
    public static final int COMPARE_NAME_DATE = 3;
    public static final int COMPARE_NAME_FILE_VOLUME = 4;
    public static final String DATE_FORMAT = "yyyy/MM/dd HH:mm";
    public static final String storePath = JetspeedResources.getString((String)"aipo.home", (String)"");
    public static final String rootFolderPath = JetspeedResources.getString((String)"aipo.mail.home", (String)"");
    public static final String categoryKey = JetspeedResources.getString((String)"aipo.mail.key", (String)"");
    private static final String seacretPassword = "1t's a s3@cr3t k3y";
    public static final String FILTER_TYPE_MAILADDRESS = "M";
    public static final String FILTER_TYPE_DOMAIN = "D";
    public static final String FILTER_TYPE_SUBJECT = "S";
    public static final String FILTER_TYPE_TO = "T";
    public static final String FOLDER_ID = "folderid";

    public static EipMMailAccount getMailAccount(int userId, int accountId) {
        if (userId < 0 || accountId < 0) {
            return null;
        }
        try {
            SelectQuery query = Database.query(EipMMailAccount.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
            Expression exp2 = ExpressionFactory.matchDbExp((String)"ACCOUNT_ID", (Object)accountId);
            EipMMailAccount account = (EipMMailAccount)query.andQualifier(exp1).andQualifier(exp2).fetchSingle();
            if (account == null) {
                logger.error((Object)"[WebMail] Not found AccountID...");
                return null;
            }
            return account;
        }
        catch (Exception ex) {
            logger.error((Object)"ALMailUtils.getMailAccount", (Throwable)ex);
            return null;
        }
    }

    public static List<EipMMailAccount> getMailAccountList(int userId) {
        if (userId < 0) {
            return null;
        }
        try {
            SelectQuery query = Database.query(EipMMailAccount.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
            List fetchList = query.andQualifier(exp1).fetchList();
            if (fetchList == null || fetchList.size() <= 0) {
                logger.debug((Object)"[WebMail] Not found AccountID...");
                return null;
            }
            return fetchList;
        }
        catch (Exception ex) {
            logger.error((Object)"ALMailUtils.getMailAccountList", (Throwable)ex);
            return null;
        }
    }

    public static String getAccountName(int userId, int accountId) {
        if (userId < 0 || accountId < 0) {
            return null;
        }
        String accountName = null;
        try {
            EipMMailAccount mailAccount = ALMailUtils.getMailAccount(userId, accountId);
            if (mailAccount == null) {
                return null;
            }
            accountName = mailAccount.getAccountName();
        }
        catch (Exception ex) {
            logger.error((Object)"ALMailUtils.getAccountName", (Throwable)ex);
            return null;
        }
        return accountName;
    }

    public static ALMailMessage getReplyMessage(ALMailMessage mailmsg) {
        if (mailmsg == null) {
            return null;
        }
        ALLocalMailMessage msg = null;
        try {
            msg = (ALLocalMailMessage)mailmsg;
            StringBuffer sb = new StringBuffer();
            sb.append("From: ").append(ALMailUtils.getFromDelegate(msg)).append(CR);
            sb.append("To: ").append(ALMailUtils.getAddressString(msg.getRecipients(Message.RecipientType.TO, false))).append(CR);
            sb.append("Sent: ").append(msg.getSentDate()).append(CR);
            sb.append("Subject: ").append(UnicodeCorrecter.correctToISO2022JP(msg.getSubject())).append(CR).append(" ").append(CR);
            msg.setSubject(MimeUtility.encodeText((String)UnicodeCorrecter.correctToISO2022JP(msg.getSubject())));
            msg.setRecipient(Message.RecipientType.TO, ALMailUtils.getReplyToDelegateExtract(msg));
            String[] lines = msg.getBodyTextArray();
            if (lines != null && lines.length > 0) {
                int length = lines.length;
                for (int i = 0; i < length; ++i) {
                    sb.append(lines[i]).append(CR);
                }
            }
            msg.setText(UnicodeCorrecter.correctToISO2022JP(sb.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"ALMailUtils.getReplyMessage", (Throwable)e);
            return null;
        }
        return msg;
    }

    public static ALMailMessage getReplyAllMessage(ALMailMessage mailmsg) {
        if (mailmsg == null) {
            return null;
        }
        ALLocalMailMessage msg = null;
        try {
            msg = (ALLocalMailMessage)mailmsg;
            StringBuffer sb = new StringBuffer();
            sb.append("From: ").append(ALMailUtils.getFromDelegate(msg)).append(CR);
            sb.append("To: ").append(ALMailUtils.getAddressString(msg.getRecipients(Message.RecipientType.TO, false))).append(CR);
            sb.append("Sent: ").append(msg.getSentDate()).append(CR);
            sb.append("Subject: ").append(UnicodeCorrecter.correctToISO2022JP(msg.getSubject())).append(CR).append(" ").append(CR);
            msg.setSubject(MimeUtility.encodeText((String)UnicodeCorrecter.correctToISO2022JP(msg.getSubject())));
            String[] lines = msg.getBodyTextArray();
            if (lines != null && lines.length > 0) {
                int length = lines.length;
                for (int i = 0; i < length; ++i) {
                    sb.append(lines[i]).append(CR);
                }
            }
            msg.setText(UnicodeCorrecter.correctToISO2022JP(sb.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"ALMailUtils.getReplyMessage", (Throwable)e);
            return null;
        }
        return msg;
    }

    public static ALMailMessage getForwardMessage(ALMailMessage mailmsg) {
        if (mailmsg == null) {
            return null;
        }
        ALLocalMailMessage msg = null;
        try {
            msg = (ALLocalMailMessage)mailmsg;
            StringBuffer sb = new StringBuffer();
            sb.append("From: ").append(ALMailUtils.getFromDelegate(msg)).append(CR);
            sb.append("To: ").append(ALMailUtils.getAddressString(msg.getRecipients(Message.RecipientType.TO, false))).append(CR);
            sb.append("Sent: ").append(msg.getSentDate()).append(CR);
            sb.append("Subject: ").append(UnicodeCorrecter.correctToISO2022JP(msg.getSubject())).append(CR).append(" ").append(CR);
            msg.setSubject(MimeUtility.encodeText((String)UnicodeCorrecter.correctToISO2022JP(msg.getSubject())));
            String[] lines = msg.getBodyTextArray();
            if (lines != null && lines.length > 0) {
                int length = lines.length;
                for (int i = 0; i < length; ++i) {
                    sb.append(lines[i]).append(CR);
                }
            }
            msg.setText(UnicodeCorrecter.correctToISO2022JP(sb.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"ALMailUtils.getForwardMessage", (Throwable)e);
            return null;
        }
        return msg;
    }

    public static String[] getLines(String str) {
        if (str == null || str.equals("")) {
            return null;
        }
        if (str.indexOf(CR) < 0) {
            return new String[]{str};
        }
        String token = null;
        ArrayList<String> tokens = new ArrayList<String>();
        BufferedReader reader = null;
        String[] lines = null;
        try {
            reader = new BufferedReader(new StringReader(str));
            while ((token = reader.readLine()) != null) {
                tokens.add(token);
            }
            reader.close();
            lines = new String[tokens.size()];
            lines = tokens.toArray(lines);
        }
        catch (Exception ioe) {
            logger.error((Object)"ALMailUtils.getLines", (Throwable)ioe);
            try {
                reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
        return lines;
    }

    public static String[] getTokens(String line, String delim) {
        if (line == null || line.equals("")) {
            return null;
        }
        if (line.indexOf(delim) < 0) {
            if (delim.length() > 1 && !"\r\n".equals(delim)) {
                String regex = "^.*[" + delim + "].*";
                if (!line.matches(regex)) {
                    return new String[]{line};
                }
            } else {
                return new String[]{line};
            }
        }
        StringTokenizer st = new StringTokenizer(line, delim);
        int length = st.countTokens();
        String[] tokens = new String[length];
        for (int i = 0; i < length; ++i) {
            tokens[i] = st.nextToken();
        }
        return tokens;
    }

    public static int[] reverse(int[] objs) {
        if (objs == null) {
            return null;
        }
        int length = objs.length;
        int[] destObjs = new int[length];
        System.arraycopy(objs, 0, destObjs, 0, length);
        Arrays.sort(destObjs);
        int[] reverseObjs = new int[length];
        for (int i = 0; i < length; ++i) {
            reverseObjs[i] = destObjs[length - i - 1];
        }
        return reverseObjs;
    }

    public static String getAddressString(Address[] addresses) {
        if (addresses == null || addresses.length <= 0) {
            return "";
        }
        HashSet<String> foundAddress = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        InternetAddress addr = null;
        int length = addresses.length;
        for (int i = 0; i < length; ++i) {
            addr = (InternetAddress)addresses[i];
            if (foundAddress.contains(addr.getAddress())) continue;
            foundAddress.add(addr.getAddress());
            if (addr.getPersonal() != null) {
                String personaladdr = ALMailUtils.getOneString(ALMailUtils.getTokens(addr.getPersonal(), "\r\n"), "");
                sb.append(personaladdr).append(" <").append(addr.getAddress()).append(">, ");
                continue;
            }
            sb.append(addr.getAddress()).append(", ");
        }
        String addressStr = sb.toString();
        return addressStr.substring(0, addressStr.length() - 2);
    }

    public static String getOneString(String[] strs, String delim) {
        if (strs == null) {
            return "";
        }
        String delimiter = delim + " ";
        StringBuffer sb = new StringBuffer();
        int length = strs.length - 1;
        for (int i = 0; i < length; ++i) {
            sb.append(strs[i]).append(delimiter);
        }
        sb.append(strs[length]);
        return sb.toString();
    }

    public static String translateDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("JST"));
        return sdf.format(date);
    }

    public static Date translateDate(String dateStr) {
        if (dateStr == null || dateStr.equals("")) {
            return null;
        }
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("JST"));
        try {
            date = sdf.parse(dateStr);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public static Date getReceivedDate(MimeMessage msg) {
        try {
            String[] receivedHeaders = msg.getHeader("Received");
            if (receivedHeaders == null || receivedHeaders.length == 0) {
                return null;
            }
            Date receivedDate = null;
            StringTokenizer st = new StringTokenizer(receivedHeaders[0], ";");
            if (st.countTokens() == 2) {
                st.nextToken();
                String receivedDateStr = st.nextToken();
                if (receivedDateStr != null && !receivedDateStr.equals("")) {
                    receivedDate = MailUtility.parseDate((String)receivedDateStr);
                }
                return receivedDate;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String convertBase64ToIso2022(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer("=?ISO-2022-JP?B?");
        sb.append(str).append("?=");
        return sb.toString();
    }

    public static String encodeWordJIS(String s) {
        try {
            return "=?ISO-2022-JP?B?" + new String(Base64.encodeBase64((byte[])s.getBytes("ISO-2022-JP"))) + "?=";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("CANT HAPPEN");
        }
    }

    public static InternetAddress getInternetAddress(String addr) {
        InternetAddress address = null;
        StringTokenizer st = new StringTokenizer(addr, "<>");
        int count = st.countTokens();
        try {
            if (count <= 0) {
                return null;
            }
            if (count == 1) {
                address = new InternetAddress(st.nextToken().trim());
            } else if (count == 2) {
                String name = st.nextToken().trim();
                String addressStr = st.nextToken().trim();
                address = new InternetAddress(addressStr, ALMailUtils.encodeWordJIS(name));
            } else if (count > 2) {
                String name = "";
                String addressStr = "";
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken().trim();
                    if (!ALStringUtil.isMailAddress((String)tmp)) continue;
                    addressStr = tmp;
                }
                if (!"".equals(addressStr)) {
                    String tmpName = addr.replace("<" + addressStr + ">", "").trim();
                    name = !"\"".equals(tmpName.substring(0, 1)) || !"\"".equals(tmpName.substring(tmpName.length() - 1, tmpName.length())) ? "\"" + tmpName + "\"" : tmpName;
                }
                address = new InternetAddress(addressStr, ALMailUtils.encodeWordJIS(name));
            }
        }
        catch (Exception e) {
            logger.error((Object)"ALMailUtils.getInternetAddress", (Throwable)e);
            return null;
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileNameFromText(String filePath) {
        String line = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(ALStorageService.getFile((String)(filePath + ".txt")), ALEipConstants.DEF_CONTENT_ENCODING));
            line = reader.readLine();
        }
        catch (Exception e) {
            logger.error((Object)"ALMailUtils.getFileNameFromText", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"ALMailUtils.getFileNameFromText", (Throwable)ex);
                }
            }
        }
        return line;
    }

    public static void setTextContent(Part p, String s) throws MessagingException {
        p.setDataHandler(new DataHandler((DataSource)new JISDataSource(s)));
        p.setHeader("Content-Transfer-Encoding", "7bit");
    }

    public static final byte[] getDecryptedMailAccountPasswd(byte[] data) {
        return ALMailUtils.getDecryptedMailAccountPasswd(seacretPassword.toCharArray(), data);
    }

    public static final byte[] getDecryptedMailAccountPasswd(char[] password, byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] decryptedData = null;
        try {
            decryptedData = ALMailUtils.cryptPBEWithMD5AndDES(2, password, data);
            if (decryptedData == null) {
                return null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"ALMailUtils.getDecryptedMailAccountPasswd", (Throwable)e);
            return null;
        }
        return decryptedData;
    }

    public static final byte[] getEncryptedMailAccountPasswd(byte[] data) {
        return ALMailUtils.getEncryptedMailAccountPasswd(seacretPassword.toCharArray(), data);
    }

    public static final byte[] getEncryptedMailAccountPasswd(char[] password, byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] encryptedData = null;
        try {
            encryptedData = ALMailUtils.cryptPBEWithMD5AndDES(1, password, data);
        }
        catch (Exception e) {
            logger.error((Object)"ALMailUtils.getEncryptedMailAccountPasswd", (Throwable)e);
            return null;
        }
        return encryptedData;
    }

    public static final byte[] cryptPBEWithMD5AndDES(int cipherMode, char[] password, byte[] data) {
        byte[] ciphertext = null;
        byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
        int count = 20;
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(cipherMode, (Key)pbeKey, pbeParamSpec);
            ciphertext = pbeCipher.doFinal(data);
        }
        catch (Exception e) {
            logger.error((Object)"ALMailUtils.cryptPBEWithMD5AndDES", (Throwable)e);
            return null;
        }
        return ciphertext;
    }

    public static ALMailReceiverContext getALPop3MailReceiverContext(String orgId, EipMMailAccount account) {
        if (account == null) {
            return null;
        }
        ALPop3MailReceiverContext rcontext = new ALPop3MailReceiverContext();
        try {
            rcontext.setOrgId(orgId);
            rcontext.setUserId(account.getUserId());
            rcontext.setAccountId(account.getAccountId());
            rcontext.setPop3Host(account.getPop3serverName());
            rcontext.setPop3Port(account.getPop3Port());
            rcontext.setPop3UserId(account.getPop3userName());
            rcontext.setPop3UserPasswd(new String(ALMailUtils.getDecryptedMailAccountPasswd(account.getPop3password())));
            rcontext.setDelete(Integer.parseInt(account.getDelAtPop3Flg()) == 1);
            rcontext.setEnableSavingDays(Integer.parseInt(account.getDelAtPop3BeforeDaysFlg()) == 1);
            rcontext.setSavingDays(account.getDelAtPop3BeforeDays());
            rcontext.setDenyReceivedMail(Integer.parseInt(account.getNonReceivedFlg()) == 1);
            rcontext.setAuthReceiveFlag(account.getAuthReceiveFlg().intValue());
            rcontext.setEncryptionFlag(account.getPop3EncryptionFlg().shortValue());
        }
        catch (Exception e) {
            logger.error((Object)"ALMailUtils.getALPop3MailReceiverContext", (Throwable)e);
            return null;
        }
        return rcontext;
    }

    public static ALMailSenderContext getALSmtpMailSenderContext(String orgId, EipMMailAccount account) {
        if (account == null) {
            return null;
        }
        ALSmtpMailSenderContext scontext = new ALSmtpMailSenderContext();
        short authSendFlg = 0;
        try {
            authSendFlg = account.getAuthSendFlg();
        }
        catch (NumberFormatException e) {
            authSendFlg = 0;
        }
        try {
            scontext.setOrgId(orgId);
            scontext.setUserId(account.getUserId());
            scontext.setAccountId(account.getAccountId());
            scontext.setSmtpHost(account.getSmtpserverName());
            scontext.setSmtpPort(account.getSmtpPort());
            scontext.setAuthSendFlag(authSendFlg);
            scontext.setAuthSendUserId(account.getAuthSendUserId());
            scontext.setEncryptionFlag(account.getSmtpEncryptionFlg().shortValue());
            byte[] auth_pass = ALMailUtils.getDecryptedMailAccountPasswd(account.getAuthSendUserPasswd());
            if (auth_pass != null) {
                scontext.setAuthSendUserPassword(new String(ALMailUtils.getDecryptedMailAccountPasswd(account.getAuthSendUserPasswd())));
            } else {
                scontext.setAuthSendUserPassword(null);
            }
            scontext.setPop3Host(account.getPop3serverName());
            scontext.setPop3Port(account.getPop3Port());
            scontext.setPop3UserId(account.getPop3userName());
            scontext.setPop3UserPasswd(new String(ALMailUtils.getDecryptedMailAccountPasswd(account.getPop3password())));
            scontext.setPop3EncryptionFlag(account.getSmtpEncryptionFlg().shortValue());
        }
        catch (Exception e) {
            return null;
        }
        return scontext;
    }

    public static ALSmtpMailContext getALSmtpMailContext(String[] to, String[] cc, String[] bcc, String from, String name, String subject, String msgText, String[] filePaths, Map<String, String> additionalHeaders) {
        ALSmtpMailContext mailcontext = new ALSmtpMailContext();
        mailcontext.setTo(to);
        mailcontext.setCc(cc);
        mailcontext.setBcc(bcc);
        mailcontext.seFrom(from);
        mailcontext.setName(name);
        mailcontext.setSubject(subject);
        mailcontext.setMsgText(msgText);
        mailcontext.setFilePaths(filePaths);
        mailcontext.setAdditionalHeaders(additionalHeaders);
        return mailcontext;
    }

    public static EipMMailAccount getEipMMailAccountForAdmin() {
        try {
            SelectQuery query = Database.query(EipMMailAccount.class);
            Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)1);
            EipMMailAccount account = (EipMMailAccount)query.andQualifier(exp).fetchSingle();
            if (account == null) {
                logger.debug((Object)"[ALMailUtils] Not found AccountID...");
                return null;
            }
            return account;
        }
        catch (Exception ex) {
            logger.error((Object)"ALMailUtils.getEipMMailAccountForAdmin", (Throwable)ex);
            return null;
        }
    }

    public static EipMMailAccount getFirstEipMMailAccount(int userId) {
        try {
            SelectQuery query = Database.query(EipMMailAccount.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
            Expression exp21 = ExpressionFactory.matchExp((String)"accountType", (Object)"1");
            Expression exp22 = ExpressionFactory.matchExp((String)"accountType", (Object)"2");
            EipMMailAccount account = (EipMMailAccount)query.andQualifier(exp1).andQualifier(exp21.orExp(exp22)).fetchSingle();
            if (account == null) {
                logger.debug((Object)"[ALMailUtils] Not found AccountID...");
                return null;
            }
            return account;
        }
        catch (Exception ex) {
            logger.error((Object)"ALMailUtils.getFirstEipMMailAccount", (Throwable)ex);
            return null;
        }
    }

    public static boolean insertMailAccountData(RunData rundata, List<String> msgList, int userId, String accountName, int accountType, String mailAddress, String mailUserName, String smtpServerName, int smtpPort, String Pop3ServerName, int pop3Port, String pop3UserName, String pop3Password, int authSendFlag, String authSendUserId, String authSendUserPasswd, int authReceiveFlg, int delAtPop3Flg, int delAtPop3BeforeDaysFlg, int delAtPop3BeforeDays, String nonReceivedFlg, String signature, int smtpEncryptionFlg, int pop3EncryptionFlg) {
        boolean enableUpdate = false;
        try {
            Date createdDate = Calendar.getInstance().getTime();
            EipMMailAccount mailAccount = null;
            EipTMailFolder mailFolder = null;
            if (accountType == 2) {
                mailAccount = (EipMMailAccount)Database.create(EipMMailAccount.class);
                mailAccount.setAccountType(Integer.toString(2));
            } else {
                SelectQuery query = Database.query(EipMMailAccount.class);
                Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
                Expression exp2 = ExpressionFactory.matchExp((String)"accountType", (Object)2);
                EipMMailAccount account = (EipMMailAccount)query.andQualifier(exp1).andQualifier(exp2).fetchSingle();
                if (account == null) {
                    Expression exp3;
                    mailAccount = (EipMMailAccount)Database.create(EipMMailAccount.class);
                    SelectQuery query3 = Database.query(EipMMailAccount.class);
                    EipMMailAccount anotherAccount = (EipMMailAccount)query3.andQualifier(exp3 = ExpressionFactory.matchExp((String)"userId", (Object)userId)).fetchSingle();
                    if (anotherAccount == null) {
                        mailAccount.setAccountType(Integer.toString(1));
                    } else {
                        mailAccount.setAccountType(Integer.toString(0));
                    }
                } else {
                    mailAccount = account;
                    if (Integer.toString(2).equals(account.getAccountType())) {
                        enableUpdate = true;
                        mailAccount.setAccountType(Integer.toString(1));
                    } else {
                        mailAccount.setAccountType(Integer.toString(0));
                    }
                }
            }
            mailAccount.setUserId(Integer.valueOf(userId));
            mailAccount.setAccountName(accountName);
            mailAccount.setSmtpserverName(smtpServerName);
            mailAccount.setPop3serverName(Pop3ServerName);
            mailAccount.setPop3userName(pop3UserName);
            mailAccount.setPop3password(ALMailUtils.getEncryptedMailAccountPasswd(pop3Password.getBytes()));
            mailAccount.setMailUserName(mailUserName);
            mailAccount.setMailAddress(mailAddress);
            mailAccount.setSmtpPort(Integer.toString(smtpPort));
            mailAccount.setPop3Port(Integer.toString(pop3Port));
            mailAccount.setAuthSendFlg(Short.valueOf((short)authSendFlag));
            mailAccount.setAuthSendUserId(authSendUserId);
            if (authSendUserPasswd != null) {
                mailAccount.setAuthSendUserPasswd(ALMailUtils.getEncryptedMailAccountPasswd(authSendUserPasswd.getBytes()));
            }
            mailAccount.setSmtpEncryptionFlg(Short.valueOf((short)smtpEncryptionFlg));
            mailAccount.setPop3EncryptionFlg(Short.valueOf((short)pop3EncryptionFlg));
            mailAccount.setAuthReceiveFlg(Short.valueOf((short)authReceiveFlg));
            mailAccount.setDelAtPop3Flg(Integer.toString(delAtPop3Flg));
            mailAccount.setDelAtPop3BeforeDaysFlg(Integer.toString(delAtPop3BeforeDaysFlg));
            mailAccount.setDelAtPop3BeforeDays(Integer.valueOf(delAtPop3BeforeDays));
            mailAccount.setNonReceivedFlg(nonReceivedFlg);
            mailAccount.setUpdateDate(createdDate);
            mailAccount.setSignature(signature);
            if (!enableUpdate) {
                mailAccount.setCreateDate(createdDate);
            }
            mailFolder = (EipTMailFolder)Database.create(EipTMailFolder.class);
            mailFolder.setEipMMailAccount(mailAccount);
            mailFolder.setFolderName("\u53d7\u4fe1\u30c8\u30ec\u30a4");
            mailFolder.setCreateDate(createdDate);
            mailFolder.setUpdateDate(createdDate);
            Database.commit();
            mailAccount.setDefaultFolderId(mailFolder.getFolderId());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(mailAccount.getAccountId().intValue(), 231, mailAccount.getAccountName());
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"ALMailUtils.insertMailAccountData", t);
            return false;
        }
        return true;
    }

    public static boolean sendMailDelegateOne(String org_id, int srcUserId, ALEipUserAddr userAddr, String pcSubject, String cellularSubject, String pcBody, String cellularBody, int destType, List<String> msgList) throws Exception {
        ArrayList<ALEipUserAddr> rcptUsers = new ArrayList<ALEipUserAddr>();
        rcptUsers.add(userAddr);
        return ALMailUtils.sendMailDelegate(org_id, srcUserId, rcptUsers, pcSubject, cellularSubject, pcBody, cellularBody, destType, msgList);
    }

    @Deprecated
    public static boolean sendMailDelegate(String org_id, int srcUserId, List<ALEipUserAddr> destMemberList, String pcSubject, String cellularSubject, String pcBody, String cellularBody, int destType, List<String> msgList) throws Exception {
        if (destType < 0 || destType > 3) {
            return false;
        }
        if (destMemberList == null || destMemberList.size() == 0) {
            return false;
        }
        EipMMailAccount account = ALMailUtils.getEipMMailAccountForAdmin();
        int successSendToPc = 0;
        int successSendToCell = 0;
        if (account == null) {
            if (destType == 1) {
                successSendToPc = 6;
            } else if (destType == 2) {
                successSendToCell = 6;
            } else {
                successSendToPc = 6;
                successSendToCell = 6;
            }
        } else {
            ALSmtpMailContext mailcontext;
            String[] tos;
            ArrayList<String> destEmailAddrs = new ArrayList<String>();
            ArrayList<String> destCellularEMailAddrs = new ArrayList<String>();
            for (ALEipUserAddr userAddr : destMemberList) {
                String cellularEmailAddr;
                if (!ALEipUtils.isEnabledUser((int)userAddr.getUserId())) continue;
                String emailAddr = userAddr.getPcMailAddr();
                if (emailAddr != null && !emailAddr.equals("")) {
                    destEmailAddrs.add(emailAddr);
                }
                if ((cellularEmailAddr = userAddr.getCellMailAddr()) == null || cellularEmailAddr.equals("")) continue;
                destCellularEMailAddrs.add(cellularEmailAddr);
            }
            int destEmailAddrsSize = destEmailAddrs.size();
            int destCellularEMailAddrsSize = destCellularEMailAddrs.size();
            ALMailHandler mailhandler = ALMailFactoryService.getInstance().getMailHandler();
            ALMailSenderContext scontext = ALMailUtils.getALSmtpMailSenderContext(org_id, account);
            if ((destType == 1 || destType == 3) && destEmailAddrsSize > 0) {
                tos = new String[destEmailAddrsSize];
                tos = destEmailAddrs.toArray(tos);
                mailcontext = ALMailUtils.getALSmtpMailContext(tos, null, null, account.getMailAddress(), ALStringUtil.unsanitizing((String)account.getMailUserName()), ALStringUtil.unsanitizing((String)pcSubject), ALStringUtil.unsanitizing((String)pcBody), null, null);
                successSendToPc = mailhandler.send(scontext, mailcontext);
            }
            if ((destType == 2 || destType == 3) && destCellularEMailAddrsSize > 0) {
                tos = new String[destCellularEMailAddrsSize];
                tos = destCellularEMailAddrs.toArray(tos);
                mailcontext = ALMailUtils.getALSmtpMailContext(tos, null, null, account.getMailAddress(), ALStringUtil.unsanitizing((String)account.getMailUserName()), ALStringUtil.unsanitizing((String)cellularSubject), ALStringUtil.unsanitizing((String)cellularBody), null, null);
                successSendToCell = mailhandler.send(scontext, mailcontext);
            }
        }
        if (successSendToPc != 0) {
            if (successSendToPc == 2) {
                msgList.add("\u30e1\u30fc\u30eb\u30b5\u30a4\u30ba\u304c\u9001\u4fe1\u53ef\u80fd\u30b5\u30a4\u30ba\u3088\u308a\u3082\u5927\u304d\u3044\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 3) {
                msgList.add("\u30ed\u30c3\u30af\u304c\u304b\u304b\u3063\u3066\u3044\u3066\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 4) {
                msgList.add("Pop before SMTP\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 5) {
                msgList.add("SMTP\u8a8d\u8a3c\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 6) {
                msgList.add("\u7ba1\u7406\u8005\u306e\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else {
                msgList.add("\u9001\u4fe1\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3067\u304d\u306a\u304b\u3063\u305f\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            }
        }
        if (successSendToCell != 0) {
            if (successSendToCell == 2) {
                msgList.add("\u30e1\u30fc\u30eb\u30b5\u30a4\u30ba\u304c\u9001\u4fe1\u53ef\u80fd\u30b5\u30a4\u30ba\u3088\u308a\u3082\u5927\u304d\u3044\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 3) {
                msgList.add("\u30ed\u30c3\u30af\u304c\u304b\u304b\u3063\u3066\u3044\u3066\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 4) {
                msgList.add("Pop before SMTP\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 5) {
                msgList.add("SMTP\u8a8d\u8a3c\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 6) {
                msgList.add("\u7ba1\u7406\u8005\u306e\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else {
                msgList.add("\u9001\u4fe1\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3067\u304d\u306a\u304b\u3063\u305f\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            }
        }
        return successSendToPc == 0 && successSendToCell == 0;
    }

    @Deprecated
    public static boolean sendMailDelegate_note(String org_id, int srcUserId, List<ALEipUserAddr> destMemberList, String pcSubject, String cellularSubject, String pcBody, String cellularBody, int destType, List<String> msgList) throws Exception {
        if (destType < 0 || destType > 3) {
            return false;
        }
        if (destMemberList == null || destMemberList.size() == 0) {
            return false;
        }
        EipMMailAccount account = ALMailUtils.getEipMMailAccountForAdmin();
        int successSendToPc = 0;
        int successSendToCell = 0;
        if (account == null) {
            if (destType == 1) {
                successSendToPc = 6;
            } else if (destType == 2) {
                successSendToCell = 6;
            } else {
                successSendToPc = 6;
                successSendToCell = 6;
            }
        } else {
            ALSmtpMailContext mailcontext;
            String[] tos;
            ArrayList<String> destEmailAddrs = new ArrayList<String>();
            ArrayList<String> destCellularEmailAddrs = new ArrayList<String>();
            for (ALEipUserAddr userAddr : destMemberList) {
                String cellularEmailAddr;
                if (!ALEipUtils.isEnabledUser((int)userAddr.getUserId())) continue;
                String emailAddr = userAddr.getPcMailAddr();
                if (emailAddr != null && !emailAddr.equals("")) {
                    destEmailAddrs.add(emailAddr);
                }
                if ((cellularEmailAddr = userAddr.getCellMailAddr()) == null || cellularEmailAddr.equals("")) continue;
                destCellularEmailAddrs.add(cellularEmailAddr);
            }
            int destEmailAddrsSize = destEmailAddrs.size();
            int destCellularEmailAddrsSize = destCellularEmailAddrs.size();
            ALMailHandler mailhandler = ALMailFactoryService.getInstance().getMailHandler();
            ALMailSenderContext scontext = ALMailUtils.getALSmtpMailSenderContext(org_id, account);
            if ((destType == 1 || destType == 3) && destEmailAddrsSize > 0) {
                tos = new String[destEmailAddrsSize];
                tos = destEmailAddrs.toArray(tos);
                mailcontext = ALMailUtils.getALSmtpMailContext(tos, null, null, account.getMailAddress(), ALStringUtil.unsanitizing((String)account.getMailUserName()), ALStringUtil.unsanitizing((String)pcSubject), ALStringUtil.unsanitizing((String)pcBody), null, null);
                successSendToPc = mailhandler.send(scontext, mailcontext);
            }
            if ((destType == 1 || destType == 3) && destEmailAddrsSize <= 0) {
                successSendToPc = -1;
            }
            if ((destType == 2 || destType == 3) && destCellularEmailAddrsSize > 0) {
                tos = new String[destCellularEmailAddrsSize];
                tos = destCellularEmailAddrs.toArray(tos);
                mailcontext = ALMailUtils.getALSmtpMailContext(tos, null, null, account.getMailAddress(), ALStringUtil.unsanitizing((String)account.getMailUserName()), ALStringUtil.unsanitizing((String)cellularSubject), ALStringUtil.unsanitizing((String)cellularBody), null, null);
                successSendToCell = mailhandler.send(scontext, mailcontext);
            }
            if ((destType == 2 || destType == 3) && destCellularEmailAddrsSize <= 0) {
                successSendToCell = -1;
            }
        }
        if (successSendToPc != 0) {
            if (successSendToPc == 2) {
                msgList.add("\u30e1\u30fc\u30eb\u30b5\u30a4\u30ba\u304c\u9001\u4fe1\u53ef\u80fd\u30b5\u30a4\u30ba\u3088\u308a\u3082\u5927\u304d\u3044\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 3) {
                msgList.add("\u30ed\u30c3\u30af\u304c\u304b\u304b\u3063\u3066\u3044\u3066\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 4) {
                msgList.add("Pop before SMTP\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 5) {
                msgList.add("SMTP\u8a8d\u8a3c\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == 6) {
                msgList.add("\u7ba1\u7406\u8005\u306e\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToPc == -1) {
                msgList.add("\u9001\u4fe1\u5148\u306e\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else {
                msgList.add("\u9001\u4fe1\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3067\u304d\u306a\u304b\u3063\u305f\u305f\u3081\u3001\u30d1\u30bd\u30b3\u30f3\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            }
        }
        if (successSendToCell != 0) {
            if (successSendToCell == 2) {
                msgList.add("\u30e1\u30fc\u30eb\u30b5\u30a4\u30ba\u304c\u9001\u4fe1\u53ef\u80fd\u30b5\u30a4\u30ba\u3088\u308a\u3082\u5927\u304d\u3044\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 3) {
                msgList.add("\u30ed\u30c3\u30af\u304c\u304b\u304b\u3063\u3066\u3044\u3066\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 4) {
                msgList.add("Pop before SMTP\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 5) {
                msgList.add("SMTP\u8a8d\u8a3c\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == 6) {
                msgList.add("\u7ba1\u7406\u8005\u306e\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else if (successSendToCell == -1) {
                msgList.add("\u9001\u4fe1\u5148\u306e\u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            } else {
                msgList.add("\u9001\u4fe1\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3067\u304d\u306a\u304b\u3063\u305f\u305f\u3081\u3001\u643a\u5e2f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            }
        }
        return successSendToPc == 0 && successSendToCell == 0;
    }

    public static ALEipUserAddr getALEipUserAddrByUserId(int userId) {
        try {
            ALEipUserAddr userAddress = new ALEipUserAddr();
            TurbineUser user = ALEipUtils.getTurbineUser((int)userId);
            userAddress.setUserId(user.getUserId());
            userAddress.setPcMailAddr(user.getEmail());
            userAddress.setCellMailAddr(user.getCellularMail());
            return userAddress;
        }
        catch (ALDBErrorException e) {
            logger.error((Object)"ALMailUtils.getALEipUserAddrByUserId", (Throwable)e);
            return null;
        }
    }

    public static List<ALEipUserAddr> getALEipUserAddrs(List<ALEipUser> memberList, int loginUserId, boolean includeLoginUser) {
        ArrayList<ALEipUserAddr> resList = new ArrayList<ALEipUserAddr>();
        ALEipUserAddr useraddr = null;
        int membersize = memberList.size();
        for (int i = 0; i < membersize; ++i) {
            ALEipUser user = memberList.get(i);
            if (!includeLoginUser && user.getUserId().getValue() == (long)loginUserId) continue;
            try {
                ALBaseUser baseuser = (ALBaseUser)JetspeedSecurity.getUser((String)user.getName().getValue());
                useraddr = new ALEipUserAddr();
                useraddr.setUserId(Integer.valueOf(baseuser.getUserId()));
                useraddr.setPcMailAddr(baseuser.getEmail());
                useraddr.setCellMailAddr(baseuser.getCellularMail());
                resList.add(useraddr);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)"ALMailUtils.getALEipUserAddrs", (Throwable)ex);
            }
        }
        return resList;
    }

    public static int getSendDestType(int keyMsgtype) {
        try {
            SelectQuery query = Database.query(EipMMailNotifyConf.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)1);
            Expression exp2 = ExpressionFactory.matchExp((String)"notifyType", (Object)keyMsgtype);
            EipMMailNotifyConf mail_notify_conf = (EipMMailNotifyConf)query.andQualifier(exp1).andQualifier(exp2).fetchSingle();
            if (mail_notify_conf == null) {
                logger.debug((Object)"[ALMailUtils] Not found Notify...");
                return 0;
            }
            return mail_notify_conf.getNotifyFlg();
        }
        catch (Exception ex) {
            logger.error((Object)"ALMailUtils.getSendDestType", (Throwable)ex);
            return 0;
        }
    }

    public static boolean setSendDestType(int keyMsgtype, int valueMsgtype) {
        try {
            Expression exp1;
            if (valueMsgtype < 0 || valueMsgtype > 3) {
                return false;
            }
            SelectQuery query = Database.query(EipMMailNotifyConf.class);
            EipMMailNotifyConf mail_notify_conf = (EipMMailNotifyConf)query.andQualifier(exp1 = ExpressionFactory.matchExp((String)"notifyType", (Object)keyMsgtype)).fetchSingle();
            if (mail_notify_conf == null) {
                logger.debug((Object)"[ALMailUtils] Not found Notify...");
                return false;
            }
            mail_notify_conf.setNotifyFlg(Integer.valueOf(valueMsgtype));
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"ALMailUtils.setSendDestType", t);
            return false;
        }
        return true;
    }

    public static String getGlobalurl() {
        EipMCompany record = ALEipUtils.getEipMCompany((String)"1");
        return ALServletUtils.getAccessUrl((String)record.getIpaddress(), (int)record.getPort(), (boolean)true);
    }

    public static String getLocalurl() {
        EipMCompany record = ALEipUtils.getEipMCompany((String)"1");
        String localurl = "";
        try {
            Integer port_internal;
            Enumeration<NetworkInterface> enuIfs;
            String ipaddress = record.getIpaddressInternal();
            if ((null == ipaddress || "".equals(ipaddress)) && null != (enuIfs = NetworkInterface.getNetworkInterfaces())) {
                while (enuIfs.hasMoreElements()) {
                    NetworkInterface ni = enuIfs.nextElement();
                    Enumeration<InetAddress> enuAddrs = ni.getInetAddresses();
                    while (enuAddrs.hasMoreElements()) {
                        InetAddress in4 = enuAddrs.nextElement();
                        if (in4.isLoopbackAddress()) continue;
                        ipaddress = in4.getHostAddress();
                    }
                }
            }
            if (null == (port_internal = record.getPortInternal())) {
                port_internal = 80;
            }
            localurl = ALServletUtils.getAccessUrl((String)ipaddress, (int)port_internal, (boolean)false);
        }
        catch (SocketException e) {
            logger.error((Object)"ALMailUtils.getLocalurl", (Throwable)e);
        }
        return localurl;
    }

    public static EipMMailNotifyConf getEipMMailNotifyConf(int conf_id) {
        try {
            EipMMailNotifyConf result = (EipMMailNotifyConf)Database.get(EipMMailNotifyConf.class, (Object)conf_id);
            if (result == null) {
                logger.debug((Object)"[ALMailUtils] Not found ID...");
                return null;
            }
            return result;
        }
        catch (Exception ex) {
            logger.error((Object)"ALMailUtils.getEipMMailNotifyConf", (Throwable)ex);
            return null;
        }
    }

    public static boolean setNotifyTime(int hour, int minute) {
        StringBuffer sb = new StringBuffer();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(Integer.toString(hour)).append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(Integer.toString(minute)).append(":00");
        Time time = Time.valueOf(sb.toString());
        try {
            EipMMailNotifyConf conf = ALMailUtils.getEipMMailNotifyConf(1);
            if (conf == null) {
                return false;
            }
            conf.setNotifyTime((Date)time);
            Database.commit();
            return true;
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"ALMailUtils.setNotifyTime", t);
            return false;
        }
    }

    public static String getNotifyTime() {
        try {
            EipMMailNotifyConf conf = ALMailUtils.getEipMMailNotifyConf(1);
            if (conf == null) {
                return null;
            }
            Date date = conf.getNotifyTime();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            StringBuffer sb = new StringBuffer();
            int hour = cal.get(11);
            int minute = cal.get(12);
            if (hour < 10) {
                sb.append("0");
            }
            sb.append(hour).append(":");
            if (minute < 10) {
                sb.append("0");
            }
            sb.append(minute);
            return sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)"ALMailUtils.getNotifyTime", (Throwable)e);
            return null;
        }
    }

    public static List<EipTMailFolder> getEipTMailFolderAll(EipMMailAccount account) {
        try {
            Expression exp;
            if (account == null) {
                logger.debug((Object)"[WebMail Folder] Empty Account...");
                return null;
            }
            SelectQuery query = Database.query(EipTMailFolder.class);
            ArrayList<EipTMailFolder> folder_list = query.andQualifier(exp = ExpressionFactory.matchDbExp((String)"eipMMailAccount", (Object)account)).orderAscending("folderName").fetchList();
            if (folder_list == null || folder_list.size() == 0) {
                logger.debug((Object)"[WebMail Folder] Not found ID...");
                return null;
            }
            ArrayList<EipTMailFolder> res = new ArrayList<EipTMailFolder>();
            for (EipTMailFolder folder : folder_list) {
                if (!folder.getFolderName().equals("\u53d7\u4fe1\u30c8\u30ec\u30a4")) continue;
                EipTMailFolder inbox = folder;
                folder_list.remove(folder);
                res.add(inbox);
                res.addAll(folder_list);
                break;
            }
            return res.size() == 0 ? folder_list : res;
        }
        catch (Exception ex) {
            logger.error((Object)"ALMailUtils.getEipTMailFolderAll", (Throwable)ex);
            return null;
        }
    }

    public static List<EipTMail> getEipTMails(EipTMailFolder folder) {
        try {
            Expression exp;
            if (folder == null) {
                logger.debug((Object)"[WebMail Folder] Empty Folder...");
                return null;
            }
            SelectQuery query = Database.query(EipTMail.class);
            List mail_list = query.andQualifier(exp = ExpressionFactory.matchExp((String)"folderId", (Object)folder.getFolderId())).fetchList();
            if (mail_list == null || mail_list.size() == 0) {
                logger.debug((Object)"[WebMail Folder] No Mail in the Folder...");
                return null;
            }
            return mail_list;
        }
        catch (Exception ex) {
            logger.error((Object)"ALMailUtils.getEipTMails", (Throwable)ex);
            return null;
        }
    }

    public static List<EipTMailFilter> getEipTMailFilters(EipMMailAccount mailAccount) {
        try {
            SelectQuery query = Database.query(EipTMailFilter.class);
            Expression exp = ExpressionFactory.matchExp((String)"eipMMailAccount", (Object)mailAccount);
            List filter_list = query.andQualifier(exp).orderAscending("sortOrder").fetchList();
            if (filter_list == null || filter_list.size() == 0) {
                logger.debug((Object)"[WebMail Filter] Not found ID...");
                return null;
            }
            return filter_list;
        }
        catch (Exception ex) {
            logger.error((Object)"ALMailUtils.getEipTMailFilters", (Throwable)ex);
            return null;
        }
    }

    public static boolean isMatchFilter(EipTMailFilter mailFilter, String subject, String from, Address[] receivers) {
        String filterType = mailFilter.getFilterType();
        String filterString = mailFilter.getFilterString();
        if (FILTER_TYPE_DOMAIN.equals(filterType)) {
            try {
                String[] domainArray = from.split("@");
                String domain = domainArray[domainArray.length - 1];
                return domain.toLowerCase().contains(filterString.toLowerCase());
            }
            catch (Exception e) {
                return false;
            }
        }
        if (FILTER_TYPE_MAILADDRESS.equals(filterType)) {
            String[] mailAddrArray = from.split("<");
            String mailAddr = mailAddrArray[mailAddrArray.length - 1];
            return mailAddr.toLowerCase().contains(filterString.toLowerCase());
        }
        if (FILTER_TYPE_SUBJECT.equals(filterType)) {
            return ALMailUtils.decodeSubject(subject).toLowerCase().contains(filterString.toLowerCase());
        }
        if (FILTER_TYPE_TO.equals(filterType)) {
            for (Address address : receivers) {
                InternetAddress iadress = (InternetAddress)address;
                String email = iadress.getAddress();
                if (!email.toLowerCase().contains(filterString.toLowerCase())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static Map<String, String> getMailFilterTypeMap() {
        TreeMap<String, String> typeMap = new TreeMap<String, String>();
        typeMap.put(FILTER_TYPE_MAILADDRESS, "\u9001\u4fe1\u5143\uff08From\uff09");
        typeMap.put(FILTER_TYPE_TO, "\u9001\u4fe1\u5148\uff08To\uff09");
        typeMap.put(FILTER_TYPE_SUBJECT, "\u4ef6\u540d");
        return typeMap;
    }

    public static String decodeSubject(String subject) {
        try {
            subject = MimeUtility.decodeText((String)MimeUtility.unfold((String)subject));
            return UnicodeCorrecter.correctToCP932(MailUtility.decodeText((String)subject));
        }
        catch (UnsupportedEncodingException e) {
            return MailUtility.decodeText((String)subject);
        }
    }

    public static int getMaxMailSize() {
        return (int)((double)TurbineUpload.getSizeMax() * 1.37);
    }

    public static String getRawFrom(MimeMessage msg) {
        String rawFrom = null;
        try {
            rawFrom = msg.getHeader("From", ",");
            if (null == rawFrom) {
                rawFrom = msg.getHeader("Sender", ",");
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return null != rawFrom ? rawFrom : "";
    }

    public static String getRawReplyTo(MimeMessage msg) {
        String rawReplyto = null;
        try {
            rawReplyto = msg.getHeader("Reply-To", ",");
            if (rawReplyto == null) {
                rawReplyto = ALMailUtils.getRawFrom(msg);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return null != rawReplyto ? rawReplyto : "";
    }

    public static String getFromInetAddressForBroken(MimeMessage msg) {
        String rawFrom = ALMailUtils.getRawFrom(msg);
        String inetAddress = null;
        try {
            inetAddress = MimeUtility.decodeText((String)MimeUtility.unfold((String)rawFrom));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null != inetAddress ? inetAddress : "";
    }

    public static String getReplytoInetAddressForBroken(MimeMessage msg) {
        String rawReplyto = ALMailUtils.getRawReplyTo(msg);
        String inetAddress = null;
        try {
            inetAddress = MimeUtility.decodeText((String)MimeUtility.unfold((String)rawReplyto));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null != inetAddress ? inetAddress : "";
    }

    public static String extractAddress(String rawAddress) {
        String regex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})";
        Pattern mailPattern = Pattern.compile(regex);
        Matcher matcher = mailPattern.matcher(rawAddress);
        if (matcher.find()) {
            String result = matcher.group(0);
            return null != result ? result : "";
        }
        return "";
    }

    public static String getFromDelegate(MimeMessage msg) throws MessagingException {
        String from = null;
        try {
            from = ALMailUtils.getAddressString(msg.getFrom());
        }
        catch (AddressException e) {
            logger.info((Object)"ALMailUtils.getFromDelegate", (Throwable)e);
            from = ALMailUtils.getFromInetAddressForBroken(msg);
        }
        return from;
    }

    public static String getFromDelegateExtract(MimeMessage msg) throws MessagingException {
        String from = null;
        try {
            from = ALMailUtils.getAddressString(msg.getFrom());
        }
        catch (AddressException e) {
            logger.info((Object)"ALMailUtils.getFromDelegateExtract", (Throwable)e);
            from = ALMailUtils.getFromInetAddressForBroken(msg);
            from = ALMailUtils.extractAddress(from);
        }
        return from;
    }

    public static Address[] getFromDelegateExtractForAddress(MimeMessage msg) throws MessagingException {
        InternetAddress[] addresses = new InternetAddress[1];
        try {
            addresses = msg.getFrom();
        }
        catch (AddressException e) {
            InternetAddress address;
            logger.info((Object)"ALMailUtils.getFromDelegateExtractForAddress", (Throwable)e);
            String from = ALMailUtils.getFromInetAddressForBroken(msg);
            from = ALMailUtils.extractAddress(from);
            addresses[0] = address = new InternetAddress(from, false);
        }
        return addresses;
    }

    public static Address getReplyToDelegateExtract(MimeMessage msg) throws MessagingException {
        Address replyTo = null;
        try {
            replyTo = msg.getReplyTo()[0];
        }
        catch (AddressException e) {
            logger.info((Object)"ALMailUtils.getReplyToDelegateExtract", (Throwable)e);
            String _replyTo = ALMailUtils.getReplytoInetAddressForBroken(msg);
            _replyTo = ALMailUtils.extractAddress(_replyTo);
            replyTo = new InternetAddress(_replyTo, false);
        }
        return replyTo;
    }
}

