/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.note;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTNoteMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.social.Activity;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.note.NoteResultData;
import com.aimluck.eip.note.util.NoteUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class NoteSelectData
extends ALAbstractSelectData<EipTNoteMap, EipTNote> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NoteSelectData.class.getName());
    private String currentTab;
    private String userId;
    private String target_group_name;
    private String target_user_id;
    private List<ALEipGroup> myGroupList = null;
    private int unreadNotesAllSum = 0;
    private int newNoteAllSum = 0;
    private Map<Integer, String> statusList;
    private List<ALEipUser> members = null;
    private String mailAccountURI;
    private String userAccountURI;
    private ALStringField target_keyword;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort;
        this.setCurrentTab(rundata, context);
        if (NoteUtils.hasResetFlag(rundata, context)) {
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
        }
        if ((sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR)) == null || sort.equals("")) {
            sort = "received_notes".equals(this.getCurrentTab()) ? "accept_date" : "create_date";
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)sort);
        } else if ("received_notes".equals(this.getCurrentTab())) {
            if ("create_date".equals(sort)) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"accept_date");
            }
        } else if ("accept_date".equals(sort) || "note_stat".equals(sort) || "create_date".equals(sort)) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"create_date");
        }
        this.userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        this.statusList = new HashMap<Integer, String>();
        this.mailAccountURI = NoteUtils.getPortletURIinPersonalConfigPane(rundata, "WebMailAccountEdit");
        this.userAccountURI = NoteUtils.getPortletURIinPersonalConfigPane(rundata, "AccountEdit");
        this.target_keyword = new ALStringField();
        super.init(action, rundata, context);
    }

    protected ResultList<EipTNoteMap> selectList(RunData rundata, Context context) {
        try {
            if (NoteUtils.hasResetFlag(rundata, context)) {
                NoteUtils.resetFilter(rundata, context, ((Object)((Object)this)).getClass().getName());
                this.target_keyword.setValue("");
            } else {
                this.target_keyword.setValue(NoteUtils.getTargetKeyword(rundata, context));
            }
            this.target_group_name = NoteUtils.getTargetGroupName(rundata, context);
            this.target_user_id = NoteUtils.getTargetUserId(rundata, context);
            List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
            this.myGroupList = new ArrayList<ALEipGroup>();
            int length = myGroups.size();
            for (int i = 0; i < length; ++i) {
                this.myGroupList.add((ALEipGroup)myGroups.get(i));
            }
            SelectQuery<EipTNoteMap> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            return query.getResultList();
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    protected SelectQuery<EipTNoteMap> buildSelectQueryForListViewSort(SelectQuery<EipTNoteMap> query, RunData rundata, Context context) {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        String sort_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (sort == null) {
            return query;
        }
        crt_key = map.getValue(sort);
        if (crt_key == null) {
            return query;
        }
        if (sort_type != null && "asc".equals(sort_type)) {
            query.orderAscending(crt_key);
        } else {
            query.orderDesending(crt_key);
            sort_type = "desc";
        }
        this.current_sort = sort;
        this.current_sort_type = sort_type;
        return query;
    }

    protected EipTNote selectDetail(RunData rundata, Context context) throws ALPageNotFoundException {
        EipTNote note;
        this.userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        this.setCurrentTab(rundata, context);
        if ("received_notes".equals(this.currentTab)) {
            this.unreadNotesAllSum = NoteUtils.getUnreadReceivedNotesAllSum(rundata, this.userId);
            this.newNoteAllSum = NoteUtils.getNewReceivedNoteAllSum(rundata, this.userId);
        }
        if ((note = NoteUtils.getEipTNoteDetail(rundata, context, this.getSelectQueryForDetail(rundata, context))) == null) {
            logger.debug((Object)"[NoteSelectData] This page cannot be loaded.");
            throw new ALPageNotFoundException();
        }
        return note;
    }

    protected Object getResultData(EipTNoteMap map) {
        try {
            EipTNote record = map.getEipTNote();
            String destUserNames = this.getDestUserNamesLimit(record);
            NoteResultData rd = new NoteResultData();
            rd.initField();
            rd.setNoteId(record.getNoteId().longValue());
            rd.setSrcUserId(record.getOwnerId());
            rd.setDestUserId(map.getUserId());
            ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(record.getOwnerId()));
            rd.setSrcUserFullName(user.getAliasName().getValue());
            rd.setDestUserFullName(destUserNames);
            rd.setClientName(record.getClientName());
            rd.setCompanyName(record.getCompanyName());
            rd.setTelephone(record.getTelephone());
            rd.setEmailAddress(record.getEmailAddress());
            if (record.getAddDestType().equals("1")) {
                rd.setAddDestTypePc("1");
            } else if (record.getAddDestType().equals("2")) {
                rd.setAddDestTypeCellphone("1");
            } else if (record.getAddDestType().equals("3")) {
                rd.setAddDestTypePc("1");
                rd.setAddDestTypeCellphone("1");
            }
            rd.setSubjectType(record.getSubjectType());
            if ("0".equals(record.getSubjectType())) {
                rd.setCustomSubject(record.getCustomSubject());
            }
            rd.setMessage(record.getMessage());
            rd.setAcceptDate(record.getAcceptDate());
            rd.setConfirmDate(map.getConfirmDate());
            rd.setCreateDate(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            Expression mapexp = ExpressionFactory.matchExp((String)"noteId", (Object)record.getNoteId());
            List list = Database.query(EipTNoteMap.class, (Expression)mapexp).fetchList();
            Integer readNotes = 0;
            for (Object notemap : list) {
                if (!notemap.getNoteStat().equals("3")) continue;
                Integer n = readNotes;
                Integer n2 = readNotes = Integer.valueOf(readNotes + 1);
            }
            rd.setSentNote(list.size() - 1);
            rd.setReadNote(readNotes.longValue());
            ArrayList<Integer> users = new ArrayList<Integer>();
            for (EipTNoteMap notemap : list) {
                if (this.userId.equals(notemap.getUserId())) {
                    map = notemap;
                }
                if ("T".equals(notemap.getDelFlg())) {
                    this.statusList.put(Integer.valueOf(notemap.getUserId()), "4");
                } else {
                    this.statusList.put(Integer.valueOf(notemap.getUserId()), notemap.getNoteStat());
                }
                users.add(Integer.valueOf(notemap.getUserId()));
            }
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", users);
            query.setQualifier(exp);
            this.members = ALEipUtils.getUsersFromSelectQuery((SelectQuery)query);
            rd.setDestUsers(this.members);
            if ("1".equals(map.getNoteStat())) {
                rd.setNoteStat("1");
                rd.setNoteStatImage("images/note/note_new_message.gif");
                rd.setNoteStatImageDescription(ALLocalizationUtils.getl10n((String)"NOTE_NEW_MESSAGE"));
            } else if ("2".equals(map.getNoteStat())) {
                rd.setNoteStat("2");
                rd.setNoteStatImage("images/note/note_unread_message.gif");
                rd.setNoteStatImageDescription(ALLocalizationUtils.getl10n((String)"NOTE_UNREAD_MESSAGE"));
                ++this.unreadNotesAllSum;
            } else if ("3".equals(map.getNoteStat())) {
                rd.setNoteStat("3");
                rd.setNoteStatImage("images/note/note_read_message.gif");
                rd.setNoteStatImageDescription(ALLocalizationUtils.getl10n((String)"NOTE_READ_MESSAGE"));
            } else {
                rd.setNoteStat("4");
                rd.setNoteStatImage("images/note/note_deleted_message.gif");
                rd.setNoteStatImageDescription(ALLocalizationUtils.getl10n((String)"NOTE_DELETED_MESSAGE"));
            }
            if (record.getMessage() == null || record.getMessage().equals("")) {
                rd.setHasMemo(false);
            } else {
                rd.setHasMemo(true);
            }
            if (map.getUserId().equals(this.userId) && !record.getOwnerId().equals(this.userId) && map.getNoteStat().equals("1")) {
                map.setNoteStat("2");
            }
            Database.commit();
            return rd;
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[NoteSelectData]", t);
            return null;
        }
    }

    protected Object getResultDataDetail(EipTNote record) {
        if (record == null) {
            return null;
        }
        try {
            Date nowDate = Calendar.getInstance().getTime();
            EipTNoteMap map = null;
            Expression mapexp = ExpressionFactory.matchExp((String)"noteId", (Object)record.getNoteId());
            List list = Database.query(EipTNoteMap.class, (Expression)mapexp).fetchList();
            ArrayList<Integer> users = new ArrayList<Integer>();
            for (EipTNoteMap notemap : list) {
                if (this.userId.equals(notemap.getUserId())) {
                    map = notemap;
                }
                if ("T".equals(notemap.getDelFlg())) {
                    this.statusList.put(Integer.valueOf(notemap.getUserId()), "4");
                } else {
                    this.statusList.put(Integer.valueOf(notemap.getUserId()), notemap.getNoteStat());
                }
                users.add(Integer.valueOf(notemap.getUserId()));
            }
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", users);
            query.setQualifier(exp);
            this.members = ALEipUtils.getUsersFromSelectQuery((SelectQuery)query);
            String destUserNames = "";
            NoteResultData rd = new NoteResultData();
            rd.initField();
            rd.setNoteId(record.getNoteId().longValue());
            rd.setSrcUserId(record.getOwnerId());
            rd.setDestUserId(map.getUserId());
            ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(record.getOwnerId()));
            rd.setSrcUserFullName(user.getAliasName().getValue());
            rd.setDestUserFullName(destUserNames);
            rd.setClientName(record.getClientName());
            rd.setCompanyName(record.getCompanyName());
            rd.setTelephone(record.getTelephone());
            rd.setEmailAddress(record.getEmailAddress());
            if (record.getAddDestType().equals("1")) {
                rd.setAddDestTypePc("1");
            } else if (record.getAddDestType().equals("2")) {
                rd.setAddDestTypeCellphone("1");
            } else if (record.getAddDestType().equals("3")) {
                rd.setAddDestTypePc("1");
                rd.setAddDestTypeCellphone("1");
            }
            rd.setSubjectType(record.getSubjectType());
            if ("0".equals(record.getSubjectType())) {
                rd.setCustomSubject(record.getCustomSubject());
            }
            rd.setMessage(record.getMessage());
            rd.setAcceptDate(record.getAcceptDate());
            rd.setCreateDate(record.getCreateDate());
            if (map.getUserId().equals(this.userId) && !record.getOwnerId().equals(this.userId)) {
                if (map.getConfirmDate() == null) {
                    map.setConfirmDate(nowDate);
                    rd.setConfirmDate(nowDate);
                    Expression exp2 = ExpressionFactory.matchExp((String)"externalId", (Object)rd.getNoteId());
                    Expression exp3 = ExpressionFactory.matchExp((String)"appId", (Object)"Note");
                    Expression exp4 = exp2.andExp(exp3);
                    List list2 = Database.query(Activity.class, (Expression)exp4).fetchList();
                    for (Activity activity : list2) {
                        ALActivityService.setRead((int)activity.getId(), (String)ALEipUtils.getTurbineUser((int)Integer.valueOf(map.getUserId())).getLoginName());
                    }
                } else {
                    rd.setConfirmDate(map.getConfirmDate());
                }
                if (map.getNoteStat().equals("3")) {
                    rd.setNoteStat(map.getNoteStat());
                } else {
                    map.setNoteStat("3");
                    rd.setNoteStat("3");
                }
                record.setUpdateDate(nowDate);
                rd.setUpdateDate(nowDate);
                Database.commit();
            } else {
                rd.setConfirmDate(map.getConfirmDate());
                rd.setNoteStat(map.getNoteStat());
                rd.setUpdateDate(record.getUpdateDate());
            }
            return rd;
        }
        catch (RuntimeException ex) {
            Database.rollback();
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("client_name", "eipTNote.clientName");
        map.putValue("company_name", "eipTNote.companyName");
        map.putValue("subject_type", "eipTNote.subjectType");
        map.putValue("create_date", "eipTNote.createDate");
        map.putValue("confirm_date", "confirmDate");
        map.putValue("accept_date", "eipTNote.acceptDate");
        map.putValue("note_stat", "noteStat");
        return map;
    }

    private SelectQuery<EipTNoteMap> getSelectQuery(RunData rundata, Context context) {
        if (this.target_keyword != null && !this.target_keyword.getValue().equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR, (String)this.target_keyword.getValue());
        } else {
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR);
        }
        SelectQuery query = Database.query(EipTNoteMap.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)Integer.valueOf(this.userId));
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"delFlg", (Object)"F");
        query.andQualifier(exp2);
        if ("received_notes".equals(this.getCurrentTab())) {
            Expression exp3 = ExpressionFactory.noMatchExp((String)"eipTNote.ownerId", (Object)Integer.valueOf(this.userId));
            query.andQualifier(exp3);
        } else {
            Expression exp3 = ExpressionFactory.matchExp((String)"eipTNote.ownerId", (Object)Integer.valueOf(this.userId));
            query.andQualifier(exp3);
        }
        return this.buildSelectQueryForFilter((SelectQuery<EipTNoteMap>)query, rundata, context);
    }

    protected SelectQuery<EipTNoteMap> buildSelectQueryForFilter(SelectQuery<EipTNoteMap> query, RunData rundata, Context context) {
        String search = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR);
        if (search != null && !search.equals("")) {
            this.current_search = search;
            Expression ex1 = ExpressionFactory.likeExp((String)"clientName", (Object)("%" + search + "%"));
            Expression ex2 = ExpressionFactory.likeExp((String)"companyName", (Object)("%" + search + "%"));
            Expression ex3 = ExpressionFactory.likeExp((String)"emailAddress", (Object)("%" + search + "%"));
            Expression ex4 = ExpressionFactory.likeExp((String)"telephone", (Object)("%" + search + "%"));
            Expression ex5 = ExpressionFactory.likeExp((String)"customSubject", (Object)("%" + search + "%"));
            Expression ex6 = ExpressionFactory.likeExp((String)"message", (Object)("%" + search + "%"));
            StringBuilder body = new StringBuilder();
            body.append("SELECT eip_t_note_map.note_id");
            body.append(" FROM eip_t_note_map");
            body.append(" INNER JOIN eip_t_note");
            body.append(" ON eip_t_note_map.note_id = eip_t_note.note_id");
            body.append(" INNER JOIN turbine_user");
            body.append(" ON ").append(Database.castToIntRawColumn((String)"eip_t_note_map.user_id")).append(" = turbine_user.user_id");
            body.append(" WHERE turbine_user.first_name LIKE #bind($search)");
            body.append(" OR turbine_user.last_name like #bind($search)");
            body.append(" OR turbine_user.first_name_kana LIKE #bind($search)");
            body.append(" OR turbine_user.last_name_kana LIKE #bind($search);");
            SQLTemplate Query = Database.sql(EipTNoteMap.class, (String)body.toString()).param("search", (Object)("%" + search + "%"));
            List fetch = Query.fetchListAsDataRow();
            ArrayList<Integer> resultid = new ArrayList<Integer>();
            for (DataRow row : fetch) {
                resultid.add((Integer)row.get((Object)"note_id"));
            }
            SelectQuery q = Database.query(EipTNote.class);
            q.andQualifier(ex6.orExp(ex5.orExp(ex4.orExp(ex3.orExp(ex2.orExp(ex1))))));
            List queryList = q.fetchList();
            for (EipTNote item : queryList) {
                if (item.getNoteId() != 0 && !resultid.contains(item.getNoteId())) {
                    resultid.add(item.getNoteId());
                    continue;
                }
                if (resultid.contains(item.getNoteId())) continue;
                resultid.add(item.getNoteId());
            }
            if (resultid.size() == 0) {
                resultid.add(-1);
            }
            Expression ex = ExpressionFactory.inDbExp((String)"NOTE_ID", resultid);
            query.andQualifier(ex);
        }
        return query;
    }

    private SelectQuery<EipTNote> getSelectQueryForDetail(RunData rundata, Context context) {
        return Database.query(EipTNote.class);
    }

    private String getDestUserNamesLimit(EipTNote note) throws ALDBErrorException {
        StringBuffer destUserNames = new StringBuffer();
        List mapList = note.getEipTNoteMaps();
        if (mapList == null || mapList.size() == 0) {
            logger.error((Object)"[NoteSelectData] DatabaseException");
            throw new ALDBErrorException();
        }
        int mapListSize = mapList.size();
        for (int i = 0; i < mapListSize; ++i) {
            EipTNoteMap tmpmap = (EipTNoteMap)mapList.get(i);
            if (!tmpmap.getUserId().equals(this.userId)) continue;
            mapList.remove(i);
            break;
        }
        if (mapList.size() > 0) {
            for (EipTNoteMap tmpmap : mapList) {
                ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(tmpmap.getUserId()));
                destUserNames.append(tmpmap == mapList.get(0) ? user.getAliasName() : "," + user.getAliasName());
            }
        }
        return destUserNames.toString();
    }

    private void setCurrentTab(RunData rundata, Context context) {
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"received_notes");
            this.currentTab = "received_notes";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public String getUserName(String userId) {
        return NoteUtils.getUserName(userId);
    }

    public String getUserFullName(String userId) {
        try {
            ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(userId));
            return user.getAliasName().getValue();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getUserId(String userName) {
        return NoteUtils.getUserId(userName);
    }

    public List<ALEipUser> getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public int getNewNoteAllSum() {
        return this.newNoteAllSum;
    }

    public int getUnreadNotesAllSum() {
        return this.unreadNotesAllSum;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public String getStatus(long id) {
        return this.statusList.get((int)id);
    }

    public List<ALEipUser> getMemberList() {
        return this.members;
    }

    public String getMailAccountURI() {
        return this.mailAccountURI;
    }

    public String getUserAccountURI() {
        return this.userAccountURI;
    }

    public ALStringField getTargetKeyword() {
        return this.target_keyword;
    }
}

