/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cabinet.FolderInfo;
import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolderMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetFolderFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetFolderFormData.class.getName());
    private ALStringField folder_name;
    private ALNumberField parent_id;
    private ALStringField note;
    private List<FolderInfo> folder_hierarchy_list;
    private FolderInfo selected_folderinfo = null;
    private FolderInfo parent_folderinfo = null;
    private boolean is_member;
    private List<ALEipUser> memberList;
    private List<ALEipGroup> groups;
    private ALNumberField access_flag;
    private ALEipUser login_user;
    private String folderid = null;
    private String orgId;
    private boolean show_acl_form = true;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"folder_id")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folder_id", (String)rundata.getParameters().getString("folder_id"));
        }
        this.orgId = Database.getDomainName();
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        String tmpfid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id");
        int fid = 1;
        if (tmpfid != null && !"".equals(tmpfid)) {
            try {
                fid = Integer.parseInt(tmpfid);
            }
            catch (Exception e) {
                fid = 1;
            }
        } else {
            fid = 1;
        }
        FolderInfo rootFolderInfo = null;
        this.folder_hierarchy_list = CabinetUtils.getFolderList();
        if (this.folder_hierarchy_list != null) {
            if (this.folder_hierarchy_list.size() > 0) {
                int size = this.folder_hierarchy_list.size();
                for (int i = 0; i < size; ++i) {
                    FolderInfo info = this.folder_hierarchy_list.get(i);
                    info.setVisible(true);
                    if (info.getFolderId() == 1) {
                        rootFolderInfo = info;
                    }
                    if (info.getFolderId() != fid) continue;
                    this.selected_folderinfo = info;
                }
            }
            CabinetUtils.setFolderVisibleForForm(this.folder_hierarchy_list, rundata);
            if (this.selected_folderinfo == null) {
                this.selected_folderinfo = rootFolderInfo;
            }
        }
        this.groups = ALEipUtils.getMyGroups((RunData)rundata);
        this.is_member = false;
        super.init(action, rundata, context);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            int tmp_access_flag;
            if (!rundata.getParameters().containsKey((Object)"parent_id")) {
                this.parent_id.setValue((long)this.selected_folderinfo.getFolderId());
            }
            if ("update".equals(this.getMode())) {
                this.folderid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id");
            }
            if ((tmp_access_flag = (int)this.access_flag.getValue()) == 1 || tmp_access_flag == 2) {
                Object[] member = rundata.getParameters().getStrings("member_to");
                SelectQuery query = Database.query(TurbineUser.class);
                Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])member);
                query.setQualifier(exp);
                this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
                boolean login_user_exists = false;
                for (int i = 0; i < this.memberList.size(); ++i) {
                    if (!((String)member[i]).equals(this.login_user.getName().getValue())) continue;
                    login_user_exists = true;
                    break;
                }
                if (!login_user_exists) {
                    this.memberList.add(this.login_user);
                }
            } else {
                this.memberList.add(this.login_user);
            }
        }
        return res;
    }

    public void initField() {
        this.folder_name = new ALStringField();
        this.folder_name.setFieldName(ALLocalizationUtils.getl10n((String)"CABINET_FOLDER_NAME"));
        this.folder_name.setTrim(true);
        this.parent_id = new ALNumberField();
        this.parent_id.setFieldName(ALLocalizationUtils.getl10n((String)"CABINET_ADD_POSISHION"));
        this.parent_id.setValue(0L);
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"CABINET_MEMO"));
        this.note.setTrim(true);
        this.access_flag = new ALNumberField();
        this.access_flag.setFieldName(ALLocalizationUtils.getl10n((String)"CABINET_ACCESS_RESTRICTION"));
        this.access_flag.setValue(0L);
        this.memberList = new ArrayList<ALEipUser>();
    }

    protected void setValidator() {
        this.folder_name.setNotNull(true);
        this.folder_name.limitMaxLength(128);
        this.parent_id.limitMinValue(0L);
        this.note.limitMaxLength(1000);
        this.access_flag.limitValue(0L, 3L);
    }

    protected boolean validate(List<String> msgList) {
        this.folder_name.validate(msgList);
        this.parent_id.validate(msgList);
        this.note.validate(msgList);
        this.access_flag.validate(msgList);
        int tmp_acl_folder = CabinetUtils.getAccessControlFolderId((int)this.parent_id.getValue());
        if (tmp_acl_folder != 1 && this.access_flag.getValue() != 0L) {
            msgList.add(ALLocalizationUtils.getl10n((String)"CABINET_DONNOT_ACCESS_NEED_TOP_LEVEL_AUTHORITY"));
        }
        if (this.existsFolderName()) {
            msgList.add(ALLocalizationUtils.getl10n((String)"CABINET_SAME_NAME_FOLDER_CHANGE_NAME"));
        }
        return msgList.size() == 0;
    }

    private boolean existsFolderName() {
        String fname = this.folder_name.getValue();
        if (fname == null || "".equals(fname)) {
            return false;
        }
        try {
            SelectQuery query = Database.query(EipTCabinetFolder.class);
            if ("insert".equals(this.getMode())) {
                Expression exp = ExpressionFactory.matchExp((String)"parentId", (Object)((int)this.parent_id.getValue()));
                query.setQualifier(exp);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)((int)this.parent_id.getValue()));
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"FOLDER_ID", (Object)Integer.valueOf(this.folderid));
                query.andQualifier(exp2);
            }
            List list = query.fetchList();
            if (list != null && list.size() > 0) {
                EipTCabinetFolder tmpfolder = null;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    tmpfolder = (EipTCabinetFolder)list.get(i);
                    if (!fname.equals(tmpfolder.getFolderName())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int acl_folder;
            int i;
            EipTCabinetFolder folder = CabinetUtils.getEipTCabinetFolder(rundata, context);
            if (folder == null) {
                return false;
            }
            this.folder_name.setValue(folder.getFolderName());
            this.note.setValue(folder.getNote());
            this.access_flag.setValue(folder.getPublicFlag());
            int int_flag = Integer.valueOf(folder.getPublicFlag());
            if (int_flag == 1 || int_flag == 2) {
                this.is_member = true;
                SelectQuery mapquery = Database.query(EipTCabinetFolderMap.class);
                Expression mapexp = ExpressionFactory.matchDbExp((String)"eipTCabinetFolder", (Object)folder.getFolderId());
                mapquery.setQualifier(mapexp);
                List list = mapquery.fetchList();
                ArrayList<Integer> users = new ArrayList<Integer>();
                int size = list.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    EipTCabinetFolderMap map = (EipTCabinetFolderMap)list.get(i2);
                    users.add(map.getUserId());
                }
                SelectQuery query = Database.query(TurbineUser.class);
                Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", users);
                Expression nonDisabledexp = ExpressionFactory.noMatchExp((String)"disabled", (Object)"T");
                query.setQualifier(exp.andExp(nonDisabledexp));
                this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
            } else {
                this.is_member = false;
            }
            int folder_id = this.selected_folderinfo.getFolderId();
            ArrayList<Integer> disable_list = new ArrayList<Integer>();
            disable_list.add(folder_id);
            int size = this.folder_hierarchy_list.size();
            for (i = 0; i < size; ++i) {
                FolderInfo info = this.folder_hierarchy_list.get(i);
                boolean flg = false;
                int len = disable_list.size();
                for (int j = 0; j < len; ++j) {
                    Integer id = (Integer)disable_list.get(j);
                    if (info.getFolderId() != id.intValue() && info.getParentFolderId() != id.intValue()) continue;
                    flg = true;
                    break;
                }
                if (flg) {
                    info.setVisible(false);
                    disable_list.add(info.getFolderId());
                    continue;
                }
                info.setVisible(true);
            }
            CabinetUtils.setFolderVisibleForForm(this.folder_hierarchy_list, rundata);
            for (i = 0; i < size; ++i) {
                FolderInfo info = this.folder_hierarchy_list.get(i);
                if (info.getFolderId() != this.selected_folderinfo.getParentFolderId()) continue;
                this.selected_folderinfo = info;
            }
            this.show_acl_form = Integer.valueOf(folder.getPublicFlag()) == 0 ? (acl_folder = CabinetUtils.getAccessControlFolderId(folder.getParentId()).intValue()) == 1 : true;
        }
        catch (Exception ex) {
            logger.error((Object)"cabinet", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String folderid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id");
            int delete_id = Integer.parseInt(folderid);
            if (delete_id <= 1) {
                return false;
            }
            int delete_parent_id = 0;
            SelectQuery query = Database.query(EipTCabinetFolder.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)Integer.valueOf(folderid));
            Expression exp2 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf(folderid));
            query.setQualifier(exp1.orExp(exp2));
            List list = query.fetchList();
            if (list == null || list.size() <= 0) {
                return false;
            }
            ArrayList<Integer> folderids = new ArrayList<Integer>();
            EipTCabinetFolder folder = null;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                folder = (EipTCabinetFolder)list.get(i);
                folderids.add(folder.getFolderId());
                if (folder.getFolderId() != delete_id) continue;
                delete_parent_id = folder.getParentId();
            }
            SelectQuery delfolderquery = Database.query(EipTCabinetFolder.class);
            Expression delfolderexp = ExpressionFactory.inDbExp((String)"FOLDER_ID", folderids);
            delfolderquery.setQualifier(delfolderexp);
            List delFolderList = delfolderquery.fetchList();
            int delFolderListsize = delFolderList.size();
            for (int i = 0; i < delFolderListsize; ++i) {
                int k;
                EipTCabinetFolder delfolder = (EipTCabinetFolder)delFolderList.get(i);
                Integer entityId = delfolder.getFolderId();
                String folderName = delfolder.getFolderName();
                List<EipTCabinetFile> cabinetfiles = CabinetUtils.getEipTCabinetFileList(delfolder.getFolderId());
                ArrayList<String> fpaths = new ArrayList<String>();
                if (cabinetfiles != null && cabinetfiles.size() > 0) {
                    int tsize = cabinetfiles.size();
                    for (k = 0; k < tsize; ++k) {
                        fpaths.add(cabinetfiles.get(k).getFilePath());
                    }
                }
                Database.delete((Persistent)delfolder);
                Database.commit();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 221, folderName);
                if (fpaths.size() <= 0) continue;
                int fsize = fpaths.size();
                for (k = 0; k < fsize; ++k) {
                    ALStorageService.deleteFile((String)(CabinetUtils.getSaveDirPath(this.orgId) + (String)fpaths.get(k)));
                }
            }
            this.folder_hierarchy_list = CabinetUtils.getFolderList();
            CabinetUtils.setFolderVisibleForForm(this.folder_hierarchy_list, rundata);
            this.selected_folderinfo = CabinetUtils.getSelectedFolderInfo(this.folder_hierarchy_list, delete_parent_id);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"cabinet", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = false;
        try {
            int uid = ALEipUtils.getUserId((RunData)rundata);
            EipTCabinetFolder folder = (EipTCabinetFolder)Database.create(EipTCabinetFolder.class);
            folder.setParentId(Integer.valueOf((int)this.parent_id.getValue()));
            folder.setFolderName(this.folder_name.getValue());
            folder.setNote(this.note.getValue());
            folder.setCreateUserId(Integer.valueOf(uid));
            folder.setUpdateUserId(Integer.valueOf(uid));
            folder.setCreateDate(Calendar.getInstance().getTime());
            folder.setUpdateDate(Calendar.getInstance().getTime());
            int accessFlag = (int)this.access_flag.getValue();
            folder.setPublicFlag(String.valueOf(accessFlag));
            for (int i = 0; i < this.memberList.size(); ++i) {
                EipTCabinetFolderMap map = (EipTCabinetFolderMap)Database.create(EipTCabinetFolderMap.class);
                ALEipUser user = this.memberList.get(i);
                int user_id = (int)user.getUserId().getValue();
                map.setEipTCabinetFolder(folder);
                map.setUserId(Integer.valueOf(user_id));
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(folder.getFolderId().intValue(), 221, this.folder_name.getValue());
            int size = this.folder_hierarchy_list.size();
            for (int i = 0; i < size; ++i) {
                FolderInfo info = this.folder_hierarchy_list.get(i);
                if ((long)info.getFolderId() != this.parent_id.getValue()) continue;
                this.parent_folderinfo = info;
                break;
            }
            this.selected_folderinfo.setFolderId(folder.getFolderId());
            this.selected_folderinfo.setFolderName(folder.getFolderName());
            this.selected_folderinfo.setHierarchyIndex(this.parent_folderinfo.getHierarchyIndex() + 1);
            this.selected_folderinfo.setParentFolderId(this.parent_folderinfo.getFolderId());
            res = true;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"cabinet", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTCabinetFolder folder = CabinetUtils.getEipTCabinetFolder(rundata, context);
            if (folder == null) {
                return false;
            }
            int uid = ALEipUtils.getUserId((RunData)rundata);
            folder.setFolderName(this.folder_name.getValue());
            folder.setParentId(Integer.valueOf((int)this.parent_id.getValue()));
            folder.setNote(this.note.getValue());
            folder.setUpdateUserId(Integer.valueOf(uid));
            folder.setUpdateDate(Calendar.getInstance().getTime());
            SelectQuery mapquery = Database.query(EipTCabinetFolderMap.class);
            Expression mapexp = ExpressionFactory.matchExp((String)"eipTCabinetFolder", (Object)folder.getFolderId());
            mapquery.setQualifier(mapexp);
            List maplist = mapquery.fetchList();
            Database.deleteAll((List)maplist);
            int accessFlag = (int)this.access_flag.getValue();
            folder.setPublicFlag(String.valueOf(accessFlag));
            for (int i = 0; i < this.memberList.size(); ++i) {
                EipTCabinetFolderMap map = (EipTCabinetFolderMap)Database.create(EipTCabinetFolderMap.class);
                ALEipUser user = this.memberList.get(i);
                int user_id = (int)user.getUserId().getValue();
                map.setEipTCabinetFolder(folder);
                map.setUserId(Integer.valueOf(user_id));
            }
            if (accessFlag != 0) {
                List<EipTCabinetFolder> children = CabinetUtils.getChildFolders(folder);
                for (int i = 0; i < children.size(); ++i) {
                    EipTCabinetFolder child = children.get(i);
                    child.setPublicFlag(String.valueOf(0));
                }
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(folder.getFolderId().intValue(), 221, this.folder_name.getValue());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"cabinet", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getFolderName() {
        return this.folder_name;
    }

    public ALNumberField getParentId() {
        return this.parent_id;
    }

    public ALNumberField getAccessFlag() {
        return this.access_flag;
    }

    public List<ALEipGroup> getGroupList() {
        return this.groups;
    }

    public boolean isMember() {
        return this.is_member && this.memberList.size() > 0;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public List<FolderInfo> getFolderHierarchyList() {
        return this.folder_hierarchy_list;
    }

    public FolderInfo getSelectedFolderInfo() {
        return this.selected_folderinfo;
    }

    public boolean showAclForm() {
        return this.show_acl_form;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public String getAclPortletFeature() {
        return "cabinet_folder";
    }
}

