/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.report;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTReport;
import com.aimluck.eip.cayenne.om.portlet.EipTReportFile;
import com.aimluck.eip.cayenne.om.portlet.EipTReportMap;
import com.aimluck.eip.cayenne.om.portlet.EipTReportMemberMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.report.util.ReportUtils;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.timeline.util.TimelineUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ReportFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ReportFormData.class.getName());
    private ALStringField report_name;
    private ALStringField note;
    private ALDateTimeField createDate;
    private ALDateTimeField startDate;
    private ALDateTimeField endDate;
    private ALStringField positions;
    private ALStringField members;
    private List<ALEipUser> memberList;
    private List<ALEipUser> mapList;
    private List<FileuploadLiteBean> fileuploadList;
    private String folderName = null;
    private ALNumberField parent_id;
    private String orgId;
    private int uid;
    private ALEipUser login_user;
    private String aclPortletFeature = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.orgId = Database.getDomainName();
        this.folderName = rundata.getParameters().getString("folderName");
        int view_uid = ReportUtils.getViewId(rundata, context, this.uid);
        this.aclPortletFeature = view_uid == this.uid ? "report_self" : ("delete".equals(action.getMode()) && ALEipUtils.isAdmin((int)ALEipUtils.getUserId((RunData)rundata)) ? "report_self" : "report_other");
    }

    public void initField() {
        this.createDate = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.createDate.setFieldName(ALLocalizationUtils.getl10n((String)"REPORT_SETFIELDNAME_CREATEDATE"));
        this.startDate = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.endDate = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.report_name = new ALStringField();
        this.report_name.setFieldName(ALLocalizationUtils.getl10n((String)"REPORT_SETFIELDNAME_REPORT_NAME"));
        this.report_name.setTrim(true);
        this.report_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"REPORT_SETFIELDNAME_NOTE"));
        this.note.setTrim(false);
        this.positions = new ALStringField();
        this.positions.setFieldName(ALLocalizationUtils.getl10n((String)"REPORT_SETFIELDNAME_POSITIONS"));
        this.positions.setTrim(true);
        this.members = new ALStringField();
        this.members.setFieldName(ALLocalizationUtils.getl10n((String)"REPORT_SETFIELDNAME_MENVERS"));
        this.members.setTrim(true);
        this.fileuploadList = new ArrayList<FileuploadLiteBean>();
        this.memberList = new ArrayList<ALEipUser>();
        this.mapList = new ArrayList<ALEipUser>();
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                Object[] userNames;
                Calendar cal;
                if (this.startDate.toString().equals("")) {
                    cal = Calendar.getInstance();
                    cal.set(12, (int)Math.floor((double)cal.get(12) / 5.0) * 5);
                    this.startDate.setValue(cal.getTime());
                    this.endDate.setValue(cal.getTime());
                } else {
                    cal = Calendar.getInstance();
                    cal.setTime(this.startDate.getValue());
                    cal.set(11, rundata.getParameters().getInt("endDate_hour"));
                    cal.set(12, rundata.getParameters().getInt("endDate_minute"));
                    cal.set(13, 0);
                    cal.set(14, 0);
                    this.endDate.setValue(cal.getTime());
                }
                this.createDate.setValue(Calendar.getInstance().getTime());
                Object[] memberNames = rundata.getParameters().getStrings("members");
                if (memberNames != null && memberNames.length > 0) {
                    SelectQuery query = Database.query(TurbineUser.class);
                    Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])memberNames);
                    query.setQualifier(exp);
                    this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
                }
                if (this.memberList.size() == 0) {
                    this.memberList.add(this.login_user);
                }
                if ((userNames = rundata.getParameters().getStrings("positions")) != null && userNames.length > 0) {
                    SelectQuery query = Database.query(TurbineUser.class);
                    Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])userNames);
                    query.setQualifier(exp);
                    this.mapList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
                }
                this.fileuploadList = ReportUtils.getFileuploadList(rundata);
            }
            catch (Exception ex) {
                logger.error((Object)"report", (Throwable)ex);
            }
        }
        return res;
    }

    protected void setValidator() {
        this.startDate.setNotNull(true);
        this.endDate.setNotNull(true);
        this.report_name.setNotNull(true);
        this.report_name.limitMaxLength(50);
        this.note.setNotNull(true);
        this.note.limitMaxLength(10000);
        this.createDate.setNotNull(true);
    }

    protected boolean validate(List<String> msgList) {
        this.startDate.validate(msgList);
        this.endDate.validate(msgList);
        this.report_name.validate(msgList);
        this.note.validate(msgList);
        this.createDate.validate(msgList);
        if (this.startDate.getValue().compareTo(this.endDate.getValue()) > 0) {
            msgList.add(ALLocalizationUtils.getl10n((String)"REPORT_MESSAGE_SELECT_END_DATE_TO_START_DATE"));
        }
        if (this.memberList == null || this.memberList.size() <= 0) {
            msgList.add(ALLocalizationUtils.getl10n((String)"REPORT_MESSAGE_SELECT_SETFIELDNAME_MENVERS"));
        } else if (!(this.memberList.get(0) instanceof ALEipUser)) {
            msgList.add(ALLocalizationUtils.getl10n((String)"REPORT_ALERT_SETFIELDNAME_MENVERS_NO_ROUTE"));
        }
        if (this.mapList == null || this.mapList.size() <= 0) {
            msgList.add(ALLocalizationUtils.getl10n((String)"REPORT_MESSAGE_SELECT_SETFIELDNAME_POSITIONS"));
        } else if (!(this.mapList.get(0) instanceof ALEipUser)) {
            msgList.add(ALLocalizationUtils.getl10n((String)"REPORT_ALERT_SETFIELDNAME_POSITIONS_NO_ROUTE"));
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTReport report = ReportUtils.getEipTReport(rundata, context);
            if (report == null) {
                return false;
            }
            this.startDate.setValue(report.getStartDate());
            this.endDate.setValue(report.getEndDate());
            this.report_name.setValue(report.getReportName());
            this.note.setValue(report.getNote());
            this.createDate.setValue(report.getCreateDate());
            List<EipTReportMap> maps = ReportUtils.getEipTReportMap(report);
            EipTReportMap map = null;
            int size = maps.size();
            for (int i = 0; i < size; ++i) {
                map = maps.get(i);
                int user_id = map.getUserId();
                this.mapList.add(ALEipUtils.getALEipUser((int)user_id));
            }
            List<EipTReportMemberMap> members = ReportUtils.getEipTReportMemberMap(report);
            EipTReportMemberMap member = null;
            int size2 = members.size();
            for (int i = 0; i < size2; ++i) {
                member = members.get(i);
                int user_id = member.getUserId();
                this.memberList.add(ALEipUtils.getALEipUser((int)user_id));
            }
            List<EipTReportFile> files = ReportUtils.getEipTReportFile(report);
            int size3 = 0;
            if (files != null) {
                size3 = files.size();
            }
            FileuploadLiteBean filebean = null;
            for (int i = 0; i < size3; ++i) {
                EipTReportFile file = files.get(i);
                filebean = new FileuploadLiteBean();
                filebean.initField();
                filebean.setFolderName("DBF" + Integer.toString(file.getFileId()));
                filebean.setFileName(file.getFileName());
                filebean.setFileId(file.getFileId().intValue());
                this.fileuploadList.add(filebean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"report", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTReport report = ReportUtils.getEipTReport(rundata, context);
            String reqname = report.getReportName();
            ArrayList<String> fpaths = new ArrayList<String>();
            SelectQuery query = Database.query(EipTReportFile.class);
            query.andQualifier(ExpressionFactory.matchDbExp((String)"eipTReport", (Object)report.getReportId()));
            List files = query.fetchList();
            if (files != null && files.size() > 0) {
                int fsize = files.size();
                for (int j = 0; j < fsize; ++j) {
                    fpaths.add(((EipTReportFile)files.get(j)).getFilePath());
                }
                ReportUtils.deleteFiles(report.getReportId(), this.orgId, report.getUserId(), fpaths);
            }
            Database.delete((Persistent)report);
            if (report.getParentId() == 0) {
                List<EipTReport> reports = ReportUtils.getChildReports(report.getReportId());
                for (EipTReport model : reports) {
                    Integer reportId = model.getReportId();
                    List<EipTReportFile> cfiles = ReportUtils.getFiles(reportId);
                    for (EipTReportFile file : cfiles) {
                        ALStorageService.deleteFile((String)(ReportUtils.getSaveDirPath(this.orgId, this.uid) + file.getFilePath()));
                    }
                    Database.deleteAll(cfiles);
                }
                Database.deleteAll(reports);
            }
            Database.commit();
            TimelineUtils.deleteTimelineActivity((RunData)rundata, (Context)context, (String)"Report", (String)report.getReportId().toString());
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(report.getReportId().intValue(), 320, reqname);
        }
        catch (ALFileNotRemovedException fe) {
            Database.rollback();
            logger.error((Object)"report", (Throwable)fe);
            msgList.add(ALLocalizationUtils.getl10n((String)"ERROR_FILE_DETELE_FAILURE"));
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"report", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALDBErrorException {
        EipTReport report = null;
        try {
            int userid;
            Object map;
            Date nowDate = Calendar.getInstance().getTime();
            report = (EipTReport)Database.create(EipTReport.class);
            report.setReportName(this.report_name.getValue());
            report.setUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
            report.setStartDate(this.startDate.getValue());
            report.setEndDate(this.endDate.getValue());
            report.setNote(this.note.getValue());
            report.setCreateDate(this.createDate.getValue());
            report.setUpdateDate(Calendar.getInstance().getTime());
            report.setTurbineUser(ALEipUtils.getTurbineUser((int)ALEipUtils.getUserId((RunData)rundata)));
            report.setParentId(Integer.valueOf(0));
            for (ALEipUser user : this.memberList) {
                map = (EipTReportMemberMap)Database.create(EipTReportMemberMap.class);
                userid = (int)user.getUserId().getValue();
                map.setEipTReport(report);
                map.setUserId(Integer.valueOf(userid));
            }
            for (ALEipUser user : this.mapList) {
                map = (EipTReportMap)Database.create(EipTReportMap.class);
                userid = (int)user.getUserId().getValue();
                map.setEipTReport(report);
                map.setUserId(Integer.valueOf(userid));
                map.setStatus("U");
                map.setCreateDate(nowDate);
                map.setUpdateDate(nowDate);
            }
            this.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, report, msgList);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(report.getReportId().intValue(), 320, this.report_name.getValue());
            String loginName = this.login_user.getName().getValue();
            ArrayList<String> recipients = new ArrayList<String>();
            for (ALEipUser user : this.mapList) {
                if (this.login_user.getUserId().getValue() == user.getUserId().getValue()) continue;
                recipients.add(user.getName().getValue());
            }
            ReportUtils.createReportActivity(report, loginName, recipients, true);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"report", (Throwable)ex);
            return false;
        }
        try {
            int msgType = ALMailUtils.getSendDestType((int)26);
            if (msgType > 0) {
                List destMemberList = ALMailUtils.getALEipUserAddrs(this.mapList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                String subject = "[" + ALOrgUtilsService.getAlias() + "]" + ALLocalizationUtils.getl10n((String)"REPORT_REPORT");
                String orgId = Database.getDomainName();
                ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                for (ALEipUserAddr destMember : destMemberList) {
                    ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                    message.setPcSubject(subject);
                    message.setCellularSubject(subject);
                    message.setPcBody(ReportUtils.createMsgForPc(rundata, report, this.memberList, this.mapList, true));
                    message.setCellularBody(ReportUtils.createMsgForCellPhone(rundata, report, this.memberList, this.mapList, true));
                    messageList.add(message);
                }
                ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)26)));
            }
        }
        catch (Exception ex) {
            msgList.add(ALLocalizationUtils.getl10n((String)"REPORT_ALERT_DONOT_SEND"));
            logger.error((Object)"report", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        EipTReport report = null;
        try {
            int userid;
            EipTReportMemberMap map;
            report = ReportUtils.getEipTReport(rundata, context);
            if (report == null) {
                return false;
            }
            Date nowDate = Calendar.getInstance().getTime();
            report.setReportName(this.report_name.getValue());
            report.setUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
            report.setStartDate(this.startDate.getValue());
            report.setEndDate(this.endDate.getValue());
            report.setNote(this.note.getValue());
            report.setCreateDate(this.createDate.getValue());
            report.setUpdateDate(Calendar.getInstance().getTime());
            report.setTurbineUser(ALEipUtils.getTurbineUser((int)ALEipUtils.getUserId((RunData)rundata)));
            List<EipTReportMap> tmp_map = ReportUtils.getEipTReportMap(report);
            List<EipTReportMemberMap> tmp_member_map = ReportUtils.getEipTReportMemberMap(report);
            Database.deleteAll(tmp_map);
            Database.deleteAll(tmp_member_map);
            for (ALEipUser user : this.memberList) {
                map = (EipTReportMemberMap)Database.create(EipTReportMemberMap.class);
                userid = (int)user.getUserId().getValue();
                map.setEipTReport(report);
                map.setUserId(Integer.valueOf(userid));
            }
            for (ALEipUser user : this.mapList) {
                map = (EipTReportMap)Database.create(EipTReportMap.class);
                userid = (int)user.getUserId().getValue();
                map.setEipTReport(report);
                map.setUserId(Integer.valueOf(userid));
                map.setStatus("U");
                map.setCreateDate(nowDate);
                map.setUpdateDate(nowDate);
            }
            List<Integer> attIdList = this.getRequestedHasFileIdList(this.fileuploadList);
            List<EipTReportFile> files = ReportUtils.getEipTReportFile(report);
            if (files != null) {
                int size = files.size();
                for (int i = 0; i < size; ++i) {
                    EipTReportFile file = files.get(i);
                    if (attIdList.contains(file.getFileId())) continue;
                    ALStorageService.deleteFile((String)(ReportUtils.getSaveDirPath(this.orgId, this.uid) + file.getFilePath()));
                    Database.delete((Persistent)file);
                }
            }
            this.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, report, msgList);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(report.getReportId().intValue(), 320, this.report_name.getValue());
            String loginName = this.login_user.getName().getValue();
            ArrayList<String> recipients = new ArrayList<String>();
            for (ALEipUser user : this.mapList) {
                if (this.login_user.getUserId().getValue() == user.getUserId().getValue()) continue;
                recipients.add(user.getName().getValue());
            }
            ReportUtils.createReportActivity(report, loginName, recipients, false);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"report", (Throwable)ex);
            return false;
        }
        try {
            int msgType = ALMailUtils.getSendDestType((int)26);
            if (msgType > 0) {
                List destMemberList = ALMailUtils.getALEipUserAddrs(this.mapList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                String subject = "[" + ALOrgUtilsService.getAlias() + "]" + ALLocalizationUtils.getl10n((String)"REPORT_REPORT");
                String orgId = Database.getDomainName();
                ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                for (ALEipUserAddr destMember : destMemberList) {
                    ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                    message.setPcSubject(subject);
                    message.setCellularSubject(subject);
                    message.setPcBody(ReportUtils.createMsgForPc(rundata, report, this.memberList, this.mapList, false));
                    message.setCellularBody(ReportUtils.createMsgForCellPhone(rundata, report, this.memberList, this.mapList, false));
                    messageList.add(message);
                }
                ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)26)));
            }
        }
        catch (Exception ex) {
            msgList.add(ALLocalizationUtils.getl10n((String)"REPORT_ALERT_DONOT_SEND"));
            logger.error((Object)"report", (Throwable)ex);
            return false;
        }
        return true;
    }

    private List<Integer> getRequestedHasFileIdList(List<FileuploadLiteBean> attachmentFileNameList) {
        ArrayList<Integer> idlist = new ArrayList<Integer>();
        FileuploadLiteBean filebean = null;
        if (attachmentFileNameList != null) {
            int size = attachmentFileNameList.size();
            for (int i = 0; i < size; ++i) {
                filebean = attachmentFileNameList.get(i);
                if (filebean.isNewFile()) continue;
                int index = filebean.getFileId();
                idlist.add(index);
            }
        }
        return idlist;
    }

    private boolean insertAttachmentFiles(List<FileuploadLiteBean> fileuploadList, String folderName, int uid, EipTReport entry, List<String> msgList) {
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            return true;
        }
        try {
            int length = fileuploadList.size();
            ArrayList<FileuploadLiteBean> newfilebeans = new ArrayList<FileuploadLiteBean>();
            FileuploadLiteBean filebean = null;
            for (int i = 0; i < length; ++i) {
                filebean = fileuploadList.get(i);
                if (!filebean.isNewFile()) continue;
                newfilebeans.add(filebean);
            }
            int newfilebeansSize = newfilebeans.size();
            if (newfilebeansSize > 0) {
                FileuploadLiteBean newfilebean = null;
                for (int j = 0; j < length; ++j) {
                    newfilebean = (FileuploadLiteBean)newfilebeans.get(j);
                    String[] acceptExts = ImageIO.getWriterFormatNames();
                    byte[] fileThumbnail = null;
                    FileuploadUtils.ShrinkImageSet bytesShrinkFilebean = FileuploadUtils.getBytesShrinkFilebean((String)this.orgId, (String)folderName, (int)uid, (FileuploadLiteBean)newfilebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)false);
                    if (bytesShrinkFilebean != null) {
                        fileThumbnail = bytesShrinkFilebean.getShrinkImage();
                    }
                    String filename = j + "_" + String.valueOf(System.nanoTime());
                    EipTReportFile file = (EipTReportFile)Database.create(EipTReportFile.class);
                    file.setOwnerId(Integer.valueOf(uid));
                    file.setFileName(newfilebean.getFileName());
                    file.setFilePath(ReportUtils.getRelativePath(filename));
                    if (fileThumbnail != null) {
                        file.setFileThumbnail(fileThumbnail);
                    }
                    file.setEipTReport(entry);
                    file.setCreateDate(Calendar.getInstance().getTime());
                    file.setUpdateDate(Calendar.getInstance().getTime());
                    ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(newfilebean.getFileId()), (String)ReportUtils.FOLDER_FILEDIR_REPORT, (String)(ReportUtils.CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
                }
                ALStorageService.deleteTmpFolder((int)uid, (String)folderName);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return true;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public void setNote(String str) {
        this.note.setValue(str);
    }

    public ALStringField getReportName() {
        return this.report_name;
    }

    public void setReportName(String str) {
        this.report_name.setValue(str);
    }

    public ALDateTimeField getCreateDate() {
        return this.createDate;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(ArrayList<ALEipUser> list) {
        this.memberList = list;
    }

    public List<ALEipUser> getMapList() {
        return this.mapList;
    }

    public void setMapList(ArrayList<ALEipUser> list) {
        this.mapList = list;
    }

    public List<ALEipUser> getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public ALDateTimeField getStartDate() {
        return this.startDate;
    }

    public ALDateTimeField getEndDate() {
        return this.endDate;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public static String toTwoDigitString(int num) {
        return ALStringUtil.toTwoDigitString((ALNumberField)new ALNumberField((long)num));
    }
}

