/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.report.util;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.utils.ALDeleteFileUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTReport;
import com.aimluck.eip.cayenne.om.portlet.EipTReportFile;
import com.aimluck.eip.cayenne.om.portlet.EipTReportMap;
import com.aimluck.eip.cayenne.om.portlet.EipTReportMemberMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class ReportUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ReportUtils.class.getName());
    public static final String DB_STATUS_UNREAD = "U";
    public static final String DB_STATUS_READ = "R";
    public static final String DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm";
    public static final String REPORT_PORTLET_NAME = "Report";
    public static final String FOLDER_FILEDIR_REPORT = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    public static final String CATEGORY_KEY = JetspeedResources.getString((String)"aipo.report.categorykey", (String)"");
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");
    public static final String PREFIX_DBFILE = "DBF";
    private static final String RESET_FLAG = "reset_params";
    public static final String TARGET_KEYWORD = "keyword";

    public static EipTReport getEipTReportParentReply(RunData rundata, Context context, boolean isJoin) throws ALPageNotFoundException, ALDBErrorException {
        String reportid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (reportid == null || Integer.valueOf(reportid) == null) {
                logger.debug((Object)"[EipTReport] Empty ID...");
                throw new ALPageNotFoundException();
            }
            int userid = ALEipUtils.getUserId((RunData)rundata);
            SelectQuery query = Database.query(EipTReport.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REPORT_ID", (Object)Integer.valueOf(reportid));
            query.setQualifier(exp1);
            query.distinct(true);
            List reports = query.fetchList();
            if (reports == null || reports.size() == 0) {
                logger.debug((Object)"[ReportTopic] Not found ID...");
                throw new ALPageNotFoundException();
            }
            EipTReport report = (EipTReport)reports.get(0);
            return report;
        }
        catch (ALPageNotFoundException pageNotFound) {
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"[ReportUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTReport getEipTReportParentReply(RunData rundata, Context context, String reportid, boolean isSuperUser) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List reports;
            if (reportid == null || Integer.valueOf(reportid) == null) {
                logger.debug((Object)"[ReportTopic] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTReport.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REPORT_ID", (Object)Integer.valueOf(reportid));
            query.setQualifier(exp1);
            if (!isSuperUser) {
                Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
                query.andQualifier(exp2);
            }
            if ((reports = query.fetchList()) == null || reports.size() == 0) {
                logger.debug((Object)"[EipTReport] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTReport)reports.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[EipUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static void deleteFiles(int timelineId, String orgId, int uid, List<String> fpaths) throws ALFileNotRemovedException {
        ALDeleteFileUtil.deleteFiles((int)timelineId, (String)"eipTReport", (String)ReportUtils.getSaveDirPath(orgId, uid), fpaths, EipTReportFile.class);
    }

    public static boolean insertFileDataDelegate(RunData rundata, Context context, EipTReport report, List<FileuploadLiteBean> fileuploadList, String folderName, List<String> msgList) {
        try {
            if (fileuploadList == null || fileuploadList.size() <= 0) {
                fileuploadList = new ArrayList<FileuploadLiteBean>();
            }
            int uid = ALEipUtils.getUserId((RunData)rundata);
            String orgId = Database.getDomainName();
            ArrayList<Integer> hadfileids = new ArrayList<Integer>();
            for (FileuploadLiteBean file : fileuploadList) {
                if (file.isNewFile()) continue;
                hadfileids.add(file.getFileId());
            }
            SelectQuery dbquery = Database.query(EipTReportFile.class);
            dbquery.andQualifier(ExpressionFactory.matchDbExp((String)"eipTReport", (Object)report.getReportId()));
            List existsFiles = dbquery.fetchList();
            ArrayList<EipTReportFile> delFiles = new ArrayList<EipTReportFile>();
            ArrayList<String> fpaths = new ArrayList<String>();
            for (EipTReportFile file : existsFiles) {
                if (hadfileids.contains(file.getFileId())) continue;
                delFiles.add(file);
                fpaths.add(file.getFilePath());
            }
            ReportUtils.deleteFiles(report.getReportId(), orgId, report.getUserId(), fpaths);
            for (FileuploadLiteBean filebean : fileuploadList) {
                if (!filebean.isNewFile()) continue;
                String[] acceptExts = ImageIO.getWriterFormatNames();
                byte[] fileThumbnail = null;
                FileuploadUtils.ShrinkImageSet bytesShrinkFilebean = FileuploadUtils.getBytesShrinkFilebean((String)orgId, (String)folderName, (int)uid, (FileuploadLiteBean)filebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)false);
                if (bytesShrinkFilebean != null) {
                    fileThumbnail = bytesShrinkFilebean.getShrinkImage();
                }
                String filename = "0_" + String.valueOf(System.nanoTime());
                EipTReportFile file = (EipTReportFile)Database.create(EipTReportFile.class);
                file.setOwnerId(Integer.valueOf(uid));
                file.setEipTReport(report);
                file.setFileName(filebean.getFileName());
                file.setFilePath(ReportUtils.getRelativePath(filename));
                if (fileThumbnail != null) {
                    file.setFileThumbnail(fileThumbnail);
                }
                file.setCreateDate(Calendar.getInstance().getTime());
                file.setUpdateDate(Calendar.getInstance().getTime());
                ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(filebean.getFileId()), (String)FOLDER_FILEDIR_REPORT, (String)(CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
            }
            ALStorageService.deleteTmpFolder((int)uid, (String)folderName);
        }
        catch (ALFileNotRemovedException fe) {
            Database.rollback();
            logger.error((Object)"BlogEntryFormData.deleteFormData", (Throwable)fe);
            msgList.add(ALLocalizationUtils.getl10n((String)"ERROR_FILE_DETELE_FAILURE"));
            return false;
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"report", (Throwable)e);
            return false;
        }
        return true;
    }

    public static EipTReport getEipTReport(RunData rundata, Context context) throws ALDBErrorException {
        String requestid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (requestid == null || Integer.valueOf(requestid) == null) {
                logger.debug((Object)"[ReportUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTReport.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REPORT_ID", (Object)requestid);
            query.setQualifier(exp1);
            List requests = query.fetchList();
            if (requests == null || requests.size() == 0) {
                logger.debug((Object)"[ReportUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTReport)requests.get(0);
        }
        catch (ALPageNotFoundException ex) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"report", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<EipTReport> getEipTReport(EipTReport report) throws ALPageNotFoundException {
        try {
            SelectQuery query = Database.query(EipTReport.class);
            Expression exp = ExpressionFactory.matchExp((String)"REPORT_ID", (Object)report);
            query.setQualifier(exp);
            return query.fetchList();
        }
        catch (Exception ex) {
            logger.error((Object)"report", (Throwable)ex);
            return null;
        }
    }

    public static EipTReportFile getEipTReportFile(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
            if (attachmentIndex < 0) {
                logger.debug((Object)"[ReportUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTReportFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)attachmentIndex);
            query.andQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[ReportUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTReportFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[ReportUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<EipTReportFile> getEipTReportFile(EipTReport report) {
        try {
            SelectQuery query = Database.query(EipTReportFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTReport.REPORT_ID", (Object)report.getReportId());
            query.setQualifier(exp);
            List maps = query.fetchList();
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[ReportSelectData] Not found ID...");
                return null;
            }
            return maps;
        }
        catch (Exception ex) {
            logger.error((Object)"report", (Throwable)ex);
            return null;
        }
    }

    public static List<EipTReportMap> getEipTReportMap(EipTReport report) {
        try {
            SelectQuery query = Database.query(EipTReportMap.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTReport.REPORT_ID", (Object)report.getReportId());
            query.setQualifier(exp);
            List maps = query.fetchList();
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[ReportSelectData] Not found ID...");
                return null;
            }
            return maps;
        }
        catch (Exception ex) {
            logger.error((Object)"report", (Throwable)ex);
            return null;
        }
    }

    public static List<EipTReportMemberMap> getEipTReportMemberMap(EipTReport report) {
        try {
            SelectQuery query = Database.query(EipTReportMemberMap.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTReport.REPORT_ID", (Object)report.getReportId());
            query.setQualifier(exp);
            List members = query.fetchList();
            if (members == null || members.size() == 0) {
                logger.debug((Object)"[ReportSelectData] Not found ID...");
                return null;
            }
            return members;
        }
        catch (Exception ex) {
            logger.error((Object)"report", (Throwable)ex);
            return null;
        }
    }

    public static String getSaveDirPath(String orgId, int uid) {
        return ALStorageService.getDocumentPath((String)FOLDER_FILEDIR_REPORT, (String)(CATEGORY_KEY + ALStorageService.separator() + uid));
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    public static List<UserLiteBean> getAuthorityUsers(RunData rundata, String groupname, boolean includeLoginuser) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            List ulist = aclhandler.getAuthorityUsersFromGroup(rundata, "report_self", groupname, includeLoginuser);
            ArrayList<UserLiteBean> list = new ArrayList<UserLiteBean>();
            for (TurbineUser tuser : ulist) {
                UserLiteBean user = new UserLiteBean();
                user.initField();
                user.setUserId(tuser.getUserId().intValue());
                user.setName(tuser.getLoginName());
                user.setAliasName(tuser.getFirstName(), tuser.getLastName());
                list.add(user);
            }
            return list;
        }
        catch (InstantiationException e) {
            return null;
        }
    }

    public static boolean hasResetFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_FLAG);
        return resetflag != null;
    }

    public static void clearReportSession(RunData rundata, Context context) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("entityid");
        list.add("submenu");
        list.add("com.aimluck.eip.report.ReportSelectDatasort");
        list.add("com.aimluck.eip.report.ReportSelectDatasorttype");
        list.add("com.aimluck.eip.report.ReportSelectDatafiltertype");
        list.add("com.aimluck.eip.report.ReportSelectDatafilter");
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, list);
    }

    public static int getViewId(RunData rundata, Context context, int uid) throws ALDBErrorException {
        int view_uid = -1;
        EipTReport record = ReportUtils.getEipTReport(rundata, context);
        view_uid = record != null ? record.getUserId() : (rundata.getParameters().containsKey((Object)"view_uid") ? Integer.parseInt(rundata.getParameters().getString("view_uid")) : uid);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_uid", (String)String.valueOf(view_uid));
        return view_uid;
    }

    public static SelectQuery<EipTReportFile> getSelectQueryForFiles(int requestid) {
        SelectQuery query = Database.query(EipTReportFile.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"REPORT_ID", (Object)requestid);
        query.setQualifier(exp);
        query.orderAscending("updateDate");
        query.orderAscending("filePath");
        return query;
    }

    public static SelectQuery<EipTReport> getSelectQueryForCoReports(int requestid) {
        SelectQuery query = Database.query(EipTReport.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"parentId", (Object)requestid);
        query.setQualifier(exp);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<FileuploadLiteBean> getFileuploadList(RunData rundata) {
        String[] fileids = rundata.getParameters().getStrings("attachments");
        if (fileids == null) {
            return null;
        }
        ArrayList<String> hadfileids = new ArrayList<String>();
        ArrayList<String> newfileids = new ArrayList<String>();
        for (int j = 0; j < fileids.length; ++j) {
            if (fileids[j].trim().startsWith("s")) {
                hadfileids.add(fileids[j].trim().substring(1));
                continue;
            }
            newfileids.add(fileids[j].trim());
        }
        ArrayList<FileuploadLiteBean> fileNameList = new ArrayList<FileuploadLiteBean>();
        FileuploadLiteBean filebean = null;
        int fileid = 0;
        if (newfileids.size() > 0) {
            String folderName = rundata.getParameters().getString("folderName");
            if (folderName == null || folderName.equals("")) {
                return null;
            }
            int length = newfileids.size();
            for (int i = 0; i < length; ++i) {
                if (newfileids.get(i) == null || ((String)newfileids.get(i)).equals("")) continue;
                try {
                    fileid = Integer.parseInt((String)newfileids.get(i));
                }
                catch (Exception e) {
                    continue;
                }
                if (fileid == 0) {
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName("photo");
                    filebean.setFileName(ALLocalizationUtils.getl10n((String)"REPORT_PREVIOUS_PICTURE_FILE"));
                    fileNameList.add(filebean);
                    continue;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(ALStorageService.getTmpFile((int)ALEipUtils.getUserId((RunData)rundata), (String)folderName, (String)(fileid + ".txt")), FILE_ENCODING));
                    String line = reader.readLine();
                    if (line == null || line.length() <= 0) continue;
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName(fileids[i]);
                    filebean.setFileId(fileid);
                    filebean.setFileName(line);
                    fileNameList.add(filebean);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"report", (Throwable)e);
                    continue;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"report", (Throwable)e);
                    }
                }
            }
        }
        if (hadfileids.size() > 0) {
            ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
            for (int k = 0; k < hadfileids.size(); ++k) {
                try {
                    fileid = Integer.parseInt((String)hadfileids.get(k));
                    hadfileidsValue.add(fileid);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                SelectQuery reqquery = Database.query(EipTReportFile.class);
                Expression reqexp1 = ExpressionFactory.inDbExp((String)"FILE_ID", hadfileidsValue);
                reqquery.setQualifier(reqexp1);
                List requests = reqquery.fetchList();
                int requestssize = requests.size();
                for (int i = 0; i < requestssize; ++i) {
                    EipTReportFile file = (EipTReportFile)requests.get(i);
                    filebean = new FileuploadBean();
                    filebean.initField();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(file.getFileName());
                    filebean.setFlagNewFile(false);
                    fileNameList.add(filebean);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"[BlogUtils] Exception.", (Throwable)ex);
            }
        }
        return fileNameList;
    }

    public static String translateDate(Date date, String dateFormat) {
        if (date == null) {
            return "Unknown";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(date);
    }

    public static EipTReport getEipTReportReply(RunData rundata, Context context, String reportid, boolean isSuperUser) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List reports;
            if (reportid == null || Integer.valueOf(reportid) == null) {
                logger.debug((Object)"[ReportTopic] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTReport.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REPORT_ID", (Object)Integer.valueOf(reportid));
            query.setQualifier(exp1);
            if (!isSuperUser) {
                Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
                query.andQualifier(exp2);
            }
            if ((reports = query.fetchList()) == null || reports.size() == 0) {
                logger.debug((Object)"[Report] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTReport)reports.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[ReportUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static void createReportActivity(EipTReport report, String loginName, List<String> recipients, Boolean type) {
        if (recipients != null && recipients.size() > 0) {
            ALActivity RecentActivity = ALActivity.getRecentActivity((String)REPORT_PORTLET_NAME, (int)report.getReportId(), (float)1.0f);
            boolean isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
            StringBuilder b = new StringBuilder(ALLocalizationUtils.getl10n((String)"REPORT_REPORT") + "\u300c");
            b.append(report.getReportName()).append("\u300d").append(type != false ? ALLocalizationUtils.getl10n((String)"REPORT_SEND_REQUEST_MSG") : ALLocalizationUtils.getl10n((String)"REPORT_UPDATED_MSG"));
            String portletParams = "?template=ReportDetailScreen" + "&entityid=" + report.getReportId();
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(REPORT_PORTLET_NAME).withUserId(report.getUserId().intValue()).withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipients).withTitle(b.toString()).withPriority(1.0f).withExternalId(String.valueOf(report.getReportId())));
            if (isDeletePrev) {
                RecentActivity.delete();
            }
        }
    }

    public static void createReportReplyActivity(EipTReport report, String loginName, List<String> recipient) {
        if (recipient != null) {
            recipient.remove(loginName);
            ALActivity RecentActivity = ALActivity.getRecentActivity((String)REPORT_PORTLET_NAME, (int)report.getReportId(), (float)1.0f);
            boolean isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
            StringBuilder b = new StringBuilder(ALLocalizationUtils.getl10n((String)"REPORT_REPORT") + "\u300c");
            b.append(report.getReportName()).append("\u300d").append(ALLocalizationUtils.getl10n((String)"REPORT_REPLY_MSG"));
            String portletParams = "?template=ReportDetailScreen" + "&entityid=" + report.getReportId();
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(REPORT_PORTLET_NAME).withUserId(report.getUserId().intValue()).withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipient).withTitle(b.toString()).withPriority(1.0f).withExternalId(String.valueOf(report.getReportId())));
            if (isDeletePrev) {
                RecentActivity.delete();
            }
        }
    }

    public static String createMsgForPc(RunData rundata, EipTReport report, List<ALEipUser> memberList, List<ALEipUser> mapList, Boolean isNew) throws ALDBErrorException {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        context.put("loginUser", (Object)loginUser.getAliasName().toString());
        context.put("hasEmail", (Object)(!user.getEmail().equals("") ? 1 : 0));
        context.put("email", (Object)user.getEmail());
        context.put("isNew", (Object)isNew);
        context.put("getReportName", (Object)report.getReportName());
        ALDateTimeField alDateTimeField = new ALDateTimeField();
        alDateTimeField.setValue(report.getCreateDate());
        StringBuffer createDate = new StringBuffer();
        createDate.append(alDateTimeField.getYear()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_YEAR", (Object[])new Object[0])).append(alDateTimeField.getMonth()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MONTH", (Object[])new Object[0])).append(alDateTimeField.getDay()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_DAY", (Object[])new Object[0])).append(alDateTimeField.getHour()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_HOUR", (Object[])new Object[0])).append(alDateTimeField.getMinute()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MINUTE", (Object[])new Object[0]));
        context.put("createDate", (Object)createDate);
        context.put("getNote", (Object)report.getNote());
        StringBuffer reportName = new StringBuffer();
        if (memberList != null) {
            int size = memberList.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    reportName.append(", ");
                }
                ALEipUser member = memberList.get(i);
                reportName.append(member.getAliasName());
            }
        }
        context.put("reportName", (Object)reportName);
        StringBuffer eipTReportMemberMap = new StringBuffer();
        if (mapList != null) {
            int size = mapList.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    eipTReportMemberMap.append(", ");
                }
                ALEipUser member = mapList.get(i);
                eipTReportMemberMap.append(member.getAliasName());
            }
        }
        context.put("eipTReportMemberMap", (Object)eipTReportMemberMap);
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && lang.equals("ja")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/report-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/report-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }

    public static String createMsgForCellPhone(RunData rundata, EipTReport report, List<ALEipUser> memberList, List<ALEipUser> mapList, Boolean isNew) throws ALDBErrorException {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        context.put("loginUser", (Object)loginUser.getAliasName().toString());
        context.put("hasEmail", (Object)(!user.getEmail().equals("") ? 1 : 0));
        context.put("email", (Object)user.getEmail());
        context.put("isNew", (Object)isNew);
        context.put("getReportName", (Object)report.getReportName());
        ALDateTimeField alDateTimeField = new ALDateTimeField();
        alDateTimeField.setValue(report.getCreateDate());
        StringBuffer createDate = new StringBuffer();
        createDate.append(alDateTimeField.getYear()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_YEAR", (Object[])new Object[0])).append(alDateTimeField.getMonth()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MONTH", (Object[])new Object[0])).append(alDateTimeField.getDay()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_DAY", (Object[])new Object[0])).append(alDateTimeField.getHour()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_HOUR", (Object[])new Object[0])).append(alDateTimeField.getMinute()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MINUTE", (Object[])new Object[0]));
        context.put("createDate", (Object)createDate);
        context.put("getNote", (Object)report.getNote());
        StringBuffer reportName = new StringBuffer();
        if (memberList != null) {
            int size = memberList.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    reportName.append(", ");
                }
                ALEipUser member = memberList.get(i);
                reportName.append(member.getAliasName());
            }
        }
        context.put("reportName", (Object)reportName);
        StringBuffer eipTReportMemberMap = new StringBuffer();
        if (mapList != null) {
            int size = mapList.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    eipTReportMemberMap.append(", ");
                }
                ALEipUser member = mapList.get(i);
                eipTReportMemberMap.append(member.getAliasName());
            }
        }
        context.put("eipTReportMemberMap", (Object)eipTReportMemberMap);
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && lang.equals("ja")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/report-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/report-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }

    public static String createReplyMsgForPc(RunData rundata, EipTReport report, EipTReport reportparentreport) {
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        String CR = System.getProperty("line.separator");
        StringBuffer body = new StringBuffer("");
        body.append(loginUser.getAliasName().toString());
        if (!"".equals(user.getEmail())) {
            body.append("(").append(user.getEmail()).append(")");
        }
        body.append(ALLocalizationUtils.getl10n((String)"REPORT_REPORT_MSG")).append(ALLocalizationUtils.getl10n((String)"REPORT_REPLY_MSG")).append(CR).append(CR);
        body.append("[" + ALLocalizationUtils.getl10n((String)"REPORT_SETFIELDNAME_REPORT_NAME") + "]").append(CR).append(reportparentreport.getReportName().toString()).append(CR);
        body.append("[" + ALLocalizationUtils.getl10n((String)"REPORT_RETURN_REPORT_CREATEDATE") + "]").append(CR).append(ReportUtils.translateDate(report.getCreateDate(), ALLocalizationUtils.getl10n((String)"REPORT_TIME"))).append(CR);
        if (report.getNote().toString().length() > 0) {
            body.append("[" + ALLocalizationUtils.getl10n((String)"REPORT_RETURN_REPORT_NOTE") + "]").append(CR).append(report.getNote().toString()).append(CR);
        }
        body.append(CR);
        body.append("[").append(ALOrgUtilsService.getAlias()).append(ALLocalizationUtils.getl10n((String)"REPORT_ACCESS") + "]").append(CR);
        if (enableAsp) {
            body.append("\u3000").append(ALMailUtils.getGlobalurl()).append(CR);
        } else {
            body.append("\u30fb" + ALLocalizationUtils.getl10n((String)"REPORT_OUTSIDE_OFFICE")).append(CR);
            body.append("\u3000").append(ALMailUtils.getGlobalurl()).append(CR);
            body.append("\u30fb" + ALLocalizationUtils.getl10n((String)"REPORT_IN_OFFICE")).append(CR);
            body.append("\u3000").append(ALMailUtils.getLocalurl()).append(CR).append(CR);
        }
        body.append("---------------------").append(CR);
        body.append(ALOrgUtilsService.getAlias()).append(CR);
        return body.toString();
    }

    public static String createReplyMsgForCellPhone(RunData rundata, EipTReport report, EipTReport reportparentreport, int destUserID) {
        ALEipUser destUser;
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        String CR = System.getProperty("line.separator");
        StringBuffer body = new StringBuffer("");
        body.append(loginUser.getAliasName().toString());
        if (!"".equals(user.getEmail())) {
            body.append("(").append(user.getEmail()).append(")");
        }
        body.append(ALLocalizationUtils.getl10n((String)"REPORT_REPORT_MSG")).append(ALLocalizationUtils.getl10n((String)"REPORT_REPLY_MSG")).append(CR).append(CR);
        body.append("[" + ALLocalizationUtils.getl10n((String)"REPORT_SETFIELDNAME_REPORT_NAME") + "]").append(CR).append(reportparentreport.getReportName().toString()).append(CR);
        body.append("[" + ALLocalizationUtils.getl10n((String)"REPORT_RETURN_REPORT_CREATEDATE") + "]").append(CR).append(ReportUtils.translateDate(report.getCreateDate(), ALLocalizationUtils.getl10n((String)"REPORT_TIME"))).append(CR);
        body.append(CR);
        try {
            destUser = ALEipUtils.getALEipUser((int)destUserID);
        }
        catch (ALDBErrorException ex) {
            logger.error((Object)"report", (Throwable)ex);
            return "";
        }
        body.append("[").append(ALOrgUtilsService.getAlias()).append(ALLocalizationUtils.getl10n((String)"REPORT_ACCESS") + "]").append(CR);
        body.append("\u3000").append(ALMailUtils.getGlobalurl()).append("?key=").append(ALCellularUtils.getCellularKey((ALEipUser)destUser)).append(CR);
        body.append("---------------------").append(CR);
        body.append(ALOrgUtilsService.getAlias()).append(CR);
        return body.toString();
    }

    public static void resetFilter(RunData rundata, Context context, String className) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
    }

    public static String getTargetKeyword(RunData rundata, Context context) {
        String target_keyword = null;
        String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
        target_keyword = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD);
        if (keywordParam == null && target_keyword == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
            target_keyword = "";
        } else if (keywordParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)keywordParam.trim());
            target_keyword = keywordParam;
        }
        return target_keyword;
    }

    public static boolean isSelf(RunData rundata, Context context) {
        boolean isSelf = false;
        if (rundata.getParameters().getStringKey("entityid") != null) {
            SelectQuery q = Database.query(EipTReportMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"reportId", (Object)rundata.getParameters().getStringKey("entityid").toString());
            q.andQualifier(exp1);
            List queryList = q.fetchList();
            for (EipTReportMap repo : queryList) {
                if (repo.getUserId() != ALEipUtils.getUserId((RunData)rundata)) continue;
                isSelf = true;
            }
        }
        return isSelf;
    }

    public static List<EipTReport> getChildReports(Integer reportId) {
        SelectQuery rquery = Database.query(EipTReport.class);
        rquery.andQualifier(ExpressionFactory.matchExp((String)"parentId", (Object)reportId));
        return rquery.fetchList();
    }

    public static List<EipTReportFile> getFiles(Integer reportId) {
        SelectQuery fquery = Database.query(EipTReportFile.class);
        fquery.andQualifier(ExpressionFactory.matchExp((String)"eipTReport", (Object)reportId));
        return fquery.fetchList();
    }
}

