/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;

public class QueuedExecutor
extends ThreadFactoryUser
implements Executor {
    protected Thread thread_;
    protected static Runnable ENDTASK = new Runnable(){

        public void run() {
        }
    };
    protected volatile boolean shutdown_;
    protected final Channel queue_;
    protected final RunLoop runLoop_;

    public QueuedExecutor() {
        this(new BoundedLinkedQueue());
    }

    public QueuedExecutor(Channel queue) {
        this.queue_ = queue;
        this.runLoop_ = new RunLoop();
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public void execute(Runnable command) throws InterruptedException {
        this.restart();
        this.queue_.put(command);
    }

    public synchronized Thread getThread() {
        return this.thread_;
    }

    public synchronized void restart() {
        if (this.thread_ == null && !this.shutdown_) {
            this.thread_ = this.threadFactory_.newThread(this.runLoop_);
            this.thread_.start();
        }
    }

    public synchronized void shutdownAfterProcessingCurrentTask() {
        block3: {
            this.shutdown_ = true;
            if (this.thread_ == null) break block3;
            try {
                while (this.queue_.poll(0L) != null) {
                }
                this.queue_.put(ENDTASK);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks() {
        block2: {
            if (this.thread_ == null || this.shutdown_) break block2;
            try {
                this.queue_.put(ENDTASK);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void shutdownNow() {
        this.shutdown_ = true;
        if (this.thread_ != null) {
            this.thread_.interrupt();
            this.shutdownAfterProcessingCurrentTask();
        }
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        public void run() {
            try {
                try {
                    while (!QueuedExecutor.this.shutdown_) {
                        Runnable task = (Runnable)QueuedExecutor.this.queue_.take();
                        if (task == ENDTASK) {
                            QueuedExecutor.this.shutdown_ = true;
                        } else if (task != null) {
                            task.run();
                            task = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                Object var2_2 = null;
                QueuedExecutor.this.clearThread();
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                QueuedExecutor.this.clearThread();
                throw throwable;
            }
        }
    }
}

