/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions.timeline;

import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.services.timeline.ALTimelineFactoryService;
import com.aimluck.eip.services.timeline.ALTimelineHandler;
import com.aimluck.eip.timeline.TimelineFormData;
import com.aimluck.eip.timeline.TimelineSelectData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TimelineAction
extends ALBaseAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimelineAction.class.getName());

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        this.clearTimelineSession(rundata, context);
        TimelineSelectData listData = new TimelineSelectData();
        listData.initField();
        listData.setContentHeightMax(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1a-rows", "0")));
        this.prepareService(rundata, context);
        listData.setRowsNum(20);
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "timeline");
    }

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            this.doTimeline_list(rundata, context);
            this.prepareService(rundata, context);
        }
        catch (Exception ex) {
            logger.error((Object)"timeline", (Throwable)ex);
        }
    }

    public void doTimeline_list(RunData rundata, Context context) throws Exception {
        TimelineSelectData listData = new TimelineSelectData();
        listData.initField();
        listData.setContentHeightMax(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-rows", "0")));
        listData.setRowsNum(20);
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "timeline-list");
    }

    public void doTimeline_insert(RunData rundata, Context context) throws Exception {
        TimelineFormData formData = new TimelineFormData();
        formData.initField();
        if (formData.doInsert((ALAction)this, rundata, context)) {
            // empty if block
        }
        this.doTimeline_list(rundata, context);
    }

    public void clearTimelineSession(RunData rundata, Context context) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("entityid");
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, list);
    }

    public void prepareService(RunData rundata, Context context) {
        ALTimelineFactoryService tlservice = (ALTimelineFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALTimelineFactoryService");
        ALTimelineHandler timelinehandler = tlservice.getTimelineHandler();
        String token = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"timelineToken");
        if ((token == null || "".equals(token)) && (token = timelinehandler.getToken(rundata)) != null && !"".equals(token)) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"timelineToken", (String)token);
        }
        context.put("token", (Object)token);
        context.put("jsapiUrl", (Object)timelinehandler.getApiUrl());
        if (rundata.getUserAgent().trim().indexOf("Mac") != -1) {
            context.put("isMacOS", (Object)"true");
        }
    }
}

