/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timeline;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTTimeline;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineFile;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineUrl;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.services.timeline.ALTimelineFactoryService;
import com.aimluck.eip.services.timeline.ALTimelineHandler;
import com.aimluck.eip.timeline.util.TimelineUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.util.ALURLConnectionUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TimelineFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimelineFormData.class.getName());
    private ALStringField note;
    private int parentId;
    private int uid;
    private String orgId;
    private String aclPortletFeature = null;
    private boolean hasAclCategoryList;
    private boolean hasAclUpdateTopicOthers;
    private boolean hasAclDeleteTopicOthers;
    private boolean has_photo;
    private List<FileuploadLiteBean> fileuploadList;
    private String folderName = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.orgId = Database.getDomainName();
        this.has_photo = false;
        this.folderName = rundata.getParameters().getString("folderName");
    }

    public void initField() {
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"TIMELINE_SETFIELDNAME_CONTENT"));
        this.note.setTrim(false);
        this.fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    protected void setValidator() {
        this.note.setNotNull(true);
        this.note.limitMaxLength(10000);
    }

    protected boolean validate(List<String> msgList) {
        return this.note.validate(msgList) || this.fileuploadList != null;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int parentid = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
            EipTTimeline parent = (EipTTimeline)Database.get(EipTTimeline.class, (Object)parentid);
            if (parent != null) {
                return TimelineUtils.deleteTimelineFromParent(rundata, context, "Timeline", parent);
            }
            return true;
        }
        catch (ALFileNotRemovedException fe) {
            Database.rollback();
            logger.error((Object)"[TimelineSelectData]", (Throwable)fe);
            msgList.add(ALLocalizationUtils.getl10n((String)"ERROR_FILE_DETELE_FAILURE"));
            return false;
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[TimelineSelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            Calendar tCal = Calendar.getInstance();
            EipTTimeline topic = (EipTTimeline)Database.create(EipTTimeline.class);
            topic.setParentId(Integer.valueOf(this.parentId));
            topic.setOwnerId(Integer.valueOf(this.uid));
            topic.setNote(this.note.getValue());
            topic.setTimelineType("T");
            topic.setCreateDate(tCal.getTime());
            topic.setUpdateDate(tCal.getTime());
            if (Integer.valueOf(this.parentId) != 0) {
                EipTTimeline parent = (EipTTimeline)Database.get(EipTTimeline.class, (Object)this.parentId);
                if (parent == null || parent.getTimelineType() == null) return false;
                if ("T".equals(parent.getTimelineType())) {
                    parent.setUpdateDate(tCal.getTime());
                } else if ("A".equals(parent.getTimelineType())) {
                    parent.setUpdateDate(tCal.getTime());
                    if (parent.getParentId() != 0) {
                        EipTTimeline grandpa = (EipTTimeline)Database.get(EipTTimeline.class, (Object)parent.getParentId());
                        grandpa.setUpdateDate(tCal.getTime());
                    }
                }
            } else if (ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"tlClipUrl") != null && !ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"tlClipUrl").equals("")) {
                EipTTimelineUrl url = (EipTTimelineUrl)Database.create(EipTTimelineUrl.class);
                if (ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"tlClipImage") != null) {
                    try {
                        String str = ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"tlClipImage");
                        str = str.replaceAll("\\n", "");
                        URI uri = new URI(str).normalize();
                        String path = uri.getPath().replaceAll("\\.\\./", "").replaceAll("\\./", "");
                        URL u = new URL(String.format("%s://%s%s", uri.getScheme(), uri.getAuthority(), path));
                        HttpURLConnection uc = ALURLConnectionUtils.openUrlConnection((URL)u);
                        uc.setRequestProperty("Referer", str);
                        uc.addRequestProperty("User-Agent", "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0; Avant Browser)");
                        uc.addRequestProperty("Accept-Encoding", "identity");
                        InputStream is = uc.getInputStream();
                        url.setThumbnail(FileuploadUtils.getBytesShrink((InputStream)is, (int)86, (int)86, msgList));
                    }
                    catch (Exception e) {
                        logger.error((Object)"timeline", (Throwable)e);
                    }
                }
                if (ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"tlClipTitle") != null) {
                    String tlClipTitle = ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"tlClipTitle");
                    if (tlClipTitle.length() > 127) {
                        tlClipTitle = tlClipTitle.substring(0, 127);
                    }
                    url.setTitle(tlClipTitle);
                }
                url.setUrl(ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"tlClipUrl"));
                if (ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"tlClipBody") != null) {
                    url.setBody(ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"tlClipBody"));
                }
                url.setEipTTimeline(topic);
                this.clearTimelineSession(rundata, context);
            }
            this.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, topic, msgList);
            Database.commit();
            if (topic.getParentId() != 0) {
                EipTTimeline parententry = TimelineUtils.getEipTTimelineParentEntry(rundata, context);
                String loginName = ALEipUtils.getALEipUser((int)this.uid).getName().getValue();
                String targetLoginName = ALEipUtils.getALEipUser((int)parententry.getOwnerId()).getName().getValue();
                TimelineUtils.createNewCommentActivity(parententry, loginName, targetLoginName);
                List<Integer> otherlist = TimelineUtils.getTimelineOtherCommentUserList(this.parentId);
                for (Integer owner_id : otherlist) {
                    int parentOwnerId = parententry.getOwnerId();
                    String targetUserName = ALEipUtils.getALEipUser((int)parententry.getOwnerId()).getAliasName().toString();
                    if (owner_id == parentOwnerId) continue;
                    String otherLoginName = ALEipUtils.getALEipUser((int)owner_id).getName().getValue();
                    TimelineUtils.createNewOtherCommentActivity(parententry, loginName, otherLoginName, targetUserName);
                }
            }
            ALTimelineFactoryService tlservice = (ALTimelineFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALTimelineFactoryService");
            ALTimelineHandler timelinehandler = tlservice.getTimelineHandler();
            timelinehandler.pushToken(rundata, String.valueOf(this.uid));
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(topic.getTimelineId().intValue(), 330, TimelineUtils.compressString(this.note.getValue()));
            return true;
        }
        catch (RuntimeException ex) {
            Database.rollback();
            logger.error((Object)"timeline", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"timeline", (Throwable)ex);
            return false;
        }
    }

    private boolean insertAttachmentFiles(List<FileuploadLiteBean> fileuploadList, String folderName, int uid, EipTTimeline entry, List<String> msgList) {
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            return true;
        }
        try {
            int length = fileuploadList.size();
            ArrayList<FileuploadLiteBean> newfilebeans = new ArrayList<FileuploadLiteBean>();
            FileuploadLiteBean filebean = null;
            for (int i = 0; i < length; ++i) {
                filebean = fileuploadList.get(i);
                if (!filebean.isNewFile()) continue;
                newfilebeans.add(filebean);
            }
            int newfilebeansSize = newfilebeans.size();
            if (newfilebeansSize > 0) {
                FileuploadLiteBean newfilebean = null;
                for (int j = 0; j < length; ++j) {
                    newfilebean = (FileuploadLiteBean)newfilebeans.get(j);
                    String[] acceptExts = ImageIO.getWriterFormatNames();
                    FileuploadUtils.ShrinkImageSet shrinkImageSet = FileuploadUtils.getBytesShrinkFilebean((String)this.orgId, (String)folderName, (int)uid, (FileuploadLiteBean)newfilebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)true);
                    String filename = j + "_" + String.valueOf(System.nanoTime());
                    EipTTimelineFile file = (EipTTimelineFile)Database.create(EipTTimelineFile.class);
                    file.setOwnerId(Integer.valueOf(uid));
                    file.setFileName(newfilebean.getFileName());
                    file.setFilePath(TimelineUtils.getRelativePath(filename));
                    if (shrinkImageSet != null && shrinkImageSet.getShrinkImage() != null) {
                        file.setFileThumbnail(shrinkImageSet.getShrinkImage());
                    }
                    file.setEipTTimeline(entry);
                    file.setCreateDate(Calendar.getInstance().getTime());
                    file.setUpdateDate(Calendar.getInstance().getTime());
                    ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(newfilebean.getFileId()), (String)TimelineUtils.FOLDER_FILEDIR_TIMELIME, (String)(TimelineUtils.CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
                    if (shrinkImageSet != null && shrinkImageSet.getFixImage() != null) {
                        ALStorageService.createNewFile((InputStream)new ByteArrayInputStream(shrinkImageSet.getFixImage()), (String)(TimelineUtils.FOLDER_FILEDIR_TIMELIME + ALStorageService.separator() + Database.getDomainName() + ALStorageService.separator() + TimelineUtils.CATEGORY_KEY + ALStorageService.separator() + uid + ALStorageService.separator() + filename));
                        continue;
                    }
                    ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(newfilebean.getFileId()), (String)TimelineUtils.FOLDER_FILEDIR_TIMELIME, (String)(TimelineUtils.CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
                }
                ALStorageService.deleteTmpFolder((int)uid, (String)folderName);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                this.fileuploadList = TimelineUtils.getFileuploadList(rundata);
            }
            catch (Exception ex) {
                logger.error((Object)"timeline", (Throwable)ex);
            }
        }
        return res;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public void setAclPortletFeature(String aclPortletFeature) {
        this.aclPortletFeature = aclPortletFeature;
    }

    public boolean hasAclUpdateTopicOthers() {
        return this.hasAclUpdateTopicOthers;
    }

    public boolean hasAclDeleteTopicOthers() {
        return this.hasAclDeleteTopicOthers;
    }

    public void setHasPhoto(boolean bool) {
        this.has_photo = bool;
    }

    public boolean hasPhoto() {
        return this.has_photo;
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public void clearTimelineSession(RunData rundata, Context context) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("tlClipImage");
        list.add("tlClipTitle");
        list.add("tlClipUrl");
        list.add("tlClipBody");
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, list);
    }
}

