/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timeline;

import com.aimluck.eip.cayenne.om.portlet.EipTTimelineLike;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.timeline.TimelineLikeResultData;
import com.aimluck.eip.timeline.TimelineSelectData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TimelineLikeSelectData
extends ALAbstractSelectData<EipTTimelineLike, EipTTimelineLike>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimelineSelectData.class.getName());
    private final List<Integer> users = new ArrayList<Integer>();

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"update_date");
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
    }

    public ResultList<EipTTimelineLike> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipTTimelineLike> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"timeline", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTTimelineLike> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTTimelineLike.class);
        String timelineId = rundata.getParameters().getString("timelineId");
        Expression exp1 = ExpressionFactory.matchExp((String)"timelineId", (Object)Integer.valueOf(timelineId));
        query.setQualifier(exp1);
        query.distinct(true);
        return query;
    }

    protected Object getResultData(EipTTimelineLike record) {
        try {
            TimelineLikeResultData rd = new TimelineLikeResultData();
            rd.initField();
            rd.setTimelineLikeId(record.getTimelineLikeId().longValue());
            rd.setTimelineId(record.getTimelineId().longValue());
            rd.setUserId(record.getOwnerId().longValue());
            rd.setCreateDate(record.getCreateDate());
            if (!this.users.contains(record.getOwnerId())) {
                this.users.add(record.getOwnerId());
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"timeline", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipTTimelineLike record) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    public EipTTimelineLike selectDetail(RunData rundata, Context context) {
        ALEipUtils.redirectPageNotFound((RunData)rundata);
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("create_date", "createDate");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public List<TimelineLikeResultData> getLikeList(Integer timelineId) {
        ArrayList<TimelineLikeResultData> likeList = new ArrayList<TimelineLikeResultData>();
        SelectQuery<EipTTimelineLike> query = TimelineLikeSelectData.getSelectQueryForLike(timelineId.toString());
        List aList = query.fetchList();
        if (aList != null) {
            for (EipTTimelineLike like : aList) {
                likeList.add((TimelineLikeResultData)this.getResultData(like));
            }
        }
        this.loadAggregateUsers();
        return likeList;
    }

    private static SelectQuery<EipTTimelineLike> getSelectQueryForLike(String topicid) {
        SelectQuery query = Database.query(EipTTimelineLike.class);
        Expression exp = ExpressionFactory.matchExp((String)"timelineId", (Object)Integer.valueOf(topicid));
        query.setQualifier(exp);
        query.orderDesending("createDate");
        return query;
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        boolean result = super.doViewList(action, rundata, context);
        this.loadAggregateUsers();
        return result;
    }

    protected void loadAggregateUsers() {
        ALEipManager.getInstance().getUsers(this.users);
    }
}

