/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class FloatValidator
extends PatternValidator
implements TypeValidator {
    private boolean _isFixed = false;
    private float _fixed = 0.0f;
    private boolean _isThereMinInclusive = false;
    private float _minInclusive = 0.0f;
    private boolean _isThereMaxInclusive = false;
    private float _maxInclusive = 0.0f;
    private boolean _isThereMinExclusive = false;
    private float _minExclusive = 0.0f;
    private boolean _isThereMaxExclusive = false;
    private float _maxExclusive = 0.0f;

    public void setFixed(float f) {
        this._fixed = f;
        this._isFixed = true;
    }

    public void setFixed(Float f) {
        this.setFixed(f.floatValue());
    }

    public void setMaxExclusive(float f) {
        this._maxExclusive = f;
        this._isThereMaxExclusive = true;
    }

    public void setMaxExclusive(Float f) {
        this.setMaxExclusive(f.floatValue());
    }

    public void setMaxInclusive(float f) {
        this._maxInclusive = f;
        this._isThereMaxInclusive = true;
    }

    public void setMaxInclusive(Float f) {
        this.setMaxInclusive(f.floatValue());
    }

    public void setMinExclusive(float f) {
        this._minExclusive = f;
        this._isThereMinExclusive = true;
    }

    public void setMinExclusive(Float f) {
        this.setMinExclusive(f.floatValue());
    }

    public void setMinInclusive(float f) {
        this._minInclusive = f;
        this._isThereMinInclusive = true;
    }

    public void setMinInclusive(Float f) {
        this.setMinInclusive(f.floatValue());
    }

    public void validate(float f) throws ValidationException {
        if (this._isFixed && f != this._fixed) {
            String string = String.valueOf(f) + " is not equal to the fixed value of ";
            string = String.valueOf(string) + this._fixed;
            throw new ValidationException(string);
        }
        if (this._isThereMinInclusive && f < this._minInclusive) {
            String string = String.valueOf(f) + " is less than the minimum allowable ";
            string = String.valueOf(string) + "value of " + this._minInclusive;
            throw new ValidationException(string);
        }
        if (this._isThereMinExclusive && f <= this._minExclusive) {
            String string = String.valueOf(f) + " is less than the minimum allowable ";
            string = String.valueOf(string) + "value of " + this._minExclusive;
            throw new ValidationException(string);
        }
        if (this._isThereMaxInclusive && f > this._maxInclusive) {
            String string = String.valueOf(f) + " is greater than the maximum allowable ";
            string = String.valueOf(string) + "value of " + this._maxInclusive;
            throw new ValidationException(string);
        }
        if (this._isThereMaxExclusive && f >= this._maxExclusive) {
            String string = String.valueOf(f) + " is greater than the maximum allowable ";
            string = String.valueOf(string) + "value of " + this._maxExclusive;
            throw new ValidationException(string);
        }
        if (this.hasPattern()) {
            super.validate(Float.toString(f));
        }
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "FloatValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        float f = 0.0f;
        try {
            f = new Float(object.toString()).floatValue();
        }
        catch (Exception exception) {
            String string = "Expecting a float, received instead: ";
            string = String.valueOf(string) + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(f);
    }
}

