/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gadgets;

import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALApplication;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.services.social.ALApplicationService;
import com.aimluck.eip.services.social.model.ALApplicationGetRequest;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.CustomizeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GadgetsAdminSelectData
extends ALAbstractSelectData<ALApplication, ALApplication> {
    private List<Object> list;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 1);
            action.setMode("list");
            ResultList<PortletEntry> resultList = this.selectListPortletEntry(rundata, context);
            if (resultList != null) {
                this.list = new ArrayList<Object>();
                for (PortletEntry model : resultList) {
                    PortletEntry object = model;
                    if (object == null) continue;
                    this.list.add(object);
                }
            }
            action.setResultData((Object)this);
            action.putData(rundata, context);
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"entityid");
            return this.list != null;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected List<PortletEntry> buildPaginatedListPortletEntry(List<PortletEntry> records) {
        ArrayList<PortletEntry> aList = new ArrayList<PortletEntry>();
        this.setPageParam(records.size());
        int size = records.size();
        int end = this.getStart() + this.getRowsNum() <= size ? this.getStart() + this.getRowsNum() : size;
        for (int i = this.getStart(); i < end; ++i) {
            aList.add(records.get(i));
        }
        return aList;
    }

    protected ResultList<ALApplication> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return new ResultList();
    }

    protected ResultList<PortletEntry> selectListPortletEntry(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        ALApplicationGetRequest.Status status = ALApplicationGetRequest.Status.ALL;
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        Profile profile = jdata.getProfile();
        String mediaType = profile.getMediaType();
        if ("1".equals(filter)) {
            status = ALApplicationGetRequest.Status.ACTIVE;
            this.current_filter = filter;
        } else if ("0".equals(filter)) {
            status = ALApplicationGetRequest.Status.INACTIVE;
            this.current_filter = filter;
        } else if ("all".equals(filter)) {
            status = ALApplicationGetRequest.Status.ALL;
            this.current_filter = filter;
        }
        ArrayList allPortlets = new ArrayList();
        List portlets = CustomizeUtils.buildPortletListWithStatus((RunData)rundata, (String)mediaType, allPortlets, (ALApplicationGetRequest.Status)status);
        return new ResultList(this.buildPaginatedListPortletEntry(portlets), this.current_page, this.getRowsNum(), portlets.size());
    }

    protected ALApplication selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String appId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        return ALApplicationService.get((ALApplicationGetRequest)new ALApplicationGetRequest().withAppId(appId).withStatus(ALApplicationGetRequest.Status.ALL).withIsDetail(true).withIsFetchXml(true));
    }

    protected Object getResultData(ALApplication model) throws ALPageNotFoundException, ALDBErrorException {
        return model;
    }

    protected Object getResultDataDetail(ALApplication model) throws ALPageNotFoundException, ALDBErrorException {
        return model;
    }

    public String getStringNumber(String str) {
        return str.replace("GadgetsTemplate::", "");
    }

    public List<Object> getList() {
        return this.list;
    }

    protected Attributes getColumnMap() {
        return null;
    }
}

