/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountPostMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountPostMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            List<EipMPost> list = this.getEipMPosts(rundata, context, values);
            if (list == null || list.size() == 0) {
                return false;
            }
            int listsize = list.size();
            for (int i = 0; i < listsize; ++i) {
                EipMPost record = list.get(i);
                List users = ALEipUtils.getUsersIncludingN((String)record.getGroupName());
                int size = users.size();
                for (int j = 0; j < size; ++j) {
                    JetspeedSecurity.unjoinGroup((String)((ALEipUser)users.get(j)).getName().getValue(), (String)record.getGroupName());
                }
                JetspeedSecurity.removeGroup((String)record.getGroupName());
                Database.deleteAll((DataObject[])new DataObject[]{record});
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getPostId().intValue(), 3, "\u90e8\u7f72\u300c" + record.getPostName() + "\u300d\u3092\u524a\u9664");
            }
            Database.commit();
            ALEipManager.getInstance().reloadPost();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccountPostMultiDelete.action", (Throwable)ex);
            return false;
        }
        return true;
    }

    private List<EipMPost> getEipMPosts(RunData rundata, Context context, List<String> values) {
        List list = null;
        try {
            if (values == null || values.size() == 0) {
                logger.debug((Object)"values are empty...");
                return null;
            }
            Expression exp = ExpressionFactory.inDbExp((String)"POST_ID", values);
            SelectQuery query = Database.query(EipMPost.class, (Expression)exp);
            list = query.fetchList();
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AccountPostMultiDelete.getEipMPosts", (Throwable)ex);
            list = null;
        }
        return list;
    }
}

