/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account.util;

import com.aimluck.commons.utils.ALDeleteFileUtil;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.account.EipMUserPosition;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTBlog;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFile;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFootmarkMap;
import com.aimluck.eip.cayenne.om.portlet.EipTMessage;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoomMember;
import com.aimluck.eip.cayenne.om.portlet.EipTTimeline;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineFile;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.orm.query.Where;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import com.aimluck.eip.services.datasync.ALDataSyncFactoryService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.social.ALApplicationService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.user.beans.UserGroupLiteBean;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.math.BigDecimal;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountUtils.class.getName());
    public static final String FOLDER_TMP_FOR_USERINFO_CSV_FILENAME = "user_info.csv";
    public static final int CSV_FILE_COL_COUNT = 11;
    public static final String[] USER_NAME_SYMBOLS = new String[]{".", "-", "_"};
    public static final String ACCOUNT_PORTLET_NAME = "Account";
    public static final String COMPANY_PORTLET_NAME = "Company";
    public static final String ACCOUNT_PERSON_PORTLET_NAME = "AccountPerson";
    public static final String ACCOUNT_LOGIN_PORTLET_NAME = "AccountLogin";
    private static final Map<Integer, FilterRole> roleMap = new HashMap<Integer, FilterRole>();
    public static final Integer ROLE_ADMIN = 1;
    public static final Integer ROLE_ACTIVE = 2;
    public static final Integer ROLE_IN_ACTIVE = 3;
    public static final Integer ROLE_INVITE = 4;
    public static final String TARGET_KEYWORD = "keyword";
    public static final String FOLDER_FILEDIR_ACCOUNT = JetspeedResources.getString((String)"aipo.filedir", (String)"");

    public static ALBaseUser getBaseUser(RunData rundata, Context context) {
        String userid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (userid == null) {
                userid = rundata.getUser().getUserName();
            }
            if (userid == null) {
                logger.debug((Object)"Empty ID...");
                return null;
            }
            ALBaseUser user = (ALBaseUser)JetspeedSecurity.getUser((String)userid);
            if ("T".equals(user.getDisabled())) {
                return null;
            }
            return (ALBaseUser)JetspeedSecurity.getUser((String)userid);
        }
        catch (UnknownUserException uex) {
            logger.error((Object)("UnknownUserException : UserID = " + userid));
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"AccountUtils.getBaseUser", (Throwable)ex);
            return null;
        }
    }

    public static EipMCompany getEipMCompany(RunData rundata, Context context) {
        return AccountUtils.getEipMCompany(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
    }

    public static EipMCompany getEipMCompany(String id) {
        EipMCompany result = null;
        try {
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)Integer.valueOf(id));
            List list = Database.query(EipMCompany.class, (Expression)exp).fetchList();
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMCompany)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"AccountUtils.getEipMCompany", (Throwable)ex);
        }
        return result;
    }

    public static EipMPost getEipMPost(RunData rundata, Context context) {
        return AccountUtils.getEipMPost(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
    }

    public static EipMPost getEipMPost(String id) {
        EipMPost result = null;
        try {
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"POST_ID", (Object)Integer.valueOf(id));
            List list = Database.query(EipMPost.class, (Expression)exp).fetchList();
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMPost)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"AccountUtils.getEipMPost", (Throwable)ex);
        }
        return result;
    }

    public static EipMPosition getEipMPosition(RunData rundata, Context context) {
        EipMPosition result = null;
        String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"POSITION_ID", (Object)Integer.valueOf(id));
            List list = Database.query(EipMPosition.class, (Expression)exp).fetchList();
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMPosition)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"AccountUtils.getEipMPosition", (Throwable)ex);
        }
        return result;
    }

    public static String[] getCsvSplitStrings(String line) {
        if (line == null || line.equals("")) {
            return null;
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            int count_comma = 0;
            StringBuffer token = new StringBuffer("");
            int len = line.length();
            for (int i = 0; i < len; ++i) {
                char c = line.charAt(i);
                if (c != ',' && i == len - 1) {
                    token.append(c);
                    list.add(token.toString());
                } else {
                    if (c == ',') {
                        list.add(token.toString());
                        token = new StringBuffer("");
                        ++count_comma;
                        continue;
                    }
                    token.append(c);
                }
                if (count_comma > 11) break;
            }
            if (line.endsWith(",")) {
                list.add("");
            }
            String[] strings = new String[list.size()];
            strings = list.toArray(strings);
            return strings;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<UserGroupLiteBean> getPostBeanList(int uid) {
        SelectQuery query = Database.query(TurbineUserGroupRole.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"turbineUser", (Object)uid);
        Expression exp2 = ExpressionFactory.greaterExp((String)"turbineGroup", (Object)3);
        Expression exp3 = ExpressionFactory.matchExp((String)"turbineGroup.ownerId", (Object)1);
        query.setQualifier(exp1);
        query.andQualifier(exp2);
        query.andQualifier(exp3);
        List list = query.fetchList();
        if (list == null || list.size() < 0) {
            return null;
        }
        ArrayList<UserGroupLiteBean> resultList = new ArrayList<UserGroupLiteBean>();
        TurbineGroup group = null;
        UserGroupLiteBean bean = null;
        for (TurbineUserGroupRole ugr : list) {
            group = ugr.getTurbineGroup();
            bean = new UserGroupLiteBean();
            bean.initField();
            bean.setGroupId(group.getName());
            bean.setName(group.getGroupAliasName());
            resultList.add(bean);
        }
        return resultList;
    }

    public static boolean getUserIsDisabledOrDeleted(String userId) {
        if (userId == null || userId.equals("")) {
            return true;
        }
        try {
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(userId));
            query.setQualifier(exp);
            List destUserList = query.fetchList();
            if (destUserList == null || destUserList.size() <= 0) {
                return true;
            }
            String disabled = ((TurbineUser)destUserList.get(0)).getDisabled();
            return "T".equals(disabled) || "N".equals(disabled);
        }
        catch (Exception ex) {
            logger.error((Object)"AccountUtils.getUserIsDisabledOrDeleted", (Throwable)ex);
            return true;
        }
    }

    public static boolean acceptWorkflow(int uid) {
        try {
            String userId = Integer.toString(uid);
            SelectQuery workflow_request_map_query = Database.query(EipTWorkflowRequestMap.class);
            Expression workflow_exp = ExpressionFactory.matchExp((String)"userId", (Object)userId);
            Expression workflow_exp2 = ExpressionFactory.matchExp((String)"status", (Object)"C");
            workflow_request_map_query.setQualifier(workflow_exp.andExp(workflow_exp2));
            List workflow_request_map_list = workflow_request_map_query.fetchList();
            EipTWorkflowRequestMap workflow_request_map = null;
            int list_size = workflow_request_map_list.size();
            for (int j = 0; j < list_size; ++j) {
                block4: {
                    EipTWorkflowRequestMap workflow_request_map2;
                    workflow_request_map = (EipTWorkflowRequestMap)workflow_request_map_list.get(j);
                    int request_number = workflow_request_map.getOrderIndex();
                    while (true) {
                        SelectQuery workflow_request_map_query2 = Database.query(EipTWorkflowRequestMap.class);
                        Expression workflow_exp3 = ExpressionFactory.matchExp((String)"eipTWorkflowRequest", (Object)workflow_request_map.getEipTWorkflowRequest());
                        Expression workflow_exp4 = ExpressionFactory.matchExp((String)"orderIndex", (Object)(request_number + 1));
                        workflow_request_map_query2.setQualifier(workflow_exp3.andExp(workflow_exp4));
                        List workflow_request_map_list2 = workflow_request_map_query2.fetchList();
                        workflow_request_map.setStatus("T");
                        if (workflow_request_map_list2.size() != 1) break block4;
                        workflow_request_map2 = (EipTWorkflowRequestMap)workflow_request_map_list2.get(0);
                        if (!AccountUtils.getUserIsDisabledOrDeleted(workflow_request_map2.getUserId().toString())) break;
                        workflow_request_map2.setStatus("T");
                        ++request_number;
                    }
                    workflow_request_map2.setStatus("C");
                    continue;
                }
                if (workflow_request_map.getEipTWorkflowRequest() == null) continue;
                workflow_request_map.getEipTWorkflowRequest().setProgress("A");
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"AccountUtils.acceptWorkflow", (Throwable)e);
            return false;
        }
    }

    public static boolean deleteUserList(RunData rundata, List<TurbineUser> userlist, List<String> msgList) throws ALDBErrorException, ALFileNotRemovedException, JetspeedSecurityException {
        if (!ALDataSyncFactoryService.getInstance().getDataSyncHandler().checkConnect()) {
            msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_CONNECT_DB_FAILED", (Object[])new Object[0]));
            return false;
        }
        int size = userlist.size();
        String[] user_name_list = new String[size];
        int admin_count = 0;
        for (TurbineUser user : userlist) {
            if (user.getLoginName().equals(rundata.getUser().getUserName())) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_DELETE_LOGINUSER", (Object[])new Object[0]));
                return false;
            }
            if (!ALEipUtils.isAdmin((int)user.getUserId()) || !ALEipUtils.isEnabledUser((int)user.getUserId())) continue;
            ++admin_count;
        }
        if (!AccountUtils.isAdminDeletable(admin_count)) {
            msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_NUMOFADMINS_LIMIT", (Object[])new Object[]{Integer.valueOf(ALConfigService.get((ALConfigHandler.Property)ALConfigHandler.Property.MINIMUM_ADMINISTRATOR_USER_COUNT))}));
            return false;
        }
        for (int i = 0; i < size; ++i) {
            String user_name;
            TurbineUser record = userlist.get(i);
            user_name_list[i] = user_name = record.getLoginName();
            if (user_name == null) {
                return false;
            }
            TurbineUser user = (TurbineUser)Database.get(TurbineUser.class, (String)"LOGIN_NAME", (Object)user_name);
            user.setPositionId(Integer.valueOf(0));
            user.setDisabled("T");
            String userId = user.getUserId().toString();
            SelectQuery ugr_query = Database.query(TurbineUserGroupRole.class);
            Expression exp2 = ExpressionFactory.matchExp((String)"turbineUser", (Object)userId);
            ugr_query.setQualifier(exp2);
            List list4 = ugr_query.fetchList();
            TurbineUserGroupRole ugr = null;
            for (int j = 0; j < list4.size(); ++j) {
                ugr = (TurbineUserGroupRole)list4.get(j);
                Database.delete((Persistent)ugr);
            }
            Database.query(EipTTodo.class).where(Operations.in((String)"userId", (Object[])new Object[]{userId})).deleteAll();
            Database.query(EipTTodoCategory.class).where(Operations.in((String)"userId", (Object[])new Object[]{userId})).deleteAll();
            String orgId = Database.getDomainName();
            SelectQuery EipBlogSQL = Database.query(EipTBlog.class).where(Operations.in((String)"ownerId", (Object[])new Object[]{userId}));
            List EipBlogList = EipBlogSQL.fetchList();
            if (EipBlogList != null && EipBlogList.size() > 0) {
                List EipTBlogEntryList = Database.query(EipTBlogEntry.class).where(Operations.in((String)"eipTBlog", (List)EipBlogList)).fetchList();
                for (EipTBlogEntry entry : EipTBlogEntryList) {
                    ArrayList<String> fpaths = new ArrayList<String>();
                    List files = entry.getEipTBlogFiles();
                    if (files == null || files.size() <= 0) continue;
                    int fileSize = files.size();
                    for (int j = 0; j < fileSize; ++j) {
                        fpaths.add(((EipTBlogFile)files.get(j)).getFilePath());
                    }
                    ALDeleteFileUtil.deleteFiles((int)entry.getEntryId(), (String)"eipTBlogEntry", (String)AccountUtils.getSaveDirPath(orgId, entry.getOwnerId(), "blog"), fpaths, EipTBlogFile.class);
                }
                Database.query(EipTBlogEntry.class).where(Operations.in((String)"eipTBlog", (List)EipBlogList)).deleteAll();
                EipBlogSQL.deleteAll();
            }
            Database.query(EipTBlogFootmarkMap.class).where(Operations.in((String)"userId", (Object[])new Object[]{userId})).deleteAll();
            ALApplicationService.deleteUserData((String[])new String[]{user_name});
            AccountUtils.acceptWorkflow(user.getUserId());
            Expression exp01 = ExpressionFactory.matchDbExp((String)"OWNER_ID", (Object)user.getUserId());
            Expression exp02 = ExpressionFactory.matchDbExp((String)"PARENT_ID", (Object)0);
            Expression exp03 = ExpressionFactory.matchDbExp((String)"TIMELINE_TYPE", (Object)"T");
            SelectQuery EipTTimelineSQL = Database.query(EipTTimeline.class).andQualifier(exp01.andExp(exp02.andExp(exp03)));
            List timelineList = EipTTimelineSQL.fetchList();
            if (!timelineList.isEmpty()) {
                ArrayList<Integer> timelineIdList = new ArrayList<Integer>();
                for (EipTTimeline timeline : timelineList) {
                    timelineIdList.add(timeline.getTimelineId());
                }
                if (!timelineIdList.isEmpty()) {
                    SelectQuery EipTTimelineSQL2 = Database.query(EipTTimeline.class).andQualifier(ExpressionFactory.inDbExp((String)"PARENT_ID", timelineIdList));
                    List timelineCommentList = EipTTimelineSQL2.fetchList();
                    if (timelineCommentList != null && !timelineCommentList.isEmpty()) {
                        timelineList.addAll(timelineCommentList);
                    }
                    for (EipTTimeline entry : timelineList) {
                        ArrayList<String> fpaths = new ArrayList<String>();
                        List files = entry.getEipTTimelineFile();
                        if (files == null || files.size() <= 0) continue;
                        int fileSize = files.size();
                        for (int j = 0; j < fileSize; ++j) {
                            fpaths.add(((EipTTimelineFile)files.get(j)).getFilePath());
                        }
                        ALDeleteFileUtil.deleteFiles((int)entry.getTimelineId(), (String)"eipTTimeline", (String)AccountUtils.getSaveDirPath(orgId, entry.getOwnerId(), "timeline"), fpaths, EipTTimelineFile.class);
                    }
                    EipTTimelineSQL2.deleteAll();
                    EipTTimelineSQL.deleteAll();
                }
            }
            List messageFileList = Database.query(EipTMessageFile.class).where(Operations.eq((String)"ownerId", (Object)user.getUserId())).fetchList();
            ALDeleteFileUtil.deleteFiles((String)AccountUtils.getSaveDirPath(orgId, user.getUserId(), "message"), (List)messageFileList);
            Database.query(EipTMessage.class).where(Operations.in((String)"userId", (Object[])new Object[]{userId})).deleteAll();
            Database.query(EipTMessageRoomMember.class).where(Operations.in((String)"userId", (Object[])new Object[]{userId})).deleteAll();
            Database.commit();
            String name = "";
            name = user.getLastName() != null && !" ".equals(user.getLastName()) && user.getFirstName() != null && !" ".equals(user.getFirstName()) ? new StringBuffer().append(user.getLastName()).append(" ").append(user.getFirstName()).toString() : user.getEmail();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(user.getUserId().intValue(), 3, "\u30e6\u30fc\u30b6\u30fc\u300c" + name + "\u300d\u3092\u524a\u9664");
            JetspeedUser juser = JetspeedSecurity.getUser((Principal)new UserNamePrincipal(user_name));
            PsmlManager.removeUserDocuments((JetspeedUser)juser);
            String dummy_user_name = "dummy_" + userId + "_" + user_name;
            user.setLoginName(dummy_user_name);
        }
        SelectQuery p_query = Database.query(EipMUserPosition.class);
        p_query.orderAscending("position");
        List userPositions = p_query.fetchList();
        if (userPositions != null && userPositions.size() > 0) {
            EipMUserPosition userPosition = null;
            int possize = userPositions.size();
            for (int i = 0; i < possize; ++i) {
                userPosition = (EipMUserPosition)userPositions.get(i);
                if (userPosition.getPosition() == i + 1) continue;
                userPosition.setPosition(Integer.valueOf(i + 1));
            }
        }
        Database.commit();
        if (!ALDataSyncFactoryService.getInstance().getDataSyncHandler().multiDeleteUser(user_name_list, size)) {
            return false;
        }
        return msgList.size() == 0;
    }

    public static boolean isAdminDeletable() {
        return AccountUtils.isAdminDeletable(1);
    }

    public static boolean isAdminDeletable(int admin_count) {
        try {
            int minimum_admin = Integer.valueOf(ALConfigService.get((ALConfigHandler.Property)ALConfigHandler.Property.MINIMUM_ADMINISTRATOR_USER_COUNT));
            Group group = JetspeedSecurity.getGroup((String)"LoginUser");
            Role adminrole = JetspeedSecurity.getRole((String)"admin");
            int current_admin_count = Database.query(TurbineUserGroupRole.class).where(new Where[]{Operations.eq((String)"turbineRole", (Object)adminrole.getId()), Operations.eq((String)"turbineGroup", (Object)group.getId()), Operations.ne((String)"turbineUser", (Object)1), Operations.eq((String)"turbineUser.disabled", (Object)"F")}).distinct(true).getCount();
            int admin_count_will = current_admin_count - admin_count;
            if (admin_count_will < 0) {
                admin_count_will = 0;
            }
            return minimum_admin <= admin_count_will;
        }
        catch (JetspeedSecurityException e) {
            logger.error((Object)"AccountUtils.isAdminDeletable", (Throwable)e);
            return false;
        }
    }

    public static boolean isValidSymbolUserName(String name) {
        List<String> symbols = Arrays.asList(USER_NAME_SYMBOLS);
        for (char c : name.toCharArray()) {
            if (!ALStringUtil.isSymbol((char)c) || symbols.contains(String.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static long getStorageSizeOfUserMail(Integer userId) {
        long totalSize = 0L;
        try {
            List accounts = ALMailUtils.getMailAccountList((int)userId);
            String orgId = Database.getDomainName();
            if (accounts != null) {
                for (EipMMailAccount account : accounts) {
                    Integer accountId = account.getAccountId();
                    ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
                    totalSize += handler.getFolderSize(orgId, userId.intValue(), accountId.intValue());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return totalSize;
    }

    public static String getSizeStr(long size) {
        if (1024L > size) {
            return size + " Byte";
        }
        if (0x100000L > size) {
            double dsize = size;
            BigDecimal bi = new BigDecimal(String.valueOf(dsize /= 1024.0));
            double value = bi.setScale(1, 4).doubleValue();
            return value + " KByte";
        }
        double dsize = size;
        dsize = dsize / 1024.0 / 1024.0;
        BigDecimal bi = new BigDecimal(String.valueOf(dsize));
        double value = bi.setScale(1, 4).doubleValue();
        return value + " MB";
    }

    public static Map<Integer, FilterRole> getRoleMap() {
        if (roleMap.size() == 0) {
            roleMap.put(ROLE_ADMIN, new FilterRole(ROLE_ADMIN, ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ROLE_ADMIN", (Object[])new Object[0])));
            roleMap.put(ROLE_ACTIVE, new FilterRole(ROLE_ACTIVE, ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ROLE_ACTIVE", (Object[])new Object[0])));
            roleMap.put(ROLE_IN_ACTIVE, new FilterRole(ROLE_IN_ACTIVE, ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ROLE_IN_ACTIVE", (Object[])new Object[0])));
        }
        return roleMap;
    }

    public static String getTargetKeyword(RunData rundata, Context context) {
        String target_keyword = null;
        String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
        target_keyword = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD);
        if (keywordParam == null && target_keyword == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
            target_keyword = "";
        } else if (keywordParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)keywordParam.trim());
            target_keyword = keywordParam;
        }
        return target_keyword;
    }

    public static String getSaveDirPath(String orgId, int uid, String portletName) {
        return ALStorageService.getDocumentPath((String)FOLDER_FILEDIR_ACCOUNT, (String)(AccountUtils.getCategoryKey(portletName) + ALStorageService.separator() + uid));
    }

    public static String getCategoryKey(String portletName) {
        return JetspeedResources.getString((String)("aipo." + portletName + ".categorykey"), (String)"");
    }

    public static String getPortletId(RunData rundata) {
        HashMap map = ALEipUtils.getPortletFromAppIdMap((RunData)rundata);
        for (Map.Entry next : map.entrySet()) {
            if (!((String)next.getKey()).endsWith(ACCOUNT_PERSON_PORTLET_NAME)) continue;
            return (String)next.getValue();
        }
        return null;
    }

    public static class FilterRole {
        private Integer roleId;
        private String roleName;

        public FilterRole(Integer id, String name) {
            this.setRoleId(id);
            this.setRoleName(name);
        }

        public Integer getRoleId() {
            return this.roleId;
        }

        public void setRoleId(Integer roleId) {
            this.roleId = roleId;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public void setRoleName(String roleName) {
            this.roleName = roleName;
        }
    }
}

