/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.blog.BlogEntryResultData;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogWordSelectData
extends ALAbstractSelectData<DataRow, DataRow> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogWordSelectData.class.getName());
    private ALStringField searchWord;
    private final List<Integer> users = new ArrayList<Integer>();

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"name_kana");
        }
        super.init(action, rundata, context);
    }

    protected ResultList<DataRow> selectList(RunData rundata, Context context) {
        List list;
        if (!rundata.getParameters().containsKey((Object)"start") && !rundata.getParameters().containsKey((Object)"sort")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"Blogsword", (String)rundata.getParameters().getString("sword"));
        }
        this.searchWord = new ALStringField();
        this.searchWord.setTrim(true);
        this.searchWord.setValue(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"Blogsword"));
        try {
            list = this.searchList(rundata, context);
            if (list == null) {
                list = new ArrayList<DataRow>();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"blog", (Throwable)ex);
            return null;
        }
        int totalSize = list.size();
        list = this.buildPaginatedList(list);
        return new ResultList(list, this.current_page, this.getRowsNum(), totalSize);
    }

    protected DataRow selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultData(DataRow obj) {
        try {
            DataRow dataRow = obj;
            Integer entry_id = (Integer)Database.getFromDataRow((DataRow)dataRow, (Object)"ENTRY_ID");
            Integer ower_id = (Integer)Database.getFromDataRow((DataRow)dataRow, (Object)"OWNER_ID");
            BlogEntryResultData rd = new BlogEntryResultData();
            rd.initField();
            rd.setEntryId(entry_id.longValue());
            rd.setOwnerId(ower_id.intValue());
            rd.setTitle(ALCommonUtils.compressString((String)((String)Database.getFromDataRow((DataRow)dataRow, (Object)"TITLE")), (int)this.getStrLength()));
            rd.setNote(((String)Database.getFromDataRow((DataRow)dataRow, (Object)"NOTE")).replaceAll("\\r\\n", " ").replaceAll("\\n", " ").replaceAll("\\r", " "));
            rd.setTitleDate((Date)Database.getFromDataRow((DataRow)dataRow, (Object)"CREATE_DATE"));
            SelectQuery query = Database.query(EipTBlogComment.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)entry_id);
            query.setQualifier(exp);
            List list = query.fetchList();
            if (list != null && list.size() > 0) {
                rd.setCommentsNum(list.size());
            }
            if (!this.users.contains(ower_id)) {
                this.users.add(ower_id);
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"blog", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(DataRow obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    private List<DataRow> searchList(RunData rundata, Context context) {
        List list = null;
        try {
            int uid = ALEipUtils.getUserId((RunData)rundata);
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            boolean hasAuthority = aclhandler.hasAuthority(uid, "blog_entry_other", 1);
            String word = this.searchWord.getValue();
            if (word == null || word.length() == 0) {
                return new ArrayList<DataRow>();
            }
            word = '%' + word + '%';
            StringBuffer statement = new StringBuffer();
            statement.append("SELECT DISTINCT t0.entry_id, t0.owner_id, t0.title, t0.note, ");
            statement.append("t0.thema_id, t0.update_date, t0.create_date ");
            statement.append("FROM eip_t_blog_entry as t0 left join eip_t_blog_comment as t1 on t1.entry_id = t0.entry_id ");
            statement.append("WHERE ((t0.title LIKE #bind($word))");
            statement.append(" OR (t0.note LIKE #bind($word))");
            statement.append(" OR (t0.entry_id = t1.entry_id AND (t1.comment LIKE #bind($word)))) ");
            if (!hasAuthority) {
                statement.append(" AND (t0.owner_id = " + uid + ") ");
            }
            statement.append("ORDER BY t0.create_date DESC");
            String query = statement.toString();
            list = Database.sql(EipTBlogEntry.class, (String)query).param("word", (Object)word).fetchListAsDataRow();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new ArrayList<DataRow>();
        }
        return list;
    }

    public ALStringField getSearchWord() {
        return this.searchWord;
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        boolean result = super.doViewList(action, rundata, context);
        this.loadAggregateUsers();
        return result;
    }

    protected void loadAggregateUsers() {
        ALEipManager.getInstance().getUsers(this.users);
    }
}

