/*
 * Decompiled with CFR 0.152.
 */
package com.develop.util;

public class HexFormatter {
    public static final char[] hexchars = new char[16];
    public static final char[] printChars = new char[256];

    public static String convertBytesToString(byte[] bytes) {
        return HexFormatter.convertBytesToString(bytes, 16, true);
    }

    public static String convertBytesToString(byte[] bytes, int lineLength, boolean showChars) {
        if (bytes == null) {
            return "(null array)";
        }
        return HexFormatter.convertBytesToString(bytes, 0, bytes.length, lineLength, showChars);
    }

    public static String convertBytesToString(byte[] bytes, int startOffset, int endOffset, int lineLength, boolean showChars) {
        if (bytes == null) {
            return "(null array)";
        }
        int loop = 0;
        StringBuffer strb = new StringBuffer(bytes.length * 5);
        int boundary = (startOffset + lineLength - 1) % lineLength;
        int charLoop = 0;
        charLoop = loop = startOffset;
        while (loop < endOffset) {
            strb.append(HexFormatter.getHexString(bytes[loop]));
            if (loop % lineLength == boundary) {
                if (showChars) {
                    strb.append(' ');
                    while (charLoop <= loop) {
                        strb.append(printChars[bytes[charLoop] & 0xFF]);
                        ++charLoop;
                    }
                }
                strb.append("\r\n");
            }
            ++loop;
        }
        if (showChars && charLoop < loop) {
            int gap = loop % lineLength;
            while (gap < lineLength) {
                strb.append("   ");
                ++gap;
            }
            strb.append(' ');
            while (charLoop < loop) {
                strb.append(printChars[bytes[charLoop] & 0xFF]);
                ++charLoop;
            }
        }
        return strb.toString();
    }

    public static char[] getHexString(byte b) {
        char[] result = new char[]{hexchars[(b & 0xF0) >> 4], hexchars[b & 0xF], ' '};
        return result;
    }

    static {
        int n = 0;
        while (n < 10) {
            HexFormatter.hexchars[n] = (char)(48 + n);
            n = (char)(n + 1);
        }
        int n2 = 10;
        while (n2 < 16) {
            HexFormatter.hexchars[n2] = (char)(55 + n2);
            n2 = (char)(n2 + 1);
        }
        int n3 = 0;
        while (n3 < 32) {
            HexFormatter.printChars[n3] = 46;
            n3 = (char)(n3 + 1);
        }
        int n4 = 32;
        while (n4 < 256) {
            HexFormatter.printChars[n4] = n4;
            n4 = (char)(n4 + 1);
        }
    }
}

