/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.VirtualProxy;
import ojb.broker.accesslayer.IndirectionHandler;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.util.LoggerFactory;

public class Identity
implements Serializable {
    private Class objectsClass;
    private Object[] pkValues;
    private transient String stringRepresentation = null;

    private Identity() {
    }

    public Identity(Object objectToIdentitify) {
        try {
            if (objectToIdentitify instanceof VirtualProxy) {
                VirtualProxy p = (VirtualProxy)objectToIdentitify;
                Identity sourceOID = p.getIdentity();
                this.objectsClass = sourceOID.objectsClass;
                this.pkValues = sourceOID.pkValues;
            } else if (objectToIdentitify instanceof Proxy) {
                Proxy p = (Proxy)objectToIdentitify;
                InvocationHandler h = Proxy.getInvocationHandler(p);
                IndirectionHandler ih = (IndirectionHandler)h;
                Identity sourceOID = ih.getIdentity();
                this.objectsClass = sourceOID.objectsClass;
                this.pkValues = sourceOID.pkValues;
            } else {
                PersistenceBroker broker = PersistenceBrokerFactory.createPersistenceBroker();
                ClassDescriptor cld = broker.getClassDescriptor(objectToIdentitify.getClass());
                this.objectsClass = broker.getExtentClass(objectToIdentitify.getClass());
                this.pkValues = cld.getKeyValues(objectToIdentitify);
            }
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().error(t);
            throw new ClassNotPersistenceCapableException(t.getMessage());
        }
    }

    public static Identity fromByteArray(byte[] anArray) throws PersistenceBrokerException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(anArray);
            GZIPInputStream gis = new GZIPInputStream(bais);
            ObjectInputStream ois = new ObjectInputStream(gis);
            Identity result = (Identity)ois.readObject();
            ois.close();
            gis.close();
            bais.close();
            return result;
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
    }

    public Class getObjectsClass() {
        return this.objectsClass;
    }

    public byte[] serialize() throws PersistenceBrokerException {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(bao);
            ObjectOutputStream oos = new ObjectOutputStream(gos);
            oos.writeObject(this);
            oos.close();
            gos.close();
            bao.close();
            byte[] result = bao.toByteArray();
            return result;
        }
        catch (Exception ignored) {
            throw new PersistenceBrokerException(ignored);
        }
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.pkValues.length) {
                buf.append(buf.length() == 0 ? "{" : ",");
                buf.append(this.pkValues[i]);
                ++i;
            }
            buf.append("}");
            this.stringRepresentation = this.objectsClass.getName() + buf.toString();
        }
        return this.stringRepresentation;
    }

    public Identity(Class aClass, Object[] pkValues) {
        this.objectsClass = aClass;
        this.pkValues = pkValues;
    }

    public Object[] getPrimaryKeyValues() {
        return this.pkValues;
    }
}

