/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.server;

import java.io.File;
import java.util.Vector;
import ojb.broker.PersistenceBroker;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;

public class BrokerPool {
    private Vector brokers;
    private Vector freeBrokerIds;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static int BROKERCOUNT = 10;

    public BrokerPool(File repositoryFile) {
        this.brokers = new Vector();
        this.freeBrokerIds = new Vector();
        try {
            DescriptorRepository repository = DescriptorRepository.getInstance(repositoryFile.getName());
            int i = 0;
            while (i < BROKERCOUNT) {
                PersistenceBrokerImpl broker = new PersistenceBrokerImpl(repository);
                this.brokers.add(broker);
                this.freeBrokerIds.add(new Integer(this.brokers.size() - 1));
                ++i;
            }
        }
        catch (Throwable t) {
            this.logger.fatal(t);
            System.exit(-1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getFreeBrokerId() {
        Vector vector = this.freeBrokerIds;
        synchronized (vector) {
            while (this.freeBrokerIds.isEmpty()) {
                try {
                    this.freeBrokerIds.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            int result = (Integer)this.freeBrokerIds.remove(0);
            this.logger.debug("getFreeBrokerId: " + result);
            return result;
        }
    }

    void releaseBrokerId(int id) {
        Vector vector = this.freeBrokerIds;
        synchronized (vector) {
            this.logger.debug("releaseBrokerId: " + id);
            Integer ID = new Integer(id);
            if (!this.freeBrokerIds.contains(ID)) {
                this.freeBrokerIds.add(ID);
            }
            this.freeBrokerIds.notifyAll();
            this.logger.debug("available: " + this.freeBrokerIds);
        }
    }

    PersistenceBroker getBrokerById(int id) {
        PersistenceBroker result = (PersistenceBroker)this.brokers.get(id);
        this.logger.debug("getBrokerById: " + id);
        return result;
    }
}

