/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.util;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import ojb.broker.util.LoggerFactory;

public abstract class BaseConfiguration {
    protected String filename;
    protected Properties properties;

    public BaseConfiguration() {
        this.load();
    }

    protected String getProperty(String key, String defaultValue) {
        ((Hashtable)this.properties).put(key, this.properties.getProperty(key, defaultValue));
        return this.properties.getProperty(key);
    }

    protected void load() {
        this.properties = new Properties();
        try {
            LoggerFactory.getBootLogger().info("OJB.properties: " + this.getClass().getClassLoader().getResource(this.getFilename()));
            InputStream strIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getFilename());
            this.properties.load(strIn);
            strIn.close();
        }
        catch (Exception ignore) {
            ((Hashtable)this.properties).put("valid", "false");
        }
    }

    protected String[] parseSeparatedString(String str, String separator) {
        StringTokenizer st = new StringTokenizer(str, separator);
        String[] ret = new String[st.countTokens()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = new String(st.nextToken());
            ++i;
        }
        return ret;
    }

    private String getFilename() {
        if (this.filename == null) {
            this.filename = this.getClass().getName() + ".properties";
        }
        return this.filename;
    }

    protected void setFilename(String name) {
        this.filename = name;
    }
}

