/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.query.Criteria;
import ojb.broker.query.Query;
import ojb.broker.query.QueryFactory;
import test.ojb.broker.Person;
import test.ojb.broker.Project;
import test.ojb.broker.Role;

public class MtoNMapping
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$MtoNMapping == null ? (class$test$ojb$broker$MtoNMapping = MtoNMapping.class$("test.ojb.broker.MtoNMapping")) : class$test$ojb$broker$MtoNMapping;
    static /* synthetic */ Class class$test$ojb$broker$MtoNMapping;
    static /* synthetic */ Class class$test$ojb$broker$Project;
    static /* synthetic */ Class class$test$ojb$broker$Role;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public MtoNMapping(String name) {
        super(name);
    }

    public void setUp() {
        this.broker = PersistenceBrokerFactory.createPersistenceBroker();
    }

    public void tearDown() {
        try {
            this.broker.clearCache();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
    }

    public void testMNLoading() {
        try {
            Person p = new Person();
            p.setId(1);
            Query q = QueryFactory.newQuery(p);
            p = (Person)this.broker.getObjectByQuery(q);
            Vector projects = (Vector)p.getProjects();
            Assert.assertNotNull((Object)projects);
            Criteria c = null;
            q = QueryFactory.newQuery(class$test$ojb$broker$Project == null ? (class$test$ojb$broker$Project = MtoNMapping.class$("test.ojb.broker.Project")) : class$test$ojb$broker$Project, c);
            Collection col = this.broker.getCollectionByQuery(q);
            Assert.assertNotNull((Object)col);
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public void testLoadingWithAssociationClass() {
        try {
            Person p = new Person();
            p.setId(1);
            Query q = QueryFactory.newQuery(p);
            p = (Person)this.broker.getObjectByQuery(q);
            Vector roles = (Vector)p.getRoles();
            Assert.assertNotNull((Object)roles);
            Criteria c = null;
            q = QueryFactory.newQuery(class$test$ojb$broker$Project == null ? (class$test$ojb$broker$Project = MtoNMapping.class$("test.ojb.broker.Project")) : class$test$ojb$broker$Project, c);
            Collection col = this.broker.getCollectionByQuery(q);
            Assert.assertNotNull((Object)col);
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                Project proj = (Project)iter.next();
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public void testInsertion() {
        try {
            Person p = new Person();
            p.setId(1);
            Query q = QueryFactory.newQuery(p);
            p = (Person)this.broker.getObjectByQuery(q);
            Vector projects = (Vector)p.getProjects();
            Assert.assertNotNull((Object)projects);
            int count = projects.size();
            Project proj = new Project();
            proj.setTitle("MARS");
            proj.setDescription("colonization of planet Mars");
            p.getProjects().add(proj);
            this.broker.beginTransaction();
            this.broker.store(p);
            this.broker.commitTransaction();
            this.broker.clearCache();
            p = (Person)this.broker.getObjectByQuery(q);
            Assert.assertEquals((int)(count + 1), (int)p.getProjects().size());
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public void testDeletion() {
        try {
            Person pers = new Person();
            pers.setId(1);
            Query query = QueryFactory.newQuery(pers);
            pers = (Person)this.broker.getObjectByQuery(query);
            Vector projects = (Vector)pers.getProjects();
            Assert.assertNotNull((Object)projects);
            int count = projects.size();
            Project proj = (Project)projects.get(0);
            Criteria crit = new Criteria();
            crit.addEqualTo("person_id", new Integer(pers.getId()));
            crit.addEqualTo("project_id", new Integer(proj.getId()));
            Query roleQuery = QueryFactory.newQuery(class$test$ojb$broker$Role == null ? (class$test$ojb$broker$Role = MtoNMapping.class$("test.ojb.broker.Role")) : class$test$ojb$broker$Role, crit);
            Role role = (Role)this.broker.getObjectByQuery(roleQuery);
            Assert.assertNotNull((Object)role);
            this.broker.beginTransaction();
            this.broker.delete(proj);
            this.broker.commitTransaction();
            this.broker.clearCache();
            pers = (Person)this.broker.getObjectByQuery(query);
            Assert.assertEquals((int)(count - 1), (int)pers.getProjects().size());
            role = (Role)this.broker.getObjectByQuery(roleQuery);
            Assert.assertNull((Object)role);
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

