/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.message;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTMessage;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRead;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoom;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoomMember;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.message.util.MessageUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.push.ALPushService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MessageFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MessageFormData.class.getName());
    private String orgId;
    private ALNumberField roomId;
    private ALNumberField userId;
    private ALStringField message;
    private ALEipUser login_user;
    private EipTMessageRoom room;
    private ALEipUser targetUser;
    private List<FileuploadLiteBean> fileuploadList;
    private String folderName = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.orgId = Database.getDomainName();
        this.folderName = rundata.getParameters().getString("folderName");
    }

    public void initField() {
        this.message = new ALStringField();
        this.message.setFieldName(ALLocalizationUtils.getl10n((String)"MESSAGE_CAPTION_MESSAGE"));
        this.message.setTrim(false);
        this.roomId = new ALNumberField();
        this.userId = new ALNumberField();
        this.fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                this.fileuploadList = MessageUtils.getFileuploadList(rundata);
            }
            catch (Exception ex) {
                logger.error((Object)"message", (Throwable)ex);
            }
        }
        return res;
    }

    protected void setValidator() throws ALPageNotFoundException, ALDBErrorException {
        this.message.setNotNull(true);
        this.message.limitMaxLength(10000);
    }

    protected boolean validate(List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        if (this.userId.getValue() > 0L) {
            this.targetUser = ALEipUtils.getALEipUser((int)((int)this.userId.getValue()));
        } else {
            this.room = (EipTMessageRoom)Database.get(EipTMessageRoom.class, (Object)this.roomId.getValue());
            if (this.room == null) {
                msgList.add(ALLocalizationUtils.getl10n((String)"MESSAGE_VALIDATE_ROOM_NOT_FOUND"));
            }
            if (this.room != null && !MessageUtils.isJoinRoom(this.room, (int)this.login_user.getUserId().getValue())) {
                msgList.add(ALLocalizationUtils.getl10n((String)"MESSAGE_VALIDATE_ROOM_ACCESS_DENIED"));
            }
        }
        this.message.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            Date now = new Date();
            if (this.room == null && this.targetUser != null) {
                int userId = (int)this.login_user.getUserId().getValue();
                int targetUserId = (int)this.targetUser.getUserId().getValue();
                this.room = MessageUtils.getRoom(userId, targetUserId);
                if (this.room == null) {
                    this.room = (EipTMessageRoom)Database.create(EipTMessageRoom.class);
                    EipTMessageRoomMember map1 = (EipTMessageRoomMember)Database.create(EipTMessageRoomMember.class);
                    map1.setEipTMessageRoom(this.room);
                    map1.setUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
                    map1.setTargetUserId(Integer.valueOf((int)this.targetUser.getUserId().getValue()));
                    map1.setLoginName(this.login_user.getName().getValue());
                    EipTMessageRoomMember map2 = (EipTMessageRoomMember)Database.create(EipTMessageRoomMember.class);
                    map2.setEipTMessageRoom(this.room);
                    map2.setTargetUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
                    map2.setUserId(Integer.valueOf((int)this.targetUser.getUserId().getValue()));
                    map2.setLoginName(this.targetUser.getName().getValue());
                    this.room.setAutoName("T");
                    this.room.setRoomType("O");
                    this.room.setLastUpdateDate(now);
                    this.room.setCreateDate(now);
                    this.room.setCreateUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
                    this.room.setUpdateDate(now);
                    Database.commit();
                }
            }
            if (this.room == null) {
                throw new IllegalArgumentException("room may not be null. ");
            }
            List members = this.room.getEipTMessageRoomMember();
            EipTMessage model = (EipTMessage)Database.create(EipTMessage.class);
            model.setEipTMessageRoom(this.room);
            model.setMessage(this.message.getValue());
            model.setCreateDate(now);
            model.setUpdateDate(now);
            model.setMemberCount(Integer.valueOf(members.size()));
            model.setUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
            ArrayList<String> recipients = new ArrayList<String>();
            for (EipTMessageRoomMember member : members) {
                if (member.getUserId() == (int)this.login_user.getUserId().getValue()) continue;
                EipTMessageRead record = (EipTMessageRead)Database.create(EipTMessageRead.class);
                record.setEipTMessage(model);
                record.setIsRead("F");
                record.setUserId(member.getUserId());
                record.setRoomId(this.room.getRoomId());
                recipients.add(member.getLoginName());
            }
            this.room.setLastMessage(ALCommonUtils.compressString((String)this.message.getValue(), (int)100));
            this.room.setLastUpdateDate(now);
            this.insertAttachmentFiles(this.fileuploadList, this.folderName, (int)this.login_user.getUserId().getValue(), model, msgList);
            Database.commit();
            this.roomId.setValue((long)this.room.getRoomId().intValue());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("roomId", String.valueOf(this.room.getRoomId()));
            params.put("messageId", String.valueOf(model.getMessageId()));
            ALPushService.pushAsync((String)"messagev2", params, recipients);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"MessageFormData.insertFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    public ALStringField getMessage() {
        return this.message;
    }

    private boolean insertAttachmentFiles(List<FileuploadLiteBean> fileuploadList, String folderName, int uid, EipTMessage entry, List<String> msgList) {
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            return true;
        }
        try {
            int length = fileuploadList.size();
            ArrayList<FileuploadLiteBean> newfilebeans = new ArrayList<FileuploadLiteBean>();
            FileuploadLiteBean filebean = null;
            for (int i = 0; i < length; ++i) {
                filebean = fileuploadList.get(i);
                if (!filebean.isNewFile()) continue;
                newfilebeans.add(filebean);
            }
            int newfilebeansSize = newfilebeans.size();
            if (newfilebeansSize > 0) {
                FileuploadLiteBean newfilebean = null;
                for (int j = 0; j < length; ++j) {
                    newfilebean = (FileuploadLiteBean)newfilebeans.get(j);
                    String[] acceptExts = ImageIO.getWriterFormatNames();
                    FileuploadUtils.ShrinkImageSet shrinkImageSet = FileuploadUtils.getBytesShrinkFilebean((String)this.orgId, (String)folderName, (int)uid, (FileuploadLiteBean)newfilebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)true);
                    String filename = j + "_" + String.valueOf(System.nanoTime());
                    EipTMessageFile file = (EipTMessageFile)Database.create(EipTMessageFile.class);
                    file.setOwnerId(Integer.valueOf(uid));
                    file.setFileName(newfilebean.getFileName());
                    file.setFilePath(MessageUtils.getRelativePath(filename));
                    if (shrinkImageSet != null && shrinkImageSet.getShrinkImage() != null) {
                        file.setFileThumbnail(shrinkImageSet.getShrinkImage());
                    }
                    file.setEipTMessage(entry);
                    file.setRoomId(this.room.getRoomId());
                    file.setCreateDate(Calendar.getInstance().getTime());
                    file.setUpdateDate(Calendar.getInstance().getTime());
                    ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(newfilebean.getFileId()), (String)MessageUtils.FOLDER_FILEDIR_MESSAGE, (String)(MessageUtils.CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
                    if (shrinkImageSet != null && shrinkImageSet.getFixImage() != null) {
                        ALStorageService.createNewFile((InputStream)new ByteArrayInputStream(shrinkImageSet.getFixImage()), (String)(MessageUtils.FOLDER_FILEDIR_MESSAGE + ALStorageService.separator() + Database.getDomainName() + ALStorageService.separator() + MessageUtils.CATEGORY_KEY + ALStorageService.separator() + uid + ALStorageService.separator() + filename));
                        continue;
                    }
                    ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(newfilebean.getFileId()), (String)MessageUtils.FOLDER_FILEDIR_MESSAGE, (String)(MessageUtils.CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
                }
                ALStorageService.deleteTmpFolder((int)uid, (String)folderName);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return true;
    }

    public int getRoomId() {
        return (int)this.roomId.getValue();
    }
}

