/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.message;

import com.aimluck.eip.cayenne.om.portlet.EipTMessage;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoom;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.message.MessageResultData;
import com.aimluck.eip.message.util.MessageUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MessageListSelectData
extends ALAbstractSelectData<EipTMessage, EipTMessage> {
    public static final int MESSAGE_LIMIT = 50;
    private int cursor = 0;
    private boolean latest = false;
    private int targetUserId;
    private int userId;
    private int lastMessageId;
    private EipTMessageRoom room;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
    }

    protected ResultList<EipTMessage> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        if (this.targetUserId > 0) {
            return new ResultList(new ArrayList(), 1, 50, 0);
        }
        try {
            this.cursor = rundata.getParameters().getInt("c");
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            int param = rundata.getParameters().getInt("latest");
            this.latest = param == 1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return MessageUtils.getMessageList(this.room.getRoomId(), this.cursor, 50, this.latest);
    }

    protected EipTMessage selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Object getResultData(EipTMessage model) throws ALPageNotFoundException, ALDBErrorException {
        MessageResultData rd = new MessageResultData();
        rd.initField();
        rd.setMessageId(model.getMessageId().intValue());
        rd.setRoomId(this.room.getRoomId().intValue());
        rd.setUserId(model.getUserId().intValue());
        rd.setFirstName(model.getFirstName());
        rd.setLastName(model.getLastName());
        rd.setHasPhoto("T".equals(model.getHasPhoto()));
        rd.setPhotoModified(model.getPhotoModified());
        rd.setMemberCount(model.getMemberCount().intValue());
        rd.setUnreadCount(model.getUnreadCount().intValue());
        rd.setMessage(model.getMessage());
        rd.setCreateDate(model.getCreateDate());
        rd.setOwner(model.getUserId() == this.userId);
        if (model.getMessageId() > this.lastMessageId) {
            this.lastMessageId = model.getMessageId();
        }
        return rd;
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        boolean res = super.doViewList(action, rundata, context);
        List result = this.getList();
        ArrayList<Integer> parentIds = new ArrayList<Integer>(result.size());
        for (Object obj : result) {
            MessageResultData rd = (MessageResultData)obj;
            parentIds.add((int)rd.getMessageId().getValue());
        }
        Map<Integer, List<FileuploadBean>> filesMap = this.getFiles(parentIds);
        for (Object obj : result) {
            MessageResultData rd = (MessageResultData)obj;
            List<FileuploadBean> list = filesMap.get((int)rd.getMessageId().getValue());
            if (list == null) continue;
            rd.setAttachmentFileList(list);
        }
        return res;
    }

    protected Map<Integer, List<FileuploadBean>> getFiles(List<Integer> parentIds) {
        if (parentIds == null || parentIds.size() == 0) {
            return new HashMap<Integer, List<FileuploadBean>>();
        }
        SelectQuery query = Database.query(EipTMessageFile.class);
        query.where(Operations.in((String)"messageId", parentIds));
        query.orderAscending("updateDate");
        query.orderAscending("filePath");
        List list = query.fetchList();
        HashMap<Integer, List<FileuploadBean>> result = new HashMap<Integer, List<FileuploadBean>>(parentIds.size());
        for (EipTMessageFile model : list) {
            Integer id = model.getMessageId();
            ArrayList<FileuploadBean> rdList = (ArrayList<FileuploadBean>)result.get(id);
            if (rdList == null) {
                rdList = new ArrayList<FileuploadBean>();
            }
            String realname = model.getFileName();
            DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
            FileuploadBean filebean = new FileuploadBean();
            filebean.setFileId(model.getFileId().intValue());
            filebean.setFileName(realname);
            if (hData != null) {
                filebean.setContentType(hData.getContentType());
            }
            filebean.setIsImage(FileuploadUtils.isImage((String)realname));
            rdList.add(filebean);
            result.put(id, rdList);
        }
        return result;
    }

    protected Object getResultDataDetail(EipTMessage model) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    public void setRoom(EipTMessageRoom room) {
        this.room = room;
    }

    public int getRoomId() {
        return this.room.getRoomId();
    }

    public int getUserId() {
        return this.userId;
    }

    public int getLastMessageId() {
        return this.lastMessageId;
    }

    public void setTargetUserId(int targetUserId) {
        this.targetUserId = targetUserId;
    }

    public int getTargetUserId() {
        return this.targetUserId;
    }

    public boolean isFirstView() {
        return this.cursor == 0 && !this.latest;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }
}

