/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.message;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALDeleteFileUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoom;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoomMember;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.message.util.MessageUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MessageRoomFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MessageRoomFormData.class.getName());
    private ALStringField members;
    private ALStringField name;
    private List<ALEipUser> memberList;
    private ALEipUser login_user;
    private FileuploadLiteBean filebean = null;
    private String folderName = null;
    private byte[] facePhoto;
    private byte[] facePhoto_smartphone;
    private int roomId;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.folderName = rundata.getParameters().getString("folderName");
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
    }

    public void initField() {
        this.name = new ALStringField();
        this.members = new ALStringField();
        this.members.setTrim(true);
        this.memberList = new ArrayList<ALEipUser>();
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                List fileBeanList;
                Object[] memberNames = rundata.getParameters().getStrings("member_to");
                this.memberList.clear();
                if (memberNames != null && memberNames.length > 0) {
                    SelectQuery query = Database.query(TurbineUser.class);
                    Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])memberNames);
                    query.setQualifier(exp);
                    this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
                }
                if (this.memberList.size() == 0) {
                    this.memberList.add(this.login_user);
                }
                if ((fileBeanList = FileuploadUtils.getFileuploadList((RunData)rundata)) != null && fileBeanList.size() > 0) {
                    this.filebean = (FileuploadLiteBean)fileBeanList.get(0);
                    if (this.filebean.getFileId() != 0) {
                        String[] acceptExts = ImageIO.getWriterFormatNames();
                        this.facePhoto = null;
                        FileuploadUtils.ShrinkImageSet bytesShrinkFilebean = FileuploadUtils.getBytesShrinkFilebean((String)Database.getDomainName(), (String)this.folderName, (int)ALEipUtils.getUserId((RunData)rundata), (FileuploadLiteBean)this.filebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)false);
                        if (bytesShrinkFilebean != null) {
                            this.facePhoto = bytesShrinkFilebean.getShrinkImage();
                        }
                        this.facePhoto_smartphone = null;
                        FileuploadUtils.ShrinkImageSet bytesShrinkFilebean2 = FileuploadUtils.getBytesShrinkFilebean((String)Database.getDomainName(), (String)this.folderName, (int)ALEipUtils.getUserId((RunData)rundata), (FileuploadLiteBean)this.filebean, (String[])acceptExts, (int)64, (int)64, msgList, (boolean)false);
                        if (bytesShrinkFilebean2 != null) {
                            this.facePhoto_smartphone = bytesShrinkFilebean2.getShrinkImage();
                        }
                    } else {
                        this.facePhoto = null;
                        this.facePhoto_smartphone = null;
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"MessageRoomFormData.setFormData", (Throwable)ex);
            }
        }
        return res;
    }

    protected void setValidator() throws ALPageNotFoundException, ALDBErrorException {
    }

    protected boolean validate(List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        if (this.memberList.size() < 2) {
            msgList.add(ALLocalizationUtils.getl10n((String)"MESSAGE_VALIDATE_ROOM_MEMBER1"));
        }
        boolean hasOwn = false;
        for (ALEipUser user : this.memberList) {
            if (user.getUserId().getValue() != this.login_user.getUserId().getValue()) continue;
            hasOwn = true;
        }
        if (!hasOwn) {
            msgList.add(ALLocalizationUtils.getl10n((String)"MESSAGE_VALIDATE_ROOM_MEMBER2"));
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTMessageRoom room = MessageUtils.getRoom(rundata, context);
            if (room == null || "O".equals(room.getRoomType())) {
                throw new ALPageNotFoundException();
            }
            if (!MessageUtils.isJoinRoom(room, (int)this.login_user.getUserId().getValue())) {
                throw new ALPermissionException();
            }
            if ("F".equals(room.getAutoName())) {
                this.name.setValue(room.getName());
            }
            List members = room.getEipTMessageRoomMember();
            ArrayList<String> memberNames = new ArrayList<String>();
            for (EipTMessageRoomMember member : members) {
                memberNames.add(member.getLoginName());
            }
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.inExp((String)"loginName", memberNames);
            query.setQualifier(exp);
            this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
            if (room.getPhoto() != null) {
                this.filebean = new FileuploadLiteBean();
                this.filebean.initField();
                this.filebean.setFolderName("");
                this.filebean.setFileId(0);
                this.filebean.setPhotoModified(String.valueOf(room.getPhotoModified().getTime()));
                this.filebean.setFileName(ALLocalizationUtils.getl10nFormat((String)"MESSAGE_ROOM_OLD_PHOTO", (Object[])new Object[0]));
            }
            this.roomId = room.getRoomId();
        }
        catch (ALPageNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.error((Object)"MessageRoomFormData.loadFormData", t);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTMessageRoom model = (EipTMessageRoom)Database.create(EipTMessageRoom.class);
            Date now = new Date();
            boolean isFirst = true;
            StringBuilder autoName = new StringBuilder();
            for (ALEipUser user : this.memberList) {
                EipTMessageRoomMember map = (EipTMessageRoomMember)Database.create(EipTMessageRoomMember.class);
                int userid = (int)user.getUserId().getValue();
                map.setEipTMessageRoom(model);
                map.setTargetUserId(Integer.valueOf(1));
                map.setUserId(Integer.valueOf(userid));
                map.setLoginName(user.getName().getValue());
                if (!isFirst) {
                    autoName.append(",");
                }
                autoName.append(user.getAliasName().getValue());
                isFirst = false;
            }
            if (StringUtils.isEmpty((String)this.name.getValue())) {
                model.setAutoName("T");
                model.setName(autoName.toString());
            } else {
                model.setAutoName("F");
                model.setName(this.name.getValue());
            }
            model.setRoomType("G");
            model.setLastUpdateDate(now);
            model.setCreateDate(now);
            model.setCreateUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
            model.setUpdateDate(now);
            if (this.filebean != null && this.filebean.getFileId() != 0) {
                model.setPhotoSmartphone(this.facePhoto_smartphone);
                model.setPhoto(this.facePhoto);
                model.setPhotoModified(new Date());
                model.setHasPhoto("T");
            } else {
                model.setHasPhoto("F");
            }
            Database.commit();
            this.roomId = model.getRoomId();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"MessageRoomFormData.insertFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTMessageRoom model = MessageUtils.getRoom(rundata, context);
            if (model == null) {
                return false;
            }
            if (!MessageUtils.isJoinRoom(model, (int)this.login_user.getUserId().getValue())) {
                msgList.add(ALLocalizationUtils.getl10n((String)"MESSAGE_VALIDATE_ROOM_ACCESS_DENIED"));
                return false;
            }
            Date now = new Date();
            Database.deleteAll((List)model.getEipTMessageRoomMember());
            boolean isFirst = true;
            StringBuilder autoName = new StringBuilder();
            for (ALEipUser user : this.memberList) {
                EipTMessageRoomMember map = (EipTMessageRoomMember)Database.create(EipTMessageRoomMember.class);
                int userid = (int)user.getUserId().getValue();
                map.setEipTMessageRoom(model);
                map.setTargetUserId(Integer.valueOf(1));
                map.setUserId(Integer.valueOf(userid));
                map.setLoginName(user.getName().getValue());
                if (!isFirst) {
                    autoName.append(",");
                }
                autoName.append(user.getAliasName().getValue());
                isFirst = false;
            }
            if (StringUtils.isEmpty((String)this.name.getValue())) {
                model.setAutoName("T");
                model.setName(autoName.toString());
            } else {
                model.setAutoName("F");
                model.setName(this.name.getValue());
            }
            model.setRoomType("G");
            model.setUpdateDate(now);
            if (this.filebean != null && this.filebean.getFileId() != 0) {
                model.setPhotoSmartphone(this.facePhoto_smartphone);
                model.setPhoto(this.facePhoto);
                model.setPhotoModified(new Date());
                model.setHasPhoto("T");
            }
            if (this.filebean != null) {
                if (this.filebean.getFileId() != 0) {
                    model.setPhoto(this.facePhoto);
                    model.setPhotoSmartphone(this.facePhoto_smartphone);
                    model.setPhotoModified(new Date());
                    model.setHasPhoto("T");
                }
            } else {
                model.setPhoto(null);
                model.setPhotoSmartphone(null);
                model.setPhotoModified(null);
                model.setHasPhoto("F");
            }
            Database.commit();
            this.roomId = model.getRoomId();
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"MessageRoomFormData.updateFormData", t);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTMessageRoom model = MessageUtils.getRoom(rundata, context);
            if (model == null) {
                return false;
            }
            List<EipTMessageFile> files = MessageUtils.getEipTMessageFilesByRoom(model.getRoomId());
            ALDeleteFileUtil.deleteFiles((String)MessageUtils.FOLDER_FILEDIR_MESSAGE, (String)MessageUtils.CATEGORY_KEY, files);
            Database.delete((Persistent)model);
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"MessageRoomFormData.deleteFormData", t);
            return false;
        }
        return true;
    }

    public ALStringField getName() {
        return this.name;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public int getRoomId() {
        return this.roomId;
    }

    public FileuploadLiteBean getFileBean() {
        return this.filebean;
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        if (this.filebean == null) {
            return null;
        }
        ArrayList<FileuploadLiteBean> list = new ArrayList<FileuploadLiteBean>();
        list.add(this.filebean);
        return list;
    }
}

