/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.commons.field;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.List;

public class ALCellNumberField
extends ALNumberField {
    private static final long serialVersionUID = -6340064223039830226L;

    public ALCellNumberField() {
    }

    public ALCellNumberField(long value) {
        super(value);
    }

    public ALCellNumberField(String str) {
        super(str);
    }

    @Override
    public boolean validate(List<String> msgList) {
        if (msgList == null) {
            msgList = new ArrayList<String>();
        }
        if (!this.isNotNullValue()) {
            if (this.isNotNull()) {
                msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_NAME", this.fieldName));
                return false;
            }
        } else {
            if (!this.isNumberValue()) {
                msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_CORRECT_NUMBER_CAUTION", this.fieldName));
                return false;
            }
            if (this.isLimitValue()) {
                long longValue = this.getValue();
                if (longValue < this.getMinValue()) {
                    msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_NUMBER_CAUTION_LESS", this.fieldName, this.getMinValue()));
                    return false;
                }
                if (longValue > this.getMaxValue()) {
                    msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_NUMBER_CAUTION_OVER", this.fieldName, this.getMaxValue()));
                    return false;
                }
            }
        }
        return true;
    }
}

