/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.commons.utils;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.utils.ALHankakuComparator;
import com.aimluck.commons.utils.ALKanaMapTable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ALStringUtil {
    public static final int HANKAKU_KANA_FIRST = 65377;
    public static final int HANKAKU_KANA_LAST = 65439;
    private static final String DAKUON = "\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070\u3073\u3076\u3079\u307c\u3071\u3074\u3077\u307a\u307d";
    private static final String SEION = "\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306f\u3072\u3075\u3078\u307b\u306f\u3072\u3075\u3078\u307b";

    public static boolean isMailAddress(String str) {
        Pattern mailPattern = Pattern.compile("[\\w\\.\\-\\+]+@([\\w\\-]+\\.)+[\\w\\-]+", 2);
        Matcher objMch = mailPattern.matcher(str);
        return objMch.matches();
    }

    public static boolean isCellPhoneMailAddress(String str) {
        Pattern mailPattern = Pattern.compile("[\\w\\.\\-\\_\\+\\p{Punct}]+@([\\w\\-]+\\.)+[\\w\\-]+", 2);
        Matcher objMch = mailPattern.matcher(str);
        return objMch.matches();
    }

    public static boolean isHankakuKana(char chr) {
        return chr >= '\uff61' && chr <= '\uff9f';
    }

    public static boolean isNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    public static String convertHiragana2Katakana(String str) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char code = str.charAt(i);
            if (code >= '\u3041' && code <= '\u3093') {
                buf.append((char)(code + 96));
                continue;
            }
            buf.append(code);
        }
        return buf.toString();
    }

    public static String convertKatakana2Hiragana(String str) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char code = str.charAt(i);
            if (code >= '\u30a1' && code <= '\u30f3') {
                buf.append((char)(code - 96));
                continue;
            }
            buf.append(code);
        }
        return buf.toString();
    }

    public static String convertH2ZKana(String str) {
        if (str == null) {
            return null;
        }
        return ALStringUtil.convertH2ZKana(str, 0, str.length());
    }

    public static String convertH2ZKana(String str, int pos, int length) {
        char[][][] table = ALKanaMapTable.TABLE_HANKAKU2ZENKAKU;
        ALHankakuComparator<Object> comp = new ALHankakuComparator<Object>();
        int retIdx = 0;
        int maxPos = pos + length;
        char[] base = new char[1];
        char[] daku = new char[2];
        char[] nChars = str.toCharArray();
        char[] nRets = new char[length];
        while (pos < maxPos) {
            char[] res;
            char nextChar;
            char currChar;
            if (!ALStringUtil.isHankakuKana(currChar = nChars[pos++])) {
                nRets[retIdx++] = currChar;
                continue;
            }
            if (pos < maxPos && ((nextChar = nChars[pos]) == '\u309b' || nextChar == '\u309c')) {
                ++pos;
                daku[0] = currChar;
                daku[1] = nextChar;
                res = ALStringUtil.convertH2ZKanaChar(daku, table, comp);
                retIdx += ALStringUtil.putCharactors(nRets, res, retIdx);
                continue;
            }
            base[0] = currChar;
            res = ALStringUtil.convertH2ZKanaChar(base, table, comp);
            retIdx += ALStringUtil.putCharactors(nRets, res, retIdx);
        }
        return new String(nRets, 0, retIdx);
    }

    public static String sanitizing(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        int len = str.length();
        block7: for (int i = 0; i < len; ++i) {
            char originalCharacter = str.charAt(i);
            switch (originalCharacter) {
                case '<': {
                    buff.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buff.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    buff.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    buff.append("&quot;");
                    continue block7;
                }
                case '&': {
                    buff.append("&amp;");
                    continue block7;
                }
                default: {
                    buff.append(originalCharacter);
                }
            }
        }
        return buff.toString();
    }

    public static String unsanitizing(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char originalChar = str.charAt(i);
            if (originalChar != '&') {
                buff.append(originalChar);
                continue;
            }
            if (len > i + 5) {
                if ("&lt;".equals(str.substring(i, i + 4))) {
                    buff.append('<');
                    i += 3;
                    continue;
                }
                if ("&gt;".equals(str.substring(i, i + 4))) {
                    buff.append('>');
                    i += 3;
                    continue;
                }
                if ("&#39;".equals(str.substring(i, i + 5))) {
                    buff.append('\'');
                    i += 4;
                    continue;
                }
                if ("&amp;".equals(str.substring(i, i + 5))) {
                    buff.append('&');
                    i += 4;
                    continue;
                }
                if ("&quot;".equals(str.substring(i, i + 6))) {
                    buff.append('\"');
                    i += 5;
                    continue;
                }
                buff.append(originalChar);
                continue;
            }
            if (i + 4 == len) {
                if ("&lt;".equals(str.substring(i))) {
                    buff.append('<');
                } else if ("&gt;".equals(str.substring(i))) {
                    buff.append('>');
                } else {
                    buff.append(str.substring(i));
                    break;
                }
                i += 3;
                continue;
            }
            if (i + 5 == len) {
                if ("&#39;".equals(str.substring(i))) {
                    buff.append('\'');
                } else if ("&amp;".equals(str.substring(i))) {
                    buff.append('&');
                } else {
                    buff.append(str.substring(i));
                    break;
                }
                i += 4;
                continue;
            }
            if (i + 6 == len) {
                if (!"&quot;".equals(str.substring(i))) {
                    buff.append(str.substring(i));
                    break;
                }
                buff.append('\"');
                i += 5;
                continue;
            }
            buff.append('&');
        }
        return buff.toString();
    }

    private static int putCharactors(char[] chars, char[] newchars, int inpos) {
        int pos = inpos;
        for (int i = 0; i < newchars.length; ++i) {
            if (newchars[i] == '\u0000') continue;
            chars[pos++] = newchars[i];
        }
        return pos - inpos;
    }

    private static char[] convertH2ZKanaChar(char[] chars, char[][][] mapTable, Comparator<Object> comparator) {
        int index = Arrays.binarySearch((Object[])mapTable, chars, comparator);
        if (index >= 0) {
            return mapTable[index][1];
        }
        if (chars.length == 1) {
            return chars;
        }
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (chars[i] == '\u0000') continue;
            char[] atom = new char[]{chars[i]};
            chars[i] = ALStringUtil.convertH2ZKanaChar(atom, mapTable, comparator)[0];
        }
        return chars;
    }

    public static boolean isSymbol(char ch) {
        byte[] chars;
        try {
            chars = Character.valueOf(ch).toString().getBytes("shift_jis");
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return chars != null && chars.length != 2 && !Character.isDigit(ch) && !Character.isLetter(ch);
    }

    public static String toTwoDigitString(ALNumberField num) {
        if (num != null) {
            return String.format("%02d", num.getValue());
        }
        return "";
    }

    public static String convertDakuon2Seion(String str) {
        int size = DAKUON.length();
        String result = str;
        for (int i = 0; i < size; ++i) {
            String s1 = DAKUON.substring(i, i + 1);
            String s2 = SEION.substring(i, i + 1);
            result = result.replaceAll(s1, s2);
        }
        return result;
    }
}

