/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.account.EipTAclPortletFeature;
import com.aimluck.eip.cayenne.om.account.EipTAclRole;
import com.aimluck.eip.cayenne.om.security.VTurbineUserLite;
import com.aimluck.eip.common.ALEipCompany;
import com.aimluck.eip.common.ALEipPosition;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.http.HttpServletRequestLocator;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.customlocalization.ALLocalizationTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALEipManager {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALEipManager.class.getName());
    private static ALEipManager manager = new ALEipManager();
    private static String USERS_KEY = "com.aimluck.eip.common.ALEipManager.users";
    private static String COMPANIES_KEY = "com.aimluck.eip.common.ALEipManager.companies";
    private static String POSTS_KEY = "com.aimluck.eip.common.ALEipManager.posts";
    private static String POSITIONS_KEY = "com.aimluck.eip.common.ALEipManager.positions";
    private static String ACL_KEY = "com.aimluck.eip.common.ALEipManager.acls";
    private static String CONFIG_PREFIX = "config_";
    private static String CONTAINER_PREFIX = "container_";
    private static String USER_PREFIX = "turbineUser_";
    private static String PSML_PREFIX = "psml";
    private static String LOCALIZATION_PREFIX = "Localization";

    public static ALEipManager getInstance() {
        return manager;
    }

    public void reloadCompany() {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            request.setAttribute(COMPANIES_KEY, null);
        }
    }

    public void reloadPost() {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            request.setAttribute(POSTS_KEY, null);
        }
    }

    public void reloadPosition() {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            request.setAttribute(POSITIONS_KEY, null);
        }
    }

    public ALEipUser getUser(Integer userId) {
        Map<Integer, ALEipUser> users = this.getUsers(Arrays.asList(userId));
        return users.get(userId);
    }

    public Map<Integer, ALEipUser> getUsers(List<Integer> users) {
        HashMap<Integer, ALEipUser> results = new HashMap<Integer, ALEipUser>(users.size());
        Map<Integer, ALEipUser> map = new HashMap(users.size());
        ArrayList<Integer> fetchUsers = new ArrayList<Integer>(users.size());
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            map = (Map)request.getAttribute(USERS_KEY);
            if (map != null) {
                for (Integer userId : users) {
                    ALEipUser user = (ALEipUser)map.get(userId);
                    if (user != null) {
                        results.put(userId, user);
                        continue;
                    }
                    fetchUsers.add(userId);
                }
            } else {
                map = new HashMap(users.size());
                fetchUsers.addAll(users);
            }
        } else {
            fetchUsers.addAll(users);
        }
        if (fetchUsers.size() > 0) {
            StringBuilder select = new StringBuilder();
            select.append("SELECT");
            select.append(" turbine_user.user_id,");
            select.append(" turbine_user.last_name,");
            select.append(" turbine_user.first_name,");
            select.append(" turbine_user.login_name,");
            select.append(" turbine_user.has_photo,");
            select.append(" turbine_user.photo_modified");
            StringBuilder body = new StringBuilder();
            body.append(" FROM turbine_user WHERE ");
            body.append(" turbine_user.user_id IN (");
            boolean isFirst = true;
            for (Integer num : fetchUsers) {
                if (!isFirst) {
                    body.append(",");
                }
                body.append(num);
                isFirst = false;
            }
            body.append(")");
            SQLTemplate<VTurbineUserLite> query = Database.sql(VTurbineUserLite.class, select.toString() + body.toString());
            List<VTurbineUserLite> list = query.fetchList();
            for (VTurbineUserLite model : list) {
                ALEipUser eipUser = new ALEipUser();
                eipUser.initField();
                eipUser.setAliasName(model.getFirstName(), model.getLastName());
                eipUser.setName(model.getLoginName());
                eipUser.setUserId(model.getUserId());
                eipUser.setHasPhoto("T".equals(model.getHasPhoto()));
                eipUser.setPhotoModified(model.getPhotoModified() != null ? model.getPhotoModified().getTime() : 0L);
                results.put(model.getUserId(), eipUser);
                map.put(model.getUserId(), eipUser);
            }
        }
        if (request != null) {
            request.setAttribute(USERS_KEY, map);
        }
        return results;
    }

    public Map<Integer, ALEipCompany> getCompanyMap() {
        Map map;
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null && (map = (Map)request.getAttribute(COMPANIES_KEY)) != null) {
            return map;
        }
        LinkedHashMap<Integer, ALEipCompany> companyMap = new LinkedHashMap<Integer, ALEipCompany>();
        try {
            List<EipMCompany> list = Database.query(EipMCompany.class).fetchList();
            for (EipMCompany record : list) {
                ALEipCompany company = new ALEipCompany();
                company.initField();
                company.setCompanyId(record.getCompanyId());
                company.setCompanyName(record.getCompanyName());
                companyMap.put(record.getCompanyId(), company);
            }
        }
        catch (Exception e) {
            logger.error((Object)("[" + Database.getDomainName() + ":ALEipManager]"), (Throwable)e);
        }
        if (request != null) {
            request.setAttribute(COMPANIES_KEY, companyMap);
        }
        return companyMap;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        Map map;
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null && (map = (Map)request.getAttribute(POSTS_KEY)) != null) {
            return map;
        }
        LinkedHashMap<Integer, ALEipPost> postMap = new LinkedHashMap<Integer, ALEipPost>();
        try {
            SelectQuery<EipMPost> query = Database.query(EipMPost.class);
            query.orderAscending("postName");
            List<EipMPost> list = query.fetchList();
            for (EipMPost record : list) {
                ALEipPost post = new ALEipPost();
                post.initField();
                post.setPostId(record.getPostId());
                post.setPostName(record.getPostName());
                post.setGroupName(record.getGroupName());
                postMap.put(record.getPostId(), post);
            }
        }
        catch (Exception e) {
            logger.error((Object)("[" + Database.getDomainName() + ":ALEipManager]"), (Throwable)e);
        }
        if (request != null) {
            request.setAttribute(POSTS_KEY, postMap);
        }
        return postMap;
    }

    public Map<Integer, ALEipPosition> getPositionMap() {
        Map map;
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null && (map = (Map)request.getAttribute(POSITIONS_KEY)) != null) {
            return map;
        }
        LinkedHashMap<Integer, ALEipPosition> positionMap = new LinkedHashMap<Integer, ALEipPosition>();
        try {
            List<EipMPosition> list = Database.query(EipMPosition.class).fetchList();
            for (EipMPosition record : list) {
                ALEipPosition position = new ALEipPosition();
                position.initField();
                position.setPositionId(record.getPositionId());
                position.setPositionName(record.getPositionName());
                positionMap.put(record.getPositionId(), position);
            }
        }
        catch (Exception e) {
            logger.error((Object)("[" + Database.getDomainName() + ":ALEipManager]"), (Throwable)e);
        }
        if (request != null) {
            request.setAttribute(POSITIONS_KEY, positionMap);
        }
        return positionMap;
    }

    public Map<String, EipTAclRole> getAclRoleMap(int userId) {
        Map map;
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null && (map = (Map)request.getAttribute(ACL_KEY)) != null) {
            return map;
        }
        HashMap<String, EipTAclRole> roleMap = new HashMap<String, EipTAclRole>();
        Expression exp = ExpressionFactory.matchDbExp((String)"eipTAclUserRoleMaps.turbineUser.USER_ID", (Object)userId);
        List<EipTAclRole> roleList = Database.query(EipTAclRole.class, exp).fetchList();
        List<EipTAclPortletFeature> featureList = Database.query(EipTAclPortletFeature.class).fetchList();
        HashMap<Integer, String> _map = new HashMap<Integer, String>();
        for (EipTAclPortletFeature feature : featureList) {
            _map.put(feature.getFeatureId(), feature.getFeatureName());
        }
        for (EipTAclRole _role : roleList) {
            String _featureName = (String)_map.get(_role.getFeatureId());
            roleMap.put(_featureName, _role);
        }
        if (request != null) {
            request.setAttribute(ACL_KEY, roleMap);
        }
        return roleMap;
    }

    public Object getConfig(String name) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            return request.getAttribute(CONFIG_PREFIX + name);
        }
        return null;
    }

    public void setConfig(String name, Object obj) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            request.setAttribute(CONFIG_PREFIX + name, obj);
        }
    }

    public Object getContainerConfig(String name) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            return request.getAttribute(CONTAINER_PREFIX + name);
        }
        return null;
    }

    public void setContainerConfig(String name, Object obj) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            request.setAttribute(CONTAINER_PREFIX + name, obj);
        }
    }

    public Object getTurbineUser(int userId) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            return request.getAttribute(USER_PREFIX + String.valueOf(userId));
        }
        return null;
    }

    public void setTurbineUser(int userId, Object obj) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            request.setAttribute(USER_PREFIX + String.valueOf(userId), obj);
        }
    }

    public Object getTurbineUser(String loginName) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            return request.getAttribute(USER_PREFIX + loginName);
        }
        return null;
    }

    public void setTurbineUser(String loginName, Object obj) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            request.setAttribute(USER_PREFIX + loginName, obj);
        }
    }

    public Object getUserProfile(ProfileLocator locator) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        String key = this.getUserProfileKey(locator);
        if (request != null && key != null) {
            return request.getAttribute(key);
        }
        return null;
    }

    public void setUserProfile(ProfileLocator locator, Object obj) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        String key = this.getUserProfileKey(locator);
        if (request != null && key != null) {
            request.setAttribute(key, obj);
        }
    }

    public void removeProfile(ProfileLocator locator) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        String key = this.getUserProfileKey(locator);
        if (request != null && key != null) {
            request.removeAttribute(key);
        }
    }

    private String getUserProfileKey(ProfileLocator locator) {
        StringBuffer buffer = new StringBuffer(PSML_PREFIX);
        String userName = null;
        JetspeedUser user = locator.getUser();
        if (user == null) {
            return null;
        }
        userName = user.getUserName();
        this.addKey(userName, buffer);
        this.addKey(locator.getMediaType(), buffer);
        this.addKey(locator.getLanguage(), buffer);
        this.addKey(locator.getCountry(), buffer);
        this.addKey(locator.getName(), buffer);
        return buffer.toString();
    }

    private void addKey(String key, StringBuffer buffer) {
        if (key != null && key.length() > 0) {
            buffer.append("_").append(key);
        }
    }

    public ALLocalizationTool getLocalizationTool() {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            Object obj = request.getAttribute(LOCALIZATION_PREFIX);
            if (obj != null) {
                return (ALLocalizationTool)((Object)obj);
            }
            return null;
        }
        return null;
    }

    public void setLocalizationTool(ALLocalizationTool tool) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            request.setAttribute(LOCALIZATION_PREFIX, (Object)tool);
        }
    }
}

