/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.http;

import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALEipConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;

public class ALCometServlet
extends HttpServlet
implements CometProcessor {
    private static final long serialVersionUID = -3319969086920456957L;
    public static final String KEY_MESSAGE_SENDER = "com.aimluck.eip.http.ALCometServlet.MessageSender";
    protected transient ConcurrentHashMap<HttpServletResponse, String> connections = null;
    protected transient MessageSender sender = null;

    public void init() {
        this.connections = new ConcurrentHashMap();
        this.sender = new MessageSender();
        this.sender.setDaemon(true);
        this.sender.start();
        this.getServletContext().setAttribute(KEY_MESSAGE_SENDER, (Object)this.sender);
    }

    public void destroy() {
        this.sender.quit();
        this.sender = null;
        this.connections.clear();
    }

    public void event(CometEvent event) throws IOException, ServletException {
        try {
            HttpServletRequest request = event.getHttpServletRequest();
            HttpServletResponse response = event.getHttpServletResponse();
            ALBaseUser user = this.getUser(request);
            if (user == null) {
                this.close(response);
                event.close();
                return;
            }
            switch (event.getEventType()) {
                case BEGIN: {
                    this.open(request, response);
                    event.setTimeout(3600000);
                    break;
                }
                case READ: {
                    this.open(request, response);
                    event.setTimeout(3600000);
                    break;
                }
                case END: {
                    this.close(response);
                    event.close();
                    break;
                }
                case ERROR: {
                    this.close(response);
                    event.close();
                    break;
                }
            }
        }
        catch (Throwable t) {
            this.log(t.getMessage(), t);
        }
    }

    protected void open(HttpServletRequest request, HttpServletResponse response) {
        ALBaseUser user = this.getUser(request);
        if (user != null) {
            this.connections.put(response, user.getUserName());
        }
    }

    protected void close(HttpServletResponse response) {
        try {
            if (!response.isCommitted()) {
                response.setContentType("text/json");
                response.setCharacterEncoding("UTF-8");
                ServletOutputStream os = response.getOutputStream();
                os.write("{}".getBytes(ALEipConstants.DEF_CONTENT_ENCODING));
                os.flush();
                os.close();
            }
        }
        catch (Throwable t) {
            this.log(t.getMessage(), t);
        }
        finally {
            try {
                this.connections.remove(response);
            }
            catch (Throwable ignore) {}
        }
    }

    protected ALBaseUser getUser(HttpServletRequest httpServletRequest) {
        try {
            HttpSession session = httpServletRequest.getSession(false);
            if (session == null) {
                return null;
            }
            return (ALBaseUser)((Object)session.getAttribute("turbine.user"));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public class MessageSender
    extends Thread {
        protected final List<Message> messages = new ArrayList<Message>();
        protected boolean running = true;

        public void quit() {
            this.running = false;
            this.messages.clear();
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void sendMessage(List<String> recipients, String message) {
            try {
                List<Message> list = this.messages;
                synchronized (list) {
                    this.messages.add(new Message(recipients, message));
                    this.messages.notify();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            block26: {
                block21: while (this.running != false) {
                    try {
                        if (this.messages.size() == 0) {
                            try {
                                var1_1 = this.messages;
                                // MONITORENTER : var1_1
                                this.messages.wait();
                                // MONITOREXIT : var1_1
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                        }
                        pendingMessages = null;
                        var2_4 = this.messages;
                        // MONITORENTER : this.messages
                        pendingMessages = this.messages.toArray(new Message[0]);
                        this.messages.clear();
                        // MONITOREXIT : var2_4
                        var2_4 = pendingMessages;
                        var3_6 = var2_4.length;
                        var4_7 = 0;
lbl21:
                        // 2 sources

                        while (true) {
                            if (var4_7 < var3_6) {
                                message = var2_4[var4_7];
                                iterator = ALCometServlet.this.connections.entrySet().iterator();
                                break block26;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Throwable var2_5) {}
                            continue block21;
                            break;
                        }
                    }
                    catch (Throwable t) {
                        ALCometServlet.this.log(t.getMessage(), t);
                    }
                }
                return;
            }
            while (iterator.hasNext()) {
                next = iterator.next();
                if (!message.getRecipients().contains(next.getValue())) continue;
                response = next.getKey();
                try {
                    if (response.isCommitted()) continue;
                    response.setContentType("text/json");
                    response.setCharacterEncoding("UTF-8");
                    os = response.getOutputStream();
                    os.write(message.getMessage().getBytes(ALEipConstants.DEF_CONTENT_ENCODING));
                    os.flush();
                    os.close();
                }
                catch (Throwable t) {
                    ALCometServlet.this.log(t.getMessage(), t);
                }
                finally {
                    try {
                        ALCometServlet.this.connections.remove(response);
                    }
                    catch (Throwable ignore) {}
                }
            }
            pendingMessages = null;
            ++var4_7;
            ** while (true)
        }
    }

    public static class Message {
        private final List<String> recipients;
        private final String message;

        public Message(List<String> recipients, String message) {
            this.recipients = recipients;
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public List<String> getRecipients() {
            return this.recipients;
        }
    }
}

