/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.orm;

import com.aimluck.eip.orm.access.CustomTransaction;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.CustomDBCPDataSourceFactory;
import org.apache.cayenne.conf.DBCPDataSourceFactory;
import org.apache.cayenne.conf.DataSourceFactoryDelegate;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;

public class Database {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)Database.class.getName());
    public static final String DEFAULT_ORG = "org001";
    protected static final String SHARED_DOMAIN = "SharedDomain";
    private static DBCPDataSourceFactory dataSourceFactory = null;

    public static <M> SelectQuery<M> query(Class<M> modelClass) {
        return new SelectQuery<M>(modelClass);
    }

    public static <M> SelectQuery<M> query(DataContext dataContext, Class<M> modelClass) {
        return new SelectQuery<M>(dataContext, modelClass);
    }

    public static <M> SelectQuery<M> query(Class<M> modelClass, Expression exp) {
        return new SelectQuery<M>(modelClass, exp);
    }

    public static <M> SelectQuery<M> query(DataContext dataContext, Class<M> modelClass, Expression exp) {
        return new SelectQuery<M>(dataContext, modelClass, exp);
    }

    public static <M> SQLTemplate<M> sql(Class<M> modelClass, String sql) {
        return new SQLTemplate<M>(modelClass, sql);
    }

    public static <M> SQLTemplate<M> sql(DataContext dataContext, Class<M> modelClass, String sql) {
        return new SQLTemplate<M>(dataContext, modelClass, sql);
    }

    public static <M> M get(Class<M> modelClass, Object primaryKey) {
        return Database.get(DataContext.getThreadDataContext(), modelClass, primaryKey);
    }

    public static <M> M get(DataContext dataContext, Class<M> modelClass, Object primaryKey) {
        Database.beginTransaction(dataContext);
        return (M)DataObjectUtils.objectForPK((ObjectContext)dataContext, modelClass, (Object)primaryKey);
    }

    public static <M> M get(Class<M> modelClass, String key, Object value) {
        return Database.get(DataContext.getThreadDataContext(), modelClass, key, value);
    }

    public static <M> M get(DataContext dataContext, Class<M> modelClass, String key, Object value) {
        Database.beginTransaction(dataContext);
        return (M)dataContext.refetchObject(new ObjectId(modelClass.getSimpleName(), key, value));
    }

    public static <M> M create(Class<M> modelClass) {
        return Database.create(DataContext.getThreadDataContext(), modelClass);
    }

    public static <M> M create(DataContext dataContext, Class<M> modelClass) {
        return (M)dataContext.createAndRegisterNewObject(modelClass);
    }

    public static void delete(Persistent target) {
        Database.delete(DataContext.getThreadDataContext(), target);
    }

    public static void delete(DataContext dataContext, Persistent target) {
        dataContext.deleteObject(target);
    }

    public static void deleteAll(List<?> target) {
        Database.deleteAll(DataContext.getThreadDataContext(), target);
    }

    public static void deleteAll(DataContext dataContext, List<?> target) {
        dataContext.deleteObjects(target);
    }

    public static void deleteAll(DataObject ... target) {
        Database.deleteAll(DataContext.getThreadDataContext(), target);
    }

    public static void deleteAll(DataContext dataContext, DataObject ... target) {
        dataContext.deleteObjects(Arrays.asList(target));
    }

    public static void commit() {
        Database.commit(DataContext.getThreadDataContext());
    }

    public static void commit(DataContext dataContext) {
        Database.beginTransaction(dataContext);
        dataContext.commitChanges();
        Transaction threadTransaction = Transaction.getThreadTransaction();
        if (threadTransaction != null) {
            try {
                threadTransaction.commit();
            }
            catch (IllegalStateException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (CayenneException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                Transaction.bindThreadTransaction(null);
            }
        }
    }

    public static void rollback() {
        Database.rollback(DataContext.getThreadDataContext());
    }

    public static void rollback(DataContext dataContext) {
        try {
            Database.beginTransaction(dataContext);
            dataContext.rollbackChanges();
        }
        catch (Throwable t) {
            logger.warn((Object)"[Database] rollback", t);
        }
    }

    public static Object getFromDataRow(DataRow dataRow, Object key) {
        String lowerKey = ((String)key).toLowerCase();
        if (dataRow.containsKey((Object)lowerKey)) {
            return dataRow.get((Object)lowerKey);
        }
        return dataRow.get((Object)((String)key).toUpperCase());
    }

    public static <M> M objectFromRowData(DataRow dataRow, Class<M> rootClass) {
        try {
            M model = rootClass.newInstance();
            CayenneDataObject obj = (CayenneDataObject)model;
            ObjEntity objEntity = DataContext.getThreadDataContext().getEntityResolver().lookupObjEntity((Persistent)obj);
            ObjectId objId = Database.createObjectId(objEntity.getName(), dataRow, objEntity.getDbEntity());
            if (objId != null) {
                obj.setObjectId(objId);
            }
            for (ObjAttribute objAttribute : objEntity.getAttributes()) {
                DbAttribute dbAttribute = objAttribute.getDbAttribute();
                Object value = Database.getFromDataRow(dataRow, dbAttribute.getName());
                if (value == null) continue;
                obj.writeProperty(objAttribute.getName(), value);
            }
            return model;
        }
        catch (InstantiationException ignore) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static ObjectId createObjectId(String entityName, DataRow dataRow, DbEntity entity) {
        List pk = entity.getPrimaryKey();
        if (pk.size() == 1) {
            DbAttribute attribute = (DbAttribute)pk.get(0);
            String key = attribute.getName();
            Object val = Database.getFromDataRow(dataRow, key);
            if (val == null) {
                return null;
            }
            return new ObjectId(entityName, attribute.getName(), val);
        }
        HashMap<String, Object> idMap = new HashMap<String, Object>(pk.size() * 2);
        for (DbAttribute attribute : pk) {
            String key = attribute.getName();
            Object val = Database.getFromDataRow(dataRow, key);
            if (val == null) {
                return null;
            }
            idMap.put(attribute.getName(), val);
        }
        return new ObjectId(entityName, idMap);
    }

    public static String getDomainName() {
        try {
            return DataContext.getThreadDataContext().getParentDataDomain().getName();
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public static DataContext createDataContext(String orgId) throws Exception {
        DataDomain dataDomain = Configuration.getSharedConfiguration().getDomain(SHARED_DOMAIN);
        DataDomain destDataDomain = new DataDomain(orgId, dataDomain.getProperties());
        destDataDomain.setEntityResolver(dataDomain.getEntityResolver());
        destDataDomain.setEventManager(dataDomain.getEventManager());
        destDataDomain.setTransactionDelegate(dataDomain.getTransactionDelegate());
        DataNode dataNode = new DataNode(orgId + "domainNode");
        dataNode.setDataMaps(dataDomain.getDataMaps());
        dataSourceFactory.initializeWithParentConfiguration(Configuration.getSharedConfiguration());
        DataSource dataSource = dataSourceFactory.getDataSource("datasource/dbcp-" + orgId + ".properties");
        dataNode.setDataSource(dataSource);
        dataNode.setAdapter((DbAdapter)new AutoAdapter(dataSource));
        destDataDomain.addNode(dataNode);
        return destDataDomain.createDataContext();
    }

    public static void tearDown() {
        Transaction threadTransaction = Transaction.getThreadTransaction();
        if (threadTransaction != null) {
            try {
                threadTransaction.rollback();
            }
            catch (IllegalStateException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (CayenneException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable t) {
                logger.warn((Object)t.getMessage(), t);
            }
            finally {
                Transaction.bindThreadTransaction(null);
            }
        }
        if (dataSourceFactory instanceof DataSourceFactoryDelegate) {
            ((DataSourceFactoryDelegate)dataSourceFactory).tearDown();
        }
        DataContext.bindThreadDataContext(null);
    }

    public static boolean isJdbcPostgreSQL() {
        DataContext dataContext = DataContext.getThreadDataContext();
        String adapterName = null;
        try {
            adapterName = ((AutoAdapter)dataContext.getParentDataDomain().getNode(Database.getDomainName() + "domainNode").getAdapter()).getAdapter().getClass().getName();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return adapterName != null && adapterName.endsWith("PostgresAdapter");
    }

    public static boolean isJdbcMySQL() {
        DataContext dataContext = DataContext.getThreadDataContext();
        String adapterName = null;
        try {
            adapterName = ((AutoAdapter)dataContext.getParentDataDomain().getNode(Database.getDomainName() + "domainNode").getAdapter()).getAdapter().getClass().getName();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return adapterName != null && adapterName.endsWith("MySQLAdapter");
    }

    protected static DBCPDataSourceFactory createDataSourceFactory() {
        String property = System.getProperty("com.aimluck.eip.orm.DataSourceFactory");
        if (property == null || property.isEmpty()) {
            return new CustomDBCPDataSourceFactory();
        }
        try {
            Class<?> forName = Class.forName(property);
            DBCPDataSourceFactory instance = (DBCPDataSourceFactory)forName.newInstance();
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void initialize(ServletContext servletContext) {
        String property = servletContext.getInitParameter("com.aimluck.eip.orm.DataSourceFactory");
        if (property == null || property.isEmpty()) {
            dataSourceFactory = new CustomDBCPDataSourceFactory();
        } else {
            try {
                Class<?> forName = Class.forName(property);
                dataSourceFactory = (DBCPDataSourceFactory)forName.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void beginTransaction(DataContext dataContext) {
        boolean res = JetspeedResources.getBoolean((String)"aipo.jdbc.aggregateTransaction");
        if (!res) {
            return;
        }
        Transaction tx = Transaction.getThreadTransaction();
        if (tx == null) {
            CustomTransaction ctx = new CustomTransaction();
            ctx.begin();
            Transaction.bindThreadTransaction(ctx);
        }
    }

    public static String castToIntRawColumn(String column) {
        if (Database.isJdbcMySQL()) {
            return "CAST(" + column + " AS UNSIGNED)";
        }
        if (Database.isJdbcPostgreSQL()) {
            return "CAST(" + column + " AS INT)";
        }
        return column;
    }

    private Database() {
    }
}

