/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.orm.access;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.Transaction;

public class CustomTransaction
extends Transaction {
    @Override
    public void begin() {
        QueryLogger.logBeginTransaction((String)"transaction started.");
    }

    @Override
    public void commit() throws IllegalStateException, SQLException, CayenneException {
        try {
            this.processCommit();
            if (this.delegate != null) {
                this.delegate.didCommit((Transaction)this);
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void rollback() throws IllegalStateException, SQLException, CayenneException {
        try {
            this.processRollback();
            if (this.delegate != null) {
                this.delegate.didRollback((Transaction)this);
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public boolean addConnection(String name, Connection connection) throws SQLException {
        if (super.addConnection(name, connection)) {
            if (connection.getAutoCommit()) {
                try {
                    connection.setAutoCommit(false);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    protected void close() {
        if (this.connections == null || this.connections.isEmpty()) {
            return;
        }
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            try {
                ((Connection)it.next()).close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected void processCommit() throws SQLException, CayenneException {
        if (this.connections != null && this.connections.size() > 0) {
            Throwable deferredException = null;
            for (Connection connection : this.connections.values()) {
                try {
                    if (deferredException == null) {
                        connection.commit();
                        continue;
                    }
                    connection.rollback();
                }
                catch (Throwable th) {
                    deferredException = th;
                }
            }
            if (deferredException != null) {
                QueryLogger.logRollbackTransaction((String)"transaction rolledback.");
                if (deferredException instanceof SQLException) {
                    throw (SQLException)deferredException;
                }
                throw new CayenneException(deferredException);
            }
            QueryLogger.logCommitTransaction((String)"transaction committed.");
        }
    }

    protected void processRollback() throws SQLException, CayenneException {
        if (this.connections != null && this.connections.size() > 0) {
            Throwable deferredException = null;
            for (Connection connection : this.connections.values()) {
                try {
                    if (connection.isClosed()) continue;
                    connection.rollback();
                }
                catch (Throwable th) {
                    deferredException = th;
                }
            }
            if (deferredException != null) {
                if (deferredException instanceof SQLException) {
                    throw (SQLException)deferredException;
                }
                throw new CayenneException(deferredException);
            }
            QueryLogger.logRollbackTransaction((String)"transaction rolledback.");
        }
    }
}

