/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.psmlmanager.db;

import com.aimluck.eip.cayenne.om.account.JetspeedGroupProfile;
import com.aimluck.eip.cayenne.om.account.JetspeedRoleProfile;
import com.aimluck.eip.cayenne.om.account.JetspeedUserProfile;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.orm.Database;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.DeleteQuery;
import org.apache.cayenne.query.QualifiedQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.profile.BasePSMLDocument;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.QueryLocator;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedGroupFactory;
import org.apache.jetspeed.om.security.JetspeedRoleFactory;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.JetspeedUserFactory;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.psmlmanager.PsmlImporter;
import org.apache.jetspeed.services.psmlmanager.PsmlManagerService;
import org.apache.jetspeed.services.psmlmanager.db.DBUtils;
import org.apache.jetspeed.services.psmlmanager.db.DatabasePsmlManager;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.exolab.castor.mapping.Mapping;
import org.xml.sax.InputSource;

public class CayenneDatabasePsmlManagerService
extends TurbineBaseService
implements DatabasePsmlManager {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CayenneDatabasePsmlManagerService.class.getName());
    private final Map<String, PSMLDocument> psmlCache = new HashMap<String, PSMLDocument>();
    private CacheRefresher refresher = null;
    private long refreshRate;
    private static final String REFRESH_RATE = "refresh-rate";
    private static final long DEFAULT_REFRESH_RATE = 28800000L;
    private boolean cachingOn;
    private static final String CACHING_ON = "caching-on";
    private static final boolean DEFAULT_CACHING_ON = false;
    private static final String POOL_NAME = "database";
    public static final String DEFAULT_MAPPING = "${webappRoot}/WEB-INF/conf/psml-mapping.xml";
    String mapFile = null;
    private Mapping mapping = null;
    private String poolName = null;

    public void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        logger.info((Object)"Initializing CayenneDatabasePsmlManagerService...");
        this.initConfiguration(conf);
        logger.info((Object)"Done initializing CayenneDatabasePsmlManagerService.");
    }

    private void initConfiguration(ServletConfig conf) throws InitializationException {
        TurbineServices.getInstance().initService("ServletService", (Object)conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("PsmlManager");
        try {
            String value = serviceConf.getString(REFRESH_RATE);
            this.refreshRate = 28800000L;
            try {
                this.refreshRate = Long.parseLong(value);
            }
            catch (Exception e) {
                logger.warn((Object)"CayenneDatabasePsmlManagerService: error in refresh-rate configuration: using default");
            }
            this.poolName = serviceConf.getString(POOL_NAME);
            value = serviceConf.getString(CACHING_ON);
            this.cachingOn = false;
            try {
                this.cachingOn = value.equals("true");
            }
            catch (Exception e) {
                logger.warn((Object)"CayenneDatabasePsmlManagerService: error in caching-on configuration: using default");
            }
            this.mapFile = serviceConf.getString("mapping", DEFAULT_MAPPING);
            this.mapFile = TurbineServlet.getRealPath((String)this.mapFile);
            this.loadMapping();
        }
        catch (Throwable t) {
            logger.error((Object)((Object)((Object)this) + ".init:"), t);
            throw new InitializationException("Exception initializing CayenneDatabasePsmlManagerService" + t);
        }
        if (this.cachingOn) {
            this.refresher = new CacheRefresher();
            this.refresher.start();
        }
    }

    public void init() throws InitializationException {
        this.setInit(true);
        try {
            PsmlManagerService exporterService = (PsmlManagerService)TurbineServices.getInstance().getService("PsmlImportManager");
            PsmlImporter importer = new PsmlImporter();
            importer.run(exporterService, (PsmlManagerService)this);
        }
        catch (Exception e) {
            logger.warn((Object)"CayenneDatabasePsmlManagerService.init: exception while importing:", (Throwable)e);
        }
    }

    protected void loadMapping() throws InitializationException {
        if (this.mapFile != null) {
            File map = new File(this.mapFile);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loading psml mapping file " + this.mapFile));
            }
            if (map.exists() && map.isFile() && map.canRead()) {
                try {
                    this.mapping = new Mapping();
                    InputSource is = new InputSource(new FileReader(map));
                    is.setSystemId(this.mapFile);
                    this.mapping.loadMapping(is);
                }
                catch (Exception e) {
                    logger.error((Object)"Error in psml mapping creation", (Throwable)e);
                    throw new InitializationException("Error in mapping", (Throwable)e);
                }
            } else {
                throw new InitializationException("PSML Mapping not found or not a file or unreadable: " + this.mapFile);
            }
        }
    }

    public void shutdown() {
        if (this.refresher != null) {
            this.refresher.setDone(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String locatorToString(ProfileLocator locator) {
        StringBuffer keybuf = new StringBuffer();
        JetspeedUser user = locator.getUser();
        Role role = locator.getRole();
        Group group = locator.getGroup();
        String name = locator.getName();
        String mediaType = locator.getMediaType();
        String country = locator.getCountry();
        String language = locator.getLanguage();
        CayenneDatabasePsmlManagerService cayenneDatabasePsmlManagerService = this;
        synchronized (cayenneDatabasePsmlManagerService) {
            if (user != null) {
                keybuf.append("User:").append(user.getUserName());
            } else if (group != null) {
                keybuf.append("Group:").append(group.getName());
            } else if (role != null) {
                keybuf.append("Role:").append(role.getName());
            }
            if (name != null) {
                keybuf.append('$').append("Page:").append(name);
            }
            if (mediaType != null) {
                keybuf.append('$').append("MediaType:").append(mediaType);
            }
            if (country != null && !country.equals("-1")) {
                keybuf.append('$').append("Country:").append(country);
            }
            if (language != null && !language.equals("-1")) {
                keybuf.append('$').append("Language:").append(language);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CayenneDatabasePsmlManagerService: Returning locator string: " + keybuf.toString()));
        }
        return keybuf.toString();
    }

    private ProfileLocator stringToLocator(String locstr) throws Exception {
        ProfileLocator locator = Profiler.createLocator();
        String entity = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CayenneDatabasePsmlManagerService: Creating locator for string: " + locstr));
        }
        StringTokenizer dollarTokens = new StringTokenizer(locstr, "$");
        while (dollarTokens.hasMoreTokens()) {
            String dollarToken = dollarTokens.nextToken().trim();
            StringTokenizer colonTokens = new StringTokenizer(dollarToken, ":");
            String colonToken = colonTokens.nextToken();
            if (colonToken.equals("User")) {
                entity = colonTokens.nextToken().trim();
                locator.setUser(JetspeedSecurity.getUser((String)entity));
                continue;
            }
            if (colonToken.equals("Group")) {
                entity = colonTokens.nextToken().trim();
                locator.setGroup(JetspeedSecurity.getGroup((String)entity));
                continue;
            }
            if (colonToken.equals("Role")) {
                entity = colonTokens.nextToken().trim();
                locator.setRole(JetspeedSecurity.getRole((String)entity));
                continue;
            }
            if (colonToken.equals("Page")) {
                entity = colonTokens.nextToken().trim();
                locator.setName(entity);
                continue;
            }
            if (colonToken.equals("MediaType")) {
                entity = colonTokens.nextToken().trim();
                locator.setMediaType(entity);
                continue;
            }
            if (colonToken.equals("Country")) {
                entity = colonTokens.nextToken().trim();
                locator.setCountry(entity);
                continue;
            }
            if (!colonToken.equals("Language")) continue;
            entity = colonTokens.nextToken().trim();
            locator.setLanguage(entity);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CayenneDatabasePsmlManagerService: Returning locator for string: " + this.locatorToString(locator)));
        }
        return locator;
    }

    public PSMLDocument getDocument(String name) {
        logger.warn((Object)"*** NOT SUPPORTED: GETDOC FROM DATABASE PSML MANAGER!!!");
        return null;
    }

    public boolean saveDocument(String fileOrUrl, PSMLDocument doc) {
        logger.warn((Object)"*** NOT SUPPORTED: SAVING DOC FROM DATABASE PSML MANAGER!!!");
        return false;
    }

    public boolean saveDocument(PSMLDocument doc) {
        logger.warn((Object)"*** NOT SUPPORTED: SAVING DOC FROM DATABASE PSML MANAGER!!!");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PSMLDocument getDocument(ProfileLocator locator) {
        if (locator == null) {
            String message = "PSMLManager: Must specify a locator";
            logger.warn((Object)("CayenneDatabasePsmlManagerService.getDocument: " + message));
            throw new IllegalArgumentException(message);
        }
        PSMLDocument psmldoc = null;
        String locStr = this.locatorToString(locator);
        boolean inCache = false;
        if (this.cachingOn) {
            Map<String, PSMLDocument> map = this.psmlCache;
            synchronized (map) {
                inCache = this.psmlCache.containsKey(locStr);
                if (inCache) {
                    psmldoc = this.psmlCache.get(locStr);
                }
            }
            if (inCache) {
                return psmldoc;
            }
        }
        try {
            return this.refresh(locator);
        }
        catch (Exception e) {
            logger.warn((Object)"CayenneDatabasePsmlManagerService.getDocument: exception:", (Throwable)e);
            throw new RuntimeException("Could not get profile from DB");
        }
    }

    public PSMLDocument createDocument(Profile profile) {
        return this.createOrSaveDocument(profile, 1);
    }

    public boolean store(Profile profile) {
        return this.createOrSaveDocument(profile, 2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PSMLDocument createOrSaveDocument(Profile profile, int operation) {
        if (profile == null) {
            String message = "PSMLManager: Must specify a profile";
            logger.warn((Object)("CayenneDatabasePsmlManagerService.createOrSaveDocument: " + message));
            throw new IllegalArgumentException(message);
        }
        JetspeedUser user = profile.getUser();
        Role role = profile.getRole();
        Group group = profile.getGroup();
        String tableName = null;
        try {
            Object object;
            DataContext dataContext = DataContext.getThreadDataContext();
            if (user != null) {
                tableName = "JETSPEED_USER_PROFILE";
                if (operation == 1) {
                    this.insertJetspeedUserProfilePeer(dataContext, profile);
                } else if (operation == 2) {
                    this.updateJetspeedUserProfilePeer(dataContext, profile);
                }
            } else if (role != null) {
                tableName = "JETSPEED_ROLE_PROFILE";
                if (operation == 1) {
                    this.insertJetspeedRoleProfilePeer(dataContext, profile);
                } else if (operation == 2) {
                    this.updateJetspeedRoleProfilePeer(dataContext, profile);
                }
            } else if (group != null) {
                tableName = "JETSPEED_GROUP_PROFILE";
                if (operation == 1) {
                    this.insertJetspeedGroupProfilePeer(dataContext, profile);
                } else if (operation == 2) {
                    this.updateJetspeedGroupProfilePeer(dataContext, profile);
                }
            }
            if (this.cachingOn) {
                object = this.psmlCache;
                synchronized (object) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("CayenneDatabasePsmlManagerService.createOrSaveDocument: caching document: profile: " + this.locatorToString((ProfileLocator)profile)));
                    }
                    this.psmlCache.put(this.locatorToString((ProfileLocator)profile), profile.getDocument());
                }
            }
            object = profile.getDocument();
            return object;
        }
        catch (Exception e) {
            Database.rollback();
            logger.warn((Object)("CayenneDatabasePsmlManagerService.createOrSaveDocument: profile: " + profile + " tableName: " + tableName), (Throwable)e);
            throw new RuntimeException("Could not create new profile in DB");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocument(ProfileLocator locator) {
        block13: {
            if (locator == null) {
                String message = "PSMLManager: Must specify a locator";
                logger.warn((Object)("CayenneDatabasePsmlManagerService.removeDocument: " + message));
                throw new IllegalArgumentException(message);
            }
            JetspeedUser user = locator.getUser();
            Role role = locator.getRole();
            Group group = locator.getGroup();
            String tableName = null;
            try {
                DataContext dataContext = DataContext.getThreadDataContext();
                if (user != null) {
                    this.deleteJetspeedUserProfilePeer(dataContext, locator);
                    tableName = "JETSPEED_USER_PROFILE";
                } else if (role != null) {
                    this.deleteJetspeedRoleProfilePeer(dataContext, locator);
                    tableName = "JETSPEED_ROLE_PROFILE";
                } else if (group != null) {
                    this.deleteJetspeedGroupProfilePeer(dataContext, locator);
                    tableName = "JETSPEED_GROUP_PROFILE";
                }
                if (!this.cachingOn) break block13;
                Map<String, PSMLDocument> map = this.psmlCache;
                synchronized (map) {
                    this.psmlCache.remove(this.locatorToString(locator));
                }
            }
            catch (Exception e) {
                logger.warn((Object)("CayenneDatabasePsmlManagerService.removeDocument: profile: " + this.locatorToString(locator) + " tableName: " + tableName), (Throwable)e);
                throw new RuntimeException("Could not delete profile for given locator from DB");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Profile> query(QueryLocator locator) {
        if (locator == null) {
            String message = "PSMLManager: Must specify a locator";
            logger.warn((Object)("CayenneDatabasePsmlManagerService.query: " + message));
            throw new IllegalArgumentException(message);
        }
        try {
            DataContext dataContext = DataContext.getThreadDataContext();
            List<JetspeedUserProfile> userData = null;
            List<JetspeedGroupProfile> groupData = null;
            List<JetspeedRoleProfile> roleData = null;
            int queryMode = locator.getQueryMode();
            List<Object> list = new ArrayList<Profile>();
            switch (queryMode) {
                case 1: {
                    userData = this.selectJetspeedUserProfilePeer(dataContext, (ProfileLocator)locator, true);
                    if (userData == null) break;
                    list = this.getProfiles(userData);
                    break;
                }
                case 4: {
                    groupData = this.selectJetspeedGroupProfilePeer(dataContext, (ProfileLocator)locator, true);
                    if (groupData == null) break;
                    list = this.getProfiles(groupData);
                    break;
                }
                case 2: {
                    roleData = this.selectJetspeedRoleProfilePeer(dataContext, (ProfileLocator)locator, true);
                    if (roleData == null) break;
                    list = this.getProfiles(roleData);
                    break;
                }
                default: {
                    userData = this.selectJetspeedUserProfilePeer(dataContext, (ProfileLocator)locator, true);
                    if (userData != null) {
                        list.addAll(this.getProfiles(userData));
                    }
                    if ((groupData = this.selectJetspeedGroupProfilePeer(dataContext, (ProfileLocator)locator, true)) != null) {
                        list.addAll(this.getProfiles(groupData));
                    }
                    if ((roleData = this.selectJetspeedRoleProfilePeer(dataContext, (ProfileLocator)locator, true)) == null) break;
                    list.addAll(this.getProfiles(roleData));
                }
            }
            Iterator<Profile> iterator = list.iterator();
            return iterator;
        }
        catch (Exception e) {
            logger.warn((Object)"CayenneDatabasePsmlManagerService.query: exception", (Throwable)e);
        }
        return new ArrayList().iterator();
    }

    private List<Profile> getProfiles(List<?> data) {
        ArrayList<Profile> list = new ArrayList<Profile>();
        for (int i = 0; i < data.size(); ++i) {
            Object obj = data.get(i);
            Portlets portlets = null;
            if (obj instanceof JetspeedUserProfile) {
                portlets = DBUtils.bytesToPortlets((byte[])((JetspeedUserProfile)obj).getProfile(), (Mapping)this.mapping);
                list.add(this.createUserProfile((JetspeedUserProfile)obj, portlets));
                continue;
            }
            if (obj instanceof JetspeedGroupProfile) {
                portlets = DBUtils.bytesToPortlets((byte[])((JetspeedGroupProfile)obj).getProfile(), (Mapping)this.mapping);
                list.add(this.createGroupProfile((JetspeedGroupProfile)obj, portlets));
                continue;
            }
            if (!(obj instanceof JetspeedRoleProfile)) continue;
            portlets = DBUtils.bytesToPortlets((byte[])((JetspeedRoleProfile)obj).getProfile(), (Mapping)this.mapping);
            list.add(this.createRoleProfile((JetspeedRoleProfile)obj, portlets));
        }
        return list;
    }

    private PSMLDocument getPSMLDocument(String page, Portlets portlets) {
        BasePSMLDocument psmldoc = new BasePSMLDocument();
        psmldoc.setName(page);
        psmldoc.setPortlets(portlets);
        return psmldoc;
    }

    public PSMLDocument getDocument(List locators) {
        if (locators == null) {
            String message = "PSMLManager: Must specify a list of locators";
            logger.warn((Object)("CayenneDatabasePsmlManagerService.getDocument: " + message));
            throw new IllegalArgumentException(message);
        }
        for (int i = 0; i < locators.size(); ++i) {
            PSMLDocument psmldoc = this.getDocument((ProfileLocator)locators.get(i));
            if (psmldoc == null) continue;
            return psmldoc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PSMLDocument refresh(ProfileLocator locator) {
        if (locator == null) {
            String message = "PSMLManager: Must specify a locator";
            logger.warn((Object)("CayenneDatabasePsmlManagerService.refresh: " + message));
            throw new IllegalArgumentException(message);
        }
        JetspeedUser user = locator.getUser();
        Role role = locator.getRole();
        Group group = locator.getGroup();
        String tableName = null;
        List<JetspeedUserProfile> records = null;
        Portlets portlets = null;
        PSMLDocument psmldoc = null;
        String page = null;
        DataContext dataContext = DataContext.getThreadDataContext();
        if (user != null) {
            tableName = "JETSPEED_USER_PROFILE";
            records = this.selectJetspeedUserProfilePeer(dataContext, locator, false);
            for (JetspeedUserProfile jetspeedUserProfile : records) {
                page = jetspeedUserProfile.getPage();
                portlets = DBUtils.bytesToPortlets((byte[])jetspeedUserProfile.getProfile(), (Mapping)this.mapping);
            }
        } else if (role != null) {
            tableName = "JETSPEED_ROLE_PROFILE";
            records = this.selectJetspeedRoleProfilePeer(dataContext, locator, false);
            for (JetspeedRoleProfile jetspeedRoleProfile : records) {
                page = jetspeedRoleProfile.getPage();
                portlets = DBUtils.bytesToPortlets((byte[])jetspeedRoleProfile.getProfile(), (Mapping)this.mapping);
            }
        } else if (group != null) {
            tableName = "JETSPEED_GROUP_PROFILE";
            records = this.selectJetspeedGroupProfilePeer(dataContext, locator, false);
            for (JetspeedGroupProfile jetspeedGroupProfile : records) {
                page = jetspeedGroupProfile.getPage();
                portlets = DBUtils.bytesToPortlets((byte[])jetspeedGroupProfile.getProfile(), (Mapping)this.mapping);
            }
        }
        if (page != null && portlets != null) {
            psmldoc = this.getPSMLDocument(page, portlets);
            if (this.cachingOn) {
                Map<String, PSMLDocument> map = this.psmlCache;
                synchronized (map) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("CayenneDatabasePsmlManagerService.refresh: caching document: profile: " + this.locatorToString(locator)));
                    }
                    this.psmlCache.put(this.locatorToString(locator), psmldoc);
                }
            }
            return psmldoc;
        }
        if (this.cachingOn) {
            this.psmlCache.put(this.locatorToString(locator), null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("CayenneDatabasePsmlManagerService.refresh: caching 'document not found': profile: " + this.locatorToString(locator)));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CayenneDatabasePsmlManagerService.refresh: no document found: profile: " + this.locatorToString(locator)));
        }
        return null;
    }

    public void removeUserDocuments(JetspeedUser user) {
        try {
            DataContext dataContext = DataContext.getThreadDataContext();
            if (user != null) {
                this.deleteJetspeedUserProfilePeer(dataContext, user);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"CayenneDatabasePsmlManagerService.removeUserDocuments: exception:", (Throwable)e);
            throw new RuntimeException("Could not delete documents for given user from DB");
        }
    }

    public void removeRoleDocuments(Role role) {
        try {
            if (role != null) {
                DataContext dataContext = DataContext.getThreadDataContext();
                this.deleteJetspeedRoleProfilePeer(dataContext, role);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"CayenneDatabasePsmlManagerService.removeRoleDocuments: exception:", (Throwable)e);
            throw new RuntimeException("Could not delete documents for given role from DB");
        }
    }

    public void removeGroupDocuments(Group group) {
        try {
            if (group != null) {
                DataContext dataContext = DataContext.getThreadDataContext();
                this.deleteJetspeedGroupProfilePeer(dataContext, group);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"CayenneDatabasePsmlManagerService.removeGroupDocuments: exception:", (Throwable)e);
            throw new RuntimeException("Could not delete documents for given group from DB");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int export(PsmlManagerService consumer, QueryLocator locator) {
        Iterator<Profile> profiles = null;
        int count = 0;
        try {
            profiles = this.query(locator);
            while (profiles.hasNext()) {
                Profile profile = profiles.next();
                try {
                    consumer.createDocument(profile);
                    ++count;
                }
                catch (Exception ex) {
                    try {
                        consumer.store(profile);
                        ++count;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("CayenneDatabasePsmlManagerService.export: profile: " + profile), (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"CayenneDatabasePsmlManagerService.export: exception:", (Throwable)e);
        }
        return count;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public Profile createUserProfile(JetspeedUserProfile entity, Portlets portlets) {
        Profile profile = Profiler.createProfile();
        try {
            JetspeedUser user = JetspeedSecurity.getUser((String)entity.getUserName());
            if (null == user) {
                user = JetspeedUserFactory.getInstance();
                user.setUserName(entity.getUserName());
            }
            profile.setUser(user);
            profile.setMediaType(entity.getMediaType());
            profile.setLanguage(entity.getLanguage());
            profile.setCountry(entity.getCountry());
            profile.setName(entity.getPage());
            profile.setDocument(this.getPSMLDocument(entity.getPage(), portlets));
        }
        catch (JetspeedSecurityException e) {
            // empty catch block
        }
        return profile;
    }

    public Profile createGroupProfile(JetspeedGroupProfile entity, Portlets portlets) {
        Profile profile = Profiler.createProfile();
        try {
            Group group = JetspeedSecurity.getGroup((String)entity.getGroupName());
            if (null == group) {
                group = JetspeedGroupFactory.getInstance();
                group.setName(entity.getGroupName());
            }
            profile.setGroup(group);
            profile.setMediaType(entity.getMediaType());
            profile.setLanguage(entity.getLanguage());
            profile.setCountry(entity.getCountry());
            profile.setName(entity.getPage());
            profile.setDocument(this.getPSMLDocument(entity.getPage(), portlets));
        }
        catch (JetspeedSecurityException e) {
            // empty catch block
        }
        return profile;
    }

    public Profile createRoleProfile(JetspeedRoleProfile entity, Portlets portlets) {
        Profile profile = Profiler.createProfile();
        try {
            Role role = JetspeedSecurity.getRole((String)entity.getRoleName());
            if (null == role) {
                role = JetspeedRoleFactory.getInstance();
                role.setName(entity.getRoleName());
            }
            profile.setRole(role);
            profile.setMediaType(entity.getMediaType());
            profile.setLanguage(entity.getLanguage());
            profile.setCountry(entity.getCountry());
            profile.setName(entity.getPage());
            profile.setDocument(this.getPSMLDocument(entity.getPage(), portlets));
        }
        catch (JetspeedSecurityException e) {
            // empty catch block
        }
        return profile;
    }

    private void updateJetspeedGroupProfilePeer(DataContext dataContext, Profile profile) throws CayenneRuntimeException {
        JetspeedGroupProfile groupProfile = this.selectJetspeedGroupProfilePeer(dataContext, (ProfileLocator)profile, false).get(0);
        groupProfile.setGroupName(profile.getGroup().getName());
        groupProfile.setMediaType(profile.getMediaType());
        String language = profile.getLanguage();
        if (language != null && !language.equals("-1")) {
            groupProfile.setLanguage(language);
        } else {
            groupProfile.setLanguage(null);
        }
        String country = profile.getCountry();
        if (country != null && !country.equals("-1")) {
            groupProfile.setCountry(country);
        } else {
            groupProfile.setCountry(null);
        }
        String name = profile.getName();
        if (name == null || name.equals("")) {
            profile.setName("default.psml");
        } else if (!name.endsWith(".psml")) {
            profile.setName(name + ".psml");
        }
        groupProfile.setPage(profile.getName());
        groupProfile.setProfile(DBUtils.portletsToBytes((Portlets)profile.getDocument().getPortlets(), (Mapping)this.getMapping()));
        Database.commit(dataContext);
    }

    private void insertJetspeedGroupProfilePeer(DataContext dataContext, Profile profile) throws CayenneRuntimeException {
        JetspeedGroupProfile groupProfile = (JetspeedGroupProfile)dataContext.createAndRegisterNewObject(JetspeedGroupProfile.class);
        groupProfile.setGroupName(profile.getGroup().getName());
        groupProfile.setMediaType(profile.getMediaType());
        String language = profile.getLanguage();
        if (language != null && !language.equals("-1")) {
            groupProfile.setLanguage(language);
        } else {
            groupProfile.setLanguage(null);
        }
        String country = profile.getCountry();
        if (country != null && !country.equals("-1")) {
            groupProfile.setCountry(country);
        } else {
            groupProfile.setCountry(null);
        }
        String name = profile.getName();
        if (name == null || name.equals("")) {
            profile.setName("default.psml");
        } else if (!name.endsWith(".psml")) {
            profile.setName(name + ".psml");
        }
        groupProfile.setPage(profile.getName());
        groupProfile.setProfile(DBUtils.portletsToBytes((Portlets)profile.getDocument().getPortlets(), (Mapping)this.getMapping()));
        Database.commit(dataContext);
    }

    private void updateJetspeedRoleProfilePeer(DataContext dataContext, Profile profile) throws CayenneRuntimeException {
        JetspeedRoleProfile roleProfile = this.selectJetspeedRoleProfilePeer(dataContext, (ProfileLocator)profile, false).get(0);
        roleProfile.setRoleName(profile.getRole().getName());
        roleProfile.setMediaType(profile.getMediaType());
        String language = profile.getLanguage();
        if (language != null && !language.equals("-1")) {
            roleProfile.setLanguage(language);
        } else {
            roleProfile.setLanguage(null);
        }
        String country = profile.getCountry();
        if (country != null && !country.equals("-1")) {
            roleProfile.setCountry(country);
        } else {
            roleProfile.setCountry(null);
        }
        String name = profile.getName();
        if (name == null || name.equals("")) {
            profile.setName("default.psml");
        } else if (!name.endsWith(".psml")) {
            profile.setName(name + ".psml");
        }
        roleProfile.setPage(profile.getName());
        roleProfile.setProfile(DBUtils.portletsToBytes((Portlets)profile.getDocument().getPortlets(), (Mapping)this.getMapping()));
        Database.commit(dataContext);
    }

    private void insertJetspeedRoleProfilePeer(DataContext dataContext, Profile profile) throws CayenneRuntimeException {
        JetspeedRoleProfile roleProfile = (JetspeedRoleProfile)dataContext.createAndRegisterNewObject(JetspeedRoleProfile.class);
        roleProfile.setRoleName(profile.getRole().getName());
        roleProfile.setMediaType(profile.getMediaType());
        String language = profile.getLanguage();
        if (language != null && !language.equals("-1")) {
            roleProfile.setLanguage(language);
        } else {
            roleProfile.setLanguage(null);
        }
        String country = profile.getCountry();
        if (country != null && !country.equals("-1")) {
            roleProfile.setCountry(country);
        } else {
            roleProfile.setCountry(null);
        }
        String name = profile.getName();
        if (name == null || name.equals("")) {
            profile.setName("default.psml");
        } else if (!name.endsWith(".psml")) {
            profile.setName(name + ".psml");
        }
        roleProfile.setPage(profile.getName());
        roleProfile.setProfile(DBUtils.portletsToBytes((Portlets)profile.getDocument().getPortlets(), (Mapping)this.getMapping()));
        Database.commit(dataContext);
    }

    private void updateJetspeedUserProfilePeer(DataContext dataContext, Profile profile) throws CayenneRuntimeException {
        JetspeedUserProfile userProfile = this.selectJetspeedUserProfilePeer(dataContext, (ProfileLocator)profile, false).get(0);
        userProfile.setUserName(profile.getUser().getUserName());
        userProfile.setMediaType(profile.getMediaType());
        String language = profile.getLanguage();
        if (language != null && !language.equals("-1")) {
            userProfile.setLanguage(language);
        } else {
            userProfile.setLanguage(null);
        }
        String country = profile.getCountry();
        if (country != null && !country.equals("-1")) {
            userProfile.setCountry(country);
        } else {
            userProfile.setCountry(null);
        }
        String name = profile.getName();
        if (name == null || name.equals("")) {
            profile.setName("default.psml");
        } else if (!name.endsWith(".psml")) {
            profile.setName(name + ".psml");
        }
        userProfile.setPage(profile.getName());
        userProfile.setProfile(DBUtils.portletsToBytes((Portlets)profile.getDocument().getPortlets(), (Mapping)this.getMapping()));
        Database.commit(dataContext);
    }

    private void insertJetspeedUserProfilePeer(DataContext dataContext, Profile profile) throws CayenneRuntimeException {
        JetspeedUserProfile userProfile = Database.create(dataContext, JetspeedUserProfile.class);
        userProfile.setUserName(profile.getUser().getUserName());
        userProfile.setMediaType(profile.getMediaType());
        String language = profile.getLanguage();
        if (language != null && !language.equals("-1")) {
            userProfile.setLanguage(language);
        } else {
            userProfile.setLanguage(null);
        }
        String country = profile.getCountry();
        if (country != null && !country.equals("-1")) {
            userProfile.setCountry(country);
        } else {
            userProfile.setCountry(null);
        }
        String name = profile.getName();
        if (name == null || name.equals("")) {
            profile.setName("default.psml");
        } else if (!name.endsWith(".psml")) {
            profile.setName(name + ".psml");
        }
        userProfile.setPage(profile.getName());
        userProfile.setProfile(DBUtils.portletsToBytes((Portlets)profile.getDocument().getPortlets(), (Mapping)this.getMapping()));
        Database.commit(dataContext);
    }

    private void deleteJetspeedGroupProfilePeer(DataContext dataContext, ProfileLocator locator) throws CayenneRuntimeException {
        DeleteQuery deleteQuery = new DeleteQuery(JetspeedGroupProfile.class);
        CayenneDatabasePsmlManagerService.assignJetSpeedGroupProfileQuery(locator, (QualifiedQuery)deleteQuery);
        dataContext.performQuery((Query)deleteQuery);
    }

    private void deleteJetspeedRoleProfilePeer(DataContext dataContext, ProfileLocator locator) throws CayenneRuntimeException {
        DeleteQuery deleteQuery = new DeleteQuery(JetspeedRoleProfile.class);
        CayenneDatabasePsmlManagerService.assignJetSpeedRoleProfileQuery(locator, (QualifiedQuery)deleteQuery);
        dataContext.performQuery((Query)deleteQuery);
    }

    private void deleteJetspeedUserProfilePeer(DataContext dataContext, ProfileLocator locator) throws CayenneRuntimeException {
        DeleteQuery deleteQuery = new DeleteQuery(JetspeedUserProfile.class);
        CayenneDatabasePsmlManagerService.assignJetSpeedUserProfileQuery(locator, (QualifiedQuery)deleteQuery);
        dataContext.performQuery((Query)deleteQuery);
    }

    private List<JetspeedGroupProfile> selectJetspeedGroupProfilePeer(DataContext dataContext, ProfileLocator locator, boolean order) throws CayenneRuntimeException {
        SelectQuery query = new SelectQuery(JetspeedGroupProfile.class);
        CayenneDatabasePsmlManagerService.assignJetSpeedGroupProfileQuery(locator, (QualifiedQuery)query);
        if (order) {
            query.addOrdering("groupName", true);
            query.addOrdering("mediaType", true);
            query.addOrdering("language", true);
            query.addOrdering("country", true);
            query.addOrdering("page", true);
        }
        Database.beginTransaction(dataContext);
        List list = dataContext.performQuery((Query)query);
        return list;
    }

    private List<JetspeedRoleProfile> selectJetspeedRoleProfilePeer(DataContext dataContext, ProfileLocator locator, boolean order) throws CayenneRuntimeException {
        SelectQuery query = new SelectQuery(JetspeedRoleProfile.class);
        CayenneDatabasePsmlManagerService.assignJetSpeedRoleProfileQuery(locator, (QualifiedQuery)query);
        if (order && query instanceof SelectQuery) {
            query.addOrdering("roleName", true);
            query.addOrdering("mediaType", true);
            query.addOrdering("language", true);
            query.addOrdering("country", true);
            query.addOrdering("page", true);
        }
        Database.beginTransaction(dataContext);
        List list = dataContext.performQuery((Query)query);
        return list;
    }

    private List<JetspeedUserProfile> selectJetspeedUserProfilePeer(DataContext dataContext, ProfileLocator locator, boolean order) throws CayenneRuntimeException {
        Object obj = ALEipManager.getInstance().getUserProfile(locator);
        if (obj != null) {
            return (List)obj;
        }
        SelectQuery query = new SelectQuery(JetspeedUserProfile.class);
        CayenneDatabasePsmlManagerService.assignJetSpeedUserProfileQuery(locator, (QualifiedQuery)query);
        if (order) {
            query.addOrdering("userName", true);
            query.addOrdering("mediaType", true);
            query.addOrdering("language", true);
            query.addOrdering("country", true);
            query.addOrdering("page", true);
        }
        Database.beginTransaction(dataContext);
        List list = dataContext.performQuery((Query)query);
        ALEipManager.getInstance().setUserProfile(locator, list);
        return list;
    }

    private void deleteJetspeedUserProfilePeer(DataContext dataContext, JetspeedUser user) throws CayenneRuntimeException {
        DeleteQuery deleteQuery = new DeleteQuery(JetspeedUserProfile.class);
        Expression exp = ExpressionFactory.matchExp((String)"userName", (Object)user.getUserName());
        deleteQuery.andQualifier(exp);
        dataContext.performQuery((Query)deleteQuery);
    }

    private void deleteJetspeedRoleProfilePeer(DataContext dataContext, Role role) throws CayenneRuntimeException {
        DeleteQuery deleteQuery = new DeleteQuery(JetspeedRoleProfile.class);
        Expression exp = ExpressionFactory.matchExp((String)"roleName", (Object)role.getName());
        deleteQuery.andQualifier(exp);
        dataContext.performQuery((Query)deleteQuery);
    }

    private void deleteJetspeedGroupProfilePeer(DataContext dataContext, Group group) throws CayenneRuntimeException {
        DeleteQuery deleteQuery = new DeleteQuery(JetspeedGroupProfile.class);
        Expression exp = ExpressionFactory.matchExp((String)"groupName", (Object)group.getName());
        deleteQuery.andQualifier(exp);
        dataContext.performQuery((Query)deleteQuery);
    }

    private static QualifiedQuery assignJetSpeedUserProfileQuery(ProfileLocator locator, QualifiedQuery query) {
        Expression exp;
        String mediaType = locator.getMediaType();
        String language = locator.getLanguage();
        String country = locator.getCountry();
        String pageName = locator.getName();
        String userName = null;
        JetspeedUser user = locator.getUser();
        if (user != null) {
            userName = user.getUserName();
        }
        if (userName != null && userName.length() > 0) {
            exp = ExpressionFactory.matchExp((String)"userName", (Object)userName);
            query.andQualifier(exp);
        }
        if (pageName != null && pageName.length() > 0) {
            exp = ExpressionFactory.matchExp((String)"page", (Object)pageName);
            query.andQualifier(exp);
        }
        if (mediaType != null && mediaType.length() > 0) {
            exp = ExpressionFactory.matchExp((String)"mediaType", (Object)mediaType);
            query.andQualifier(exp);
        }
        if (language != null && language.length() > 0 && !language.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"language", (Object)language);
            query.andQualifier(exp);
        } else if (language != null && language.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"language", null);
            query.andQualifier(exp);
        }
        if (country != null && country.length() > 0 && !country.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"country", (Object)country);
            query.andQualifier(exp);
        } else if (country != null && country.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"country", null);
            query.andQualifier(exp);
        }
        return query;
    }

    private static QualifiedQuery assignJetSpeedRoleProfileQuery(ProfileLocator locator, QualifiedQuery query) {
        Expression exp;
        String mediaType = locator.getMediaType();
        String language = locator.getLanguage();
        String country = locator.getCountry();
        String pageName = locator.getName();
        String roleName = null;
        Role role = locator.getRole();
        if (role != null) {
            roleName = role.getName();
        }
        if (roleName != null && roleName.length() > 0) {
            exp = ExpressionFactory.matchExp((String)"roleName", (Object)roleName);
            query.andQualifier(exp);
        }
        if (pageName != null && pageName.length() > 0) {
            exp = ExpressionFactory.matchExp((String)"page", (Object)pageName);
            query.andQualifier(exp);
        }
        if (mediaType != null && mediaType.length() > 0) {
            exp = ExpressionFactory.matchExp((String)"mediaType", (Object)mediaType);
            query.andQualifier(exp);
        }
        if (language != null && language.length() > 0 && !language.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"language", (Object)language);
            query.andQualifier(exp);
        } else if (language != null && language.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"language", null);
            query.andQualifier(exp);
        }
        if (country != null && country.length() > 0 && !country.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"country", (Object)country);
            query.andQualifier(exp);
        } else if (country != null && country.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"country", null);
            query.andQualifier(exp);
        }
        return query;
    }

    private static QualifiedQuery assignJetSpeedGroupProfileQuery(ProfileLocator locator, QualifiedQuery query) {
        Expression exp;
        String mediaType = locator.getMediaType();
        String language = locator.getLanguage();
        String country = locator.getCountry();
        String pageName = locator.getName();
        String groupName = null;
        Group group = locator.getGroup();
        if (group != null) {
            groupName = group.getName();
        }
        if (groupName != null && groupName.length() > 0) {
            exp = ExpressionFactory.matchExp((String)"groupName", (Object)groupName);
            query.andQualifier(exp);
        }
        if (pageName != null && pageName.length() > 0) {
            exp = ExpressionFactory.matchExp((String)"page", (Object)pageName);
            query.andQualifier(exp);
        }
        if (mediaType != null && mediaType.length() > 0) {
            exp = ExpressionFactory.matchExp((String)"mediaType", (Object)mediaType);
            query.andQualifier(exp);
        }
        if (language != null && language.length() > 0 && !language.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"language", (Object)language);
            query.andQualifier(exp);
        } else if (language != null && language.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"language", null);
            query.andQualifier(exp);
        }
        if (country != null && country.length() > 0 && !country.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"country", (Object)country);
            query.andQualifier(exp);
        } else if (country != null && country.equals("-1")) {
            exp = ExpressionFactory.matchExp((String)"country", null);
            query.andQualifier(exp);
        }
        return query;
    }

    class CacheRefresher
    extends Thread {
        private boolean done = false;

        CacheRefresher() {
            this.setDaemon(true);
            this.setPriority(2);
        }

        void setDone(boolean done) {
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                try {
                    while (!this.done) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Cache Refresher thread sleeping now!");
                        }
                        CacheRefresher.sleep(CayenneDatabasePsmlManagerService.this.refreshRate);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Cache Refresher thread working now!");
                        }
                        try {
                            CacheRefresher cacheRefresher = this;
                            synchronized (cacheRefresher) {
                                for (String locator : CayenneDatabasePsmlManagerService.this.psmlCache.keySet()) {
                                    PSMLDocument doc = CayenneDatabasePsmlManagerService.this.refresh(CayenneDatabasePsmlManagerService.this.stringToLocator(locator));
                                    CayenneDatabasePsmlManagerService.this.psmlCache.put(locator, doc);
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.warn((Object)"CayenneDatabasePsmlManagerService.CacheRefresher: Error in cache refresher...", (Throwable)e);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug((Object)"CayenneDatabasePsmlManagerService.CacheRefresher: recieved interruption, aborting.");
                }
            }
        }
    }
}

