/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.category;

import com.aimluck.eip.category.CommonCategorySelectData;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CommonCategoryMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CommonCategoryMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            int loginuserid = ALEipUtils.getUserId((RunData)rundata);
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            boolean hasAuthorityOtherDelete = aclhandler.hasAuthority(loginuserid, "manhour_common_category_other", 16);
            SelectQuery query = Database.query(EipTCommonCategory.class);
            if (!hasAuthorityOtherDelete) {
                Expression exp1 = ExpressionFactory.matchExp((String)"createUserId", (Object)loginuserid);
                query.andQualifier(exp1);
            }
            Expression exp2 = ExpressionFactory.inDbExp((String)"COMMON_CATEGORY_ID", values);
            query.andQualifier(exp2);
            List commoncategory_list = query.fetchList();
            if (commoncategory_list == null || commoncategory_list.size() == 0) {
                return false;
            }
            for (EipTCommonCategory record : commoncategory_list) {
                CommonCategoryUtils.setDefaultCommonCategoryToSchedule(record);
            }
            Database.deleteAll((List)commoncategory_list);
            Database.commit();
            rundata.getParameters().add("mode", "multi_delete");
            for (EipTCommonCategory record : commoncategory_list) {
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getCommonCategoryId().intValue(), 300, record.getName());
            }
            String filtername = CommonCategorySelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"CommonCategoryMultiDelete.action", t);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "manhour_common_category";
    }
}

