/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.util.RunData;

public class WebMailFileScreen
extends RawScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailFileScreen.class.getName());

    protected String getContentType(RunData rundata) {
        return "application/octet-stream";
    }

    protected void doOutput(RunData rundata) throws Exception {
        ServletOutputStream out = null;
        try {
            String orgId = Database.getDomainName();
            int uid = ALEipUtils.getUserId((RunData)rundata);
            int accountid = Integer.parseInt(rundata.getParameters().getString("accountid"));
            int mailindex = rundata.getParameters().getInt("entityid");
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex");
            if (mailindex < 0 || attachmentIndex < 0) {
                return;
            }
            String currentTab = rundata.getParameters().getString("tab");
            int type_mail = "receive".equals(currentTab) ? 1 : 2;
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            ALFolder folder = handler.getALFolder(type_mail, orgId, uid, accountid);
            ALLocalMailMessage msg = (ALLocalMailMessage)folder.getMail(mailindex);
            if (msg == null) {
                return;
            }
            boolean isMsie = ALEipUtils.isMsieBrowser((RunData)rundata);
            String fileName = isMsie ? new String(msg.getFileName(attachmentIndex).getBytes("Windows-31J"), "8859_1") : new String(msg.getFileName(attachmentIndex).getBytes("UTF-8"), "8859_1");
            InputStream in = msg.getInputStream(attachmentIndex);
            HttpServletResponse response = rundata.getResponse();
            response.setHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
            response.setHeader("Cache-Control", "aipo");
            response.setHeader("Pragma", "aipo");
            out = response.getOutputStream();
            byte[] b = new byte[1024];
            int len = -1;
            while ((len = in.read(b)) != -1) {
                out.write(b, 0, len);
                out.flush();
            }
            in.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)"WebMailFileScreen.doOutput", (Throwable)e);
        }
    }
}

