/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.screens.WebMailAdminFormJSONScreen;
import com.aimluck.eip.modules.screens.WebMailAdminFormScreen;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.webmail.util.WebMailUtils;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WebMailAccountFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailAccountFormData.class.getName());
    private final int DEF_SMTP_PORT = 25;
    private final int DEF_POP3_PORT = 110;
    private ALNumberField account_id;
    private ALNumberField user_id;
    private ALStringField account_name;
    private ALStringField account_type;
    private ALStringField smtpserver_name;
    private ALStringField pop3server_name;
    private ALStringField pop3user_name;
    private ALStringField pop3_password;
    private ALStringField mail_user_name;
    private ALStringField mail_address;
    private ALNumberField smtp_port;
    private ALNumberField pop3_port;
    private ALNumberField auth_send_flg;
    private ALStringField auth_send_user_id;
    private ALStringField auth_send_user_password;
    private ALNumberField auth_receive_flag;
    private ALNumberField del_at_pop3_flg;
    private ALNumberField del_at_pop3_before_days_flg;
    private ALNumberField del_at_pop3_before_days;
    private ALNumberField non_received_flg;
    private ALDateTimeField create_date;
    private ALDateTimeField update_date;
    private ALStringField signature;
    private ALNumberField smtp_encryption_flag;
    private ALNumberField pop3_encryption_flag;
    private String orgId;
    private boolean isAdmin;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.orgId = Database.getDomainName();
        this.isAdmin = rundata.getScreen().equals(WebMailAdminFormScreen.class.getSimpleName()) || rundata.getScreen().equals(WebMailAdminFormJSONScreen.class.getSimpleName());
    }

    public void initField() {
        this.account_id = new ALNumberField();
        this.account_id.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_ACCOUNTID"));
        this.user_id = new ALNumberField();
        this.user_id.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_USERID"));
        this.account_name = new ALStringField();
        this.account_name.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_MAILACCOUNT"));
        this.account_name.setTrim(true);
        this.account_type = new ALStringField();
        this.account_type.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_ACCOUNT_TYPE"));
        this.account_type.setTrim(true);
        this.smtpserver_name = new ALStringField();
        this.smtpserver_name.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_MAILSERVER_SEND"));
        this.smtpserver_name.setTrim(true);
        this.pop3server_name = new ALStringField();
        this.pop3server_name.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_MAILSERVER_RECEIVE"));
        this.pop3server_name.setTrim(true);
        this.pop3user_name = new ALStringField();
        this.pop3user_name.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_USERID_RECEIVE"));
        this.pop3user_name.setTrim(true);
        this.pop3_password = new ALStringField();
        this.pop3_password.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_USERPASS_RECEIVE"));
        this.pop3_password.setTrim(true);
        this.mail_user_name = new ALStringField();
        this.mail_user_name.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_NAME"));
        this.mail_user_name.setTrim(true);
        this.mail_address = new ALStringField();
        this.mail_address.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_MAILADDRESS"));
        this.mail_address.setTrim(true);
        this.smtp_port = new ALNumberField();
        this.smtp_port.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_PORTNUM_SEND"));
        this.smtp_port.setValue(25L);
        this.pop3_port = new ALNumberField();
        this.pop3_port.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_PORTNUM_RECEIVE"));
        this.pop3_port.setValue(110L);
        this.auth_send_flg = new ALNumberField();
        this.auth_send_flg.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_AUTHENTICATION_SEND"));
        this.auth_send_flg.setValue(0L);
        this.smtp_encryption_flag = new ALNumberField();
        this.smtp_encryption_flag.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_CYPHER_SEND"));
        this.smtp_encryption_flag.setValue(0L);
        this.auth_send_user_id = new ALStringField();
        this.auth_send_user_id.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_SMTP_ID"));
        this.auth_send_user_id.setTrim(true);
        this.auth_send_user_password = new ALStringField();
        this.auth_send_user_password.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_SMTP_PW"));
        this.auth_send_user_password.setTrim(true);
        this.auth_receive_flag = new ALNumberField();
        this.auth_receive_flag.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_RECEIVE_AUTHENTICATION"));
        this.auth_receive_flag.setValue(0L);
        this.pop3_encryption_flag = new ALNumberField();
        this.pop3_encryption_flag.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_CYPHER_RECEIVE"));
        this.pop3_encryption_flag.setValue(0L);
        this.del_at_pop3_flg = new ALNumberField();
        this.del_at_pop3_flg.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_DELETE_MAIL_FROM_SERVER_AFTER_RECEIVE"));
        this.del_at_pop3_flg.setValue(0L);
        this.del_at_pop3_before_days_flg = new ALNumberField();
        this.del_at_pop3_before_days_flg.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_DELETE_MAIL_DATE_FLUG"));
        this.del_at_pop3_before_days_flg.setValue(0L);
        this.del_at_pop3_before_days = new ALNumberField();
        this.del_at_pop3_before_days.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_DELETE_MAIL_DATE"));
        this.del_at_pop3_before_days.setValue(0L);
        this.non_received_flg = new ALNumberField();
        this.non_received_flg.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL__DONOT_INPORT_RECEIVEDMSG"));
        this.non_received_flg.setValue(1L);
        this.create_date = new ALDateTimeField("yyyy/MM/dd");
        this.create_date.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_MAILACCOUNT_CREATE_DATE"));
        this.update_date = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.update_date.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_MAILACCOUNT_LAST_UPDATE_DATE"));
        this.signature = new ALStringField();
        this.signature.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_SIGN"));
        this.signature.setTrim(true);
    }

    protected void setValidator() {
        this.account_name.setNotNull(true);
        this.account_name.limitMaxLength(50);
        this.smtpserver_name.setNotNull(true);
        this.smtpserver_name.setCharacterType(19);
        this.smtpserver_name.limitMaxLength(50);
        this.pop3server_name.setNotNull(true);
        this.pop3server_name.setCharacterType(19);
        this.pop3server_name.limitMaxLength(50);
        this.pop3user_name.setNotNull(true);
        this.pop3user_name.setCharacterType(19);
        this.pop3user_name.limitMaxLength(50);
        this.pop3_password.setNotNull(true);
        this.pop3_password.setCharacterType(19);
        this.pop3_password.limitMaxLength(50);
        this.mail_user_name.setNotNull(true);
        this.mail_user_name.limitMaxLength(50);
        this.mail_address.setNotNull(true);
        this.mail_address.setCharacterType(19);
        this.mail_address.limitMaxLength(50);
        this.smtp_port.setNotNull(true);
        this.smtp_port.limitMinValue(0L);
        this.smtp_port.limitMaxValue(65535L);
        this.pop3_port.setNotNull(true);
        this.pop3_port.limitMinValue(0L);
        this.pop3_port.limitMaxValue(65535L);
        this.auth_send_flg.setNotNull(true);
        this.auth_send_flg.limitMinValue(0L);
        this.auth_send_flg.limitMaxValue(2L);
        this.smtp_encryption_flag.setNotNull(true);
        this.smtp_encryption_flag.limitMaxValue(1L);
        this.smtp_encryption_flag.limitMinValue(0L);
        this.auth_send_user_id.setNotNull(true);
        this.auth_send_user_id.setCharacterType(19);
        this.auth_send_user_id.limitMaxLength(50);
        this.auth_send_user_password.setNotNull(true);
        this.auth_send_user_password.setCharacterType(19);
        this.auth_send_user_password.limitMaxLength(50);
        this.auth_receive_flag.setNotNull(true);
        this.auth_receive_flag.limitMinValue(0L);
        this.auth_receive_flag.limitMaxValue(1L);
        this.pop3_encryption_flag.setNotNull(true);
        this.pop3_encryption_flag.limitMinValue(0L);
        this.pop3_encryption_flag.limitMaxValue(1L);
        this.del_at_pop3_flg.setNotNull(true);
        this.del_at_pop3_flg.limitMinValue(0L);
        this.del_at_pop3_flg.limitMaxValue(1L);
        this.del_at_pop3_before_days_flg.setNotNull(true);
        this.del_at_pop3_before_days_flg.limitMinValue(0L);
        this.del_at_pop3_before_days_flg.limitMaxValue(1L);
        this.del_at_pop3_before_days.setNotNull(true);
        this.del_at_pop3_before_days.limitMinValue(0L);
        this.del_at_pop3_before_days.limitMaxValue(100L);
        this.non_received_flg.setNotNull(true);
        this.non_received_flg.limitMinValue(0L);
        this.non_received_flg.limitMaxValue(1L);
        this.signature.limitMaxLength(1000);
    }

    protected boolean validate(List<String> msgList) {
        this.account_name.validate(msgList);
        this.smtpserver_name.validate(msgList);
        if (!this.isAdmin || this.isAdmin && this.auth_send_flg.getValue() == 1L) {
            this.pop3server_name.validate(msgList);
            this.pop3user_name.validate(msgList);
            this.pop3_password.validate(msgList);
            this.pop3_port.validate(msgList);
            this.pop3_encryption_flag.validate(msgList);
            this.auth_receive_flag.validate(msgList);
        }
        this.mail_user_name.validate(msgList);
        if (this.mail_address.validate(msgList) && !ALStringUtil.isMailAddress((String)this.mail_address.getValue())) {
            msgList.add("\u300e <span class='em'>\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        this.smtp_port.validate(msgList);
        this.auth_send_flg.validate(msgList);
        if (this.auth_send_flg.getValue() == 2L) {
            this.auth_send_user_id.validate(msgList);
            this.auth_send_user_password.validate(msgList);
        }
        this.smtp_encryption_flag.validate(msgList);
        this.del_at_pop3_flg.validate(msgList);
        if (this.del_at_pop3_flg.getValue() == 0L) {
            this.del_at_pop3_before_days_flg.validate(msgList);
            if (this.del_at_pop3_before_days_flg.getValue() == 1L) {
                this.del_at_pop3_before_days.validate(msgList);
            }
        }
        this.non_received_flg.validate(msgList);
        this.signature.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int userId = this.isAdmin ? 1 : ALEipUtils.getUserId((RunData)rundata);
            int accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
            EipMMailAccount account = ALMailUtils.getMailAccount((int)userId, (int)accountId);
            if (account == null) {
                return false;
            }
            this.account_id.setValue((long)account.getAccountId().intValue());
            this.account_name.setValue(account.getAccountName());
            this.account_type.setValue(account.getAccountType());
            this.smtpserver_name.setValue(account.getSmtpserverName());
            this.pop3server_name.setValue(account.getPop3serverName());
            this.pop3user_name.setValue(account.getPop3userName());
            this.pop3_password.setValue(new String(ALMailUtils.getDecryptedMailAccountPasswd((byte[])account.getPop3password())));
            this.mail_user_name.setValue(account.getMailUserName());
            this.mail_address.setValue(account.getMailAddress());
            this.smtp_port.setValue(account.getSmtpPort());
            this.pop3_port.setValue(account.getPop3Port());
            this.auth_send_flg.setValue((long)account.getAuthSendFlg().shortValue());
            this.smtp_encryption_flag.setValue((long)account.getSmtpEncryptionFlg().shortValue());
            this.pop3_encryption_flag.setValue((long)account.getPop3EncryptionFlg().shortValue());
            this.auth_send_user_id.setValue(account.getAuthSendUserId());
            this.signature.setValue(account.getSignature());
            byte[] tmpAuthSendUserPasswd = account.getAuthSendUserPasswd();
            if (tmpAuthSendUserPasswd != null && tmpAuthSendUserPasswd.length > 0) {
                this.auth_send_user_password.setValue(new String(ALMailUtils.getDecryptedMailAccountPasswd((byte[])tmpAuthSendUserPasswd)));
            }
            this.auth_receive_flag.setValue(account.getAuthReceiveFlg().longValue());
            this.del_at_pop3_flg.setValue(account.getDelAtPop3Flg());
            this.del_at_pop3_before_days_flg.setValue(account.getDelAtPop3BeforeDaysFlg());
            this.del_at_pop3_before_days.setValue(account.getDelAtPop3BeforeDays().longValue());
            this.non_received_flg.setValue(account.getNonReceivedFlg());
            this.create_date.setValue(account.getCreateDate());
            this.update_date.setValue(account.getUpdateDate());
        }
        catch (Exception ex) {
            logger.error((Object)"webmail", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        int uid = this.isAdmin ? 1 : ALEipUtils.getUserId((RunData)rundata);
        return ALMailUtils.insertMailAccountData((RunData)rundata, msgList, (int)uid, (String)this.getAccountName().getValue(), (int)0, (String)this.getMailAddress().getValue(), (String)this.getMailUserName().getValue(), (String)this.getSmtpserverName().getValue(), (int)((int)this.getSmtpPort().getValue()), (String)this.getPop3serverName().getValue(), (int)((int)this.getPop3Port().getValue()), (String)this.getPop3userName().getValue(), (String)this.getPop3Password().getValue(), (int)((int)this.getAuthSendFlg().getValue()), (String)this.getAuthSendUserId().getValue(), (String)this.getAuthSendUserPasswd().getValue(), (int)((int)this.getAuthReceiveFlg().getValue()), (int)((int)this.getDelAtPop3Flg().getValue()), (int)((int)this.getDelAtPop3BeforeDaysFlg().getValue()), (int)((int)this.getDelAtPop3BeforeDays().getValue()), (String)this.getNonReceivedFlg().toString(), (String)this.getSignature().getValue(), (int)((int)this.getSmtpEncryptionFlag().getValue()), (int)((int)this.getPop3EncryptionFlag().getValue()));
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int userId = this.isAdmin ? 1 : ALEipUtils.getUserId((RunData)rundata);
            int accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
            EipMMailAccount mailAccount = ALMailUtils.getMailAccount((int)userId, (int)accountId);
            if (mailAccount == null) {
                return false;
            }
            mailAccount.setUserId(Integer.valueOf(userId));
            mailAccount.setAccountName(this.getAccountName().getValue());
            mailAccount.setSmtpserverName(this.getSmtpserverName().getValue());
            mailAccount.setPop3serverName(this.getPop3serverName().getValue());
            mailAccount.setPop3userName(this.getPop3userName().getValue());
            mailAccount.setPop3password(ALMailUtils.getEncryptedMailAccountPasswd((byte[])this.getPop3Password().getValue().getBytes()));
            mailAccount.setMailUserName(this.getMailUserName().getValue());
            mailAccount.setMailAddress(this.getMailAddress().getValue());
            mailAccount.setSmtpPort(Integer.toString((int)this.getSmtpPort().getValue()));
            mailAccount.setPop3Port(Integer.toString((int)this.getPop3Port().getValue()));
            mailAccount.setAuthSendFlg(Short.valueOf(this.getAuthSendFlg().toString()));
            mailAccount.setSmtpEncryptionFlg(Short.valueOf((short)this.getSmtpEncryptionFlag().getValue()));
            mailAccount.setPop3EncryptionFlg(Short.valueOf((short)this.getPop3EncryptionFlag().getValue()));
            if (this.getAuthSendFlg().getValue() == 2L) {
                mailAccount.setAuthSendUserId(this.getAuthSendUserId().getValue());
                mailAccount.setAuthSendUserPasswd(ALMailUtils.getEncryptedMailAccountPasswd((byte[])this.getAuthSendUserPasswd().getValue().getBytes()));
            }
            mailAccount.setAuthReceiveFlg(Short.valueOf((short)this.getAuthReceiveFlg().getValue()));
            mailAccount.setDelAtPop3Flg(this.getDelAtPop3Flg().getValueAsString());
            if (this.getDelAtPop3Flg().getValue() == 0L) {
                mailAccount.setDelAtPop3BeforeDaysFlg(this.getDelAtPop3BeforeDaysFlg().getValueAsString());
                if (this.getDelAtPop3BeforeDaysFlg().getValue() == 1L) {
                    mailAccount.setDelAtPop3BeforeDays(Integer.valueOf((int)this.getDelAtPop3BeforeDays().getValue()));
                }
            }
            mailAccount.setNonReceivedFlg(this.getNonReceivedFlg().toString());
            mailAccount.setUpdateDate(Calendar.getInstance().getTime());
            mailAccount.setSignature(this.getSignature().getValue());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(mailAccount.getAccountId().intValue(), 231, mailAccount.getAccountName());
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[WebMailAccountFormData]", t);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int uid = ALEipUtils.getUserId((RunData)rundata);
            int accountId = rundata.getParameters().getInt("accountid");
            SelectQuery query = Database.query(EipMMailAccount.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)uid);
            Expression exp2 = ExpressionFactory.matchDbExp((String)"ACCOUNT_ID", (Object)accountId);
            EipMMailAccount account = (EipMMailAccount)query.setQualifier(exp1.andExp(exp2)).fetchSingle();
            if (account == null) {
                msgList.add("\u6307\u5b9a\u3057\u305f\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                return false;
            }
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            handler.removeAccount(this.orgId, ALEipUtils.getUserId((RunData)rundata), accountId);
            Database.delete((Persistent)account);
            Database.commit();
            String sql = "DELETE FROM eip_t_mail WHERE account_id = " + String.valueOf(account.getAccountId());
            SQLTemplate sqlTemplate = Database.sql(EipTMail.class, (String)sql);
            sqlTemplate.execute();
            WebMailUtils.clearWebMailAccountSession(rundata, context);
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(account.getAccountId().intValue(), 231, account.getAccountName());
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[WebMailAccountFormData]", t);
            return false;
        }
        return true;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            Expression exp2;
            Expression exp1;
            SelectQuery query;
            EipMMailAccount account;
            if ("new".equals(rundata.getParameters().getString("entityid")) && (account = (EipMMailAccount)(query = Database.query(EipMMailAccount.class)).setQualifier((exp1 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata))).andExp(exp2 = ExpressionFactory.matchExp((String)"accountType", (Object)2))).fetchSingle()) != null) {
                this.mail_address.setValue(account.getMailAddress());
            }
            return super.setFormData(rundata, context, msgList);
        }
        catch (Exception ex) {
            logger.error((Object)"webmail", (Throwable)ex);
            return false;
        }
    }

    public ALStringField getAccountName() {
        return this.account_name;
    }

    public ALStringField getAccountType() {
        return this.account_type;
    }

    public ALDateTimeField getCreateDate() {
        return this.create_date;
    }

    public ALNumberField getDelAtPop3Flg() {
        return this.del_at_pop3_flg;
    }

    public ALStringField getMailAddress() {
        return this.mail_address;
    }

    public ALStringField getMailUserName() {
        return this.mail_user_name;
    }

    public ALNumberField getNonReceivedFlg() {
        return this.non_received_flg;
    }

    public ALStringField getPop3Password() {
        return this.pop3_password;
    }

    public ALNumberField getPop3Port() {
        return this.pop3_port;
    }

    public ALStringField getPop3serverName() {
        return this.pop3server_name;
    }

    public ALStringField getPop3userName() {
        return this.pop3user_name;
    }

    public ALStringField getSmtpserverName() {
        return this.smtpserver_name;
    }

    public ALNumberField getSmtpPort() {
        return this.smtp_port;
    }

    public ALDateTimeField getUpdateDate() {
        return this.update_date;
    }

    public int getAccountId() {
        return (int)this.account_id.getValue();
    }

    public ALNumberField getAuthSendFlg() {
        return this.auth_send_flg;
    }

    public ALStringField getAuthSendUserId() {
        return this.auth_send_user_id;
    }

    public ALStringField getAuthSendUserPasswd() {
        return this.auth_send_user_password;
    }

    public ALNumberField getAuthReceiveFlg() {
        return this.auth_receive_flag;
    }

    public ALNumberField getDelAtPop3BeforeDaysFlg() {
        return this.del_at_pop3_before_days_flg;
    }

    public ALNumberField getDelAtPop3BeforeDays() {
        return this.del_at_pop3_before_days;
    }

    public ALStringField getSignature() {
        return this.signature;
    }

    public ALNumberField getSmtpEncryptionFlag() {
        return this.smtp_encryption_flag;
    }

    public ALNumberField getPop3EncryptionFlag() {
        return this.pop3_encryption_flag;
    }
}

