/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.Fault;
import org.apache.cayenne.FaultFailureException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.PersistenceState;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.ChildDiffLoader;
import org.apache.cayenne.access.DataContextDelegate;
import org.apache.cayenne.access.DataContextDeleteAction;
import org.apache.cayenne.access.DataContextFactory;
import org.apache.cayenne.access.DataContextFlushEventHandler;
import org.apache.cayenne.access.DataContextMergeHandler;
import org.apache.cayenne.access.DataContextQueryAction;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.NoopDelegate;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.ObjectStoreGraphDiff;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.access.TransactionResultIteratorDecorator;
import org.apache.cayenne.access.event.DataContextEvent;
import org.apache.cayenne.access.util.IteratedSelectObserver;
import org.apache.cayenne.access.util.PrefetchHelper;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.property.ClassDescriptor;
import org.apache.cayenne.property.CollectionProperty;
import org.apache.cayenne.property.Property;
import org.apache.cayenne.property.PropertyVisitor;
import org.apache.cayenne.property.SingleObjectArcProperty;
import org.apache.cayenne.query.GenericSelectQuery;
import org.apache.cayenne.query.NamedQuery;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.EventUtil;
import org.apache.cayenne.util.GenericResponse;
import org.apache.cayenne.util.Util;
import org.apache.log4j.Level;

public class DataContext
implements ObjectContext,
DataChannel,
QueryEngine,
Serializable {
    public static final EventSubject WILL_COMMIT = EventSubject.getSubject(DataContext.class, "DataContextWillCommit");
    public static final EventSubject DID_COMMIT = EventSubject.getSubject(DataContext.class, "DataContextDidCommit");
    public static final EventSubject DID_ROLLBACK = EventSubject.getSubject(DataContext.class, "DataContextDidRollback");
    protected static final ThreadLocal threadDataContext = new ThreadLocal();
    private static boolean transactionEventsEnabledDefault;
    private boolean transactionEventsEnabled;
    private DataContextDelegate delegate;
    protected boolean usingSharedSnaphsotCache;
    protected boolean validatingObjectsOnCommit;
    protected ObjectStore objectStore;
    protected transient DataChannel channel;
    protected transient EntityResolver entityResolver;
    protected transient DataContextMergeHandler mergeHandler;
    protected Map userProperties;
    protected transient String lazyInitParentDomainName;

    public static DataContext getThreadDataContext() throws IllegalStateException {
        DataContext dc = (DataContext)threadDataContext.get();
        if (dc == null) {
            throw new IllegalStateException("Current thread has no bound DataContext.");
        }
        return dc;
    }

    public static void bindThreadDataContext(DataContext context) {
        threadDataContext.set(context);
    }

    public static DataContext createDataContext() {
        return Configuration.getSharedConfiguration().getDomain().createDataContext();
    }

    public static DataContext createDataContext(boolean useSharedCache) {
        return Configuration.getSharedConfiguration().getDomain().createDataContext(useSharedCache);
    }

    public static DataContext createDataContext(String domainName) {
        DataDomain domain = Configuration.getSharedConfiguration().getDomain(domainName);
        if (domain == null) {
            throw new IllegalArgumentException("Non-existent domain: " + domainName);
        }
        return domain.createDataContext();
    }

    public static DataContext createDataContext(String domainName, boolean useSharedCache) {
        DataDomain domain = Configuration.getSharedConfiguration().getDomain(domainName);
        if (domain == null) {
            throw new IllegalArgumentException("Non-existent domain: " + domainName);
        }
        return domain.createDataContext(useSharedCache);
    }

    public DataContext() {
        this((DataChannel)null, null);
    }

    public DataContext(QueryEngine parent, ObjectStore objectStore) {
        this((DataChannel)((Object)parent), objectStore);
    }

    public DataContext(DataChannel channel, ObjectStore objectStore) {
        this.setChannel(channel);
        this.setTransactionEventsEnabled(transactionEventsEnabledDefault);
        if (objectStore != null) {
            this.objectStore = objectStore;
            objectStore.setContext(this);
            DataDomain domain = this.getParentDataDomain();
            this.usingSharedSnaphsotCache = domain != null && objectStore.getDataRowCache() == domain.getSharedSnapshotCache();
        }
    }

    protected Map getUserProperties() {
        if (this.userProperties == null) {
            this.userProperties = new HashMap();
        }
        return this.userProperties;
    }

    public DataContext createChildDataContext() {
        DataContextFactory factory = this.getParentDataDomain().getDataContextFactory();
        ObjectStore objectStore = new ObjectStore();
        DataContext child = factory != null ? factory.createDataContext(this, objectStore) : new DataContext(this, objectStore);
        child.setValidatingObjectsOnCommit(this.isValidatingObjectsOnCommit());
        child.usingSharedSnaphsotCache = this.isUsingSharedSnapshotCache();
        return child;
    }

    public Object getUserProperty(String key) {
        return this.getUserProperties().get(key);
    }

    public void setUserProperty(String key, Object value) {
        this.getUserProperties().put(key, value);
    }

    public QueryEngine getParent() {
        return this.getParentDataDomain();
    }

    public void setParent(QueryEngine parent) {
        if (parent != null && !(parent instanceof DataChannel)) {
            throw new CayenneRuntimeException("Only parents that implement DataChannel are supported.");
        }
        this.setChannel((DataChannel)((Object)parent));
    }

    public DataChannel getChannel() {
        this.awakeFromDeserialization();
        return this.channel;
    }

    public void setChannel(DataChannel channel) {
        if (this.channel != channel) {
            if (this.mergeHandler != null) {
                this.mergeHandler.setActive(false);
            }
            this.entityResolver = null;
            this.mergeHandler = null;
            this.channel = channel;
            if (channel != null) {
                DataRowStore cache;
                this.entityResolver = channel.getEntityResolver();
                EventManager eventManager = channel.getEventManager();
                if (eventManager != null) {
                    this.mergeHandler = new DataContextMergeHandler(this);
                    EventUtil.listenForChannelEvents(channel, (DataChannelListener)this.mergeHandler);
                }
                if (!this.usingSharedSnaphsotCache && this.getObjectStore() != null && (cache = this.getObjectStore().getDataRowCache()) != null) {
                    cache.setEventManager(eventManager);
                }
            }
        }
    }

    public DataDomain getParentDataDomain() {
        this.awakeFromDeserialization();
        if (this.channel == null) {
            return null;
        }
        if (this.channel instanceof DataDomain) {
            return (DataDomain)this.channel;
        }
        if (this.channel instanceof DataContext) {
            return ((DataContext)this.channel).getParentDataDomain();
        }
        return null;
    }

    public void setDelegate(DataContextDelegate delegate) {
        this.delegate = delegate;
    }

    public DataContextDelegate getDelegate() {
        return this.delegate;
    }

    DataContextDelegate nonNullDelegate() {
        return this.delegate != null ? this.delegate : NoopDelegate.noopDelegate;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public boolean hasChanges() {
        return this.getObjectStore().hasChanges();
    }

    public Collection newObjects() {
        return this.getObjectStore().objectsInState(2);
    }

    public Collection deletedObjects() {
        return this.getObjectStore().objectsInState(6);
    }

    public Collection modifiedObjects() {
        return this.getObjectStore().objectsInState(4);
    }

    public Collection uncommittedObjects() {
        int len = this.getObjectStore().registeredObjectsCount();
        if (len == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Persistent> objects = new ArrayList<Persistent>(len > 100 ? len / 2 : len);
        Iterator it = this.getObjectStore().getObjectIterator();
        while (it.hasNext()) {
            Persistent object = (Persistent)it.next();
            int state = object.getPersistenceState();
            if (state != 4 && state != 2 && state != 6) continue;
            objects.add(object);
        }
        return objects;
    }

    public DataObject registeredObject(ObjectId id) {
        return (DataObject)this.localObject(id, null);
    }

    public DataRow currentSnapshot(DataObject object) {
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(object);
        if (object.getPersistenceState() == 5 && object.getDataContext() != null) {
            return this.getObjectStore().getSnapshot(object.getObjectId());
        }
        DataRow snapshot = new DataRow(10);
        Iterator attributes = entity.getAttributeMap().entrySet().iterator();
        while (attributes.hasNext()) {
            Map.Entry entry = attributes.next();
            String attrName = (String)entry.getKey();
            ObjAttribute objAttr = (ObjAttribute)entry.getValue();
            snapshot.put(objAttr.getDbAttributePath(), object.readPropertyDirectly(attrName));
        }
        Iterator relationships = entity.getRelationshipMap().entrySet().iterator();
        while (relationships.hasNext()) {
            Object targetObject;
            Map.Entry entry = relationships.next();
            ObjRelationship rel = (ObjRelationship)entry.getValue();
            if (rel.isSourceIndependentFromTargetChange() || (targetObject = object.readPropertyDirectly(rel.getName())) == null) continue;
            if (targetObject instanceof Fault) {
                DataRow storedSnapshot = this.getObjectStore().getSnapshot(object.getObjectId());
                if (storedSnapshot == null) {
                    throw new CayenneRuntimeException("No matching objects found for ObjectId " + object.getObjectId() + ". Object may have been deleted externally.");
                }
                DbRelationship dbRel = (DbRelationship)rel.getDbRelationships().get(0);
                Iterator joins = dbRel.getJoins().iterator();
                while (joins.hasNext()) {
                    DbJoin join = (DbJoin)joins.next();
                    String key = join.getSourceName();
                    snapshot.put(key, storedSnapshot.get(key));
                }
                continue;
            }
            DataObject target = (DataObject)targetObject;
            Map idParts = target.getObjectId().getIdSnapshot();
            if (idParts.isEmpty()) continue;
            DbRelationship dbRel = (DbRelationship)rel.getDbRelationships().get(0);
            Map fk = dbRel.srcFkSnapshotWithTargetSnapshot(idParts);
            snapshot.putAll(fk);
        }
        Map thisIdParts = object.getObjectId().getIdSnapshot();
        if (thisIdParts != null) {
            Iterator idIterator = thisIdParts.entrySet().iterator();
            while (idIterator.hasNext()) {
                Map.Entry entry = idIterator.next();
                Object nextKey = entry.getKey();
                if (snapshot.containsKey(nextKey)) continue;
                snapshot.put(nextKey, entry.getValue());
            }
        }
        return snapshot;
    }

    public List localObjects(List objects) {
        ArrayList<Persistent> localObjects = new ArrayList<Persistent>(objects.size());
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            DataObject object = (DataObject)it.next();
            if (object == null) {
                throw new CayenneRuntimeException("Null object");
            }
            localObjects.add(this.localObject(object.getObjectId(), null));
        }
        return localObjects;
    }

    public List objectsFromDataRows(ObjEntity entity, List dataRows, boolean refresh, boolean resolveInheritanceHierarchy) {
        return new ObjectResolver(this, entity, refresh, resolveInheritanceHierarchy).synchronizedObjectsFromDataRows(dataRows);
    }

    public List objectsFromDataRows(Class objectClass, List dataRows, boolean refresh, boolean resolveInheritanceHierarchy) {
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(objectClass);
        if (entity == null) {
            throw new CayenneRuntimeException("Unmapped Java class: " + objectClass);
        }
        return this.objectsFromDataRows(entity, dataRows, refresh, resolveInheritanceHierarchy);
    }

    public DataObject objectFromDataRow(Class objectClass, DataRow dataRow, boolean refresh) {
        List list = this.objectsFromDataRows(objectClass, Collections.singletonList(dataRow), refresh, true);
        return (DataObject)list.get(0);
    }

    public DataObject createAndRegisterNewObject(String objEntityName) {
        DataObject dataObject;
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(objEntityName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid entity name: " + objEntityName);
        }
        try {
            dataObject = (DataObject)descriptor.createObject();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error instantiating object.", ex);
        }
        descriptor.injectValueHolders(dataObject);
        dataObject.setObjectId(new ObjectId(objEntityName));
        dataObject.setDataContext(this);
        dataObject.setPersistenceState(2);
        this.getObjectStore().recordObjectCreated(dataObject);
        return dataObject;
    }

    public Persistent newObject(Class persistentClass) {
        if (persistentClass == null) {
            throw new NullPointerException("Null 'persistentClass'");
        }
        if (!DataObject.class.isAssignableFrom(persistentClass)) {
            throw new IllegalArgumentException(this + ": this implementation of ObjectContext only supports full DataObjects. Class " + persistentClass + " is invalid.");
        }
        return this.createAndRegisterNewObject(persistentClass);
    }

    public DataObject createAndRegisterNewObject(Class objectClass) {
        if (objectClass == null) {
            throw new NullPointerException("DataObject class can't be null.");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(objectClass);
        if (entity == null) {
            throw new IllegalArgumentException("Class is not mapped with Cayenne: " + objectClass.getName());
        }
        return this.createAndRegisterNewObject(entity.getName());
    }

    public void registerNewObject(final DataObject object) {
        if (object == null) {
            throw new NullPointerException("Can't register null object.");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(object);
        if (entity == null) {
            throw new IllegalArgumentException("Can't find ObjEntity for DataObject class: " + object.getClass().getName() + ", class is likely not mapped.");
        }
        if (object.getObjectId() != null) {
            if (object.getDataContext() == this) {
                return;
            }
            if (object.getDataContext() != null) {
                throw new IllegalStateException("DataObject is already registered with another DataContext. Try using 'localObjects()' instead.");
            }
        } else {
            object.setObjectId(new ObjectId(entity.getName()));
        }
        object.setDataContext(this);
        object.setPersistenceState(2);
        this.getObjectStore().recordObjectCreated(object);
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid entity name: " + entity.getName());
        }
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitCollectionArc(CollectionProperty property) {
                property.injectValueHolder(object);
                if (!property.isFault(object)) {
                    Iterator it = ((Collection)property.readProperty(object)).iterator();
                    while (it.hasNext()) {
                        Object target = it.next();
                        if (!(target instanceof DataObject)) continue;
                        DataObject targetDO = (DataObject)target;
                        DataContext.this.registerNewObject(targetDO);
                        DataContext.this.getObjectStore().recordArcCreated(object, targetDO.getObjectId(), property.getName());
                    }
                }
                return true;
            }

            public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                Object target = property.readPropertyDirectly(object);
                if (target instanceof DataObject) {
                    DataObject targetDO = (DataObject)target;
                    DataContext.this.registerNewObject(targetDO);
                    DataContext.this.getObjectStore().recordArcCreated(object, targetDO.getObjectId(), property.getName());
                }
                return true;
            }

            public boolean visitProperty(Property property) {
                return true;
            }
        });
    }

    public void unregisterObjects(Collection dataObjects) {
        this.getObjectStore().objectsUnregistered(dataObjects);
    }

    public void invalidateObjects(Collection dataObjects) {
        this.getObjectStore().objectsInvalidated(dataObjects);
    }

    public void deleteObjects(Collection objects) {
        if (objects.isEmpty()) {
            return;
        }
        Iterator it = new ArrayList(objects).iterator();
        while (it.hasNext()) {
            DataObject object = (DataObject)it.next();
            this.deleteObject(object);
        }
    }

    public void deleteObject(Persistent object) throws DeleteDenyException {
        new DataContextDeleteAction(this).performDelete(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject refetchObject(ObjectId oid) {
        if (oid == null) {
            throw new NullPointerException("Null ObjectId");
        }
        if (oid.isTemporary()) {
            throw new CayenneRuntimeException("Can't refetch ObjectId " + oid + ", as it is a temporary id.");
        }
        ObjectStore objectStore = this.getObjectStore();
        synchronized (objectStore) {
            DataObject object = (DataObject)this.objectStore.getNode(oid);
            if (object != null) {
                this.invalidateObjects(Collections.singleton(object));
            }
        }
        DataObject object = (DataObject)DataObjectUtils.objectForQuery(this, new ObjectIdQuery(oid));
        if (object == null) {
            throw new CayenneRuntimeException("Refetch failure: no matching objects found for ObjectId " + oid);
        }
        return object;
    }

    public DataNode lookupDataNode(DataMap dataMap) {
        DataDomain domain = this.getParentDataDomain();
        if (domain == null) {
            throw new CayenneRuntimeException("DataContext is not attached to a DataDomain ");
        }
        return domain.lookupDataNode(dataMap);
    }

    public void rollbackChangesLocally() {
        if (!(this.getChannel() instanceof DataDomain)) {
            throw new CayenneRuntimeException("Implementation pending.");
        }
        this.rollbackChanges();
    }

    public void rollbackChanges() {
        if (this.objectStore.hasChanges()) {
            ObjectStoreGraphDiff diff = this.getObjectStore().getChanges();
            this.getObjectStore().objectsRolledBack();
            if (this.channel != null) {
                this.channel.onSync(this, null, 3);
            }
            this.fireDataChannelRolledback(this, diff);
        }
    }

    public void commitChangesToParent() {
        this.flushToParent(false);
    }

    public void commitChanges(Level logLevel) throws CayenneRuntimeException {
        this.commitChanges();
    }

    public void commitChanges() throws CayenneRuntimeException {
        this.flushToParent(true);
    }

    public EventManager getEventManager() {
        return this.channel != null ? this.channel.getEventManager() : null;
    }

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        switch (syncType) {
            case 3: {
                return this.onContextRollback(originatingContext);
            }
            case 1: {
                return this.onContextFlush(originatingContext, changes, false);
            }
            case 2: {
                return this.onContextFlush(originatingContext, changes, true);
            }
        }
        throw new CayenneRuntimeException("Unrecognized SyncMessage type: " + syncType);
    }

    GraphDiff onContextRollback(ObjectContext originatingContext) {
        this.rollbackChanges();
        return this.channel != null ? this.channel.onSync(this, null, 3) : new CompoundDiff();
    }

    GraphDiff onContextFlush(ObjectContext originatingContext, GraphDiff changes, boolean cascade) {
        if (this != originatingContext && changes != null) {
            changes.apply(new ChildDiffLoader(this));
            this.fireDataChannelChanged(originatingContext, changes);
        }
        return cascade ? this.flushToParent(true) : new CompoundDiff();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    GraphDiff flushToParent(boolean cascade) {
        if (this.getChannel() == null) {
            throw new CayenneRuntimeException("Cannot commit changes - channel is not set.");
        }
        int syncType = cascade ? 2 : 1;
        ObjectStore objectStore = this.getObjectStore();
        synchronized (objectStore) {
            boolean noop;
            DataContextFlushEventHandler eventHandler = null;
            ObjectStoreGraphDiff changes = this.getObjectStore().getChanges();
            boolean bl = noop = this.isValidatingObjectsOnCommit() ? changes.validateAndCheckNoop() : changes.isNoop();
            if (noop) {
                this.getObjectStore().postprocessAfterPhantomCommit();
                return new CompoundDiff();
            }
            if (this.isTransactionEventsEnabled()) {
                eventHandler = new DataContextFlushEventHandler(this);
                eventHandler.registerForDataContextEvents();
                this.fireWillCommit();
            }
            try {
                GraphDiff returnChanges = this.getChannel().onSync(this, changes, syncType);
                this.getObjectStore().postprocessAfterCommit(returnChanges);
                this.fireTransactionCommitted();
                this.fireDataChannelCommitted(this, changes);
                if (!returnChanges.isNoop()) {
                    this.fireDataChannelCommitted(this.getChannel(), returnChanges);
                }
                GraphDiff graphDiff = returnChanges;
                return graphDiff;
            }
            catch (CayenneRuntimeException ex) {
                this.fireTransactionRolledback();
                Throwable unwound = Util.unwindException(ex);
                if (unwound instanceof CayenneRuntimeException) {
                    throw (CayenneRuntimeException)unwound;
                }
                throw new CayenneRuntimeException("Commit Exception", unwound);
            }
            finally {
                if (this.isTransactionEventsEnabled()) {
                    eventHandler.unregisterFromDataContextEvents();
                }
            }
        }
    }

    public ResultIterator performIteratedQuery(Query query) throws CayenneException {
        ResultIterator result;
        if (Transaction.getThreadTransaction() != null) {
            return this.internalPerformIteratedQuery(query);
        }
        Transaction tx = this.getParentDataDomain().createTransaction();
        Transaction.bindThreadTransaction(tx);
        try {
            result = this.internalPerformIteratedQuery(query);
        }
        catch (Exception e) {
            Transaction.bindThreadTransaction(null);
            tx.setRollbackOnly();
            throw new CayenneException(e);
        }
        finally {
            if (tx.getStatus() == 7) {
                try {
                    tx.rollback();
                }
                catch (Exception rollbackEx) {}
            }
        }
        return new TransactionResultIteratorDecorator(result, tx);
    }

    ResultIterator internalPerformIteratedQuery(Query query) throws CayenneException {
        IteratedSelectObserver observer = new IteratedSelectObserver();
        this.getParentDataDomain().performQueries(Collections.singletonList(query), observer);
        return observer.getResultIterator();
    }

    public QueryResponse performGenericQuery(Query query) {
        query = this.nonNullDelegate().willPerformGenericQuery(this, query);
        if (query == null) {
            return new GenericResponse();
        }
        if (this.getChannel() == null) {
            throw new CayenneRuntimeException("Can't run query - parent DataChannel is not set.");
        }
        return this.onQuery(this, query);
    }

    public List performQuery(Query query) {
        query = this.nonNullDelegate().willPerformQuery(this, query);
        if (query == null) {
            return new ArrayList(1);
        }
        if ((query = this.filterThroughDelegateDeprecated(query)) == null) {
            return new ArrayList(1);
        }
        List result = this.onQuery(this, query).firstList();
        return result != null ? result : new ArrayList(1);
    }

    public QueryResponse onQuery(ObjectContext context, Query query) {
        return new DataContextQueryAction(this, context, query).execute();
    }

    public int[] performNonSelectingQuery(Query query) {
        int[] count = this.performGenericQuery(query).firstUpdateCount();
        return count != null ? count : new int[]{};
    }

    public int[] performNonSelectingQuery(String queryName) {
        return this.performNonSelectingQuery(new NamedQuery(queryName));
    }

    public int[] performNonSelectingQuery(String queryName, Map parameters) {
        return this.performNonSelectingQuery(new NamedQuery(queryName, parameters));
    }

    public void performQueries(Collection queries, OperationObserver callback) {
        ArrayList<Query> finalQueries = new ArrayList<Query>(queries.size());
        Iterator it = queries.iterator();
        while (it.hasNext()) {
            Query query = (Query)it.next();
            if ((query = this.filterThroughDelegateDeprecated(query)) == null) continue;
            finalQueries.add(query);
        }
        if (!finalQueries.isEmpty()) {
            this.getParentDataDomain().performQueries(queries, callback);
        }
    }

    Query filterThroughDelegateDeprecated(Query query) {
        if (query instanceof GenericSelectQuery) {
            GenericSelectQuery genericSelect = (GenericSelectQuery)query;
            return this.nonNullDelegate().willPerformSelect(this, genericSelect);
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performQueries(Collection queries, OperationObserver callback, Transaction transaction) {
        Transaction.bindThreadTransaction(transaction);
        try {
            this.performQueries(queries, callback);
        }
        finally {
            Transaction.bindThreadTransaction(null);
        }
    }

    public void prefetchRelationships(SelectQuery query, List objects) {
        List prefetches;
        QueryMetadata metadata = query.getMetaData(this.getEntityResolver());
        Collection collection = prefetches = metadata.getPrefetchTree() != null ? query.getPrefetchTree().nonPhantomNodes() : Collections.EMPTY_LIST;
        if (objects == null || objects.size() == 0 || prefetches.size() == 0) {
            return;
        }
        ObjEntity entity = metadata.getObjEntity();
        Iterator prefetchesIt = prefetches.iterator();
        while (prefetchesIt.hasNext()) {
            PrefetchTreeNode prefetch = (PrefetchTreeNode)prefetchesIt.next();
            String path = prefetch.getPath();
            if (path.indexOf(46) >= 0) {
                throw new CayenneRuntimeException("Only one-step relationships are supported at the moment, this will be fixed soon. Unsupported path : " + path);
            }
            ObjRelationship relationship = (ObjRelationship)entity.getRelationship(path);
            if (relationship == null) {
                throw new CayenneRuntimeException("Invalid relationship: " + path);
            }
            if (relationship.isToMany()) {
                throw new CayenneRuntimeException("Only to-one relationships are supported at the moment. Can't prefetch to-many: " + path);
            }
            PrefetchHelper.resolveToOneRelations(this, objects, path);
        }
    }

    public List performQuery(String queryName, boolean expireCachedLists) {
        return this.performQuery(queryName, Collections.EMPTY_MAP, expireCachedLists);
    }

    public List performQuery(String queryName, Map parameters, boolean expireCachedLists) {
        NamedQuery query = new NamedQuery(queryName, parameters);
        query.setForceNoCache(expireCachedLists);
        return this.performQuery(query);
    }

    public EntityResolver getEntityResolver() {
        this.awakeFromDeserialization();
        return this.entityResolver;
    }

    public static void setTransactionEventsEnabledDefault(boolean flag) {
        transactionEventsEnabledDefault = flag;
    }

    public void setTransactionEventsEnabled(boolean flag) {
        this.transactionEventsEnabled = flag;
    }

    public boolean isTransactionEventsEnabled() {
        return this.transactionEventsEnabled;
    }

    public boolean isUsingSharedSnapshotCache() {
        return this.usingSharedSnaphsotCache;
    }

    public boolean isValidatingObjectsOnCommit() {
        return this.validatingObjectsOnCommit;
    }

    public void setValidatingObjectsOnCommit(boolean flag) {
        this.validatingObjectsOnCommit = flag;
    }

    public Collection getDataMaps() {
        return this.getEntityResolver() != null ? this.getEntityResolver().getDataMaps() : Collections.EMPTY_LIST;
    }

    void fireWillCommit() {
        if (this.transactionEventsEnabled) {
            DataContextEvent commitChangesEvent = new DataContextEvent(this);
            this.getEventManager().postEvent(commitChangesEvent, WILL_COMMIT);
        }
    }

    void fireTransactionRolledback() {
        if (this.transactionEventsEnabled) {
            DataContextEvent commitChangesEvent = new DataContextEvent(this);
            this.getEventManager().postEvent(commitChangesEvent, DID_ROLLBACK);
        }
    }

    void fireTransactionCommitted() {
        if (this.transactionEventsEnabled) {
            DataContextEvent commitChangesEvent = new DataContextEvent(this);
            this.getEventManager().postEvent(commitChangesEvent, DID_COMMIT);
        }
    }

    void fireDataChannelCommitted(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_FLUSHED_SUBJECT);
        }
    }

    void fireDataChannelRolledback(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_ROLLEDBACK_SUBJECT);
        }
    }

    void fireDataChannelChanged(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_CHANGED_SUBJECT);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.channel == null && this.lazyInitParentDomainName != null) {
            out.writeObject(this.lazyInitParentDomainName);
        } else if (this.channel instanceof DataDomain) {
            DataDomain domain = (DataDomain)this.channel;
            out.writeObject(domain.getName());
        } else {
            out.writeObject(this.channel);
        }
        if (!this.isUsingSharedSnapshotCache()) {
            out.writeObject(this.objectStore.getDataRowCache());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Object value = in.readObject();
        if (value instanceof DataChannel) {
            this.channel = (DataChannel)value;
        } else if (value instanceof String) {
            this.lazyInitParentDomainName = (String)value;
        } else {
            throw new CayenneRuntimeException("Parent attribute of DataContext was neither a QueryEngine nor the name of a valid DataDomain:" + value);
        }
        if (!this.isUsingSharedSnapshotCache()) {
            DataRowStore cache = (DataRowStore)in.readObject();
            this.objectStore.setDataRowCache(cache);
        }
        ObjectStore objectStore = this.getObjectStore();
        synchronized (objectStore) {
            Iterator it = this.objectStore.getObjectIterator();
            while (it.hasNext()) {
                DataObject object = (DataObject)it.next();
                object.setDataContext(this);
            }
        }
    }

    private final void awakeFromDeserialization() {
        if (this.channel == null && this.lazyInitParentDomainName != null) {
            this.setChannel(Configuration.getSharedConfiguration().getDomain(this.lazyInitParentDomainName));
        }
    }

    public void prepareForAccess(Persistent object, String property) {
        if (object.getPersistenceState() == 5) {
            if (!(object instanceof DataObject)) {
                throw new CayenneRuntimeException("Can only resolve DataObjects. Got: " + object);
            }
            this.getObjectStore().resolveHollow((DataObject)object);
            if (object.getPersistenceState() != 3) {
                String state = PersistenceState.persistenceStateName(object.getPersistenceState());
                throw new FaultFailureException("Error resolving fault for ObjectId: " + object.getObjectId() + " and state (" + state + "). Possible cause - matching row is missing from the database.");
            }
        }
    }

    public void propertyChanged(Persistent object, String property, Object oldValue, Object newValue) {
        if (object.getPersistenceState() == 3) {
            this.getObjectStore().registerDiff(object, null);
        }
    }

    public GraphManager getGraphManager() {
        return this.objectStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistent localObject(ObjectId id, Persistent prototype) {
        Persistent localObject;
        if (id == null) {
            throw new IllegalArgumentException("Null ObjectId");
        }
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
        Persistent cachedObject = (Persistent)this.getGraphManager().getNode(id);
        if (cachedObject != null) {
            int state = cachedObject.getPersistenceState();
            if (cachedObject != prototype && state != 4 && state != 6) {
                descriptor.injectValueHolders(cachedObject);
                if (prototype != null && prototype.getPersistenceState() != 5) {
                    descriptor.shallowMerge(prototype, cachedObject);
                    if (state == 5) {
                        cachedObject.setPersistenceState(3);
                    }
                }
            }
            return cachedObject;
        }
        GraphManager graphManager = this.getGraphManager();
        synchronized (graphManager) {
            localObject = (Persistent)descriptor.createObject();
            localObject.setObjectContext(this);
            localObject.setObjectId(id);
            this.getGraphManager().registerNode(id, localObject);
        }
        if (prototype != null && prototype.getPersistenceState() != 5) {
            localObject.setPersistenceState(3);
            descriptor.injectValueHolders(localObject);
            descriptor.shallowMerge(prototype, localObject);
        } else {
            localObject.setPersistenceState(5);
        }
        return localObject;
    }
}

