/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataDomainDeleteBucket;
import org.apache.cayenne.access.DataDomainFlattenedBucket;
import org.apache.cayenne.access.DataDomainFlushObserver;
import org.apache.cayenne.access.DataDomainIndirectDiffBuilder;
import org.apache.cayenne.access.DataDomainInsertBucket;
import org.apache.cayenne.access.DataDomainUpdateBucket;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.FlattenedArcKey;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.ObjectStoreGraphDiff;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.BatchQuery;

class DataDomainFlushAction {
    private final DataDomain domain;
    private Map changesByObjectId;
    private CompoundDiff resultDiff;
    private Collection resultDeletedIds;
    private Map resultModifiedSnapshots;
    private Collection resultIndirectlyModifiedIds;
    private DataDomainInsertBucket insertBucket;
    private DataDomainUpdateBucket updateBucket;
    private DataDomainDeleteBucket deleteBucket;
    private DataDomainFlattenedBucket flattenedBucket;
    private List queries;

    DataDomainFlushAction(DataDomain domain) {
        this.domain = domain;
    }

    DataDomain getDomain() {
        return this.domain;
    }

    Collection getResultDeletedIds() {
        return this.resultDeletedIds;
    }

    CompoundDiff getResultDiff() {
        return this.resultDiff;
    }

    Collection getResultIndirectlyModifiedIds() {
        return this.resultIndirectlyModifiedIds;
    }

    Map getResultModifiedSnapshots() {
        return this.resultModifiedSnapshots;
    }

    ObjectDiff objectDiff(Object objectId) {
        return (ObjectDiff)this.changesByObjectId.get(objectId);
    }

    void addFlattenedInsert(DbEntity flattenedEntity, FlattenedArcKey flattenedInsertInfo) {
        this.flattenedBucket.addFlattenedInsert(flattenedEntity, flattenedInsertInfo);
    }

    void addFlattenedDelete(DbEntity flattenedEntity, FlattenedArcKey flattenedDeleteInfo) {
        this.flattenedBucket.addFlattenedDelete(flattenedEntity, flattenedDeleteInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphDiff flush(DataContext context, GraphDiff changes) {
        if (changes == null) {
            return new CompoundDiff();
        }
        if (!(changes instanceof ObjectStoreGraphDiff)) {
            throw new IllegalArgumentException("Expected 'ObjectStoreGraphDiff', got: " + changes.getClass().getName());
        }
        this.changesByObjectId = ((ObjectStoreGraphDiff)changes).getChangesByObjectId();
        this.insertBucket = new DataDomainInsertBucket(this);
        this.deleteBucket = new DataDomainDeleteBucket(this);
        this.updateBucket = new DataDomainUpdateBucket(this);
        this.flattenedBucket = new DataDomainFlattenedBucket(this);
        this.queries = new ArrayList();
        DataRowStore dataRowStore = context.getObjectStore().getDataRowCache();
        synchronized (dataRowStore) {
            this.resultIndirectlyModifiedIds = new HashSet();
            this.preprocess(context, changes);
            if (this.queries.isEmpty()) {
                return new CompoundDiff();
            }
            this.resultDiff = new CompoundDiff();
            this.resultDeletedIds = new ArrayList();
            this.resultModifiedSnapshots = new HashMap();
            this.runQueries();
            this.postprocess(context);
            return this.resultDiff;
        }
    }

    private void preprocess(DataContext context, GraphDiff changes) {
        ObjectStore objectStore = context.getObjectStore();
        Iterator it = this.changesByObjectId.keySet().iterator();
        while (it.hasNext()) {
            ObjectId id = (ObjectId)it.next();
            Persistent object = (Persistent)objectStore.getNode(id);
            ObjEntity entity = context.getEntityResolver().lookupObjEntity(id.getEntityName());
            switch (object.getPersistenceState()) {
                case 2: {
                    this.insertBucket.addDirtyObject(object, entity);
                    break;
                }
                case 4: {
                    this.updateBucket.addDirtyObject(object, entity);
                    break;
                }
                case 6: {
                    this.deleteBucket.addDirtyObject(object, entity);
                }
            }
        }
        new DataDomainIndirectDiffBuilder(this).processIndirectChanges(changes);
        this.insertBucket.appendQueries(this.queries);
        this.flattenedBucket.appendInserts(this.queries);
        this.updateBucket.appendQueries(this.queries);
        this.flattenedBucket.appendDeletes(this.queries);
        this.deleteBucket.appendQueries(this.queries);
    }

    private void runQueries() {
        DataDomainFlushObserver observer = new DataDomainFlushObserver();
        try {
            DataNode lastNode = null;
            DbEntity lastEntity = null;
            int rangeStart = 0;
            int len = this.queries.size();
            for (int i = 0; i < len; ++i) {
                DataNode node;
                BatchQuery query = (BatchQuery)this.queries.get(i);
                if (query.getDbEntity() == lastEntity || (node = this.domain.lookupDataNode((lastEntity = query.getDbEntity()).getDataMap())) == lastNode) continue;
                if (i - rangeStart > 0) {
                    lastNode.performQueries(this.queries.subList(rangeStart, i), observer);
                }
                rangeStart = i;
                lastNode = node;
            }
            lastNode.performQueries(this.queries.subList(rangeStart, len), observer);
        }
        catch (Throwable th) {
            Transaction.getThreadTransaction().setRollbackOnly();
            throw new CayenneRuntimeException("Transaction was rolledback.", th);
        }
    }

    private void postprocess(DataContext context) {
        this.deleteBucket.postprocess();
        this.updateBucket.postprocess();
        this.insertBucket.postprocess();
        if (!(this.resultDeletedIds.isEmpty() && this.resultModifiedSnapshots.isEmpty() && this.resultIndirectlyModifiedIds.isEmpty())) {
            context.getObjectStore().getDataRowCache().processSnapshotChanges(context.getObjectStore(), this.resultModifiedSnapshots, this.resultDeletedIds, Collections.EMPTY_LIST, this.resultIndirectlyModifiedIds);
        }
    }
}

