/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.NodeIdChangeOperation;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.commons.collections.Factory;

abstract class DataDomainSyncBucket {
    final Map objectsByEntity = new HashMap();
    final DataDomainFlushAction parent;
    List dbEntities;
    Map objEntitiesByDbEntity;

    DataDomainSyncBucket(DataDomainFlushAction parent) {
        this.parent = parent;
    }

    boolean isEmpty() {
        return this.objectsByEntity.isEmpty();
    }

    abstract void appendQueriesInternal(Collection var1);

    void appendQueries(Collection queries) {
        if (!this.objectsByEntity.isEmpty()) {
            this.groupObjEntitiesBySpannedDbEntities();
            this.appendQueriesInternal(queries);
        }
    }

    void checkReadOnly(ObjEntity entity) throws CayenneRuntimeException {
        if (entity.isReadOnly()) {
            StringBuffer message = new StringBuffer();
            message.append("Attempt to modify object(s) mapped to a read-only entity: ").append(entity.getName());
            if (entity != null) {
                message.append(" '").append(entity.getName()).append("'");
            }
            message.append(". Can't commit changes.");
            throw new CayenneRuntimeException(message.toString());
        }
    }

    private void groupObjEntitiesBySpannedDbEntities() {
        this.dbEntities = new ArrayList(this.objectsByEntity.size());
        this.objEntitiesByDbEntity = new HashMap(this.objectsByEntity.size() * 2);
        Iterator i = this.objectsByEntity.keySet().iterator();
        while (i.hasNext()) {
            ObjEntity objEntity = (ObjEntity)i.next();
            DbEntity dbEntity = objEntity.getDbEntity();
            List<ObjEntity> objEntitiesForDbEntity = (ArrayList<ObjEntity>)this.objEntitiesByDbEntity.get(dbEntity);
            if (objEntitiesForDbEntity == null) {
                objEntitiesForDbEntity = new ArrayList<ObjEntity>(1);
                this.dbEntities.add(dbEntity);
                this.objEntitiesByDbEntity.put(dbEntity, objEntitiesForDbEntity);
            }
            if (!objEntitiesForDbEntity.contains(objEntity)) {
                objEntitiesForDbEntity.add(objEntity);
            }
            Iterator j = objEntity.getAttributeMap().values().iterator();
            while (j.hasNext()) {
                ObjAttribute objAttribute = (ObjAttribute)j.next();
                if (!objAttribute.isCompound()) continue;
                dbEntity = (DbEntity)objAttribute.getDbAttribute().getEntity();
                objEntitiesForDbEntity = (List)this.objEntitiesByDbEntity.get(dbEntity);
                if (objEntitiesForDbEntity == null) {
                    objEntitiesForDbEntity = new ArrayList(1);
                    this.dbEntities.add(dbEntity);
                    this.objEntitiesByDbEntity.put(dbEntity, objEntitiesForDbEntity);
                }
                if (objEntitiesForDbEntity.contains(objEntity)) continue;
                objEntitiesForDbEntity.add(objEntity);
            }
        }
    }

    void addDirtyObject(Object object, ObjEntity entity) {
        ArrayList<Object> objects = (ArrayList<Object>)this.objectsByEntity.get(entity);
        if (objects == null) {
            objects = new ArrayList<Object>();
            this.objectsByEntity.put(entity, objects);
        }
        objects.add(object);
    }

    void postprocess() {
        if (!this.objectsByEntity.isEmpty()) {
            CompoundDiff result = this.parent.getResultDiff();
            Map modifiedSnapshots = this.parent.getResultModifiedSnapshots();
            Collection deletedIds = this.parent.getResultDeletedIds();
            Iterator it = this.objectsByEntity.values().iterator();
            while (it.hasNext()) {
                Iterator objects = ((Collection)it.next()).iterator();
                while (objects.hasNext()) {
                    DataObject object = (DataObject)objects.next();
                    ObjectId id = object.getObjectId();
                    DataRow dataRow = object.getDataContext().currentSnapshot(object);
                    dataRow.setReplacesVersion(object.getSnapshotVersion());
                    object.setSnapshotVersion(dataRow.getVersion());
                    if (id.isReplacementIdAttached()) {
                        ObjectId replacementId = id.createReplacementId();
                        result.add(new NodeIdChangeOperation((Object)id, replacementId));
                        if (!id.isTemporary()) {
                            deletedIds.add(id);
                        }
                        modifiedSnapshots.put(replacementId, dataRow);
                        continue;
                    }
                    if (id.isTemporary()) {
                        throw new CayenneRuntimeException("Temporary ID hasn't been replaced on commit: " + object);
                    }
                    modifiedSnapshots.put(id, dataRow);
                }
            }
        }
    }

    static final class PropagatedValueFactory
    implements Factory {
        ObjectId masterID;
        String masterKey;

        PropagatedValueFactory(ObjectId masterID, String masterKey) {
            this.masterID = masterID;
            this.masterKey = masterKey;
        }

        public Object create() {
            Object value = this.masterID.getIdSnapshot().get(this.masterKey);
            if (value == null) {
                throw new CayenneRuntimeException("Can't extract a master key. Missing key (" + this.masterKey + "), master ID (" + this.masterID + ")");
            }
            return value;
        }
    }
}

