/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.PrefetchTreeNode;

class PrefetchProcessorNode
extends PrefetchTreeNode {
    List dataRows;
    List objects;
    ObjRelationship incoming;
    ObjectResolver resolver;
    Map partitionByParent;
    boolean jointChildren;
    boolean partitionedByParent;
    DataObject lastResolved;

    PrefetchProcessorNode(PrefetchTreeNode parent, String segmentPath) {
        super(parent, segmentPath);
    }

    void afterInit() {
        boolean bl = this.partitionedByParent = !this.phantom && this.incoming != null && this.incoming.isSourceIndependentFromTargetChange();
        if (this.partitionedByParent) {
            this.partitionByParent = new HashMap();
        }
    }

    void linkToParent(DataObject object, DataObject parent) {
        if (parent != null) {
            if (!this.incoming.isToMany()) {
                parent.writeProperty(this.getName(), object);
            } else {
                ArrayList<DataObject> peers = (ArrayList<DataObject>)this.partitionByParent.get(parent);
                if (peers == null) {
                    peers = new ArrayList<DataObject>();
                    this.partitionByParent.put(parent, peers);
                } else if (peers.contains(object)) {
                    return;
                }
                peers.add(object);
            }
        }
    }

    void connectToParents() {
        if (this.isPartitionedByParent()) {
            boolean parentObjectsExist;
            PrefetchProcessorNode parent = (PrefetchProcessorNode)this.getParent();
            boolean bl = parentObjectsExist = parent.getObjects() != null && parent.getObjects().size() > 0;
            if (this.incoming.isToMany()) {
                if (parentObjectsExist) {
                    this.connectToNodeParents(parent.getObjects());
                } else {
                    this.connectToFaultedParents();
                }
            } else if (parentObjectsExist) {
                this.clearNullRelationships(parent.getObjects());
            }
        }
    }

    private final void clearNullRelationships(List parentObjects) {
        Iterator it = parentObjects.iterator();
        while (it.hasNext()) {
            DataObject object = (DataObject)it.next();
            if (!(object.readPropertyDirectly(this.name) instanceof Fault)) continue;
            object.writeProperty(this.name, null);
        }
    }

    private final void connectToNodeParents(List parentObjects) {
        Iterator it = parentObjects.iterator();
        while (it.hasNext()) {
            DataObject object = (DataObject)it.next();
            List related = (List)this.partitionByParent.get(object);
            this.connect(object, related);
        }
    }

    private final void connectToFaultedParents() {
        Iterator it = this.partitionByParent.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            DataObject object = (DataObject)entry.getKey();
            List related = (List)entry.getValue();
            this.connect(object, related);
        }
    }

    private final void connect(DataObject object, List related) {
        if (!this.incoming.isToMany()) {
            throw new CayenneRuntimeException("To-one relationship wasn't handled properly: " + this.incoming.getName());
        }
        ValueHolder toManyList = (ValueHolder)object.readProperty(this.getName());
        toManyList.setValueDirectly(related != null ? related : new ArrayList(1));
    }

    List getDataRows() {
        return this.dataRows;
    }

    List getObjects() {
        return this.objects;
    }

    void setResolver(ObjectResolver resolver) {
        this.resolver = resolver;
    }

    ObjectResolver getResolver() {
        return this.resolver;
    }

    ObjRelationship getIncoming() {
        return this.incoming;
    }

    void setIncoming(ObjRelationship incoming) {
        this.incoming = incoming;
    }

    void setDataRows(List dataRows) {
        this.dataRows = dataRows;
    }

    void setObjects(List objects) {
        this.objects = objects;
    }

    boolean isJointChildren() {
        return this.jointChildren;
    }

    void setJointChildren(boolean jointChildren) {
        this.jointChildren = jointChildren;
    }

    boolean isPartitionedByParent() {
        return this.partitionedByParent;
    }

    DataObject getLastResolved() {
        return this.lastResolved;
    }

    void setLastResolved(DataObject lastResolved) {
        this.lastResolved = lastResolved;
    }
}

