/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DefaultConfiguration;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.cayenne.util.WebApplicationResourceLocator;
import org.apache.log4j.Logger;

public class BasicServletConfiguration
extends DefaultConfiguration {
    private static Logger logObj = Logger.getLogger(BasicServletConfiguration.class);
    public static final String CONFIGURATION_PATH_KEY = "cayenne.configuration.path";
    public static final String DATA_CONTEXT_KEY = "cayenne.datacontext";
    protected ServletContext servletContext;

    public static synchronized BasicServletConfiguration initializeConfiguration(ServletContext ctxt) {
        BasicServletConfiguration basicConfiguration;
        Configuration oldConfiguration = Configuration.sharedConfiguration;
        if (oldConfiguration instanceof BasicServletConfiguration && (basicConfiguration = (BasicServletConfiguration)oldConfiguration).getServletContext() == ctxt) {
            logObj.info("BasicServletConfiguration is already initialized, reusing.");
            return basicConfiguration;
        }
        BasicServletConfiguration conf = new BasicServletConfiguration(ctxt);
        Configuration.initializeSharedConfiguration(conf);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataContext getDefaultContext(HttpSession session) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            DataContext ctxt = (DataContext)session.getAttribute(DATA_CONTEXT_KEY);
            if (ctxt == null) {
                ctxt = DataContext.createDataContext();
                session.setAttribute(DATA_CONTEXT_KEY, (Object)ctxt);
            }
            return ctxt;
        }
    }

    public BasicServletConfiguration() {
    }

    public BasicServletConfiguration(ServletContext ctxt) {
        this.setServletContext(ctxt);
        WebApplicationResourceLocator l = new WebApplicationResourceLocator(this.servletContext);
        l.setSkipAbsolutePath(true);
        l.setSkipClasspath(false);
        l.setSkipCurrentDirectory(true);
        l.setSkipHomeDirectory(true);
        String configurationPath = ctxt.getInitParameter(CONFIGURATION_PATH_KEY);
        if (configurationPath != null && configurationPath.trim().length() > 0) {
            ((ResourceLocator)l).addFilesystemPath(configurationPath);
        }
        this.setResourceLocator(l);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean canInitialize() {
        return this.getServletContext() != null;
    }
}

