/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dataview;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.dataview.DataObjectChangeEvent;
import org.apache.cayenne.dataview.DataObjectChangeListener;
import org.apache.cayenne.dataview.EventDispatcher;

public class DataObjectList
extends AbstractList {
    protected List dataObjects;
    protected EventDispatcher changeDispatcher;

    public DataObjectList() {
        this.dataObjects = new ArrayList();
    }

    public DataObjectList(int capacity) {
        this.dataObjects = new ArrayList(capacity);
    }

    public DataObjectList(Collection dataObjects, boolean typeCheck) {
        if (typeCheck) {
            Iterator i = dataObjects.iterator();
            while (i.hasNext()) {
                if (i.next() instanceof DataObject) continue;
                this.dataObjects = new ArrayList(1);
                return;
            }
        }
        this.dataObjects = new ArrayList(dataObjects);
    }

    public DataObjectList(Collection dataObjects) {
        this(dataObjects, true);
    }

    public void addDataObjectChangeListener(DataObjectChangeListener listener) {
        this.changeDispatcher = EventDispatcher.add(this.changeDispatcher, listener);
    }

    public void removeDataObjectChangeListener(DataObjectChangeListener listener) {
        this.changeDispatcher = EventDispatcher.remove(this.changeDispatcher, listener);
    }

    public void clearDataObjectChangeListeners() {
        if (this.changeDispatcher != null) {
            this.changeDispatcher.clear();
            this.changeDispatcher = null;
        }
    }

    public int indexOf(Object o) {
        if (!(o instanceof DataObject)) {
            return -1;
        }
        return this.dataObjects.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        if (!(o instanceof DataObject)) {
            return -1;
        }
        return this.dataObjects.lastIndexOf(o);
    }

    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public boolean isEmpty() {
        return this.dataObjects.isEmpty();
    }

    public int size() {
        return this.dataObjects.size();
    }

    public boolean add(DataObject dataObject) {
        boolean success = this.dataObjects.add(dataObject);
        int index = this.dataObjects.size() - 1;
        if (success && this.changeDispatcher != null) {
            this.changeDispatcher.dispatch(new DataObjectChangeEvent(this, 1, index));
        }
        return success;
    }

    public void add(int index, DataObject dataObject) {
        this.dataObjects.add(index, dataObject);
        if (this.changeDispatcher != null) {
            this.changeDispatcher.dispatch(new DataObjectChangeEvent(this, 1, index));
        }
    }

    public boolean add(Object o) {
        return this.add((DataObject)o);
    }

    public void add(int index, Object element) {
        this.add(index, (DataObject)element);
    }

    public Object remove(int index) {
        Object dataObject = this.dataObjects.remove(index);
        if (dataObject != null && this.changeDispatcher != null) {
            this.changeDispatcher.dispatch(new DataObjectChangeEvent(this, 2, index));
        }
        return dataObject;
    }

    public boolean remove(Object o) {
        int index = this.indexOf(o);
        return this.remove(index) != null;
    }

    public DataObject set(int index, DataObject dataObject) {
        DataObject oldObject = this.dataObjects.set(index, dataObject);
        if (this.changeDispatcher != null) {
            this.changeDispatcher.dispatch(new DataObjectChangeEvent(this, 3, index));
        }
        return oldObject;
    }

    public Object set(int index, Object element) {
        return this.set(index, (DataObject)element);
    }

    public Object get(int index) {
        return this.dataObjects.get(index);
    }

    public DataObject getDataObject(int index) {
        return (DataObject)this.get(index);
    }

    public Object[] toArray(Object[] array) {
        return this.dataObjects.toArray(array);
    }

    public Object[] toArray() {
        return this.dataObjects.toArray();
    }

    public void clear() {
        boolean empty = this.isEmpty();
        this.dataObjects.clear();
        if (!empty && this.changeDispatcher != null) {
            this.changeDispatcher.dispatch(new DataObjectChangeEvent(this, 2));
        }
    }

    public boolean removeAll(Collection dataObjects) {
        boolean success = this.dataObjects.removeAll(dataObjects);
        if (success && this.changeDispatcher != null) {
            this.changeDispatcher.dispatch(new DataObjectChangeEvent(this, 2));
        }
        return success;
    }

    public boolean containsAll(Collection dataObjects) {
        return this.dataObjects.containsAll(dataObjects);
    }

    public boolean addAll(Collection dataObjects, boolean typeCheck) {
        boolean success;
        if (typeCheck) {
            Iterator i = dataObjects.iterator();
            while (i.hasNext()) {
                if (i.next() instanceof DataObject) continue;
                return false;
            }
        }
        if ((success = this.dataObjects.addAll(dataObjects)) && this.changeDispatcher != null) {
            this.changeDispatcher.dispatch(new DataObjectChangeEvent(this, 1));
        }
        return success;
    }

    public boolean addAll(int index, Collection dataObjects, boolean typeCheck) {
        boolean success;
        if (typeCheck) {
            Iterator i = dataObjects.iterator();
            while (i.hasNext()) {
                if (i.next() instanceof DataObject) continue;
                return false;
            }
        }
        if ((success = this.dataObjects.addAll(index, dataObjects)) && this.changeDispatcher != null) {
            this.changeDispatcher.dispatch(new DataObjectChangeEvent(this, 1));
        }
        return success;
    }

    public boolean addAll(Collection dataObjects) {
        return this.addAll(dataObjects, true);
    }

    public boolean addAll(int index, Collection c) {
        return this.addAll(index, this.dataObjects, true);
    }

    public boolean retainAll(Collection dataObjects) {
        boolean success = this.dataObjects.retainAll(dataObjects);
        if (success && this.changeDispatcher != null) {
            this.changeDispatcher.dispatch(new DataObjectChangeEvent(this, 2));
        }
        return success;
    }
}

