/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.hessian.service;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.Serializer;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.remote.hessian.service.ServerAbstractQueryDeserializer;
import org.apache.cayenne.remote.hessian.service.ServerDataRowSerializer;
import org.apache.cayenne.remote.hessian.service.ServerPersistentObjectListSerializer;
import org.apache.cayenne.util.PersistentObjectList;

class ServerSerializerFactory
extends AbstractSerializerFactory {
    private EntityResolver serverResolver;
    private ServerPersistentObjectListSerializer persistentObjectListSerializer = new ServerPersistentObjectListSerializer();
    private ServerDataRowSerializer dataRowSerilaizer = new ServerDataRowSerializer();
    private Map deserializers;

    ServerSerializerFactory() {
    }

    void setEntityResolver(EntityResolver resolver) {
        this.serverResolver = resolver;
    }

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        if (PersistentObjectList.class.isAssignableFrom(cl)) {
            return this.persistentObjectListSerializer;
        }
        if (DataRow.class.isAssignableFrom(cl)) {
            return this.dataRowSerilaizer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
        Object deserializer = null;
        if (AbstractQuery.class.isAssignableFrom(cl)) {
            ServerSerializerFactory serverSerializerFactory = this;
            synchronized (serverSerializerFactory) {
                if (this.deserializers != null) {
                    deserializer = (Deserializer)this.deserializers.get(cl);
                }
                if (deserializer == null) {
                    deserializer = new ServerAbstractQueryDeserializer(cl, this.serverResolver.getClientEntityResolver());
                    if (this.deserializers == null) {
                        this.deserializers = new HashMap();
                    }
                    this.deserializers.put(cl, deserializer);
                }
            }
        }
        return deserializer;
    }
}

