/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.access.ClientServerChannel;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DefaultConfiguration;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.RemoteService;
import org.apache.cayenne.remote.RemoteSession;
import org.apache.cayenne.remote.service.DispatchHelper;
import org.apache.cayenne.remote.service.ServerSession;
import org.apache.cayenne.util.Util;
import org.apache.log4j.Logger;

public abstract class BaseRemoteService
implements RemoteService {
    public static final String EVENT_BRIDGE_FACTORY_PROPERTY = "cayenne.RemoteService.EventBridge.factory";
    private final Logger logObj = Logger.getLogger(BaseRemoteService.class);
    protected DataDomain domain;
    protected String eventBridgeFactoryName;
    protected Map eventBridgeParameters;

    public String getEventBridgeFactoryName() {
        return this.eventBridgeFactoryName;
    }

    public Map getEventBridgeParameters() {
        return this.eventBridgeParameters != null ? Collections.unmodifiableMap(this.eventBridgeParameters) : Collections.EMPTY_MAP;
    }

    protected void initService(Map properties) throws CayenneRuntimeException {
        this.logObj.debug(this.getClass().getName() + " is starting");
        this.initCayenneStack(properties);
        this.initEventBridgeParameters(properties);
        this.logObj.debug(this.getClass().getName() + " started");
    }

    protected void destroyService() {
        this.logObj.debug(this.getClass().getName() + " destroyed");
    }

    public DataChannel getRootChannel() {
        return this.domain;
    }

    protected abstract ServerSession createServerSession();

    protected abstract ServerSession createServerSession(String var1);

    protected abstract ServerSession getServerSession();

    public RemoteSession establishSession() {
        this.logObj.debug("Session requested by client");
        RemoteSession session = this.createServerSession().getSession();
        this.logObj.debug("Established client session: " + session);
        return session;
    }

    public RemoteSession establishSharedSession(String name) {
        this.logObj.debug("Shared session requested by client. Group name: " + name);
        if (name == null) {
            throw new CayenneRuntimeException("Invalid null shared session name");
        }
        return this.createServerSession(name).getSession();
    }

    public Object processMessage(ClientMessage message) throws Throwable {
        ServerSession handler = this.getServerSession();
        if (handler == null) {
            throw new CayenneRuntimeException("No session associated with request.");
        }
        this.logObj.debug("processMessage, sessionId: " + handler.getSession().getSessionId());
        try {
            return DispatchHelper.dispatch(handler.getChannel(), message);
        }
        catch (Throwable th) {
            th = Util.unwindException(th);
            this.logObj.info("error processing message", th);
            throw th;
        }
    }

    protected RemoteSession createRemoteSession(String sessionId, String name, boolean enableEvents) {
        RemoteSession session = enableEvents ? new RemoteSession(sessionId, this.eventBridgeFactoryName, this.eventBridgeParameters) : new RemoteSession(sessionId);
        session.setName(name);
        return session;
    }

    protected DataChannel createChannel() {
        return new ClientServerChannel(this.domain, false);
    }

    protected void initCayenneStack(Map properties) {
        DefaultConfiguration cayenneConfig = new DefaultConfiguration("cayenne.xml");
        try {
            ((Configuration)cayenneConfig).initialize();
            ((Configuration)cayenneConfig).didInitialize();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error starting Cayenne", ex);
        }
        this.domain = cayenneConfig.getDomain();
    }

    protected void initEventBridgeParameters(Map properties) {
        String eventBridgeFactoryName = (String)properties.get(EVENT_BRIDGE_FACTORY_PROPERTY);
        if (eventBridgeFactoryName != null) {
            HashMap eventBridgeParameters = new HashMap(properties);
            eventBridgeParameters.remove(EVENT_BRIDGE_FACTORY_PROPERTY);
            this.eventBridgeFactoryName = eventBridgeFactoryName;
            this.eventBridgeParameters = eventBridgeParameters;
        }
    }
}

