/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.commons.collections.FastTreeMap;

public class CayenneMap
extends FastTreeMap {
    protected Object parent;

    public CayenneMap(Object parent) {
        this.parent = parent;
    }

    public CayenneMap(Object parent, Comparator c) {
        super(c);
        this.parent = parent;
    }

    public CayenneMap(Object parent, Map m) {
        this.parent = parent;
        this.putAll(m);
    }

    public CayenneMap(Object parent, SortedMap m) {
        this.parent = parent;
        this.putAll((Map)m);
    }

    public Object put(Object key, Object value) {
        if (this.containsKey(key) && this.get(key) != value) {
            StringBuffer message = new StringBuffer();
            message.append("Attempt to insert duplicate key. [key '");
            message.append(key);
            message.append("'");
            if (this.parent instanceof CayenneMapEntry) {
                message.append(", parent '").append(((CayenneMapEntry)this.parent).getName()).append("'");
            }
            if (value instanceof CayenneMapEntry) {
                message.append(", child '").append(((CayenneMapEntry)value).getName()).append("'");
            }
            message.append("]");
            throw new IllegalArgumentException(message.toString());
        }
        if (value instanceof CayenneMapEntry) {
            ((CayenneMapEntry)value).setParent(this.parent);
        }
        super.put(key, value);
        return null;
    }

    public void putAll(Map t) {
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object mapParent) {
        this.parent = mapParent;
    }
}

